#include "world.h"


static int zline = 0;


/**************************************************************************/
/* GLOBAL **************      GetSisalInfo         ************************/
/**************************************************************************/
/* PURPOSE: RETURN SISAL SOURCE INFORMATION FOR NODE n IN BUFFER buf. Buf */
/*          IS TAKEN AS AN ARGUMENT AND RETURNED AS A RESULT.             */
/**************************************************************************/

char * GetSisalInfo( n, buf )
PNODE  n;
char  *buf;
{
  if ( n->line <= 0 ) {
    sprintf( buf, "\"%s,%s,line=lost\"",
	     (n->file == NULL)? "unknown.sis" : n->file,
	     (n->funct == NULL)? "unknown(...)" : n->funct );
	   
    return( buf );
    }

  sprintf( buf, "\"%s,%s,line=%d\"",
	   (n->file == NULL)? "unknown.sis" : n->file,
	   (n->funct == NULL)? "unknown(...)" : n->funct, n->line );

  return( buf );
}


/**************************************************************************/
/* GLOBAL **************      PrintBoundsCheck     ************************/
/**************************************************************************/
/* PURPOSE: PRINT A BOUNDS CHECK FOR ARRAY a AND INDEX i FOR NODE n.      */
/**************************************************************************/

void PrintBoundsCheck( indent, n, a, i )
int   indent;
PNODE n;
PEDGE a;
PEDGE i;
{
  char buf[200];

  if ( sdbx ) {
    fprintf( output, "SdbxBoundsCheck%d( ", (i != NULL)? 1 : 2 );
    PrintTemp( a );

    if ( i != NULL ) {
      fprintf( output, ", " );
      PrintTemp( i );
      }

    fprintf( output, ");\n" );
    return;
    }

  fprintf( output, "BoundsCheck%d( ", (i != NULL)? 1 : 2 );
	   
  PrintTemp( a );

  fprintf( output, ", \"%s\"", (a->name == NULL)? "lost" : a->name );

  if ( i != NULL ) {
    fprintf( output, ", \"%s\", ", (i->name == NULL)? "lost" : i->name );
    PrintTemp( i );
    }

  fprintf( output, ", %s", GetSisalInfo( n, buf ) );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintRagged         ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY MEMORY RAGGED MANAGEMENT NODE n TO output.        */
/**************************************************************************/

void PrintRagged( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );

  fprintf( output, "RaggedManager( rag%d, ", n->imp->iport );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************     PrintPSMemAllocDVI    ************************/
/**************************************************************************/
/* PURPOSE: PRINT POINTER SWAP MemAllocDVI NODE n TO output.              */
/**************************************************************************/

void PrintPSMemAllocDVI( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );
  fprintf( output, "PSMAllocDVI( " );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc->isucc );
  fprintf( output, " );\n", n->imp->iport );
}


/**************************************************************************/
/* GLOBAL **************       PrintPSScatter      ************************/
/**************************************************************************/
/* PURPOSE: PRINT POINTER SWAP SCATTER NODE n TO output.                  */
/**************************************************************************/

void PrintPSScatter( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );
  fprintf( output,  "PSScatter( " );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc->isucc );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintPSManager      ************************/
/**************************************************************************/
/* PURPOSE: PRINT POINTER SWAP MANAGER NODE n OF TYPE nm TO output.       */
/**************************************************************************/

void PrintPSManager( indent, n, nm )
int    indent;
PNODE  n;
char  *nm;
{
  PrintIndentation( indent );
  fprintf( output, "PSManager%s( ", nm );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintPSFree         ************************/
/**************************************************************************/
/* PURPOSE: PRINT POINTER SWAP FREE NODE n OF TYPE nm TO output.          */
/**************************************************************************/

void PrintPSFree( indent, n, nm, g )
int    indent;
PNODE  n;
char  *nm;
PNODE  g;
{
  register PNODE nn;

  if ( !freeall ) {
    /* SKIP DEALLOCATIONS IF THEY ARE THE LAST THINGS DONE IN THE PROGRAM */
    if ( sequential && standalone && IsXGraph( g ) ) {
      /* IF COMPLEX LIES AHEAD THEN FREE THE STORAGE */
      for ( nn = n->nsucc; nn != NULL; nn = nn->nsucc )
	if ( IsCompound( nn ) || IsCall( nn ) )
	  break;

      if ( nn == NULL )
	return;
      }
    }

  PrintIndentation( indent );

  if ( n->imp->isucc == NULL ) {
    fprintf( output, "PSFree%s( ", nm );
    PrintTemp( n->imp );
    fprintf( output, " );\n" );
    return;
    }

  fprintf( output, "PSFree%sX( ", nm );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );
  fprintf( output, ", %s", GetFreeName( n->imp->isucc->info ) );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintPSAlloc        ************************/
/**************************************************************************/
/* PURPOSE: PRINT POINTER SWAP ALLOCATION NODE n OF TYPE nm TO output.    */
/**************************************************************************/

void PrintPSAlloc( indent, n, nm )
int    indent;
PNODE  n;
char  *nm;
{
  register int   c;
  register PEDGE i;

  PrintIndentation( indent );
  fprintf( output, "PSMAlloc%s( %s, %s, ", nm, n->gname, 
	   n->usucc->exp->info->A_ELEM->A_ELEM->tname );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );
  fprintf( output, ", " );

  for ( c = 2, i = n->imp->isucc->isucc; i != NULL; i = i->isucc, c++ ) {
    PrintTemp( i );
    fprintf( output, ", " );
    }

  for ( ; c != 6; c++ )
    fprintf( output, "0, " );

  fprintf( output, " %d );\n", n->imp->iport );
}


/**************************************************************************/
/* GLOBAL **************       PrintMemAlloc       ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY MEMORY ALLOCATION NODE n TO output.               */
/**************************************************************************/

void PrintMemAlloc( indent, n )
int   indent;
PNODE n;
{
  register PEDGE se;

  PrintIndentation( indent );

  if ( n->wmark )
    fprintf( output, "Ragged" );

  if ( n->type == IFMemAllocDV )
    fprintf( output, "MAllocDV( " );
  else if ( n->type == IFMemAllocDVI )
    fprintf( output, "MAllocDVI( " );
  else
    fprintf( output, "MAlloc( " );

  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", %s", n->exp->info->A_ELEM->A_ELEM->tname );

  if ( n->type == IFMemAllocDVI ) {
    fprintf( output, ", " );
    PrintTemp( n->imp->isucc );
    fprintf( output, ", %d", n->exp->sr );

    se = n->imp->isucc->isucc;
    }
  else
    se = n->imp->isucc;

  if ( n->wmark ) {
    if ( se == NULL )
      Error2( "PrintMemAlloc", "se IS NULL" );

    fprintf( output, ", " );
    PrintTemp( se );
    }

  fprintf( output, " )\n" );
}


/**************************************************************************/
/* GLOBAL **************      PrintGABase          ************************/
/**************************************************************************/
/* PURPOSE: PRINT GetArrayBase NODE n TO output.                          */
/**************************************************************************/

void PrintGABase( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );

  fprintf( output, "GABase( %s, ", n->exp->info->tname );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, " );\n" );

  /* SHOULD NOT BE NEEDED! */
  PrintProducerModifiers( indent, n );
  PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************    PrintOptAElement       ************************/
/**************************************************************************/
/* PURPOSE: PRINT OptAElement NODE n TO output.                           */
/**************************************************************************/

void PrintOptAElement( indent, n )
int   indent;
PNODE n;
{
    register PEDGE e;

    PrintIndentation( indent );

    fprintf( output, "%s( %s, ", GetMacro( n ), n->exp->info->tname );
    PrintTemp( n->exp );
    fprintf( output, ", " );
    PrintTemp( n->imp );
    fprintf( output, ", " );
    PrintTemp( n->imp->isucc );
    fprintf( output, " );\n" );

    PrintProducerModifiers( indent, n );
    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************      PrintArrayMacro      ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY MACRO REPRESENTING NODE n TO output.  THE MACRO   */
/*          NAME IS pre || macro || component type.  THE ARGUMENT LIST    */
/*          HAS FORMAT ( n->exp, n->imps... ). NODE n CAN EXPORT EITHER   */
/*          AN ARRAY OR BUFFER REPRESENTING AN ARRAY.                     */
/**************************************************************************/

void PrintArrayMacro( indent, pre, macro, n )
int    indent;
char  *pre;
char  *macro;
PNODE  n;
{
    register PEDGE i;
    char           buf[100];

    PrintIndentation( indent );

    if ( IsBuffer( n->imp->info ) )
        fprintf( output, "%s%s( %s, ", pre, macro, 
		 n->exp->info->A_ELEM->A_ELEM->tname );
    else
        fprintf( output, "%s%s( %s, ", pre, macro, n->imp->info->A_ELEM->tname);

    PrintTemp( n->exp );

    for ( i = n->imp; i != NULL; i = i->isucc ) {
	fprintf( output, ", " );
	PrintTemp( i );
	}
	
    fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintAReplace       ************************/
/**************************************************************************/
/* PURPOSE: PRINT AReplace NODE n TO OUTPUT. IF nmark IS FALSE THEN AN    */
/*          ATTEMPT IS MADE TO DEALLOCATE THE REPLACED COMPONENTS.        */
/**************************************************************************/

void PrintAReplace( indent, n )
int   indent;
PNODE n;
{
    register PEDGE i;
    register PINFO ci;
    register int   c;
    register PEDGE ab;
    register int   opt = FALSE;
	     char  buf[100];

    if ( n->exp->temp != n->imp->temp )
	PrintAssgn( indent, n->exp, n->imp );

    PrintSetRefCount( indent, n->exp, n->exp->sr, TRUE );

    ci = n->exp->info->A_ELEM;
    ab = FindImport( n, MAX_PORT_NUMBER );

    if ( (ab != NULL) && aimp )
        if ( (ab->rc == 0) && (UsageCount( ab->src, ab->eport ) == 1) )
	    opt = TRUE;

    if ( (!IsBasic( ci )) && (!n->nmark) )
	sprintf( buf, "DARepl( %s, ", GetFreeName( ci ) );
    else
	sprintf( buf, "ARepl( " );

    for ( c = 0, i = n->imp->isucc->isucc; i != NULL; c++ ) {
	if ( (c > 0) && opt ) {
	    PrintIndentation( indent );
	    fprintf( output, "IncArrayBase( %s, ", ci->tname );
	    PrintTemp( ab );
	    fprintf( output, " );\n" );
	    }

	PrintIndentation( indent );

	fprintf( output, "%s%s %s, ", (ab != NULL)? "Opt" : "", buf, ci->tname);
	PrintTemp( n->exp );
	fprintf( output, ", " );
	PrintTemp( n->imp->isucc );

	if ( !opt && (c > 0) )
	    fprintf( output, " + %d", c );

	fprintf( output, ", " );
        PrintTemp( i );

	if ( ab != NULL ) {
	    fprintf( output, ", " );
	    PrintTemp( ab );
	    }

        fprintf( output, " );\n" );

	if ( (i = i->isucc) == ab )
	    break;
	}
}


/**************************************************************************/
/* GLOBAL **************       PrintABuild         ************************/
/**************************************************************************/
/* PURPOSE: PRINT ABuild NODE n TO output.                                */
/**************************************************************************/

void PrintABuild( indent, n )
int   indent;
PNODE n;
{
  register PEDGE i;

  PrintIndentation( indent );

  fprintf( output, "DoABld( " );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", %d );\n", n->exp->sr );

  for ( i = n->imp->isucc; i != NULL; i = i->isucc ) {
    PrintIndentation( indent );

    fprintf( output, "GathUpd( %s, ", n->exp->info->A_ELEM->tname );
    PrintTemp( n->exp );
    fprintf( output, ", " );
    PrintTemp( i );
    fprintf( output, " );\n" );
    }
}


/**************************************************************************/
/* GLOBAL **************       PrintABuildAT       ************************/
/**************************************************************************/
/* PURPOSE: PRINT ABuildAT NODE n TO output.                              */
/**************************************************************************/

void PrintABuildAT( indent, n )
int   indent;
PNODE n;
{
    register PEDGE i;
    register PEDGE b;
    register int   c;
    register int   s;

    if ( n->cmark ) {
	PrintIndentation( indent );
	fprintf( output, "%s( ", GetIncRefCountName( n->exp->info ) );
	PrintTemp( n->exp );
	fprintf( output, ", %s, %d );\n", n->exp->info->sname, 1 );
	return;
	}

    /* FIND THE BUFFER IMPORT AND THE NUMBER OF INITIAL ELEMENTS */
    for ( s = 0, i = n->imp->isucc; i != NULL; i = i->isucc )
	if ( i->isucc != NULL ) 
	  s++; 
	else 
	  b = i;


    /* PART OF VECTORIZED ReduceAT COMPUTATION? */
    if ( n->nmark && IsSGraph( b->src ) )
      if ( b->src->G_DAD->vmark ) {
        for ( c = 0, i = n->imp->isucc; i != b; i = i->isucc, c++ ) {
          PrintIndentation( indent );
	  fprintf( output, "((%s*)", n->exp->info->A_ELEM->tname );
	  PrintTemp( b );
	  fprintf( output, ")[%d] = ", c );
	  PrintTemp( i );
	  fprintf( output, ";\n" );
	  }

	return;
	}

    PrintIndentation( indent );

    switch ( n->type ) {
      case IFABuildATDVI:
        fprintf( output, "BldATDVI( %s, ", n->exp->info->A_ELEM->tname );
	break;

      case IFABuildATDV:
        fprintf( output, "BldATDV( %s, ", n->exp->info->A_ELEM->tname );
	break;

      default:
        fprintf( output, "%s%s( %s, ", (n->nmark)? "Opt" : "", GetMacro( n ),  
	         n->exp->info->A_ELEM->tname );
        break;
      }
	     
    PrintTemp( n->exp );
    fprintf( output, ", " );
    PrintTemp( n->imp );

    fprintf( output, ", %d, ", s );
    PrintTemp( b );
    fprintf( output, " );\n" );

    if ( n->imp->isucc != b ) {
      PrintIndentation( indent );
      fprintf( output, "{\n" );

      PrintIndentation( indent );
      fprintf( output, "  register %s *pp;\n", n->exp->info->A_ELEM->tname );

      PrintIndentation( indent );
      fprintf( output, "  pp = (%s*) ", n->exp->info->A_ELEM->tname );
      PrintTemp( b );
      fprintf( output, "->Base;\n" );

      for ( c = 0, i = n->imp->isucc; i != b; i = i->isucc, c++ ) {
	PrintIndentation( indent );

	fprintf( output, "  pp[%d] = ", c );
	PrintTemp( i );
	fprintf( output, ";\n" );
	}

      PrintIndentation( indent );
      fprintf( output, "}\n" );
      }

    if ( !(n->nmark) )
      PrintSetRefCount( indent, n->exp, n->exp->sr, FALSE );
}


/**************************************************************************/
/* GLOBAL **************       PrintAAddHLAT       ************************/
/**************************************************************************/
/* PURPOSE: PRINT AAddLAT OR AAddHAT NODE n TO output.                    */
/**************************************************************************/

void PrintAAddHLAT( indent, n )
int   indent;
PNODE n;
{
    char *s;
    int   assgnOK;

    assgnOK = TRUE;

    switch ( n->type ) {
      case IFAAddHATDVI:
	s = "HATDVI" ;
	assgnOK = FALSE;
	break;

      case IFAAddHATDV:
	s = "HATDV";
	assgnOK = FALSE;
	break;

      case IFAAddLATDVI:
        s = "LATDVI";
	assgnOK = FALSE;
	break;

      case IFAAddLATDV:
	s = "LATDV";
	assgnOK = FALSE;
	break;

      case IFAAddHAT:
	s = "HAT";
	break;

      case IFAAddLAT:
	s = "LAT";
	break;

      default:
	Error2( "PrintAAddHLAT", "ILLEGAL NODE TYPE" );
      }

    if ( !(n->nmark) )
      if ( n->imp->pmark )
        if ( n->imp->temp != n->exp->temp )
          if ( assgnOK )
	    PrintAssgn( indent, n->exp, n->imp );

    PrintIndentation( indent );

    fprintf( output, "%s%sAdd%s( ",
	     (n->nmark)? "Opt" : "", (n->imp->pmark)? "P" : "", s );

    PrintTemp( n->exp );
    fprintf( output, ", " );

    if ( !(n->imp->pmark) ) {
      PrintTemp( n->imp );
      fprintf( output, ", " );
      }

    PrintTemp( n->imp->isucc );
    fprintf( output, ", " );
    PrintTemp( n->imp->isucc->isucc );
    fprintf( output, ", %s, %s, ", GetCopyFunction( n->exp->info ),
	     n->exp->info->A_ELEM->tname                         );
    PrintTemp( n->imp->isucc->isucc->isucc );
    fprintf( output, ", " );
    PrintTemp( n->imp->isucc->isucc->isucc->isucc );
    fprintf( output, " );\n" );

    if ( !(n->nmark) ) {
      if ( n->imp->pmark )
        PrintSetRefCount( indent, n->exp, n->exp->sr, TRUE );
      else
        PrintSetRefCount( indent, n->exp, n->exp->sr, FALSE );
      }

    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************        PrintAAddH         ************************/
/**************************************************************************/
/* PURPOSE: PRINT AAddH NODE n TO output.                                 */
/**************************************************************************/

void PrintAAddH( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );

  fprintf( output, "AAddH%s( ", (IsBasic( n->exp->info->A_ELEM))? "" : "X" );

  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );
  fprintf( output, ", " );

  fprintf( output, "%s, %s, %s", GetCopyFunction( n->exp->info ),
	   n->exp->info->A_ELEM->tname, GetFreeName( n->exp->info ) );

  if ( IsBasic(n->exp->info->A_ELEM) )
    fprintf( output, " );\n" );
  else
    fprintf( output, ", %s );\n", GetFreeName( n->exp->info->A_ELEM ) );

  PrintSetRefCount( indent, n->exp, n->exp->sr, TRUE );
}


/**************************************************************************/
/* GLOBAL **************      PrintACatenateAT     ************************/
/**************************************************************************/
/* PURPOSE: PRINT ACatenateAT NODE n TO output.                           */
/**************************************************************************/

void PrintACatenateAT( indent, n )
int   indent;
PNODE n;
{
    char buf[100];
    char *s;
    int  assgnOK;

    assgnOK = TRUE;

    switch ( n->type ) {
      case IFACatenateATDVI:
	s = "DVI";
	assgnOK = FALSE;
	break;

      case IFACatenateATDV:
	s = "DV";
	assgnOK = FALSE;
	break;

      default:
	s = "";
        break;
      }

    if ( n->imp->pmark ) {
	if ( !(n->nmark) )
	  if ( n->imp->temp != n->exp->temp )
            if ( assgnOK )
	      PrintAssgn( indent, n->exp, n->imp );

	if ( !(n->imp->isucc->pmark) )
	    sprintf( buf, "PCCatAT" );
        else
	    sprintf( buf, "PPCatAT" );
	}
    else if ( n->imp->isucc->pmark ) {
	if ( !(n->nmark) )
	  if ( n->imp->isucc->temp != n->exp->temp )
            if ( assgnOK )
	      PrintAssgn( indent, n->exp, n->imp->isucc );

	sprintf( buf, "CPCatAT" );
        }
    else
	sprintf( buf, "CCCatAT" );

    PrintIndentation( indent );

    fprintf( output, "%s%s", (n->nmark)? "Opt" : "", buf );

    fprintf( output, "%s( ", s );

    PrintTemp( n->exp );
    fprintf( output, ", " );

    if ( strcmp( buf, "CCCatAT" ) == 0 ) {
      PrintTemp( n->imp );
      fprintf( output, ", " );
      PrintTemp( n->imp->isucc );
      fprintf( output, ", " );
    } else {
      if ( strcmp( buf, "PPCatAT" ) != 0 ) {
        if ( strcmp( buf, "CPCatAT" ) == 0 ) {
          PrintTemp( n->imp );
          fprintf( output, ", " );
        } else {
          PrintTemp( n->imp->isucc );
          fprintf( output, ", " );
          }
	}
      }

    PrintTemp( n->imp->isucc->isucc );
    fprintf( output, ", %s, %s, ", GetCopyFunction( n->exp->info ),
	     n->exp->info->A_ELEM->tname                        );
    PrintTemp( n->imp->isucc->isucc->isucc );
    fprintf( output, ", " );
    PrintTemp( n->imp->isucc->isucc->isucc->isucc );
    fprintf( output, " );\n" );

    if ( !(n->nmark) ) {
      if ( n->imp->pmark || n->imp->isucc->pmark ) {
        PrintSetRefCount( indent, n->exp, n->exp->sr, TRUE  );
	}
      else
        PrintSetRefCount( indent, n->exp, n->exp->sr, FALSE );
      }

    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************       PrintArrayNoOp      ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY NoOp NODE n TO output.                            */
/**************************************************************************/

void PrintArrayNoOp( indent, n )
int   indent;
PNODE n;
{
    register PEDGE i; 
             char  pre[100];

    if ( n->imp->rmark1 == RMARK )
	if ( n->imp->omark1 || n->imp->pmark ) {           /* A TRUE NoOp */
	    if ( n->imp->temp != n->exp->temp )
	        PrintAssgn( indent, n->exp, n->imp );

if ( n->exp != NULL )
  if ( IsAReplace( n->exp->dst ) )
    if ( n->exp->dst->exp->sr == 1 )
      n->exp->dst->exp->sr = 0;

            return;
	    }

    i = n->imp;

    if ( i->pmark ) {
	PrintIndentation( indent );

	fprintf( output, "P%sANoOp( ", (i->rmark1 == rMARK)? "C" : "" );
	PrintTemp( n->exp );
	fprintf( output, ", " );
	PrintTemp( i );
	fprintf( output, ", %s );\n", GetFreeName( i->info ) );

	return;
	}

    PrintIndentation( indent );

    if ( i->rmark1 == rMARK )
	fprintf( output, "COANoOp( " );
    else
	fprintf( output, "ANoOp( " );

    PrintTemp( n->exp );
    fprintf( output, ", " );
    PrintTemp( n->imp );
    fprintf( output, ", %s, %s, %s );\n", n->exp->info->A_ELEM->tname,
	     GetCopyFunction( n->exp->info ), GetFreeName( n->exp->info ) );
}
