#include "world.h"


static char *cfun[] = {                  /* ARRAY COMPONENT COPY FUNCTION */
    "ArrArrCopy",      "Compiler_Error", "Compiler_Error",   "Compiler_Error",
    "Compiler_Error",  "Compiler_Error", "Compiler_Error",   "Compiler_Error",
    "Compiler_Error",  "Compiler_Error", "Compiler_Error",   "Compiler_Error",
    "ArrBoolCopy",     "ArrCharCopy",    "ArrDblCopy",       "ArrIntCopy",
    "ArrNullCopy",     "ArrFltCopy",     "Compiler_Error",   "Compiler_Error"
    };

static char *snames[] = {                            /* SIMPLE NODE NAMES */
    "AAddH", "AAddL", "AAdj",  "ABld",  "ACat",  "AElm",  "AFill",
    "AGath", "AEpty", "ALimH", "ALimL", "ARemH", "ARemL", "@ARepl",
    "AScat", "ASetL", "ASize", "Abs",   "BindA", "Bool",  "Call",
    "Char",  "Div",   "Dbl",   "Equal", "Exp",   "FstV",  "FnlV",
    "Floor", "Int",   "IsErr", "Less",  "LessE", "Max",   "Min",
    "Minus", "Mod",   "Neg",   "NoOp",  "Not",   "NotE",  "Plus",
    "RgGen", "RBld",  "RElm",  "RRepl", "RedL",  "RedR",  "RedT",
    "Red",   "RestV", "Sngle", "Times", "Trunc", "ReplM"
    };

static char *atnames[] = {                            /* IF2 ATNODE NAMES */
    "AddLAT", "AddHAT",  "BPart",  "BldAT",  "BScat",  "CatAT",  "ElmAT",
    "AdjAT",  "FillAT",  "GathAT", "RemHAT", "RemLAT", "ReplAT", "AToB",
    "SetAT",  "DefAB",   "DefRB",  "FnlVAT", "MAlloc", "BElm",   "RBldAT",
    "RToB",   "RElmAT",  "RedAT",  "ShiftB", "SBpart", "RedLAT", "RedRAT",
    "RedTAT", "XXXXX",   "XXXXX",  "XXXXX",  "Assgn",  "GABase", "OptAElm",
    "Div2"
    };


/**************************************************************************/
/* GLOBAL **************          GetMacro         ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE SYMBOLIC MACRO NAME OF NODE n.                     */
/**************************************************************************/

char *GetMacro( n )
PNODE n;
{
    if ( IsCompound( n ) )
	Error1( "GetMacro: REQUEST FOR COMPOUND MACRO NAME" );

    if ( IsSimple( n ) )
	return( snames[ n->type - IFAAddH ] );

    if ( IsAtNode( n ) )
	return( atnames[ n->type - IFAAddLAT ] );

    fprintf( stderr, "HELP: n->type = %d n->if1line %d\n", n->type, n->if1line );
    Error1( "GetMacro: REQUEST FOR GRAPH MACRO NAME" );
}


static char buf[100];                        /* COPY FUNCTION NAME BUFFER */


/**************************************************************************/
/* GLOBAL **************      GetCopyFunction      ************************/
/**************************************************************************/
/* PURPOSE: RETURN COMPONENT COPY FUNCTION NAME FOR ARRAY i. NOTE, A CALL */
/*          MIGHT WIPE OUT THE PREVIOUS CONTENTS OF STRING BUFFER buf.    */
/**************************************************************************/

char *GetCopyFunction( i )
PINFO i;
{
  switch ( i->A_ELEM->type ) {
    case IF_RECORD:
    case IF_UNION:
    case IF_BRECORD:
      sprintf( buf, "Arr%sCopy", i->A_ELEM->cname );
      return( buf );
      break;

    default:
      return( cfun[ i->A_ELEM->type ] );
      break;
    }
}


/**************************************************************************/
/* GLOBAL **************    GetIncRefCountName     ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE INCREMENT REFERENCE COUNT MACRO NAME FOR i. THE    */
/*          TYPE OF i IS ASSUMED TO BE UNION, RECORD, OR ARRAY.           */
/**************************************************************************/

char *GetIncRefCountName( i )
PINFO i;
{
  switch ( i->type ) {
    case IF_RECORD:
    case IF_UNION:
    case IF_ARRAY:
      return( "IncRefCount" );
    
    default:
      Error2( "GetIncRefCountName", "ILLEGAL TYPE" );
    }
}


/**************************************************************************/
/* GLOBAL **************    GetSetRefCountName     ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE SET REFERENCE COUNT MACRO NAME FOR i. THE          */
/*          TYPE OF i IS ASSUMED TO BE UNION, RECORD, OR ARRAY.           */
/**************************************************************************/

char *GetSetRefCountName( i )
PINFO i;
{
  switch ( i->type ) {
    case IF_RECORD:
    case IF_UNION:
    case IF_ARRAY:
      return( "SetRefCount" );

    default:
      Error2( "GetSetRefCountName", "ILLEGAL INFO TYPE" );
    }
}
