#include "world.h"


static int nm    =  0;                             /* UNIQUE ID FOR NAMES */


/**************************************************************************/
/* STATIC **************         NameAlloc         ************************/
/**************************************************************************/
/* PURPOSE: ALLOCATE AND RETURN A UNIQUE NAME WITH PREFIX pre.            */
/**************************************************************************/

static char *NameAlloc( pre )
char *pre;
{
    char buffer[100];

    sprintf( buffer, "%s%d", pre, ++nm );

    return( CopyString( buffer ) );
}


/**************************************************************************/
/* STATIC **************     AssignExportNames     ************************/
/**************************************************************************/
/* PURPOSE: ASSIGN A NAME TO EACH UNIQUE EXPORT OF n'S EXPORT LIST.       */
/**************************************************************************/

static void AssignExportNames( n, pre )
PNODE  n;
char  *pre;
{
    register PEDGE e1;
    register PEDGE e2;

    for ( e1 = n->exp; e1 != NULL; e1 = e1->esucc ) {
	if ( e1->dname != NULL )
	    continue;

        e1->dname = NameAlloc( pre );

	for ( e2 = e1->esucc; e2 != NULL; e2 = e2->esucc )
	    if ( (e2->eport == e1->eport) )
		e2->dname = e1->dname;
        }
}


/**************************************************************************/
/* STATIC **************        AssignNames        ************************/
/**************************************************************************/
/* PURPOSE: ASSIGN NAMES TO THE UNIQUE EXPORTS OF ALL NODES IN GRAPH g.   */
/**************************************************************************/

static void AssignNames( g )
register PNODE g;
{
    register PNODE n;

    if ( IsIGraph( g ) ) 
	return;

    if ( !IsSGraph( g ) )
	AssignExportNames( g, "I" );

    for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
	AssignExportNames( n, "D" );

	if ( !IsSimple( n ) )
	    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
	         AssignNames( g );
        }
}


/**************************************************************************/
/* STATIC **************        PPrintConst        ************************/
/**************************************************************************/
/* PURPOSE: PRINT CONSTANT c TO output.                                   */
/**************************************************************************/

static void PPrintConst( c )
PEDGE c;
{
    if ( c->CoNsT == NULL ) {
        fprintf( output, "\"%s\"", ERROR_CONSTANT );
	return;
	}

    switch ( c->info->type ) {
        case IF_CHAR:
            fprintf( output, "\"\'%s\'\"", c->CoNsT );
            break;

        case IF_ARRAY:
        case IF_STREAM:
            fprintf( output, "\"\"%s\"\"", c->CoNsT );
            break;

        default:
            fprintf( output, "\"%s\"", c->CoNsT );
            break;
        }
}


/**************************************************************************/
/* STATIC **************     PPrintIndentation     ************************/
/**************************************************************************/
/* PURPOSE: PRINT ln FOLLOWED BY indent BLANKS AND indent TO output.      */
/**************************************************************************/

static void PPrintIndentation( indent, ln )
int indent;
int ln;
{
    register int i;

    fprintf( output, "%4.4d", ln );

    for ( i = 0; i <= indent; i++ )
	fprintf( output, " " );

    fprintf( output, "%d: ", indent );
}


/**************************************************************************/
/* STATIC **************   PPrintGraphParameters   ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE NAME OF EACH IMPORT AND EXPORT OF GRAPH g TO output.*/
/*          EXPORT NAME SYNTAX IS export port number : reference name AND */
/*          IMPORT NAME SYNTAX IS import port number : reference name or  */
/*          constant.  THE reference name CAN BE EITHER A SYMBOLIC NAME   */
/*          OR A PORT NUMBER.                                             */
/**************************************************************************/

static void PPrintGraphParameters( g )
PNODE g;
{
    register PEDGE e1;
    register PEDGE e2;
    register PEDGE i;

    fprintf( output, "(" );

    for ( e1 = g->exp; e1 != NULL; e1 = e1->esucc ) {
	if ( e1->eport < 0 )
	    continue;
	    
	fprintf( output, " %d:", e1->eport );

	if ( e1->dname == NULL )
            fprintf( output, "%d", e1->eport );
	else
            fprintf( output, "%s", e1->dname );

	for ( e2 = e1->esucc; e2 != NULL; e2 = e2->esucc )
	    if ( e2->eport == e1->eport )
		e2->eport = -(e2->eport);
        }

    for ( e1 = g->exp; e1 != NULL; e1 = e1->esucc )
        if ( e1->eport <= 0 )
	    e1->eport = -(e1->eport);

    fprintf( output, " RETURNS" );

    for ( i = g->imp; i != NULL; i = i->isucc ) {
	fprintf( output, " %d:", i->iport );

	if ( IsConst( i ) ) {
	    PPrintConst( i );
	    continue;
	    }

        if ( i->dname == NULL )
	    fprintf( output, "%d", i->eport );
        else
	    fprintf( output, "%s", i->dname );
        }

    fprintf( output, " )\n" );
}


/**************************************************************************/
/* STATIC **************    PPrintNodeParameters   ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE NAME OF EACH IMPORT AND EXPORT OF NODE n TO output  */
/*          EXPORT NAME SYNTAX IS export port number : symbolic name AND  */
/*          IMPORT NAME SYNTAX IS import port number : reference name or  */
/*          constant.  THE reference name CAN BE EITHER A SYMBOLIC NAME   */
/*          OR A PORT NUMBER.                                             */
/**************************************************************************/

static void PPrintNodeParameters( n )
PNODE n;
{
    register PEDGE e1;
    register PEDGE e2;
    register PEDGE i;

    fprintf( output, "(" );

    for ( i = n->imp; i != NULL; i = i->isucc ) {
	fprintf( output, " %d:", i->iport );

	if ( IsConst( i ) ) {
	    PPrintConst( i );
	    continue;
	    }

        if ( i->dname == NULL )
	    fprintf( output, "%d", i->eport );
        else
	    fprintf( output, "%s", i->dname );
        }

    fprintf( output, " RETURNS" );

    for ( e1 = n->exp; e1 != NULL; e1 = e1->esucc ) {
	if ( e1->eport < 0 )
	    continue;
	    
        fprintf( output, " %d:%s", e1->eport, e1->dname );

	for ( e2 = e1->esucc; e2 != NULL; e2 = e2->esucc )
	    if ( e2->eport == e1->eport )
		e2->eport = -(e2->eport);
        }

    for ( e1 = n->exp; e1 != NULL; e1 = e1->esucc )
	if ( e1->eport <= 0 )
	    e1->eport = -(e1->eport);

    fprintf( output, " );\n" );
}


/**************************************************************************/
/* LOCAL  **************         PPrintNode        ************************/
/**************************************************************************/
/* PURPOSE: PRINT GRAPH g IN A READABLE FORMAT; indent DEFINES THE        */
/*          NESTING LEVEL.  TYPE INFORMATION IS NOT PRINTED.              */
/**************************************************************************/

static void PPrintNode( g, indent )
PNODE g;
{
    register PNODE n;

    PPrintIndentation( indent, g->if1line );

    switch ( g->type ) {
	case IFIGraph:
	    fprintf( output, "IMPORT FUNCTION %s(...)\n", g->G_NAME );
	    return;

	case IFLGraph:
	    fprintf( output, "LOCAL FUNCTION %s", g->G_NAME );
	    break;

	case IFXGraph:
	    fprintf( output, "EXPORT FUNCTION %s", g->G_NAME );
	    break;

	case IFSGraph:
	    fprintf( output, "SGrph" );
	    break;
	}

    PPrintGraphParameters( g ); indent++;

    for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
	PPrintIndentation( indent, n->if1line );

	if ( IsOther( n ) )
	    fprintf( output, "Other[%d]", n->type );
	else if ( IsSimple( n ) )
	    fprintf( output, "%s", snames[ n->type - IFAAddH ] );
        else
	    fprintf( output, "%s", cnames[ n->type ] );

        PPrintNodeParameters( n );

	if ( IsCompound( n ) )
	    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		PPrintNode( g, indent + 1 );
	}
}


/**************************************************************************/
/* GLOBAL **************         if1PPrint         ************************/
/**************************************************************************/
/* PURPOSE: PRINT ALL FUNCTION GRAPHS TO output IN A READABLE FORM.       */
/**************************************************************************/

void If1PPrint()
{
    register PNODE f;

    for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
	fprintf( output, "\n" );

	AssignNames( f );
	PPrintNode( f, 0 );
	}
}
