#include "world.h"


static int   vfcnt = 0;             /* COUNT OF GENERATED VECTOR FORALLS  */
static int   cfcnt = 0;         /* COUNT OF GENERATED CONCURRENT FORALLS  */
static int   mcnt  = 0;                           /* COUNT OF MOVED NODES */
static int   scnt  = 0;                  /* COUNT OF SPLIT AElement NODES */


/**************************************************************************/
/* LOCAL  **************     MoveTheNegNodes       ************************/
/**************************************************************************/
/* PURPOSE: MOVE THE NODES IN SUBGRAPH src THAT HAVE NEGATIVE LABELS TO   */
/*          SUBGRAPH dst, AND WIRE THE NON-NEGATIVE SOURCE EDGES TO dst.  */
/**************************************************************************/

static void MoveTheNegNodes( src, dst )
PNODE src;
PNODE dst;
{
  register PNODE n;
  register PNODE pn;
  register PNODE sn;
  register PEDGE i;

  pn = dst;

  for ( n = src->G_NODES; n != NULL; n = sn ) {
    sn = n->nsucc;

    if ( n->label >= 0 )
      continue;

    UnlinkNode( n );
    LinkNode( pn, n );
    pn = n;

    for ( i = n->imp; i != NULL; i = i->isucc ) {
      if ( IsConst( i ) )
	continue;

      if ( !IsSGraph( i->src ) )
	continue;

      UnlinkExport( i );
      LinkExport( dst, i );
      }
    }
}


/**************************************************************************/
/* LOCAL  **************    WireNegExports         ************************/
/**************************************************************************/
/* PURPOSE: WIRE THE NEG NODES NOW IN FORALL NODE f2 THAT ARE DIRECTLY    */
/*          REFERENCED IN BODY SUBGRAPH src WHICH HAS A CONTROL ROD WITH  */
/*          PORT NUMBER cport.                                            */
/**************************************************************************/

static void WireNegExports( f2, src, crod )
PNODE f2;
PNODE src;
PEDGE crod;
{
  register PNODE n;
  register PEDGE e;
  register PEDGE ee;
  register PEDGE se;
  register PNODE aelm;
  register PNODE gat;
  register int   port;
  register int   eport;
  register PINFO minfo;
  register PINFO ainfo;
  register PINFO info;

  f2->F_BODY->label = -1;

  for ( n = f2->F_BODY; n != NULL; n = n->nsucc ) {
StartOver:
    for ( e = n->exp; e != NULL; e = se ) {
      se = e->esucc;

      if ( e->dst->label < 0 )
	continue;

      port  = ++maxint;
      eport = e->eport;

      info  = e->info;

      ainfo = FindInfo( ++maxint, IF_ARRAY );
      ainfo->A_ELEM = info;

      minfo = FindInfo( ++maxint, IF_MULTIPLE );
      minfo->A_ELEM = info;

      /* ALLOCATE THE AElement NODE */
      aelm = NodeAlloc( ++maxint, IFAElement );
      CopyVitals( n, aelm );
      LinkNode( src, aelm );

      /* LINK IN THE AElement CONTROL ROD REFERENCE */
      ee = EdgeAlloc( src, crod->iport, aelm, 2 );
      ee->info = crod->info;
      LinkExport( src, ee );
      LinkImport( aelm, ee );

      for ( ee = e; ee != NULL; ee = se ) {
	se = ee->esucc;

	if ( ee->eport != eport )
	  continue;

	if ( ee->dst->label < 0 )
	  continue;

	UnlinkExport( ee );
	ee->eport = 1;
	LinkExport( aelm, ee );
	}

      /* WIRE n TO f2->BODY USING PORT */
      ee = EdgeAlloc( n, eport, f2->F_BODY, port );
      ee->info = info;
      LinkExport( n, ee );
      LinkImport( f2->F_BODY, ee );

      /* ALLOCATE THE AGather NODE */
      gat = NodeAlloc( ++maxint, IFAGather );
      CopyVitals( f2, aelm );
      LinkNode( f2->F_RET, gat );

      /* LINK THE LOWER BOUND TO THE AGather NODE */
      CopyEdgeAndReset( f2->F_GEN->imp->src->imp, f2->F_RET, gat );
      gat->imp->iport = 1;

      /* LINK THE IMPORT VALUE TO THE AGather NODE */
      ee = EdgeAlloc( f2->F_RET, port, gat, 2 );
      ee->info = minfo;
      LinkExport( f2->F_RET, ee );
      LinkImport( gat, ee );

      /* LINK THE gat TO f2->F_BODY */
      ee = EdgeAlloc( gat, 1, f2->F_RET, port );
      ee->info = ainfo;
      LinkExport( gat, ee );
      LinkImport( f2->F_RET, ee );

      /* WIRE f2 TO THE src->G_DAD NODE USING THE NEW ARRAY */
      ee = EdgeAlloc( f2, port, src->G_DAD, port );
      ee->info = ainfo;
      LinkExport( f2, ee );
      LinkImport( src->G_DAD, ee );

      /* WIRE IN THE NEW ARRAY INTO THE AElement NODE */
      ee = EdgeAlloc( src, port, aelm, 1 );
      ee->info = ainfo;
      LinkExport( src, ee );
      LinkImport( aelm, ee );

      goto StartOver;
      }
    }

  f2->F_BODY->label = 0;
}


/**************************************************************************/
/* GLOBAL **************       IsVecCandidate      ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF Forall NODE f IS A CANDIDATE FOR VECTOR        */
/*          EXECUTION.                                                    */
/**************************************************************************/

int IsVecCandidate( f )
PNODE f;
{
  register PNODE n;
  register PEDGE i;

  if ( alliantfx ) {
    /* f MUST HAVE UNFILTERED AGathers ONLY */
    for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc ) {
      if ( n->type != IFAGather )
        return( FALSE );

      if ( n->imp->isucc->isucc != NULL )
        return( FALSE );
      }

    /* f MUST HAVE A SIMPLIFIED GENERATE GRAPH */
    for ( n = f->F_GEN->G_NODES; n != NULL; n = n->nsucc ) {
      if ( n->type != IFRangeGenerate )
        return( FALSE );

      if ( n->nsucc != NULL )
        return( FALSE );
      }

    /* ONLY SPECIFIC NODES ARE ALLOWED IN THE BODY */
    for ( n = f->F_BODY->G_NODES; n != NULL; n = n->nsucc )
      switch ( n->type ) {
        case IFPlus:
        case IFMinus:
        case IFTimes:
        case IFDiv:
        case IFAbs:
        case IFNeg:
        case IFDouble:
        case IFTrunc:
        case IFSingle:
          break;
  
        case IFAElement:
          if ( !IsConst( n->imp ) )
            if ( IsAElement( n->imp->src ) )
              return( FALSE );
  
	  break;
  
        default:
	  return( FALSE );
        }

    return( TRUE );
    }

  if ( cRay ) {
    if ( IsInnerLoop( f->F_BODY ) ) {
      /* NO FILTERS ALLOWED!!! */
      for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc ) {
	switch ( n->type ) {
	  case IFAGather:
	    /* FOR NOW, DO NOT VECTORIZE ARRAYS OF ARRAYS OR BOOLEANS */
	    i = n->imp->isucc;

	    if ( IsMultiple( i->info ) ) {
	      if ( IsArray( i->info->A_ELEM ) )
	        return( FALSE );
              else if ( IsBoolean( i->info->A_ELEM ) )
		return( FALSE );
            } else {
	      if ( IsArray( i->info ) )
	        return( FALSE );
              else if ( IsBoolean( i->info ) )
		return( FALSE );
	      }

	    if ( i->isucc != NULL )
	      return( FALSE );

	    break;

	  case IFReduce:
	  case IFRedTree:
	  case IFRedLeft:
	  case IFRedRight:
	    if ( n->imp->isucc->isucc->isucc != NULL )
	      return( FALSE );

	    break;

	  default:
	    break;
	  }
        }

      return( TRUE );
      }

    return( FALSE );
    }

  return( TRUE );
}


/**************************************************************************/
/* LOCAL  **************      DecodeIndexing       ************************/
/**************************************************************************/
/* PURPOSE: DECONDE INDEXING OPERATIONS AElementN, AElementM, and         */
/*          AElementP IN GRAPH b.                                         */
/**************************************************************************/

static void DecodeIndexing( b )
PNODE b;
{
  register PNODE n;
  register PNODE nn;
  register PEDGE ee;
  register PEDGE ii;
  register PEDGE iii;

  for ( n = b->G_NODES; n != NULL; n = n->nsucc ) {
    /* DO SOME CLEANUP!!! */
    if ( n->label < 0 )
      n->label = -(n->label);

    switch ( n->type ) {
      case IFAElementN:
	n->type = IFAElement;
	break;

      case IFAElementM:
      case IFAElementP:
	if ( n->type == IFAElementM )
	  nn = NodeAlloc( ++maxint, IFMinus );
        else
	  nn = NodeAlloc( ++maxint, IFPlus );

	CopyPragmas( n, nn );
	LinkNode( n->npred, nn );

	ii = n->imp->isucc;
	iii = ii->isucc;

	UnlinkImport( ii );
	UnlinkImport( iii );

	ii->iport  = 1;
	iii->iport = 2;

	LinkImport( nn, ii );
	LinkImport( nn, iii );

	ee = EdgeAlloc( nn, 1, n, 2 );
	ee->info = iii->info;

	LinkExport( nn, ee );
	LinkImport( n, ee );

	n->type = IFAElement;
	break;

      default:
	break;
      }
    }
}


/**************************************************************************/
/* LOCAL  **************      EncodeIndexing       ************************/
/**************************************************************************/
/* PURPOSE: ENCODE INDEXING OPERATIONS OF THE FORM a[i], a[i+I], AND      */
/*          a[i-I], WHERE a IS A K PORT ARRAY AND i and I ARE ONE OF THE  */
/*          FOLLOWING: CONSTANT, K PORT VALUE, OR LOOP CONTROL REFERENCE  */
/*          (HAVING PORT NUMBER cport).                                   */
/**************************************************************************/

static void EncodeIndexing( b, cport )
PNODE b;
int   cport;
{
  register PNODE n;
  register PNODE op;
  register PEDGE i;
  register int   eport;
  register PNODE nn;

  for ( n = b->G_NODES; n != NULL; n = n->nsucc ) {
    /* MAKE SURE ALL LABELS ARE GREATER THAN ZERO */
    if ( n->label < 0 )
      n->label = -(n->label);

    if ( !IsAElement( n ) ) continue;

    /* MAKE SURE THE SOURCE IS A K VALUE ARRAY OR SPECIAL AElement EXPORT */

    if ( !IsArray( n->imp->info ) )
      continue;

    if ( !IsConst( n->imp ) ) {
      if ( !IsSGraph( n->imp->src ) ) {
	switch ( n->imp->src->type ) {
	  case IFAElementN:
	  case IFAElementP:
	  case IFAElementM:
	    break;

	  default:
	    continue;
	  }
        }
      else if ( !IsImport( b->G_DAD, n->imp->eport ) )
	continue;
      }
      
    /* CHECK THE INDEXING */

    if ( IsConst( n->imp->isucc ) ) {
      n->type = IFAElementN;
      continue;
      }

    op = n->imp->isucc->src;

    if ( IsSGraph( op ) ) {
      eport = n->imp->isucc->eport;

      if ( IsImport( b->G_DAD, eport ) || eport == cport )
        n->type = IFAElementN;

      continue;
      }

    switch ( op->type ) {
      case IFPlus:
      case IFMinus:
	NormalizeNode( op );

	if ( !IsConst( op->imp ) ) {
	  if ( !IsSGraph( op->imp->src ) )
	    break;

	  eport = op->imp->eport;

          if ( !( IsImport( b->G_DAD, eport ) || eport == cport ) )
	    break;
	  }

	if ( !IsConst( op->imp->isucc ) ) {
	  if ( !IsSGraph( op->imp->isucc->src ) )
	    break;

	  eport = op->imp->isucc->eport;

          if ( !( IsImport( b->G_DAD, eport ) || eport == cport ) )
	    break;
          }
	    
	n->type = (IsPlus(op))? IFAElementP : IFAElementM;

	i = n->imp->isucc;
	UnlinkImport( i );

	CopyEdgeAndLink( op->imp, n, 2 );
	CopyEdgeAndLink( op->imp->isucc, n, 3 );

	UnlinkExport( i );
	RemoveDeadNode( op ); /* WILL REMOVE op IF op->exp IS NULL */
	break;

      default:
	break;
      }
    }
}


/**************************************************************************/
/* GLOBAL **************      WriteConcurInfo      ************************/
/**************************************************************************/
/* PURPOSE: WRITE LOOP AND FORALL CONCURRENTIZATION INFORMATION TO stderr.*/
/**************************************************************************/

void WriteConcurInfo()
{
  fprintf( stderr, "\n   * FORALL SPLITTING FOR CONCURRENTIZATION\n\n" );
  fprintf( stderr, " Generated Vector Forall Nodes:     %d\n", vfcnt );
  fprintf( stderr, " Generated Concurrent Forall Nodes: %d\n", cfcnt );
  fprintf( stderr, " Moved Nodes:                       %d\n", mcnt );
  fprintf( stderr, " Split AElement Nodes:              %d\n", scnt  );
}


/**************************************************************************/
/* LOCAL  **************    IsFractureCandidate    ************************/
/**************************************************************************/
/* PURPOSE: RETURNS TRUE IF THE NODE LIST OF BODY SUBGRAPH b CONTAINS     */
/*          SOME EXTRACTABLE VECTOR NODES (MARKING THEM WITH NEGATIVE     */
/*          LABELS). B IS ASSUMED TO BE THE BODY OF AN OUTER LOOP. Cport  */
/*          IS THE PORT NUMBER OF THE LOOP'S CONTROL ROD.                 */
/**************************************************************************/

static int IsFractureCandidate( b, cport )
PNODE b;
int   cport;
{
  register PNODE n;
  register PEDGE i;
  register int   c;

  for ( c = 0, n = b->G_NODES; n != NULL; n = n->nsucc ) {
    switch ( n->type ) {
      /* case IFAbs: HURTS VECTORIZATION (SEE if2vector.c IN If2gen) */
      case IFDiv:             
      case IFExp:             
      case IFMax:             
      case IFMin:             
      case IFNeg:             
      case IFPlus:            
      case IFTimes:
      case IFMinus:           
      /* case IFDouble:          */
      /* case IFFloor:           */
      /* case IFInt:             */
      /* case IFSingle:          */
      /* case IFTrunc:           */
	if ( IsArithmetic( n->imp->info ) )
if ( n->imp->info->type != IF_INTEGER )
	  break;

	continue;

      case IFAElementN:
      case IFAElementP:
      case IFAElementM:
	n->label = -(n->label);
	continue;

      default:
        continue;
      }

    for ( i = n->imp; i != NULL; i = i->isucc ) {
      if ( IsConst( i ) )
        continue;

      if ( IsSGraph( i->src ) ) {
	if ( !IsImport( b->G_DAD, i->eport ) ) {
	  if ( i->eport == cport ) {
	    /* IS i LOOP CARRIED??? */
	    if ( IsLoopB( b->G_DAD ) )
	      if ( IsImport( b, i->eport ) )
		goto SkipOut;

	    continue;
	    }

	  goto SkipOut;
	  }

	continue;
	}

      if ( i->src->label < 0 )
	continue;

SkipOut:
      break;
      }

    if ( i != NULL )
      continue;

    if ( n->type != IFAElement )
      c++;

    n->label = -(n->label);
    }

  mcnt += c;

  return( (c > 0)? TRUE : FALSE );
}


/**************************************************************************/
/* LOCAL  **************  DoTheConcurrentization   ************************/
/**************************************************************************/
/* PURPOSE: YANK THE CONCURRENT NODES FROM LOOP OR FORALL f1 WITH BODY b  */
/*          RETURN r, AND CONTORL ROD crod WITH LOWER BOUND low AND UPPER */
/*          BOUND high, AND FORM A NEW FORALL.                            */
/**************************************************************************/

static void DoTheConcurrentization( f1, b, r, crod, low, high )
PNODE f1;
PNODE b;
PNODE r;
PEDGE crod;
PEDGE low;
PEDGE high;
{
  register PNODE n;
  register PEDGE e;
  register PEDGE i;
  register int   neg;
  register int   pos;
  register PNODE nn;
  register PEDGE se;
  register PNODE gen;
  register PNODE body;
  register PNODE ret;
  register PNODE f2;
  register PNODE nnn;
  register PEDGE ee;
  register PNODE aelm;
  register PNODE gat;
  register PNODE rg;
  register int   port;
  register PINFO info;
  register PALIST l;

  /* UNTANGLE AElement[NPM] FANOUT */

  for ( n = FindLastNode( b ); n != b; n = n->npred )
    switch( n->type ) {
      case IFAElementN:
      case IFAElementP:
      case IFAElementM:
	neg = 0;
	pos = 0;

	for ( e = n->exp; e != NULL; e = e->esucc ) {
	  if ( e->dst->label < 0 )
	    neg++;
          else
	    pos++;
	  }

	if ( neg + pos == 0 ) {
	  n->label = -(n->label);
	  break;
	  }

	/* NEG ONLY */
	if ( (neg > 0) && (pos == 0) )
	  break;

	/* POS ONLY */
	if ( (neg == 0) && (pos > 0) ) {
	  n->label = -(n->label);
	  break;
	  }

	/* BOTH NEG AND POS, SO SPLIT THE SUCKER! */
	scnt++;

        nn = CopyNode( n );
        LinkNode( n->npred, nn );

        for ( i = n->imp; i != NULL; i = i->isucc ) {
          if ( IsConst( i ) )
            CopyEdgeAndReset( i, NULL, nn );
          else
	    CopyEdgeAndReset( i, i->src, nn );

          continue;
          }

        n->label = -(n->label);

	for ( e = n->exp; e != NULL; e = se ) {
	  se = e->esucc;

	  if ( e->dst->label >= 0 )
	    continue;

	  UnlinkExport( e );
	  LinkExport( nn, e );
	  }

	break;

      default:
	break;
      }

  if ( IsForall(f1) )
    vfcnt++;
  else
    cfcnt++;

  /* DO THE MOVEMENT!!! */

  f2 = NodeAlloc( ++maxint, IFForall );
  CopyPragmas( f1, f2 );
  f2->info    = f1->info;
  f2->gname   = f1->gname;

  l = AssocListAlloc( 0 );
  l = LinkAssocLists( l, AssocListAlloc( 1 ) );
  l = LinkAssocLists( l, AssocListAlloc( 2 ) );
  f2->alst = l;
  f2->scnt = 3;

  f2->if1line = f1->if1line;
  LinkNode( f1->npred, f2 );

    gen = NodeAlloc( 0, IFSGraph );
    CopyVitals( f2, gen );
    rg  = NodeAlloc( ++maxint, IFRangeGenerate );
    CopyVitals( f2, rg );
    LinkNode( gen, rg );

    ee = EdgeAlloc( rg, 1, gen, crod->iport );
    ee->info = crod->info;
    LinkExport( rg, ee );
    LinkImport( gen, ee );

    port = low->iport;
    low->iport = 1;
    CopyEdgeAndReset( low, gen, rg );
    low->iport = port;

    port = high->iport;
    high->iport = 2;
    CopyEdgeAndReset( high, gen, rg );
    high->iport = port;

  gen->G_DAD = f2;
  gen->gsucc = NULL;
  gen->gpred = NULL;
  LinkGraph( f2, gen );    /* THIS ASSUMES F_GEN IS THE FIRST GRAPH!!! */

  body = NodeAlloc( 0, IFSGraph );
  CopyVitals( f2, body );
  body->G_DAD = f2;
  CopyPragmas( b, body );
  LinkGraph( gen, body );  /* THIS ASSUMES F_BODY IS THE SECOND GRAPH!!! */

  ret = NodeAlloc( 0, IFSGraph );
  CopyVitals( f2, ret );
  ret->G_DAD = f2;
  CopyPragmas( r, ret );
  LinkGraph( body, ret );  /* THIS ASSUMES F_RET IS THE LAST GRAPH!!! */

  /* BLINDLY COPY ALL OF f1'S IMPORTS TO f2 */
  for ( i = f1->imp; i != NULL; i = i->isucc )
    CopyEdgeAndLink( i, f2, i->iport );

  MoveTheNegNodes( b, f2->F_BODY );
  WireNegExports( f2, b, f2->F_GEN->imp );

  DecodeIndexing( f2->F_BODY );
}


/**************************************************************************/
/* LOCAL  **************      VectorizeForalls     ************************/
/**************************************************************************/
/* PURPOSE: TRY AND EXTRACT AND REPACKAGE THE VECTOR OPERATIONS FOUND IN  */
/*          THE NON-VECTOR FORALL NODES OF GRAPH g.                       */
/**************************************************************************/

static void VectorizeForalls( g )
PNODE g;
{
  register PNODE n;
  register PNODE sg;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( !IsCompound( n ) )
      continue;

    if ( IsForall( n ) )
      if ( IsInnerLoop( n->F_BODY ) )
        continue;

    for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
      VectorizeForalls( sg );

    if ( !IsForall( n ) )
      continue;

    /* CHECK IF THE CONTROL IS SUITABLE FOR VECTORIZATION */
    if ( n->F_GEN->G_NODES->nsucc != NULL )
      continue;
    if ( n->F_GEN->imp->src->type != IFRangeGenerate )
      continue;

    /* OK, GIVE IT A SHOT! */
    EncodeIndexing( n->F_BODY, n->F_GEN->imp->iport );

    if ( IsFractureCandidate( n->F_BODY, n->F_GEN->imp->iport ) ) {
      DoTheConcurrentization( n, n->F_BODY, n->F_RET, n->F_GEN->imp,
			      n->F_GEN->imp->src->imp,
			      n->F_GEN->imp->src->imp->isucc      );
      }

    DecodeIndexing( n->F_BODY );
    }
}


/**************************************************************************/
/* GLOBAL **************           If1Vec          ************************/
/**************************************************************************/
/* PURPOSE: YANK AND REPACKAGE VECTOR OPERATIONS FOUND IN THE PROGRAM'S   */
/*          NONVECTOR FORALLS.                                            */
/**************************************************************************/

void If1Vec()
{
  register PNODE f;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    VectorizeForalls( f );
}


/**************************************************************************/
/* LOCAL  **************      ParallelizeLoops     ************************/
/**************************************************************************/
/* PURPOSE: TRY AND EXTRACT AND REPACKAGE THE PARALLEL OPERATIONS FOUND   */
/*          IN THE SEQUENTIAL LOOP NODES (LoopB) OF GRAPH g.              */
/**************************************************************************/

static void ParallelizeLoops( g )
PNODE g;
{
  register PNODE n;
  register PNODE sg;
  register PEDGE crod;
  register PNODE nn;
  register PEDGE ee;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( !IsCompound( n ) )
      continue;

    for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
      ParallelizeLoops( sg );

    if ( !IsLoopB( n ) )
      continue;

    /* CHECK IF THE CONTROL IS SUITABLE FOR PARALLELIZATION */

    /* crod <= [Const,K] */
    nn = n->L_TEST->G_NODES;
    if ( nn == NULL )
      continue;
    if ( nn->nsucc != NULL )
      continue;
    if ( !IsLessEqual( nn ) )
      continue;

    crod = nn->imp;
    if ( IsConst( crod ) )
      continue;
    if ( !IsSGraph( crod->src ) )
      continue;
    if ( crod->info->type != IF_INTEGER )
      continue;
    if ( IsImport( n, crod->eport ) )
      continue;
    if ( (crod = FindImport( n->L_INIT, crod->eport )) == NULL )
      continue;

    ee = nn->imp->isucc;

    if ( !IsConst( ee ) ) {
      if ( !IsSGraph( ee->src ) )
        continue;
      if ( !IsImport( n, ee->eport ) )
	continue;
      }

    /* BODY:  crod := old crod + 1 */
    if ( (ee = FindImport( n->L_BODY, crod->iport )) == NULL )
      continue;
    if ( IsConst( ee ) )
      continue;
    if ( !IsPlus( ee->src ) )
      continue;

    NormalizeNode( ee->src );

    ee = ee->src->imp;
    if ( IsConst( ee ) )
      continue;
    if ( !IsSGraph( ee->src ) )
      continue;
    if ( ee->eport != crod->iport )
      continue;

    ee = ee->isucc;
    if ( !IsConst( ee ) )
      continue;
    if ( atoi( ee->CoNsT ) != 1 )
      continue;

    /* OK, GIVE IT A SHOT! */
    EncodeIndexing( n->L_BODY, crod->iport );

    if ( IsFractureCandidate( n->L_BODY, crod->iport ) ) {
      DoTheConcurrentization( n, n->L_BODY, n->L_RET, crod,
			      crod, nn->imp->isucc       );
      }

    DecodeIndexing( n->L_BODY );
    }
}


/**************************************************************************/
/* GLOBAL **************           If1Par          ************************/
/**************************************************************************/
/* PURPOSE: YANK AND REPACKAGE PARALLEL OPERATIONS FOUND IN THE PROGRAM'S */
/*          SEQUENTIAL LOOPS.                                             */
/**************************************************************************/

void If1Par()
{
  register PNODE f;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    ParallelizeLoops( f );
}
