#include "world.h"

static int efs   = 0;                        /* COUNT OF EXPLODED Foralls */
static int rff   = 0;             /* COUNT OF RESULTING Forall FRAGEMENTS */
static int maelm = 0;                 /* COUNT OF MODIFIED AElement NODES */

#define MAX_HASH  31                  /* HASH TABLES FOR FAST INFO LOOKUP */

static PINFO mihash[MAX_HASH];
static PINFO aihash[MAX_HASH];

/**************************************************************************/
/* LOCAL  **************    IsExplodeCandidate     ************************/
/**************************************************************************/
/* PURPOSE: RETURNS TRUE IF NODE n IS A CANDIDATE FOR EXPLOSION.          */
/**************************************************************************/

static int IsExplodeCandidate( n )
PNODE n;
{
  register PEDGE i;
  register PEDGE e;

  switch ( n->type ) {
    case IFAElementN:
    case IFAElementP:
    case IFAElementM:
      return( FALSE );

    default:
      break;
    }

  /* ARE ALL IMPORTS ONE OF FOUR FROMS: CONSTANTS, SPECIAL AElement NODES, */
  /* OR K PORT VALUES.                                                     */
  for ( i = n->imp; i != NULL; i = i->isucc ) {
    if ( IsConst( i ) )
      continue;

    switch ( i->src->type ) {
      case IFSGraph:
      case IFAElementN:
      case IFAElementM:
      case IFAElementP:
	break;

      default:
	return( FALSE );
      }
    }

  /* ARE ALL USES WITHIN THE SUBGRAPH? */
  /* for ( e = n->exp; e != NULL; e = e->esucc )
    if ( IsSGraph( e->dst ) )
      return( FALSE ); */

  return( TRUE );
}


/**************************************************************************/
/* LOCAL  **************      DecodeIndexing       ************************/
/**************************************************************************/
/* PURPOSE: DECONDE INDEXING OPERATIONS AElementN, AElementM, and         */
/*          AElementP IN GRAPH b.                                         */
/**************************************************************************/

static void DecodeIndexing( b )
PNODE b;
{
  register PNODE n;
  register PNODE nn;
  register PEDGE ee;
  register PEDGE ii;
  register PEDGE iii;

  for ( n = b->G_NODES; n != NULL; n = n->nsucc ) {
    /* DO SOME CLEANUP!!! */
    if ( n->label < 0 )
      n->label = -(n->label);

    switch ( n->type ) {
      case IFAElementN:
	n->type = IFAElement;
	break;

      case IFAElementM:
      case IFAElementP:
	if ( n->type == IFAElementM )
	  nn = NodeAlloc( ++maxint, IFMinus );
        else
	  nn = NodeAlloc( ++maxint, IFPlus );

	CopyPragmas( n, nn );
	LinkNode( n->npred, nn );

	ii = n->imp->isucc;
	iii = ii->isucc;

	UnlinkImport( ii );
	UnlinkImport( iii );

	ii->iport  = 1;
	iii->iport = 2;

	LinkImport( nn, ii );
	LinkImport( nn, iii );

	ee = EdgeAlloc( nn, 1, n, 2 );
	ee->info = iii->info;

	LinkExport( nn, ee );
	LinkImport( n, ee );

	n->type = IFAElement;
	break;

      default:
	break;
      }
    }
}


/**************************************************************************/
/* LOCAL  **************      EncodeIndexing       ************************/
/**************************************************************************/
/* PURPOSE: ENCODE INDEXING OPERATIONS OF THE FORM a[i], a[i+I], AND      */
/*          a[i-I], WHERE a IS A K PORT ARRAY AND i and I ARE ONE OF THE  */
/*          FOLLOWING: CONSTANT, K PORT VALUE, OR LOOP CONTROL REFERENCE  */
/*          (HAVING PORT NUMBER cport).                                   */
/**************************************************************************/

static void EncodeIndexing( b, cport )
PNODE b;
int   cport;
{
  register PNODE n;
  register PNODE op;
  register PEDGE i;
  register int   eport;

  for ( n = b->G_NODES; n != NULL; n = n->nsucc ) {
    /* DO SOME CLEANUP!!! */
    if ( n->label < 0 )
      n->label = -(n->label);

    if ( !IsAElement( n ) ) continue;

    /* MAKE SURE THE SOURCE IS A K VALUE ARRAY */

    if ( !IsArray( n->imp->info ) )
      continue;

    if ( !IsConst( n->imp ) ) {
      if ( !IsSGraph( n->imp->src ) )
	continue;

      if ( !IsImport( b->G_DAD, n->imp->eport ) )
	continue;
      }
      
    /* CHECK THE INDEXING */

    if ( IsConst( n->imp->isucc ) ) {
      n->type = IFAElementN;
      maelm++;
      continue;
      }

    op = n->imp->isucc->src;

    if ( IsSGraph( op ) ) {
      eport = n->imp->isucc->eport;

      if ( IsImport( b->G_DAD, eport ) || eport == cport ) {
        n->type = IFAElementN;
        maelm++;
	}

      continue;
      }

    switch ( op->type ) {
      case IFPlus:
      case IFMinus:
	NormalizeNode( op );

	if ( !IsConst( op->imp ) ) {
	  if ( !IsSGraph( op->imp->src ) )
	    break;

	  eport = op->imp->eport;

          if ( !( IsImport( b->G_DAD, eport ) || eport == cport ) )
	    break;
	  }

	if ( !IsConst( op->imp->isucc ) ) {
	  if ( !IsSGraph( op->imp->isucc->src ) )
	    break;

	  eport = op->imp->isucc->eport;

          if ( !( IsImport( b->G_DAD, eport ) || eport == cport ) )
	    break;
          }
	    
	n->type = (IsPlus(op))? IFAElementP : IFAElementM;

	i = n->imp->isucc;
	UnlinkImport( i );

	CopyEdgeAndLink( op->imp, n, 2 );
	CopyEdgeAndLink( op->imp->isucc, n, 3 );

	UnlinkExport( i );
	RemoveDeadNode( op ); /* WILL REMOVE op IF op->exp IS NULL */
        maelm++;
	break;

      default:
	break;
      }
    }
}


/**************************************************************************/
/* LOCAL  **************      BuildFragement       ************************/
/**************************************************************************/
/* PURPOSE: REMOVE NODE n FROM Forall f1 AND ENCAPSOLATE IT IN ITS OWN    */
/*          FORALL NODE.  THEN LINK THE NEW Forall TO f1.                 */
/**************************************************************************/

static PNODE BuildFragement( f1, n )
PNODE f1;
PNODE n;
{
  register PNODE gen;
  register PNODE body;
  register PNODE ret;
  register PNODE f2;
  register PNODE nn;
  register PNODE nnn;
  register PEDGE i;
  register PEDGE e;
  register PEDGE ee;
  register PEDGE se;
  register PNODE aelm;
  register PNODE gat;
  register int   port;
  register PINFO info;

  f2 = NodeAlloc( ++maxint, IFForall );

  CopyPragmas( f1, f2 );

  f2->info    = f1->info;
  f2->gname   = f1->gname;
  f2->alst    = f1->alst;
  f2->scnt    = f1->scnt;
  f2->if1line = f1->if1line;

  LinkNode( f1->npred, f2 );

  gen = CopyNode( f1->F_GEN );
  gen->G_DAD = f2;
  gen->gsucc = NULL;
  gen->gpred = NULL;

  LinkGraph( f2, gen ); /* THIS ASSUMES F_GEN IS THE FIRST GRAPH!!! */

  body = NodeAlloc( 0, IFSGraph );
  body->G_DAD = f2;
  CopyPragmas( f1->F_BODY, body );
  LinkGraph( gen, body );  /* THIS ASSUMES F_BODY IS THE SECOND GRAPH!!! */

  ret = NodeAlloc( 0, IFSGraph );
  ret->G_DAD = f2;
  CopyPragmas( f1->F_RET, ret );
  LinkGraph( body, ret );  /* THIS ASSUMES F_RET IS THE LAST GRAPH!!! */

  nn = CopyNode( n );
  LinkNode( body, nn );

  for ( i = n->imp; i != NULL; i = i->isucc ) {
    if ( IsConst( i ) ) {
      CopyEdgeAndReset( i, NULL, nn );
      continue;
      }

    if ( IsSGraph( i->src ) ) {
      CopyEdgeAndReset( i, body, nn );
      continue;
      }

    /* MUST BE A SPECIAL AElement NODE! */
    nnn = CopyNode( i->src );
    LinkNode( body, nnn );

    CopyEdgeAndReset( i->src->imp, body, nnn );
    CopyEdgeAndReset( i->src->imp->isucc, body, nnn );

    if ( i->src->imp->isucc->isucc != NULL )
      CopyEdgeAndReset( i->src->imp->isucc->isucc, body, nnn );

    CopyEdgeAndReset( i, nnn, nn );
    }

  for ( e = n->exp; e != NULL; e = n->exp ) {
    /* ALLOCATE AND LINK THE NEW NODE TO NEW BODY AND THREAD THE SYSTEM!! */
    port = ++maxint;
    ee = CopyEdge( e, nn, body );
    ee->iport = port;
    LinkExport( nn, ee   );
    LinkImport( body, ee );

    /* LINK THE LOWER BOUND AND COMPONENT VALUE TO THE NEW AGather NODE */
    gat = NodeAlloc( ++maxint, IFAGather );
    LinkNode( ret, gat );

    CopyEdgeAndReset( gen->imp->src->imp, ret, gat );
    gat->imp->iport = 1;

    ee = EdgeAlloc( ret, port, gat, 2 );

    if ( (info = mihash[(e->info->label)%MAX_HASH]) == NULL ) {
      ee->info = FindInfo( ++maxint, IF_MULTIPLE );
      ee->info->A_ELEM = e->info;
      mihash[(e->info->label)%MAX_HASH] = ee->info;
      }
    else
      ee->info = info;

    LinkExport( ret, ee );
    LinkImport( gat, ee );

    /* LINK THE NEW AGather TO THE NEW RETURN GRAPH */
    port = ++maxint;
    ee = EdgeAlloc( gat, 1, ret, port );

    if ( (info = aihash[(e->info->label)%MAX_HASH]) == NULL ) {
      info = FindInfo( ++maxint, IF_ARRAY ); 
      info->A_ELEM = e->info;
      ee->info = info;
      aihash[(e->info->label)%MAX_HASH] = info;
      }
    else
      ee->info = info;

    LinkExport( gat, ee );
    LinkImport( ret, ee );

    /* LINK THE TWO Foralls */
    ee = EdgeAlloc( f2, port, f1, port );
    ee->info = info;
    LinkExport( f2, ee );
    LinkImport( f1, ee );

    /* BUILD THE NEW AElement NODE---SPECIAL */
    aelm = NodeAlloc( ++maxint, IFAElementN );
    LinkNode( n->npred, aelm );

    /* LINK IN THE CONTROL INDEX */
    ee = CopyEdge( f1->F_GEN->imp, f1->F_BODY, aelm );
    ee->eport = f1->F_GEN->imp->iport;
    ee->iport = 2;
    LinkImport( aelm, ee );
    LinkExport( f1->F_BODY, ee );

    /* LINK IN THE NEW ARRAY SOURCE TO aelm */
    ee = EdgeAlloc( f1->F_BODY, port, aelm, 1 );
    ee->info = info;
    LinkExport( f1->F_BODY, ee );
    LinkImport( aelm, ee );

    /* MOVE n EXPORTS for e->eport TO THE NEW AElement NODE aelm */
    for ( ee = e->esucc; ee != NULL; ee = se ) {
      se = ee->esucc;

      if ( ee->eport != e->eport )
	continue;

      UnlinkExport( ee );
      ee->eport = 1;
      LinkExport( aelm, ee );
      }

    UnlinkExport( e );
    e->eport = 1;
    LinkExport( aelm, e );
    }

  /* COPY f1 IMPORTS TO f2 */
  for ( i = f1->imp; i != NULL; i = i->isucc ) {
    if ( IsExport( f2->F_GEN, i->iport ) || IsExport( f2->F_BODY, i->iport ) )
      CopyEdgeAndLink( i, f2, i->iport );
    }

  /* REMOVE n FROM f1 */
  RemoveDeadNode( n );

  return( f2 );
}


/**************************************************************************/
/* LOCAL  **************       ExplodeForalls      ************************/
/**************************************************************************/
/* PURPOSE: EXPLODE THE FORALL NODES IN GRAPH g. THIS ROUTINE RETURNS     */
/*          TRUE IF g IS THE BODY OF AN INNER LOOP.                       */
/**************************************************************************/

static int ExplodeForalls( g, explodeI )
PNODE g;
int   explodeI;
{
  register PNODE sg;
  register PNODE n;
  register PNODE nn;
  register PNODE sn;
  register PNODE snn;
  register PNODE f;
  register int   in1;
  register int   nin;


  for ( in1 = FALSE, n = g->G_NODES; n != NULL; n = sn ) {
    sn = n->nsucc;

    if ( IsCompound( n ) ) {
      for ( nin = FALSE, sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
        nin = nin ||  ExplodeForalls( sg, explodeI );

      in1 = in1 || nin;

      if ( IsLoop( n ) ) {
	in1 = TRUE;
	continue;
	}
      }

    if ( !IsForall( n ) )
      continue;

    in1 = TRUE;

    if ( explodeI && nin )
      continue;

    /* CHECK IF THE CONTROL IS SUITABLE FOR EXPLOSION: A SINGLE Range NODE */
    if ( n->F_GEN->G_NODES->nsucc != NULL )
      continue;
    if ( n->F_GEN->imp->src->type != IFRangeGenerate )
      continue;

    efs++;
    EncodeIndexing( n->F_BODY, n->F_GEN->imp->iport );

    for ( nn = n->F_BODY->G_NODES; nn != NULL; nn = snn ) {
      snn = nn->nsucc;

      if ( !IsExplodeCandidate( nn ) )
	continue;

      f = BuildFragement( n, nn ); /* THIS WILL REMOVE nn FROM n->F_BODY */

      DecodeIndexing( f->F_BODY );
      rff++;
      }

    DecodeIndexing( n->F_BODY );
    RemoveDeadNode( n ); /* NEW CANN 2/92 */
    }

  return( in1 );
}

/**************************************************************************/
/* GLOBAL **************     WriteExplodeInfo      ************************/
/**************************************************************************/
/* PURPOSE: WRITE FORALL EXPLOSION INFORMATION TO stderr.                 */
/**************************************************************************/

void WriteExplodeInfo()
{
  fprintf( stderr, "\n   * FORALL EXPLOSION\n\n" );
  fprintf( stderr, " Exploded Foralls:            %d\n", efs   );
  fprintf( stderr, " Resulting Forall Fragements: %d\n", rff   );
  fprintf( stderr, " Modified AElement Nodes:     %d\n", maelm );
}


/**************************************************************************/
/* GLOBAL **************       If1Explode          ************************/
/**************************************************************************/
/* PURPOSE: EXPLODE THE FORALL NODES OF ALL FUNCTION GRAPHS.              */
/**************************************************************************/

void If1Explode( explodeI )
int explodeI;
{
  register PNODE f;
  register int   i;

  if ( noassoc ) return;

  for ( i = 0; i < MAX_HASH; i++ ) {
    mihash[i] = NULL;
    aihash[i] = NULL;
    }

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    ExplodeForalls( f, explodeI );
}
