#include <stdio.h>
#include <signal.h>

long clock = 0;
long sysclock = 0;

long
labs(a)
     long	a;
{
  return (a<0)?(-a):(a);
}

void
exit_(stat)
     int	stat;
{
  exit(stat);
}
/* this supports unix (tm bell labs) interrupt handling for di.
   specifically, ctrl/c and arithmetic error handling.		*/


int signalled;

intercept( level ) int level;
{
    /* if (signalled != level) */
    {
	printf( "Interrupt level=%d\n",level );
    	signalled = level;
    }
}

clearsignal()
{ signalled = 0;	}

initsignal()
{ signal( SIGINT, intercept );	}

#if!	  vax
int arithlevel;

arithtrap( level ) int level;
{ arithlevel = level;	}

enablearithtrap()
{ arithlevel = 0;
  signal( SIGFPE, arithtrap );
}

disablearithtrap()
{ signal( SIGFPE, SIG_DFL ); }

int aritherroroccured()
{
/* if arithlevel == 0 then return(0) else return(1) */
  return( (arithlevel == 0) ? 0 : 1 );
}
#endif


#define JUST_IN_CASE_OVERFLOW  100
#define TRUE                   1
#define FALSE                  0
#define OK                     0
#define ERROR                  1

static double          RealScale;
static int             RequiredScale;
static int             ProfBufferSize;
static short          *ProfBuffer;
static FILE           *ProfFile;

static char            ProfEnabled = FALSE;


/******************************/
/*      GetRequiredScale      */ /* refer to man profil */
/******************************/


static int GetRequiredScale( TheScale )
double TheScale;
{
	int Counter;
	int Answer;
	int Bit;

	Answer = 0;

	for ( Counter = 0; Counter < 16; Counter++ ) {
		Bit       = 0;
		TheScale *= 2.0;

		if ( TheScale >= 1.0 )  {
			TheScale -= 1.0;
			Bit       = 1;
			}

		Answer = (Answer << 1) | Bit;
		}

	if ( Answer == 0xffff )
		return( 0x10000 );

	return( Answer );
}


/******************************/
/*        initprofiler        */
/******************************/


int initprofiler( UserMapping )
int   UserMapping;
{
	extern int etext;

	ProfFile = fopen( "prof.out", "w" );

	if ( ProfFile == NULL || UserMapping < 1 )
		return( ERROR );

	RealScale       = 1.0 / (double) UserMapping;
	RequiredScale   = GetRequiredScale( RealScale );

	ProfBufferSize  = (int) &etext;
	ProfBufferSize  = (int) ( ((double) ProfBufferSize) * RealScale );
	ProfBufferSize += JUST_IN_CASE_OVERFLOW;
	ProfBuffer      = (short *) malloc( ProfBufferSize * sizeof(short) );

	if ( ProfBuffer == NULL )
		return( ERROR );

	ProfEnabled = TRUE;

	fprintf( ProfFile, "%d %x\n", UserMapping, &etext );
	fflush ( ProfFile );

	return( OK );
}


/******************************/
/*        startprofiler       */
/******************************/


int startprofiler()
{
	if ( !ProfEnabled )
		return( ERROR );

	profil( ProfBuffer, ProfBufferSize * sizeof(short), 0, RequiredScale );

	return( OK );
}


/******************************/
/*        stopprofiler        */
/******************************/


int stopprofiler()
{
	int Pc;
	int Index;

	if ( !ProfEnabled )
		return( ERROR );

	profil( NULL, 0, 0, 0 );  /* TURN PROFILER OFF */

	for ( Index = ProfBufferSize - 1; Index >= 0; Index-- )
		if ( ProfBuffer[Index] != 0 ) {
			Pc = 2 * ((int) (((double) Index) / RealScale ));

			fprintf( ProfFile, "%x %d\n", Pc, ProfBuffer[Index] );
			}

	fflush ( ProfFile );

	return( OK );
}
/* moveblock
/*   interface to the C library routine to copy bytes
/* usage
/*   moveblock( SourceBegin, SourceEnd, Destination )
/* action
/*   SourceEnd-SourceBegin bytes are moved to Destination
/* sks 87/11/12
*/
void
moveblock( SBegin, SEnd, Dest )
  char *SBegin, *SEnd, *Dest;
{
  bcopy( SBegin, Dest, SEnd-SBegin );
}
