/* ------------------------------------------------------------
lines.c

Patrick Miller		Initial Release			11 June 1991

This module will make a best guess at line numbers.  The
AssignSourceLinesToGraph() routine uses either the line numbers
supplied by the IF1 or the default line that is passed to it.  If all
else fails, then the default line is line 1. 
------------------------------------------------------------ */
#include "world.h"

/* ------------------------------------------------------------ */
/* Assign line numbers to a graph.  For sub nodes, use the line number */
/* for the node (if it exists), the line number for the graph, or the */
/* default line number which was passed in.  Compound nodes are */
/* recursively numbered. */
void
AssignSourceLinesToGraph(G,DefLine)
     PNODE	G;		/* Graph to number */
     int	DefLine;	/* Default line number to use */
{
  PNODE		N,Sub;

  /* If there is no line on the graph, use the DefLine */
  if ( G->line ) {
    DefLine = G->line;
  } else {
    G->line = DefLine;
  }

  /* For each node set its line number.  If it has none, use the DefLine */
  for(N=G->G_NODES;N;N=N->nsucc) {
    if (!N->line) N->line = DefLine;

    /* For compounds, visit the sub graphs and assign line numbers. */
    if ( IsCompound(N) ) {
      for(Sub=N->C_SUBS;Sub;Sub=Sub->C_SUBS) {
	AssignSourceLinesToGraph(Sub,N->line);
      }
    }
  }
}

/* ------------------------------------------------------------ */
/* This function will simply assign line numbers starting at each entry. */
void
AssignLineNumbers()
{
  PNODE		F;

  for( F=glstop->gsucc; F; F = F->gsucc ) {

    /* Make sure all sub-nodes have line numbers.  Use the function */
    /* line as a default if none exists.  If there is no function */
    /* line, then use line #1. */
    AssignSourceLinesToGraph(F,1);
  }
}
