#include "world.h"
/* ------------------------------------------------------------ */
void
ReName(N)
     PNODE	N;
{
  PEDGE		E;
  char		Name[100];

  for(E=N->exp;E;E=E->esucc) {
    if ( ! E->name ) {
      (void)sprintf(Name,"T%d.%d_%d.%d",E->src->label,E->eport,
                        E->dst->label,E->iport);
      E->name = strcpy(malloc(strlen(Name)+1),Name);
    }
  }
}
/* ------------------------------------------------------------ */
int
LegalOrder(A,B)
     PNODE	A,B;
{
  PEDGE		E;
  /* Its a legal order if no outputs of B are inputs of A */
  for(E=B->exp;E;E=E->esucc) if ( E->dst == A ) return 0;

  return 1;
}
/* ------------------------------------------------------------ */
void
ReorderGraph(G)
     PNODE	G;
{
  PNODE		N,M,T;
  int		MadeASwap;
  static int	Label = 1;

  /* ------------------------------------------------------------ */
  /* OK, bubble sorts are terrible, but their easy...  Walk down the */
  /* list of nodes making swaps wherever the line numbers are out of */
  /* order AND the dataflow order is not violated. */
  do {
    MadeASwap = 0;
    for(N=G->G_NODES; N; N=M) {
      M = N->nsucc;
      if ( M && M->line < N->line && LegalOrder(M,N) ) {
	MadeASwap = 1;
	UnlinkNode(N);
	LinkNode(M,N);
	T=N; N=M; M=T;
      }
    }
  } while (MadeASwap);

  /* ------------------------------------------------------------ */
  /* Fill in the empty line numbers from preceeding nodes */
  for(N=G->G_NODES; N; N=N->nsucc) {
    N->label = Label++;
    if ( !N->line ) N->line = N->npred->line;
  }
}

/* ------------------------------------------------------------ */
void
ApplyToGraph(G)
     PNODE	G;
{
  PNODE		N,SUBG;

  ReorderGraph(G);
  ReName(G);

  for(N=G->G_NODES; N; N=N->nsucc) {
    ReName(N);
    if (IsCompound(N)) {
      for(SUBG=N->C_SUBS; SUBG; SUBG=SUBG->C_SUBS) ApplyToGraph(SUBG);
    }
  }
}
  

/* ------------------------------------------------------------ */
void
If2Process()
{
  PNODE		F;

  for(F=glstop->gsucc; F; F=F->gsucc) ApplyToGraph(F);

  If2Write();
}
