/* ------------------------------------------------------------
if1xy.c

Patrick Miller		Initial Release			11 June 1991

This is the main routine for the if1->xcbi graph walker.  The program
inputs an IF1 graph, decorates it with line numbers and XY positions
and dumps out a TCL compatable table.
------------------------------------------------------------ */
#include "world.h"
extern char *rindex();
void If2Process();

/* ------------------------------------------------------------ */
/* This is just the required routines for interface to the if2 graph */
/* library. */

int	sgnok		= 1;
FILE	*input		= stdin;
FILE	*output		= stdout;
char	*program	= "if1xy";

void
Stop(status)
     int	status;
{
}

/* ------------------------------------------------------------ */
/* The main routine walks the graph, assigns line numbers, assigns XY */
/* offsets in the graph, creates a list of entry locations, and */
/* creates a description of the graph */
void
main(argc,argv)
     int	argc;
     char	*argv[];
{
  char IF1File[256];
  char GraphName[256];
  char *DotP;

  /* If there's one argument, its the input file.  Use input file name */
  /* with the .IF1 extension for the ordered version of the if1 file. */
  if ( argc > 1 ) {
    input = fopen(argv[1],"r");
    if ( !input ) {
      fprintf(stderr,"Cannot open the input file %s\n",argv[1]);
      exit(1);
    }

    /* Find the address of the extension. */
    strcpy(GraphName,argv[1]);
    strcpy(IF1File, argv[1]);
    DotP = rindex(GraphName,'.');
    if ( rindex(GraphName,'/') > DotP ) DotP = NULL;

    /* If there is an extension, change it to .graph and .IF1 */
    /* repectively.  If there is none, then catenate one onto the end. */
    if ( DotP ) {
      strcpy(DotP,".graph");
      strcpy( &IF1File[ DotP-GraphName ], ".IF1");
    } else {
      strcat(GraphName,".graph");
      strcat(IF1File, ".IF1");
    }
  }

  If2Read();
  
  /* W. Cedeno: ReWrite if1 with new names and correct node labeling */
  output = fopen(IF1File,"w");
  if ( !output ) {
    fprintf(stderr,"Cannot open the output file %s\n",IF1File);
    exit(1);
  }
  If2Process();
  fclose(output);

  output = fopen(GraphName,"w");
  if ( !output ) {
    fprintf(stderr,"Cannot open the output file %s\n",GraphName);
    exit(1);
  }
  AssignLineNumbers();

  AssignXY();

  CreateEntryTable();

  CreateNodeTable();
  fclose(output);
}
