.TH S.OUT local
.SH NAME
s.out \- SISAL executable
.SH SYNOPSIS
.B s.out 
[ options ] [ infile ] [ outfile ]
.SH DESCRIPTION
.I S.out
is the output file of the optimizing SISAL compiler (see \fIosc\fR(1)) and the
link editor \fIld\fR(1).  It is executable if there were no errors and
no unresolved externals during compilation.
When execution begins, FIBRE input is read from
infile (if provided) or
standard input and is associated positionally
with the arguments of the main SISAL
function.  At completion, results are
written in positional order
to outfile (if provided) or standard output in FIBRE form.
The character `-' implies standard input or output if it appears as  a
file parameter.

Options:
.TP 12
.BI \-wNUM
Set the number of worker processes to
.I NUM.
A value greater than one makes sense only on a multiprocessor
SISAL implementation (Cray, Encore, Sequent, Alliant, etc.).  Default:  1.

.TP 12
.BI \-lsNUM
If compiled for concurrent execution
(refer to \fIosc\fR(1)), 
slice each concurrentized 
.I for
loop into
.I NUM 
pieces.
Default:  Slice each concurrentized
loop into
.I W
pieces, where 
.I W
is the number of workers.

.TP 13
.B \-gss
If compiled for concurrent execution,
slice each concurrentized 
.I for
loop using guided self
scheduling.  Here the thickness of a slice is dynamically computed as
the number of iterations not yet scheduled divided by the
number of workers.
Note that the \-ls and \-gss options conflict.

.TP 12
.BI \-axNUM
Set array expansion value to
.I NUM\.
Each time the space for a dynamically growing array must be
expanded, it will obtain \fINUM\fR times the number of previous
expansions more elements.
Programs with dynamically growing arrays may benefit from a
larger value.  
The expansion value is also used to prevent memory fragmentation in
programs repeatedly building and recycling incrementally smaller or 
larger arrays.
Default:  100.

.TP 12
.BI \-dsNUM
Initialize the shared data management pool 
to
.I NUM
bytes.  An execution that terminates because of storage deadlock may
need more dynamic memory.  Default:  2000000 bytes.

.TP 12
.BI \-pdsNUM
Initialize each private data management pool 
to
.I NUM
bytes.  An execution that terminates because of storage deadlock may
need more dynamic memory.  Default:  2000000 bytes.

.TP 12
.BI \-dxNUM
Set the exact fit storage allocation threshold to
.I NUM
bytes.  This eliminates the existence of
leftover free blocks whose sizes are smaller than \fINUM\fR bytes.  
Default: 100.

.TP 12
.BI \-r
Append resource utilization information to the file s.info (elapsed cpu
time, elapsed wall clock time, memory utilization figures, etc.).
A new file is created if s.info does not exist.

.TP 12
.BI \-z
Do not print the program's output. Default: print the program's output.

.TP 12
.BI \-P
Execute the program using private memory only
(see osc's -P option). In conjunction with
this option, the program cannot run with more than 1 worker process
(refer to the \-w option).
Default: Execute the program using both shared and private memory.

.TP 12
.BI \-in
.I
FOR THE BBN TC2000 ONLY.
Run the program in interactive mode.

.TP 12
.BI \-bmNUM
Run the program in benchmark mode.  \fINUM\fR is an estimate of the execution 
time
(in seconds) that the gang daemon uses to decide if the code should be run
at the time of submission, or queued for later execution.  If the program
runs longer than \fINUM\fR seconds, the gang daemon will
automatically cause the program to revert to interactive mode.
In benchmark mode, the entry point function is called  \fICYCLE\fR times
(see -bc).  Each call is timed and the collected data (in seconds) is
printed to stderr. Hence, \fINUM\fR must reflect the time for
\fICYCLE\fR executions.

.TP 12
.BI \-bcNUM
If the program is being run in benchmark mode, execute the program entry
point \fINUM\fR times. The default value is 2.

.TP 12
.BI \-pRANGE
.I
FOR THE BBN TC2000 ONLY.
Use the processors specified by \fIRANGE\fR.  The format of the \fIRANGE\fR
specifier is a comma seperated list of subranges, denoted by a starting
processor number, a -, and an ending processor number.  There can be no spaces
in the \fIRANGE\fR specifier.  For example, -p10-19,30-39,41,53 specifies that
the program is to be run on processors 10 through 19, 30 through 39, 41, and 53.
The code will print an error message if the number of processors specified by
\fIRANGE\fR does not agree with the -w (see above) argument, and the program
aborts.

.SH IMPORTANT NOTES
One may provide an upper bound in a FIBRE array definition to reduce
FIBRE processing time.  Simply follow the lower bound by a comma 
and then the upper bound; for example,  "[1,2: 10 20]".
