.TH OSC local
.SH NAME
osc \- optimizing SISAL compiler
.SH SYNOPSIS
.B osc 
[ option ]... [ file ]...
.SH DESCRIPTION
.I OSC
compiles SISAL programs and modules, and generates SISAL executables.
Those command line arguments having the suffix `.sis'
are taken to be SISAL source files; each is
parsed, with its resulting object code (IF1)
left in the file whose root name is that of the source file and suffix
is `.if1'.
Then all resulting and provided `.if1' files are linked to form a 
.I program 
(the default) or 
.I module 
for optimization and
code generation. 
A
.I program
is callable from the Operating System (called `s.out' by
default) or possibly an 
external language (see -forC and -forFORTRAN)
with `main' defining the default
entry point (see -e).
A 
.I module
on the other hand, is only callable from a
.I program
or another
.I module.
The
.I module 
system facilitates
the construction of large SISAL applications (see -module and -db).

Compilation may be stopped after any compilation phase and resumed 
at a later time by simply providing
the intermediate file(s) on the compilation command line.
Unless otherwise specified, the results of compilation and any
provided `.o' (compiled SISAL modules, etc.)  and `.a' files and specified 
libraries (-l option) are 
loaded (in the order given) to produce an executable, 
which must include a single
.I program.

By default, all optimizations are 
done: scalar,
build-in-place, and update-in-place.
The scalar optimizations include
record and array fission, 
strength reduction,
common subexpression removal,
loop invariant removal, 
loop fusion,
loop unrolling, 
loop unswitching, 
loop distribution,
global common subexpression removal, 
constant folding,
constant aggregate identification,
and dead code removal.
On concurrent machines, program concurrentization is the default.
On vector machines, program vectorization is the default.
On concurrent-vector machines, program concurrentization and vectorization
are the defaults.
On sequential machines, program parallelization is
automatically disabled; however, a parallelized program will
compile and execute on any machine.

Options:
.TP 13
.B \-v
Verbose mode:  echo the command lines invoking the various compiler phases.

.TP 13
.B \-d
Debug mode:  echo, but do not execute, the command lines invoking the
various compiler phases.

.TP 13
.B \-nocpp
Do not run the C preprocessor on the named SISAL files.
Default: run the C preprocessor.

.TP 13
.B \-CPP
Run each named SISAL file through the C preprocessor and stop, leaving each
result in `root.i', where `root' is the root of the file.

.TP 13
.B \-Dname[=val]
Define macro
.I name
to the C preprocessor as if it were defined by a `#define' directive
in SISAL source (see \fIcc\fR(1)).

.TP 13
.B \-Uname
Undefine macro
.I name
to the C preprocessor as if it were undefined by a `#undef' directive
in SISAL source (see \fIcc\fR(1)).

.TP 13
.B \-Ipath
Establish
.I path
as one of the first directories searched by the C preprocessor when
expanding `#include' directives
in SISAL source (see \fIcc\fR(1)).

.TP 13
.B \-IF1
Compile the named SISAL files to IF1 and stop.
No optimizations are done.

.TP 13
.B \-listing
For each SISAL source file `root.sis' and `root.i' produce 
a listing and cross reference table and place it in `root.lst'.
Default: Do not produce listings and cross reference tables.

.TP 13
.B \-MONO
Compile the named SISAL files to IF1,
link all the resulting and provided `.if1'
files to form a monolithic program, and stop.
The resulting monolith is placed in `root.mono',
where  `root' is the root of the first file on the command line.
No optimizations are done.

.TP 13
.B \-hybrid
Compile the named SISAL files and generate both C and FORTRAN.
The default is to generate C only.  In some situations, this
can increased performance, especially on the Crays.
OSC places the resulting FORTRAN in `rootF.f', where `root' is the
root of the first file on the command line. OSC will automatically compile
the code using the local FORTRAN compiler (see -FF); however, it is
the user's responsibility to provide the appropriate and desired compilation
options, including optimization switches, etc. (see -ff). Note,
OSC uses `root' when building unique FORTRAN
subroutine names, and
OSC does not destroy `rootF.f' files.

.TP 13
.B \-C
Compile the named SISAL files, generate C, and Stop.
The resulting C is placed in `root.c', where `root' is the root of the 
first file on the command line. This option will preserve FORTRAN code
generated due of the -hybrid option (in `rootF.f').

.TP 13
.B \-P
Compile the named SISAL files to use private memory only
This option disables the load time construction of read-only global
constants in shared memory. Use this option in conjunction with the -P  
run time option to realize a complete private memory execution of the program
(see \fIs.out.l\fR).
Default: Construct read-only global constants in shared memory at load time.

.TP 13
.B \-S
Compile the named SISAL files, generate assembly language, and Stop.
The resulting assembly language is placed in `file.s', where `file' is 
the root of the 
first file on the command line.

.TP 13
.B \-noload
Compile the named SISAL files, generate object code, and Stop.
The resulting object code is placed in `root.o', where `root' is the 
root of the 
first file on the command line.

.TP 13
.B \-o absolute
Name the final executable program \fIabsolute\fR. Default: \fIs.out\fR.

.TP 13
.B \-e funct
Take function
.B funct
as a 
.I program 
or 
.I module
entry point (the default entry point is `main').
Entry points can also be specified
within SISAL text using the ``%$entry=funct_list'' pragma,
where ``funct_list'' is a comma separated list of function names;
blanks and tabs are allowed in the list.
Unlike modules,
only one
.I program
entry point is allowed.
See IMPORTANT NOTES at the bottom of this man page.

.TP 13
.B \-c funct
Take function
.B funct
as a C external language function.
C external language functions can also be specified
within SISAL text using the ``%$c=funct_list'',
where ``funct_list'' is a comma separated list of function names;
blanks and tabs are allowed in the list.
Default: take the function to be a 
.I module
entry point reference.
See IMPORTANT NOTES at the bottom of this man page.

.TP 13
.B \-f funct
Take function
.B funct
as a FORTRAN external language function.
FORTRAN external language functions can also be specified
within SISAL text using the ``%$fortran=funct_list'',
where ``funct_list'' is a comma separated list of function names;
blanks and tabs are allowed in the list.
Default: take the function to be a 
.I module
entry point reference.
See IMPORTANT NOTES at the bottom of this man page.

.TP 13
.B \-module
Compile the provided files into a single 
.I module
callable from other 
.I sisal
modules and a
.I program.
Multiple 
.I module
entry points are allowed (see -e).
Default: compile the provided files into a single 
.I program 
callable
from an external language program (see -forFORTRAN and -forC) or the operating
system (the default).

.TP 13
.B \-db database
During 
.I module 
compilation, use \fIdatabase\fR as the inter-module data
repository, which OSC's manages and uses to improve inter-module efficiency.
If used, the same database file must be supplied for each invocation of
OSC used to build the final executable (including compilation of the 
.I program
)
Failure to do this 
will result in a load-error. The file should only be manipulated by OSC,
although it is human readable. WARNING: OSC does not guarantee atomic access to
to \fIdatabase\fR.

.TP 13
.B \-forC
Compile the provided files into a
.I program 
callable from C only.
The default entry point is `main' (see -e).
In this mode, more than one entry point is allowed.
Files ending with `.c' are passed to the local C compiler along
with the other files required to finalize compilation:
See IMPORTANT NOTES at the bottom of this man page.
The resulting executable is by default `c.out'.

.TP 13
.B \-forFORTRAN
Compile the provided files into a
.I program 
callable from FORTRAN only.
The default entry point is `main' (see -e).
In this mode, more than one entry point is allowed.
Files ending with `.f' are passed to the local FORTRAN compiler along
with the other files required to finalize compilation:
See IMPORTANT NOTES at the bottom of this man page.
The resulting executable is by default `f.out'.

.TP 13
.B \-noopt
Disable all optimizations:
shorthand for
\-noscalar,
\-noinline,
\-nomem,
\-noup,
\-novector,
and \-noconcur.

.TP 13
.B \-noinline
Skip function inlining.
Default: all functions, except those part of recursive cycles and
those that would cause an explosion of code, are
inlined.

.TP 13
.B \-inter
Interactively select functions for inlining; ignored if -noinline
is given.

.TP 13
.B \-inlineall
Inline all functions except those part of recursive cycles.
This option conflicts with \-inter and \-noinline, but not
\-call.
Default: Inline all functions, except those part of recursive cycles
and those that would cause an explosion of code.

.TP 13
.B \-call funct
Do not inline function
.B funct.
Ignored if -inter is given.
Default: Try and inline function 
.B funct.

.TP 13
.B \-time funct
Generate code to time the execution of function
.B funct, 
reporting the data to stderr.
This option implies "-call funct".

.TP 13
.B \-noscalar
Disable all scalar optimizations.
This option implies -nofuse.
Default: do all scalar optimizations.

.TP 13
.B \-noifuse
Disable independent loop and conditional fusion.
Default: do independent loop and conditional fusion.

.TP 13
.B \-nodfuse
Disable dependent loop and conditional fusion.
Default: do dependent loop and conditional fusion.

.TP 13
.B \-nofuse
This option implies \-noifuse and -nodfuse.
Default: do independent and dependent loop fusion (see -noscalar).

.TP 13
.B \-noOinvar
Disable the invariant removal of inner loops from the outer loops of each 
function. This is useful when benchmarking a computational kernel.

.TP 13
.B \-uNUM
Selectively unroll \fIfor\fR loops having no more than 
.I NUM
iterations.
An unrolling value of zero disables loop unrolling as does -noscalar.
Default: -u2.

.TP 13
.B \-nounroll
Disable loop unrolling. This option is equivalent to \-u0 and is
implied by -noscalar.

.TP 13
.B \-nomem
Skip all subphases of build-in-place analysis, including
attempts to preallocate storage for arrays returned by
product-form \fIfor\fR loops.  
This option implies \-nopreb.
Default: do all subphases of build-in-place analysis.

.TP 13
.B \-noup
Disable all phases of update-in-place analysis. This option implies
\-nopreb.

.TP 13
.B \-seq
Compile for sequential execution. 
This option is equivalent to providing both \-noconcur and
\-novector.

.TP 13
.B \-pNUM
If compiling for concurrent execution, partition the program
to use no more than 
.I NUM
processors.
Default: Partition the program to use  all the
available processors :
a number defined during OSC installation.

.TP 13
.B \-nNUM
If compiling for concurrent execution, only consider
product-form \fIfor\fR loops 
nested no deeper than
.I NUM 
for concurrent execution.
Default: consider all eligible
product-form \fIfor\fR loops
regardless of nesting level.
A 
.I NUM
of 1 results in consideration of only the outermost loops.
A 
.I NUM
of 0 is equivalent to \-noconcur.

.TP 13
.B \-iNUM
If compiling for concurrent execution, assume 
product-form \fIfor\fR loops 
iterate an average of
.I NUM
times and 
arrays comprise on the average
.I NUM 
elements.
This number helps derive the execution cost estimates 
used during program concurrentization.
Default: 100.

.TP 13
.B \-hNUM
If compiling for concurrent execution, only slice eligible
product-form \fIfor\fR loops 
with estimated execution costs greater than or equal to
.I NUM. 
Default: 7000.

.TP 13
.B \-maxconcur
Shorthand for -h1,
which
results in compilation for maximal concurrency; that is,
all \fIfor\fR loops are assumed to have execution costs that
warrant concurrent execution.
The -n option can still be used to
throttle concurrentization.

.TP 13
.B \-noconcur
Shorthand for ``-n0'',
which disables concurrentization.
Default: For concurrent machines, the default is to concurrentize
loops.

.TP 13
.B \-novector
Disable loop vectorization.
Default: For vector machines, the default is to
vectorize loops.


.TP 13
.B \-cray
Cross compile the named program for execution on CRAY computers.
This option implies -C.


.TP 13
.B \-explode
Aggressively apply loop distribution regardless of the cost in
compilation time.
Default: when compiling for vector execution
OSC will do some loop distribution to uncover
additional vectorization. 

.TP 13
.B \-explodeI
Aggressively apply loop distribution regardless of the cost in compilation
time, except only consider innermost loops (see -explode).

.TP 13
.B \-icse
Push identical operations sequences (possibly having nonidentical operands) 
between subgraphs down and out of conditionals.  This option should be used
with care as it will often increase program execution time on
the Crays. It should improve execution time on machines that execute both
branches of a conditional before discarding the unneeded results.

.TP 13
.B \-noassoc
Disable concurrentization and vectorization of loops comprising floating
point reduction operations, and other associative transformations.
Note, this option does not guarantee that the local C compiler will not
do associative transformations (see -cc).
Default: Attempt to concurrentize and vectorize loops defining
floating
point reduction operations, and do other associative transformations.

.TP 13
.B \-pbNUM
Set the array prebuilding dimension count to 
.B NUM.
A value of zero disables prebuilding and
a value larger than five is treated as five.
Default: -pb3.

.TP 13
.B \-nopreb
Disable array prebuilding. This option is equivalent to -pb0.

.TP 13
.B \-bind
Declares that the descriptor data (lower and upper bounds, etc.) and 
array addresses passed each 
SISAL function call from C or FORTRAN  will never
changes between invocations. However, array components
may change between calls.  Use of this option can dramatically 
increase the performance of the interface during repetitive
invocations.
Default: Assume the descriptor data and array addresses may change
between invocations.

.TP 13
.B \-glue
Disable the removal, hoisting, and combining of non-inlined function calls.

.TP 13
.B \-bounds
Generate code to check for and report array subscript violations, and other
problems such as division by zero.
This option implies -novector, -noinline, -glue, -noscalar, and -nopreb.
Warning, this option may degrade the run time performance of the
program or module being compiled.
Default: do not check for subscript violations and other problems.

.TP 13
.B \-sdbx
Generate code to interface with 
OSC's symbolic debugger.
Note that -bounds and -sdbx conflict, as one function of the symbolic debugger
is to report
subscript violations and divisions by zero.
This option implies -novector, -noconcur, -noinline, -glue, -noscalar, 
-noup, -nomem, -nopreb, and -noimp.
Warning, this option will degrade the run time performance of the program or
module being compiled.

.TP 13
.B \-copyinfo
Generate code to gather aggregate copy information at run time and
write the data to s.info (see the -r option in \fIs.out.l\fR).
This option can result in increased program execution time.
Default: do not gather copy information.

.TP 13
.B \-flopinfo
Generate code to gather floating point operation counts at run time and
write the data to s.info (see the -r option in \fIs.out.l\fR).
This option can result in increased program execution time.
The operations counted are +, -, *, /, and negation,
and reduction operations, logicals, and floating point intrinsics.
Filtered reductions are not counted.
Default: do not gather floating point operation count information.

.TP 13
.B \-fflopinfo funct
Generate code to gather floating point operation counts at run time 
for function 
.I funct
and write
the data to stderr.
This option implies \-flopinfo.
Default: do not gather floating point operation count information for 
function 
.I funct.

.TP 13
.B \-noimp
Compile with the C compiler's optimizers disabled (see \fIcc\fR(1)).
Default: Compile with the C compiler's optimizers enabled.

.TP 13
.B \-CC=COMPILER
Use COMPILER to compile C source.

.TP 13
.B \-cc=OPTION
Give option OPTION to the local C compiler. For example, to profile SISAL
execution, ``-cc=-pg'' works for most Unix C Compilers.

.TP 13
.B \-FF=COMPILER
Use COMPILER to compile FORTRAN source (see -forFORTRAN).

.TP 13
.B \-ff=OPTION
Give option OPTION to the local FORTRAN compiler (see -forFORTRAN).

.TP 13
.B \-real
Treat all SISAL double_real data as real data. Default: honor program
declarations.  SISAL real maps to C float on the target machine.
On the Cray, SISAL double_real maps to C float.

.TP 13
.B \-double_real
Treat all SISAL real data as double_real data. Default: honor program
declarations.  Except for the Cray, SISAL double_real maps to C double.
On the Cray, all double_real data is treated as real (see -real),
and this option is ignored.

.TP 13
.B \-info
Print diagnostic information gathered during compilation to stderr.
Default: run silently.

.TP 13
.B \-cvinfo
Print concurrentization and vectorization 
information gathered during compilation to stderr.
This option provides a subset of the information generated
by the \-info option.
Default: run silently.

.TP 13
.B -lx
During the load phase of compilation, search library `libx.a', where x
is a string, to resolve undefined externals.
Refer to \fIld\fR(1) for the default search paths.

.SH INTRINSICS
OSC recognizes intrinsic functions "and" (bitwise and),
"or" (bitwise or), "xor" (bitwise exclusive or), 
"not" (one's complement), "shiftl" (left shift with zero fill),
"shiftr" (right shift, possibly arithmetic), and the following
math functions taken from the C math library (see math.h):
sin, cos, tan, asin, acos, atan, sqrt, log, log10, etothe (exp in math.h).


.SH IMPORTANT NOTES
If a SISAL
program builds an error value at run time, the program will 
print an error message and abort; further, ``is error'' always
yields ``FALSE''. Stream data types are processed as array
data types.  Program entry points are not reentrant with respect to the outside
world.
Further, no guarantee is given that Fortran or C calls from SISAL are reentrant.
To facilitate program debugging, OSC supports a predefined function
peek that accepts zero or more arguments of any type and returns integer 1.
Peek prints its input values to standard error in FIBRE format.
A call to this  function will not be removed by dead code elimination.
