#include "world.h"


#ifdef CRAY

static void SignalHandler( SigCode )
int SigCode;
{
  extern void InitSignalSystem();

  if ( UsingSdbx )
    switch ( SigCode ) {
      case SIGINT:
	SdbxMonitor( SDBX_INT );
	InitSignalSystem();
	return;

      case SIGFPE:
	SdbxMonitor( SDBX_FPE );
	break;

      default:
	break;
      }

  fprintf( stderr, "\nERROR: SignalCode=%d\n", SigCode );
  AbortParallel();
}

void InitSignalSystem()
{
  signal( SIGINT, SignalHandler );
  signal( SIGFPE, SignalHandler );
}

#else

static int SignalHandler( SigCode )
int SigCode;
{
  extern void InitSignalSystem();

  if ( UsingSdbx )
    switch( SigCode ) {
      case SIGINT:
	SdbxMonitor( SDBX_INT );
	InitSignalSystem();
	return;

      case SIGFPE:
	SdbxMonitor( SDBX_FPE );
	break;

      default:
	break;
      }

  psignal( SigCode, "\nERROR"  );
  AbortParallel();
}

void InitSignalSystem()
{
     /* DYNIX V2.1: shbrk and shsbrk require default SIGSEGV handler for    */
     /*             internal use (extension of shared memory)               */
     /*             Since shmalloc only called once from virtual processor  */
     /*             0, handler for segmentation faults can be used if setup */
     /*             after the shmalloc call (which is the case)             */
     /*             This is not done by libppp.a                            */

  signal( SIGILL,   SignalHandler );
  signal( SIGFPE,   SignalHandler );
  signal( SIGBUS,   SignalHandler );

#ifndef BBN
  signal( SIGHUP,   SignalHandler );
  signal( SIGINT,   SignalHandler );
  signal( SIGQUIT,  SignalHandler );
  signal( SIGPIPE,  SignalHandler );
  signal( SIGXCPU,  SignalHandler );
  signal( SIGXFSZ,  SignalHandler );
  signal( SIGSEGV,  SignalHandler );
#endif
}
#endif
