#include "world.h"


static char *SharedBase; 
static char *SharedMemory; 
static int   SharedSize;

extern char *malloc();


void PrivateFree( Ptr )
POINTER Ptr;
{
  free( (char*)Ptr );
}

POINTER PrivateMalloc( NumBytes )
int NumBytes;
{
  NumBytes += 50;
  NumBytes = ALIGN( int, NumBytes );

  return( (POINTER) malloc(NumBytes) );
}

POINTER SharedMalloc( NumBytes )
int NumBytes;
{
  register char *ReturnPtr;

  NumBytes += 50;
  NumBytes = ALIGN( int, NumBytes );

  if ( SharedSize < NumBytes )
    SisalError( "SharedMalloc", "ALLOCATION SIZE TO BIG" );

  ReturnPtr     = SharedMemory;
  SharedMemory += NumBytes;
  SharedSize   -= NumBytes;

  return( (POINTER) ReturnPtr );
}


#ifdef ENCORE
int p_procnum = 0;
char *share_malloc();

void ReleaseSharedMemory()
{
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  if ( share_malloc_init( SharedSize+100000 ) != 0 )
    SisalError( "AcquireSharedMemory", "share_malloc_init FAILED" );

  SharedBase = SharedMemory = share_malloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "share_malloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

void StartWorkers()
{
  register int NumProcs = NumWorkers;

  while( --NumProcs > 0 )
    if ( fork() == 0 )
      break;

  EnterWorker( p_procnum = NumProcs );

  if ( NumProcs != 0 ) {
    LeaveWorker( FALSE );
    exit( 0 );
    }
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel()
{
  kill( 0, SIGKILL );
}
#endif




#if SUNIX || SUN
int p_procnum = 0;

void ReleaseSharedMemory()
{
  free( SharedBase );
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  SharedBase = SharedMemory = malloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "malloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

void StartWorkers() 
{
  EnterWorker( p_procnum );
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel() 
{ 
  exit( 1 ); 
}
#endif




#ifdef ALLIANT
void ReleaseSharedMemory()
{
  free( SharedBase );
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  SharedBase = SharedMemory = malloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "malloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

void StartWorkers()
{
  EnterWorker( 0 );
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel() 
{ 
  kill( 0, SIGKILL ); 
}
#endif




#if BALANCE || SYMMETRY
extern char *shmalloc();

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  SharedBase = SharedMemory = shmalloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "shmalloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

void ReleaseSharedMemory()
{
  shfree( SharedBase );
}

#ifdef GANGD
void StartWorkers()
{
  register int pID;

  begin_parallel( NumWorkers );

  GETPROCID(pID);

  EnterWorker( pID );

  if ( pID != 0 ) {
    LeaveWorker( FALSE );
    end_parallel();
    }
}

void StopWorkers()
{
  LeaveWorker( TRUE );
  end_parallel();
}

void AbortParallel() 
{ 
  abort_parallel(); 
}
#else
int p_procnum = 0;

void StartWorkers( )
{
  register int NumProcs = NumWorkers;

  while( --NumProcs > 0 )
    if ( fork() == 0 )
      break;

  EnterWorker( p_procnum = NumProcs );

  if ( NumProcs != 0 ) {
    LeaveWorker( FALSE );
    exit( 0 );
    }
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel()
{
  kill( 0, SIGKILL );
}
#endif

#endif




#ifdef CRAY
int TaskInfo[10][3];
LOCK_TYPE TheFirstLock;

void ReleaseSharedMemory()
{
  free( SharedBase );
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  SharedBase = SharedMemory = malloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "malloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

int ProcessorId()
{
  register int pID;
  GETPROCID(pID);
  return( pID );
}

static void CrayWorker( ProcId )
int ProcId;
{
  EnterWorker( ProcId );
  LeaveWorker( FALSE );
}

void StartWorkers()
{
  register int NumProcs = NumWorkers;
  register int i;

  MY_LOCKASGN;

  for ( i = 0; i < NumProcs; i++ ) {
    TaskInfo[i][0] = 3;
    TaskInfo[i][2] = i;  /* PROCESS IDENTIFIER */
    }

  for ( i = 1; i < NumProcs; i++ )
    TSKSTART( TaskInfo[i], CrayWorker, TaskInfo[i][2] );

  EnterWorker( TaskInfo[0][2] );
}

void StopWorkers()
{
  register int i;

  LeaveWorker( TRUE );

  for ( i = 1; i < NumWorkers; i++ )
    TSKWAIT( TaskInfo[i] );
}

void AbortParallel()
{
  ERREXIT();
}
#endif


#ifdef SGI
static ulock_t  TheLock;
static usptr_t *UsHandle;

void ReleaseSharedMemory()
{
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  char ArenaName[50];

  SharedSize = NumBytes + 100000;

  sprintf( ArenaName, "/tmp/sis%d", getpid() );

  /* if ( (usconfig( CONF_INITSIZE, 1000 )) == -1 )
    SisalError( "AcquireSharedMemory", "USCONFIG CONF_INITSIZE FAILED" ); */

  if ( (usconfig( CONF_ARENATYPE, US_SHAREDONLY )) == -1 )
    SisalError( "AcquireSharedMemory", "USCONFIG CONF_ARENATYPE FAILED" );

  if ( (UsHandle = usinit(ArenaName)) == NULL)
    SisalError( "AcquireSharedMemory", "USINIT FAILED" );

  if ( (TheLock = usnewlock( UsHandle )) == (ulock_t) NULL )
    SisalError( "AcquireSharedMemory", "usnewlock FAILED" );


  SharedBase = SharedMemory = (char *) malloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "malloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

static void SgiTransfer( ProcId )
int ProcId;
{
  GetProcId = ProcId;

  /* if ( NumWorkers > 1 ) */
  /*   if ( BindParallelWork ) */
  /*     if ( sysmp( MP_MUSTRUN, ProcId ) == -1 ) */
  /*       SisalError( "SgiTransfer", "sysmp MP_MUSTRUN FAILED" ); */

  EnterWorker( ProcId );

  if ( ProcId != 0 ) {
    LeaveWorker( FALSE );
    _exit( 0 );
    }
}

void StartWorkers()
{
  register int NumProcs = NumWorkers;

  while( --NumProcs > 0 )
    if ( sproc( SgiTransfer, PR_SADDR, NumProcs ) == -1 )
      SisalError( "StartWorkers", "sproc FAILED" );

  if ( NumWorkers > 1 )
    if ( schedctl( SCHEDMODE, SGS_GANG, 0 ) == -1 )
      SisalError( "StartWorkers", "schedctl FAILED" );

  SgiTransfer( NumProcs );
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel()
{
  kill( 0, SIGKILL );
}

int MyLock(plock)
register volatile LOCK_TYPE *plock;
{
  for (;;) {
    while (*(plock) == 1);
    ussetlock(TheLock);
    if (*(plock) == 0) {
      *(plock) = 1;
      usunsetlock(TheLock);
      break;
      }
    usunsetlock(TheLock);
    }
}

int MyUnlock(plock)
register volatile LOCK_TYPE *plock;
{
  *plock = 0;
}

int MyInitLock(plock)
register volatile LOCK_TYPE *plock;
{
  *plock = 0;
}

BARRIER_TYPE *MyInitBarrier()
{
  barrier_t *bar;

  if ( (bar = new_barrier( UsHandle )) == (barrier_t *) NULL )
    SisalError( "myinitbarrier", "new_barrier FAILED" );

  init_barrier(bar);

  return( (BARRIER_TYPE*) bar );
}

int MyBarrier( bar, limit )
BARRIER_TYPE *bar;
int limit;
{
  barrier( (barrier_t *) bar, limit );
}
#endif




#ifdef BBN
int p_procnum = 0;

#include <ctype.h>
#include "/usr/local/include/gang.h"
static int Proc_ids[MAX_PROCS];

/*
 * we need to redefine exit so that we can block sigterm and end 
 * gracefully.  Gist uses the exit routine to write its buffers
 * so we don't want to take a sigterm while we are exiting.
 */

#define NUM_EXITFUNC 32
/*
 *  exit and atexit code.
 *
 *    Under the pxp model of computation, a child node is killed as soon 
 *  as the parent detects that a sibling has taken an exception or exited.
 *  The children who are in exit at the time need to ignore the signal, 
 *  and continue through it.  Thus we set the sigmask to ignore SIGTERM, and 
 *  continue on through exit.
 */

/* #include <signal.h> */

static void (*atExitRoutines[NUM_EXITFUNC])();

static int exitRoutineNum = 0;

int
#ifdef __ANSIC__
atexit(void (*aFunc)())
#else
atexit(aFunc)
void (*aFunc)();
#endif
{
  /*
   * ensure that there is room in the exit routine list, return -1 if not
   * register the function and return 0 otherwise
   */

  if (exitRoutineNum < NUM_EXITFUNC) {
    atExitRoutines[exitRoutineNum++] = aFunc;
    return(0);
  } else {
    return(-1); /* error, no room left */
    }
}

/*
 * exit routine - set the SIGTERM interrupt off, call the exit routines 
 *                registered with atexit, and then cleanup and _exit;
 */
int
#ifdef __ANSIC__
exit(int status)
#else
exit(status)
int status;
#endif
{
  void (*func)();
  int exitNum;

  /* 
   * first thing is turn of the SIGTERM exceptions.  We want to exit
   * with a little grace, and need the parent to leave us along as we do.
   */

  (void) sigblock(sigmask(SIGTERM)); /* turn off sigterms */

  /* 
   * remove the routine *before* calling it.  This will get rid of 
   *       the problem of recursion - when the routine trys to call
   *       exit itself.
   */

  for (exitNum = 0 ; exitNum < exitRoutineNum ; exitNum++) {
    func = atExitRoutines[exitNum];

    atExitRoutines[exitNum] = (void *) -1;

    if (func != (void *) -1) { /* not called already */
      (*func)();
      }
    }

    _cleanup();   
    _exit(status);
}


#define MAX_KILL_RETRIES (8*1024)

BailOut(status,kids,num_procs)
int status;
int kids[];
int num_procs;
{
  union wait child_status;
  unsigned int counter;
  unsigned int retry_count = 0;
  unsigned int pids_left = 0;

  /*
   * since we don't know which child has exited, if any, we signal them all
   */

  for(counter = 0; counter < NumWorkers; counter++)
    if(kids[counter] != 0) {
      (void)kill(kids[counter], SIGTERM);
      pids_left++;
      }

  /*
   * now we want to wait for all of the children we think we have
   * laying around spending our money -- if a child exited to cause us
   * to enter this routine, num_procs will be 1 less than the total 
   * number of children
   */
 for(counter = 0;counter < num_procs; counter++)
   while(1) { /* loop only terminates if a child does */
     if(wait(&child_status) == -1) {
       perror("BailOut: unable to get child status");
       gsDetach();
       exit(status);
       }

     if(WIFEXITED(child_status))
       break;

     if(retry_count++ >= MAX_KILL_RETRIES) {
       fprintf(stderr,
               "WARNING: timeout on exit -- please check child processes\n");
       fflush(stderr);
       gsDetach();
       exit(status);
       }
     }

  gsDetach();
  /* everything o.k., just leave quietly */
}

ChildExit()
{
  fflush(stdout);
  fflush(stderr);
  exit(0);  /* Make signaled children exit nicely */
}

static int *parseMap(count, string)
int count;
char *string;
{
  int *map;
  int anInt;       /* tmp counter */
  char *index;     /* index into string */
  int start, stop; /* tmp vars */
  int nodesFound = 0;

  map = (int *) malloc (sizeof(int) * count);

  for (anInt = 0 ; anInt < count ; anInt++) {
    map[anInt] = -1;
    } /* for */

  if (string == NULL) { /* no string, return this */
    return map;
    } /* if */

  start = -1;
  for (index = string ; *index ; ) { /* run down string */
    switch(*index) {
      case '0': case '1': case '2': case '3': case '4': 
      case '5': case '6': case '7': case '8': case '9':
        if (start == -1) { /* if we ar looking for a start position */
          start = atoi(index);
          while(isdigit(*index)) index++;
        } else { /* have start, looking for stop */
          stop = atoi(index);
          if (start == stop) {
            fprintf(stderr, "err in cpu range <%s>\n", index);
            exit(1);
            } /* if */

          if (start < stop) {
            if ((stop - start) > (count - nodesFound)) {
              fprintf(stderr, " error, asked for %d nodes, NumWorkers = %d\n",
                                nodesFound + (stop -start), count);
              exit(1);
              } /* if */

            for (anInt = start ; anInt <= stop ; anInt++) {
              map[nodesFound++] = anInt;
              } /* for */
          } else { /* stop < start */
            if ((start - stop) > (count - nodesFound)) {
              fprintf(stderr, " error, asked for %d nodes, NumWorkers = %d\n",
                                nodesFound + (stop -start), count);
              exit(1);
              } /* if */

            for (anInt = start ; anInt >= stop ; anInt--) {
              map[nodesFound++] = anInt;
              } /* for */
            } /* if */

          while(isdigit(*index)) index++;
            start = stop = -1;
          } /* if */

        break;

      case ',':
      case ' ':
      case 0: /* for end of string */
        if (start != -1) {
          map[nodesFound++] = start;
          start = -1;
          } /* if */

        index++;
        break;

      case '-':
        if (start == -1) { /* error, range must have a start */
          fprintf(stderr, "error, range with no start\n");
          exit(1);
          } /* if */

        index++;
        break;

      case '+':
        index++;
        if (*index) {
          fprintf(stderr, "%s: error, open range not last item in list\n");
          exit(1);
          } /* if */

        if (start == -1) {
          fprintf(stderr, "error, open range does not have start\n");
          exit(1);
          } /* if */

        anInt = 0;
        while (nodesFound < count) {
          map[nodesFound] = start + anInt;
          anInt++;
          nodesFound++;
          } /* while */

        start = -1;
        break;

      default:
        fprintf(stderr, "error unknown character <%c>\n", *index);
        exit(1);
      } /* switch */
    } /* for */

  /*
   * if we make it here with start equal something, we have hit the end
   * of the string, and have to grab the last item.
   */
  if (start != -1) {
    map[nodesFound++] = start;
    } /* if */

  if (nodesFound != count) {
    fprintf(stderr,"parsed %d nodes, needed %d\n",  nodesFound, count);
    exit(1);
    } /* if */

  for (anInt = 0 ; anInt < (count-1) ; anInt++) {
    for (start = anInt+1 ; start < count ; start ++) {
      if (map[anInt] == map[start]) {
        fprintf(stderr,"ERROR node %d selected twice\n", 
                        map[start]);
        exit(1);
        } /* if */
      } /* for */
    } /* for */

  return map;
} /* parseMap */

int JobId;
extern gsPrioClass_t GsClass;        /* class of this job */
extern int BenchTime;        /* amount of benchmark time for this job */
extern char *Proc_string;
extern sbarrier_t *StartBarrier;
unsigned char IsGang;

#define GSCHED_NUM 0                /* always connect to scheduler 0 */
#define CAN_RETRY_ATTACH(x) ((x == gsBenchmarking) || (x == gsResourceInUse))
#define MAXBENCHTRIES 60        /* retry sleep 60 times */
#define BENCHSLEEP 60                /* 60 seconds for each sleep */

void StartWorkers()
{
  register int num_procs = NumWorkers;
  char *env_string;
  gsRetVal gs_return_code;
  int llnl_ret_code;
  int my_gid, my_cluster;
  kern_return_t success;
  unsigned int tn;                /* temp node counter */
  unsigned int terminated_pid;
  union wait child_status;
  int *nodemap;
  int jobid;                        /* local copy to pass to children */
  gsPrioClass_t gsclass;                /* local copy to pass to kids */
  char *string;
  int benchtries = 0;
  unsigned char isgang;
  unsigned int i;

  IsGang = isgang = TRUE;

  /*
   * enable llnl_job_control
   */
  llnl_ret_code = llnl_job_control(1);

  if(llnl_ret_code == -1) {
    perror("llnl_job_control call failed");
    exit(1);
    }

  if(num_procs > 1) {
    signal(SIGTERM,ChildExit);
    }

  /*
   * the generic user is "unknown"
   */
  gs_return_code = gsAttach(GSCHED_NUM,GS_REMOVE_ON_EXIT,&my_cluster);
  if(gs_return_code != gsSuccess) {
    if(CAN_RETRY_ATTACH(gs_return_code)) {
      unsigned int retries = 0;
      gsErrorMsg(gs_return_code,&string);
      fprintf(stderr, 
	      "WARNING: gs_attach: cannot attach to scheduler: %s - retrying\n",
              string);
      for (retries = 1 ; CAN_RETRY_ATTACH(gs_return_code) ;retries <<= 1)  {
        sleep(retries);
        gs_return_code = gsAttach(GSCHED_NUM,GS_REMOVE_ON_EXIT,&my_cluster);
        }
      }

    if(gs_return_code != gsSuccess) {
      gsErrorMsg(gs_return_code,&string);
      fprintf(stderr,"gsAttach: cannot attach to scheduler: %s\n",string);
      exit(1);
      }
    }

  /*
   * if the user has specified a map, use it
   */
 nodemap = parseMap(num_procs, Proc_string);


 jobid = JobId = NEWJOBID;
 gsclass = GsClass;

 gs_return_code = gsAllocateProcs(&JobId, num_procs, nodemap);
 if(gs_return_code != gsSuccess) {
   if(CAN_RETRY_ATTACH(gs_return_code)) {
     unsigned int retries = 0;
     gsErrorMsg(gs_return_code,&string);
     fprintf(stderr,
             "WARNING: gsAllocateProcs: cannot allocate nodes: %s - retrying\n",
             string);

     for (retries = 1 ; CAN_RETRY_ATTACH(gs_return_code) ;retries <<= 1) {
       sleep(retries);
       gs_return_code = gsAllocateProcs(&JobId,num_procs,nodemap);
       }
     }

   if(gs_return_code != gsSuccess) {
     gsErrorMsg(gs_return_code,&string);
     fprintf(stderr, "gsAllocateProcs: cannot allocate nodes : %s\n",string);
     fprintf(stderr,"nodemap: \n");
     for(i=0; i < num_procs; i++)
       fprintf(stderr,"%d\n",nodemap[i]);
     exit(1);
     }
   }

 /*
  * create one process for each node 
  */
 gs_return_code = gsCreatProcesses(JobId, num_procs);
 if(gs_return_code != gsSuccess) {
   if(CAN_RETRY_ATTACH(gs_return_code)) {
     unsigned int retries = 0;
     gsErrorMsg(gs_return_code,&string);
     fprintf(stderr,
             "WARNING: gsCreatProcesses: cannot yet fork: %s - retrying\n",
             string);
     for (retries = 1 ; CAN_RETRY_ATTACH(gs_return_code) ;retries <<= 1) {
       sleep(retries);
       gs_return_code = gsCreatProcesses(JobId,num_procs);
       }
     }

   if(gs_return_code != gsSuccess) {
     gsErrorMsg(gs_return_code,&string);
     fprintf(stderr,
             "gsCreatProcesses: cannot fork: %s\n",string);
     exit(1);
     }
   }


 /*
  * pour the tasks into the nodes and stir...
  */
 for(tn = 0; tn < num_procs; tn++) {
   success = fork_and_bind(nodemap[tn], my_cluster, &Proc_ids[tn]);
   if(success != KERN_SUCCESS) {
     mach_error("fork and bind failure",success);
     fprintf(stderr,"Couldn't fork process %d\n",tn);
     BailOut(1,Proc_ids,num_procs);
     }

   /*
    * if if am the child, record my proc id, run the function,
    * and exit
    */
   if(Proc_ids[tn] == 0) {
     p_procnum = tn;
     JobId = jobid;
     GsClass = gsclass;
     IsGang = isgang;

     EnterWorker(p_procnum);
     /*
      * if I am not the master, call leave worker and exit
      */
     if(tn != 0) {
       LeaveWorker( FALSE );
       exit(0);
     } else {
       /*
        * otherwise, return out so master can call SisalMain
        */
       return;
       }
     }

   /*
    * if I am the parent, I skip the above code and loop back around
    */
   }

 gs_return_code = gsAddProcesses(JobId, num_procs, Proc_ids);
 if(gs_return_code != gsSuccess) {
   gsErrorMsg(gs_return_code,&string);
   fprintf(stderr, "%s: cannot register nodes : %s\n", string);
   BailOut(1,Proc_ids,num_procs);
   }

 /*
  * now try and set the appropriate class
  */
 if(GsClass != pc_none) {
   if(GsClass != pc_benchmark) {
     gs_return_code = gsSetPClass(JobId, GsClass);
   } else {
     while(benchtries < MAXBENCHTRIES) {
       gs_return_code = gsBenchMark(JobId, BenchTime,GS_NOFLAG);
       if((gs_return_code != gsSuccess) &&
          (gs_return_code != gsClassNotChanged)) {
         gsErrorMsg(gs_return_code,&string);
         fprintf(stderr,
	  "StartParallelExecution: cannot begin benchmarking: %s, retrying\n",
	  string);
         sleep(BENCHSLEEP);
       } else {
         break;
	 }

       benchtries++;
       }
     }

   if((gs_return_code != gsSuccess) &&
      (gs_return_code != gsClassNotChanged)) {
     gsErrorMsg(gs_return_code, &string);
     fprintf(stderr, " cannot obtain class desired: %s\n", string);
     BailOut(1,Proc_ids,num_procs);
     }
   }

 /*
  * now enter barrier to let the workers go
  */
 WAIT_BARRIER(StartBarrier);

 while(num_procs) {
   if((terminated_pid = wait(&child_status)) == -1) {
     perror("Start Parallel: unable to get child status");
     BailOut(1,Proc_ids,num_procs);
     }

   /*
    * if the child exited because of a signal, get out
    */
   if(WIFEXITED(child_status) && WIFSIGNALED(child_status))
     goto GetOut;

   /*
    * otherwise, loop back with one less child
    */
    num_procs--;
    }

  /*
  * all children died a natural death, simply exit
  */
  gsDetach();
  exit(0);


GetOut:
  if(child_status.w_termsig == 0) {
    if(child_status.w_retcode) {
      fprintf(stderr, "first child %d exited with status %d \n",
                      terminated_pid,child_status.w_retcode);
      }

    BailOut(child_status.w_retcode, Proc_ids,num_procs-1);
  } else {
    psignal(child_status.w_termsig, "first child died on signal");
    BailOut(1,Proc_ids,num_procs-1);
    }

  /* NOTREACHED */
}

void StopWorkers()
{
  LeaveWorker( TRUE );
}

void AbortParallel() { BailOut(1,Proc_ids,NumWorkers); }

void mylock(lockptr)
int *lockptr;
{
  register short got_lock = 0;
  register short backoff  = 0;
  register int   memval;

  while( !got_lock ) {
    if ( (memval = xmemi(lockptr, 1)) != 0 ) {
      backoff += 1;
      waitspin(backoff);
      continue;
      }
    else
      got_lock = 1;
    }
}

void myunlock(lockptr)
int *lockptr;
{
  *lockptr = 0;
}

void AcquireSharedMemory( NumBytes ) 
int NumBytes;
{
  SharedSize = NumBytes + 100000;

  if ( UsePrivateMemory )
    SharedBase = SharedMemory = (char *) malloc( SharedSize-40 );
  else
    SharedBase = SharedMemory = (char *) shmalloc( SharedSize-40 );

  if ( SharedMemory == (char *) NULL )
    SisalError( "AcquireSharedMemory", "shmalloc FAILED" );

  SharedMemory = ALIGN(char*,SharedMemory);
}

void ReleaseSharedMemory()
{
  shfree( SharedBase );
}
#endif
