#define POINTER   char*

#define True      1
#define False     0

#define MaxInt          ((int)(((unsigned int)-1) >> 1))
#define MinInt          -MaxInt

#ifdef CRAY
#define MaxFloat         2.7e2465
#define MinFloat        -2.7e2465
#define MaxDouble        2.7e2465
#define MinDouble       -2.7e2465
#endif

#if SUNIX
#define MaxFloat         1.7e38
#define MinFloat        -1.7e38
#define MaxDouble        1.7e38
#define MinDouble       -1.7e38
#endif

#if SYMMETRY || BALANCE || ALLIANT || ENCORE || SGI || SUN || BBN
#define MaxFloat         1.9e38
#define MinFloat        -1.9e38
#define MaxDouble       1.7e308
#define MinDouble      -1.7e308
#endif

#if SYMMETRY || BALANCE || BBN
#else
#define shared
#endif

#ifndef SGI
#define volatile
#endif

/* POINTER to CHARACTER CAST TO DO POINTER to CHARACTER MATHEMATICS */
#ifdef CRAY
#define PCMCAST char*
#else
#define PCMCAST int
#endif

#if ALLIANT || BBN
#define ALIGN_SIZE sizeof(double)
#else
#if CRAY
#define ALIGN_SIZE sizeof(int)
#else
#ifdef SGI
#define ALIGN_SIZE sizeof(int)
/* #define ALIGN_SIZE sizeof(double) */
#else
#define ALIGN_SIZE sizeof(long)
#endif
#endif
#endif

#define ALIGN(x,y)       ((x)((((int)y)+(ALIGN_SIZE))&(~((ALIGN_SIZE)-1))))
#define SIZE_OF(x)       (((sizeof(x)/(ALIGN_SIZE))+1)*(ALIGN_SIZE))
#define ALIGNED_INC(x,y) (((PCMCAST)y)+SIZE_OF(x))

#ifdef CRAY
#define float double
#endif
