#define ARRAY     struct Array
#define ARRAYP    struct Array *
#define PHYS      struct ArrayPhys
#define PHYSP     struct ArrayPhys *
#define BUFFER    struct MemoryBuffer
#define BUFFERP   struct MemoryBuffer *
#define PSBUFFER  struct PointerSwapBuffer
#define PSBUFFERP struct PointerSwapBuffer *

struct ArrayPhys {
  int       Size;               /* ABSOLUTE SIZE OF PHYSICAL SPACE    */ 
  POINTER   Base;               /* FIRST CELL OF PHYSICAL SPACE       */
  LOCK_TYPE Mutex;              /* LOCK FOR PHYSICAL BLOCK            */
  int       RefCount;           /* CURRENT NUMBER OF REFERENCES       */
  int       ExpHistory;         /* COUNT OF PREVIOUS EXPANSIONS       */
  int       Free;               /* UNOCCUPIED CELLS TO THE RIGHT      */
  POINTER   Dope;               /* UTILITY FIELD                      */

  POINTER   PBase;            /* FIRST CELL OF PRIVATE PHYSICAL SPACE */
  int       Owner;            /* PROCESSOR OWNING PBase               */
  int       Status;           /* STATUS OF PBASE                      */
  PHYSP     Next;             /* DISTRIBUTED DEALLOCATION UTILITY     */
  };

struct Array {
  POINTER   Base;               /* RELATIVE BASE                      */
  int       LoBound;            /* LOWER BOUND                        */
  int       Size;               /* LOGICAL ARRAY SIZE                 */
  PHYSP     Phys;               /* POINTER TO PHYSICAL BLOCK          */
  LOCK_TYPE Mutex;              /* LOCK FOR DOPE VECTOR               */
  int       RefCount;           /* CURRENT NUMBER OF REFERENCES       */
  int       Mutable;            /* INTERFACE MUTABILITY               */
  };

struct MemoryBuffer {
  PHYSP    Phys;
  POINTER  Base;
  };

struct PointerSwapBuffer {
  POINTER Current;             /* THE STORAGE TO USE ON THIS ITERATION     */
  POINTER Next;                /* THE STORAGE TO USE ON THE NEXT ITERATION */
  POINTER Temp;                /* POINTER SWAP TEMPORARY VARIABLE          */
  int     InfoTop;             /* Info TOP POINTER                         */
  int     Info[6];             /* Info ARRAY FOR REGION                    */
  };

extern POINTER  ArrayDuplicatePlus();
extern POINTER  ArrayDuplicate();
extern POINTER  pr_ArrayDuplicatePlus();
extern POINTER  pr_ArrayDuplicate();

extern PHYSP    DoPhysExpand();
extern PHYSP    dpr_DoPhysExpand();
extern PHYSP    pr_DoPhysExpand();

#define pr_ACTIVE    1
#define pr_NOTACTIVE 2
#define pr_INVALID   3
