#include "world.h"

int   level      = 1000000;  /* NESTED LOOP PARALLIZATION THRESHOLD       */
int atlevel      = -1;       /* ONLY SLICE AT THIS PARALLEL NESTING LEVEL */

static int edges;             /* NUMBER OF COUNTED EDGES                  */
static int total;             /* TOTAL DISTANCE OF COUNTED EDGES          */


static int vok      = 0;
static int vrg      = 0;
static int vrtype   = 0;
static int vrfan    = 0;
static int vrn      = 0;
static int vnum     = 0;
static int vbn      = 0;
static int vbtype   = 0;
static int vbadst   = 0;
static int vbaeldst = 0;
static int vbasrc   = 0;
static int vbinvar  = 0;
static int vbpmfan  = 0;
static int vbaelx   = 0;
static int vprag    = 0;
static int vrrf     = 0;
static int vbc      = 0;


/**************************************************************************/
/* LOCAL  **************        IsBRecord          ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF INFO i IS A BASIC RECORD CANDIDATE.            */
/**************************************************************************/

/* WARNING: IF MAX_BRECORD CHANGES, CHANGE IT IN if2gen AND if2up */
#define MAX_BRECORD 4 /* MAXIMUM NUMBER OF FIELDS ALLOWED IN A BASIC RECORD */

static int IsBRecord( i )
PINFO i;
{
  register PINFO ii;
  register int   c;

  for ( c = 0, ii = i->R_FIRST; ii != NULL; ii = ii->L_NEXT, c++ ) {
    if ( !IsBasic( ii->L_SUB ) )
      return( FALSE );
    }

  if ( c <= MAX_BRECORD )
    return( TRUE );

  return( FALSE );
}


int IsInnerLoop( b )
PNODE b;
{
  register PNODE n;
  register PNODE sg;

  for ( n = b->G_NODES; n != NULL; n = n->nsucc ) {
    if ( IsCompound( n ) ) {
      if ( !IsSelect( n ) )
        return( FALSE );

      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
        if ( !IsInnerLoop( sg ) )
          return( FALSE );
      }
    }

  return( TRUE );
}


static int IsInvariant( n )
PNODE n;
{
    register PEDGE i;

    for ( i = n->imp; i != NULL; i = i->isucc ) {
        if ( IsConst( i ) )
            continue;

        if ( !IsSGraph( i->src ) )
            return( FALSE );

        if ( !IsImport( i->src->G_DAD, i->eport ) )
            return( FALSE );
        }

    return( TRUE );
}


/**************************************************************************/
/* GLOBAL **************       IsVecCandidate      ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF FORALL f IS A CANDIDATE FOR VECTORIZATION.     */
/**************************************************************************/

int IsVecCandidate( f )
PNODE f;
{
    register PEDGE e;
    register PEDGE i;
    register PNODE n;
    register PEDGE c;
    register PEDGE ee;
    register PNODE nn;
    register int   cu = 0;
    register int   an = FALSE;
    register PEDGE ii;
    register int   lo;
    register int   hi;

    vnum++;

    /* IF1OPT: if1split.c DISABLE CONCURRENTIZATION OF THIN COPY */
    if ( f->line == 9999999 )
        return( FALSE );

    /* GENERATE SUBGRAPH CAN ONLY COMPRISE 1 NODE: RangeGenerate, UNLESS    */
    /* COMPILING FOR THE CRAY AND THE OTHER NODES ARE BUFFER SCATTER NODES  */
    /* FOR ABuildAT nodes PART OF BUILD-IN-PLACE RETURN VALUE OF CATENATES. */ 
    if ( f->F_GEN->G_NODES->nsucc != NULL ) {
      if ( !cRay ) {
        vrg++;
        return( FALSE );
        }

/* START: CRAY ONLY ********************* */
      for ( nn = f->F_GEN->G_NODES->nsucc; nn != NULL; nn = nn->nsucc ) 
        switch ( nn->type ) {
          case IFScatterBufPartitions:
            if ( (e = FindExport( f->F_BODY, nn->exp->iport )) == NULL ) {
              vrg++;
              return( FALSE );
              }

            if ( e->dst->type != IFABuildAT ) {
              vrg++;
              return( FALSE );
              }

            ee = e->dst->exp;

            if ( ee == NULL ) { 
              vrg++;
              return( FALSE );
              }

            if ( ee->sr != 1 ) {
              vrg++;
              return( FALSE );
              }

            if ( !IsSGraph( ee->dst ) ) {
              vrg++;
              return( FALSE );
              }

            if ( (e = FindExport( f->F_RET, ee->iport )) == NULL ) {
              vrg++;
              return( FALSE );
              }

            if ( e->pm > 0 || e->pl > 0 ) {
              vrg++;
              return( FALSE );
              }

            for ( ee = f->F_BODY->exp; ee != NULL; ee = ee->esucc ) {
              if ( ee->eport != e->eport )
                continue;

              switch ( ee->dst->type ) {
                case IFSGraph:
                  if ( ee->iport != 0 ) {
                    vrg++;
                    return( FALSE );
                    }

                  break;

                case IFReduceAT:
                case IFRedLeftAT:
                case IFRedRightAT:
                case IFRedTreeAT:
                  if ( !(ee->pmark) ) {
                    vrg++;
                    return( FALSE );
                    }

                  break;

                default:
                  vrg++;
                  return( FALSE );
                }
              }

            break;

          default:
            vrg++;
            return( FALSE );
          }
      }
/* STOP:  CRAY ONLY ********************* */

    if ( f->F_GEN->G_NODES->type != IFRangeGenerate ) {
        vrg++;
        return( FALSE );
        }

    c = f->F_GEN->G_NODES->exp;

/* START: NOT NOT NOT CRAY */
    if ( !cRay ) {
      /* ALL NODES IN THE BODY SUBGRAPH MUST NOT BE INVARIANT AND MUST BE IN */
      /* THE NODE SET {+,-,*,/,neg,abs, AElement}.                           */
      /* THE FIRST AElement IMPORT MUST BE TO A K PORT VALUE.                */
      for ( n = f->F_BODY->G_NODES; n != NULL; n = n->nsucc ) {
          if ( IsInvariant( n ) ) {
              vbinvar++;
              return( FALSE );
              }

          switch ( n->type ) {
              case IFPlus:
              case IFMinus:
              case IFTimes:
              case IFDiv:
              case IFAbs:
              case IFNeg:
              case IFDouble:
              case IFTrunc:
              case IFSingle:
                  break;

              case IFAElement:
                  if ( IsConst( n->imp ) )
                    return( FALSE );

                  if ( !IsSGraph( n->imp->src ) )
                    return( FALSE );

                  if ( FindImport( f, n->imp->eport ) == NULL )
                    return( FALSE );

                  break;
  
              default:
                  vbn++;
                  return( FALSE );
              }
          }

      /* THE CONTROL CAN ONLY BE USED BY +, -, and AElement NODES. THE  */
      /* SUCCESSOR NODES OF THE + and - NODES MUST BE AElement NODES.   */
      /* NO REFERENCE COUNT PRAGMAS ARE ALLOWED IN THE BODY.            */
      /* THE CONTROL MUST BE USED AS MUST AN AELEMENT NODE.             */
      for ( e = f->F_BODY->exp; e != NULL; e = e->esucc ) {
          if ( e->pm > 0 || e->cm == -1 ) {
              vprag++;
              return( FALSE );
              }
  
          if ( e->eport == c->iport ) {
              cu++;
              switch ( e->dst->type ) {
                  case IFPlus:
                  case IFMinus:
                      for ( ee = e->dst->exp; ee != NULL; ee = ee->esucc )
                          if ( ee->dst->type != IFAElement ) {
                              vbc++;
                              return( FALSE );
                              }

                      break;

                  case IFAElement:
                      /* an = TRUE; */
                      break;

                  default:
                      vbc++;
                      return( FALSE );
                      break;
                  }
              }
          }

      if ( cu <= 0 )
        return( FALSE );
      }
/* STOP:  NOT NOT NOT CRAY */

/* START: CRAY ONLY ********************* */
    if ( cRay ) {
      if ( !IsInnerLoop( f->F_BODY ) ) {
        vbn++;
        return( FALSE );
        }
      }
/* STOP:  CRAY ONLY ********************* */

    /* ALL EXPORTS OF RETURNS SUBGRAPH MUST CARRY int, real, or double */
    /* VALUES. RETURN SUBGRAPH EXPORT FANOUT IS NOT ALLOWED, UNLESS    */
    /* EACH EDGE DEFINES THE LOWER BOUND OR SIZE SPECIFICATION OF AN   */
    /* AGatherAT node.                                                 */

    /* BRecords are OK!!! */

    /* ON THE CRAY, ReduceAT's WITH pmarks ARE OK... AT LEAST FOR NOW */

    for ( e = f->F_RET->exp; e != NULL; e = e->esucc ) {
      switch ( e->info->type ) {
        case IF_ARRAY:
          if ( !cRay ) {
            vrtype++;
            return( FALSE );
	    }

/* START: CRAY ONLY ********************* */
          if ( !IsBasic( e->info->A_ELEM ) ) {
            vrtype++;
            return( FALSE );
	    }

          switch ( e->dst->type ) {
            case IFSGraph:
              if ( e->iport != 0 ) {
                vrtype++;
                return( FALSE );
		}

              break;

            case IFReduceAT:
            case IFRedLeftAT:
            case IFRedRightAT:
            case IFRedTreeAT:
              if ( e->pm > 0 || (!(e->pmark)) ) {
                vrtype++;
                return( FALSE );
		}

              if ( (ee = FindImport( f->F_BODY, e->eport )) == NULL ) {
                vrtype++;
                return( FALSE );
		}

              if ( ee->src->type != IFABuildAT ) {
                vrtype++;
                return( FALSE );
		}

              break;

            default:
              vrtype++;
              return( FALSE );
            }

          break;
/* STOP:  CRAY ONLY ********************* */

        case IF_RECORD:
          if ( !cRay ) {
            vrtype++;
            return( FALSE );
	    }

/* START: CRAY ONLY ********************* */
          if ( IsBRecord( e->info ) )
            break;

          vrtype++;
          return( FALSE );
/* STOP:  CRAY ONLY ********************* */

        case IF_INTEGER:
        case IF_REAL:
        case IF_DOUBLE:
          break;

        case IF_MULTPLE:
          switch ( e->info->A_ELEM->type ) {
             case IF_ARRAY:
               if ( !cRay ) {
                 vrtype++;
                 return( FALSE );
		 }

/* START: CRAY ONLY ********************* */
               if ( !IsBasic( e->info->A_ELEM->A_ELEM ) ) {
                 vrtype++;
                 return( FALSE );
		 }
     
               switch ( e->dst->type ) {
                 case IFSGraph:
                   if ( e->iport != 0 ) {
                     vrtype++;
                     return( FALSE );
		     }
     
                   break;
     
                 case IFReduceAT:
                 case IFRedLeftAT:
                 case IFRedRightAT:
                 case IFRedTreeAT:
                   if ( e->pm > 0 || (!(e->pmark)) ) {
                     vrtype++;
                     return( FALSE );
		     }
     
                   if ( (ee = FindImport( f->F_BODY, e->eport )) == NULL ) {
                     vrtype++;
                     return( FALSE );
		     }
     
                   if ( ee->src->type != IFABuildAT ) {
                     vrtype++;
                     return( FALSE );
		     }

                   break;

                 default:
                   vrtype++;
                   return( FALSE );
                 }

               break;
/* STOP:  CRAY ONLY ********************* */

             case IF_RECORD:
               if ( !cRay ) {
                 vrtype++;
                 return( FALSE );
		 }

/* START: CRAY ONLY ********************* */
               if ( IsBRecord( e->info->A_ELEM ) )
                 break;

               vrtype++;
               return( FALSE );
/* STOP:  CRAY ONLY ********************* */

             case IF_INTEGER:
             case IF_REAL:
             case IF_DOUBLE:
               break;
  
             default:
               vrtype++;
               return( FALSE );
             }

           break;

         case IF_BUFFER:
           break;

         default:
           vrtype++;
           return( FALSE );
         }

/* START: NOT NOT NOT CRAY */
       if ( !cRay ) {
         if ( UsageCount( f->F_RET, e->eport ) != 1 ) {
           for ( ee = f->F_RET->exp; ee != NULL; ee = ee->esucc )
              if ( ee->eport == e->eport ) {
                if ( ee->dst->type != IFAGatherAT ) {
                  vrfan++;
                  return( FALSE );
                  }

                /* FIRST (LOWER BOUND) OR FIFTH (SIZE) */
                if ( ee->dst->imp != ee && 
                     ee->dst->imp->isucc->isucc->isucc != ee ) {
                  vrfan++;
                  return( FALSE );
                  }
                }
           }
         }
/* STOP:  NOT NOT NOT CRAY */
       }

    /* THE RETURN SUBGRAPH CAN ONLY COMPRISE GatherAT and Reduce (SUM, */
    /* PRODUCT, LEAST, AND GREATEST) nodes. THE REDUCTION NODES CANNOT */
    /* HAVE FILTERS.                                                   */

    /* SPECIAL ReduceAT NODES ARE OK ON THE CRAY                       */ 

    for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc )
        switch ( n->type ) {
            case IFAGatherAT:
                break;

            case IFRedLeftAT:
            case IFRedRightAT:
            case IFRedTreeAT:
            case IFReduceAT:
              if ( !cRay ) {
                vrn++;
                return( FALSE );
		}

              break;

            case IFReduce:
            case IFRedLeft:
            case IFRedRight:
            case IFRedTree:
                if ( nopred ) 
                    return( FALSE );

                switch ( n->imp->CoNsT[0] ) {
                    case REDUCE_SUM:
                    case REDUCE_PRODUCT:
                    case REDUCE_GREATEST:
                    case REDUCE_LEAST:
                        if ( n->imp->isucc->isucc->isucc != NULL ) {
                            vrrf++;
                            return( FALSE );
                            }
                        break;
                    
                    default:
                        vrn++;
                        return( FALSE );
                    }

                break;

            default:
                vrn++;
                return( FALSE );
                break;
            }

/* START: NOT NOT NOT CRAY */
    if ( !cRay ) {
      /* ALL BODY SUBGRAPH IMPORTS MUST CARRY int, real, or double VALUES */
      for ( i = f->F_BODY->imp; i != NULL; i = i->isucc )
        switch ( i->info->type ) {
          case IF_INTEGER:
          case IF_REAL:
          case IF_DOUBLE:
            break;

          default:
            vbtype++;
            return( FALSE );
          }

      /* ALL BODY SUBGRAPH EXPORTS MUST CARRY int, real, double, OR array */
      /* VALUES.  THE ARRAY VALUES MUST BE 1-D with int, real, or double  */
      /* CONSTITUENTS; THEY CAN ONLY BE USED BY AElement NODES.           */

      for ( e = f->F_BODY->exp; e != NULL; e = e->esucc )
        switch ( e->info->type ) {
          case IF_INTEGER:
          case IF_REAL:
          case IF_DOUBLE:
            break;

          case IF_ARRAY:
            switch ( e->info->A_ELEM->type ) {
              case IF_INTEGER:
              case IF_REAL:
              case IF_DOUBLE:
                if ( (ii = FindImport( f, e->eport )) == NULL )
                  return( FALSE );

                if ( ii->cm == -1 )
                  return( FALSE );

                break;

              default:
                vbtype++;
                return( FALSE );
              }

            if ( e->dst->type != IFAElement ) {
              vbadst++;
              return( FALSE );
              }

            break;

          default:
            vbtype++;
            return( FALSE );
          }

      /* AN AElement NODE'S FIRST INPUT MUST BE A K PORT ARRAY. ITS      */
      /* SECOND INPUT CAN BE ANYTHING.                                   */
      for ( n = f->F_BODY->G_NODES; n != NULL; n = n->nsucc ) {
        switch( n->type ) {
          case IFPlus:
          case IFMinus:
            if ( n->imp == c || n->imp->isucc == c )
              for ( e = n->exp; e != NULL; e->esucc )
                if ( e->dst->type != IFAElement ) {
                  vbpmfan++;
                  return( FALSE );
                  }

            break;

          case IFTimes:
          case IFDiv:
          case IFAbs:
          case IFNeg:
          case IFDouble:
          case IFTrunc:
          case IFSingle:
            break;

          case IFAElement:
            if ( n->imp->src != f->F_BODY ) {
              vbasrc++;
              return( FALSE );
              }
  
            /* IF TRUE, THEN AElement NODE IS INVARIANT */
            if ( IsConst( n->imp->isucc ) )
              return( FALSE );
  
            for ( e = n->exp; e != NULL; e = e->esucc )
              switch ( e->dst->type  ) {
                case IFPlus:
                case IFMinus:
                case IFTimes:
                case IFDiv:
                case IFAbs:
                case IFNeg:
                case IFDouble:
                case IFTrunc:
                case IFSingle:
                  break;

                case IFAElement:
                  break;

                case IFSGraph:
                  break;
  
                default:
                  vbaeldst++;
                  return( FALSE );
                }

              break;

            default:
              vbn++;
              return( FALSE );
            }
          }
        }
/* STOP:  NOT NOT NOT CRAY */

    vok++;
    return( TRUE );
}


static void VectorSummary()
{
    fprintf( stderr, "\n   * VECTORIZATION SUMMARY\n" );
    fprintf( stderr, "\n\n" );

    fprintf( stderr, "NUMBER OF VECTORIZATION ATTEMPTS:  %d\n", vnum );
    fprintf( stderr, "NUMBER OF VECTORIZED LOOPS:        %d\n", vok );
    fprintf( stderr, "NOT A SINGLE RangeGenerate:        %d\n", vrg );
    fprintf( stderr, "ILLEGAL USE OF CONTROL IN BODY:    %d\n", vbc );
    fprintf( stderr, "RETURN EXPORT TYPE ERROR:          %d\n", vrtype );
    fprintf( stderr, "RETURN FANOUT:                     %d\n", vrfan );
    fprintf( stderr, "ILLEGAL RETURN NODE:               %d\n", vrn );
    fprintf( stderr, "BODY EXPORT AND IMPORT TYPE ERROR: %d\n", vbtype );
    fprintf( stderr, "ILLEGAL ARRAY USAGE IN BODY:       %d\n", vbadst );
    fprintf( stderr, "INVARIANTS IN BODY:                %d\n", vbinvar );
    fprintf( stderr, "ILLEGAL + and - NODE FANOUT:       %d\n", vbpmfan );
    fprintf( stderr, "ILLEGAL AElement SOURCE:           %d\n", vbasrc );
    fprintf( stderr, "ILLEGAL AElement INDEX:            %d\n", vbaelx );
    fprintf( stderr, "ILLEGAL AElement DESTINATION:      %d\n", vbaeldst );
    fprintf( stderr, "ILLEGAL BODY NODE:                 %d\n", vbn );
    fprintf( stderr, "REDUCTION FILTER:                  %d\n", vrrf );
}


/**************************************************************************/
/* LOCAL  **************      AverageDistance      ************************/
/**************************************************************************/
/* PURPOSE: CALCULATE AND RETURN THE AVERAGE USAGE DISTANCE FOR ALL NODES */
/*          IN GRAPH g.                                                   */
/**************************************************************************/

static void AverageDistance( g )
PNODE g;
{
    register PNODE n;
    register PEDGE e;
    register int   i;

    for ( i = 1, n = g->G_NODES; n != NULL; n = n->nsucc, i++ )
        n->label = i;

    for ( n = g->G_NODES; n != NULL; n = n->nsucc )
        for ( e = n->exp; e != NULL; e = e->esucc )
            if ( !IsGraph( e->dst ) ) {
                edges++;
                total += e->dst->label - n->label;
                }
}


/**************************************************************************/
/* LOCAL  **************       IsSliceCandidate    ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF Forall NODE f IS STRUCTURALLY A CANDIDATE FOR  */
/*          SLICING, ELSE RETURN FALSE. A CANDIDATE MUST EITHER SCATTER   */
/*          ARRAYS OR VALUES FROM A RangeGenerate AND RETURN NON-FILTERED */
/*          PREALLOCATED GATHERED ARRAYS AND SCALARS RESULTING FROM       */
/*          REDUCTIONS. ONLY MAX_DOTS DOT PRODUCTS ARE ALLOWED. A Forall  */
/*          RETURNING A STREAM IS NOT CONSIDERED A CANDIDATE.             */
/**************************************************************************/

static int IsSliceCandidate( f )
PNODE f;
{
    register PNODE n;
    register PEDGE i;
    register PEDGE ii;
    register PEDGE gi;
    register int   dots = -1;

    /* IF1OPT: if1split.c DISABLE CONCURRENTIZATION OF THIN COPY */
    if ( f->line == 9999999 ) {
        return( FALSE );
        }

    if ( IsStream( f->exp->info ) )
        return( FALSE );

    for ( n = f->F_GEN->G_NODES; n != NULL; n = n->nsucc ) 
        switch ( n->type ) {
            case IFRangeGenerate:
                dots++;
                break;

            case IFAScatter:
                return( FALSE );

            case IFScatterBufPartitions:
                break;

            default:
                return( FALSE );
            }

    /* ASSUMES if1opt REMOVED DOTS!!! */
    if ( dots > 0 )
        return( FALSE );

    for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc )
        switch ( n->type ) {
            case IFAGatherAT:
                if ( n->imp->isucc->isucc->iport == 3 )
                    return( FALSE );

                break;

            case IFReduceAT:
            case IFRedLeftAT:
            case IFRedRightAT:
            case IFRedTreeAT:
                if ( !(n->imp->isucc->isucc->pmark) )
                  return( FALSE );

                break;

            case IFReduce:
            case IFRedTree:
            case IFRedLeft:
            case IFRedRight:
                if ( (n->imp->CoNsT[0] == REDUCE_SUM ||
                      n->imp->CoNsT[0] == REDUCE_PRODUCT) && nopred &&
                      (n->exp->info->type == IF_DOUBLE || 
                       n->exp->info->type == IF_REAL) )
                    return( FALSE );

                if ( !IsBasic( n->exp->info ) )
                    return( FALSE );

                break;

            default:
                return( FALSE );
            }

    return( TRUE );
}


/**************************************************************************/
/* LOCAL  **************       IsStreamTask        ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF LOOP n IMPORTS OR EXPORTS A STREAM, ELSE FALSE.*/
/**************************************************************************/

static int IsStreamTask( n )
PNODE n;
{
    register PEDGE i;
    register PEDGE e;
    register PNODE init;
    register PNODE ret;
    register int   yes;

    if ( IsForall( n ) ) {
        init = n->F_GEN; 
        ret = n->F_RET;
    } else {
        init = n->L_INIT;
        ret = n->L_RET;
        }

    yes = FALSE;

    for ( i = n->imp; i != NULL; i = i->isucc ) 
        if ( IsStream( i->info ) )
            if ( IsExport( init, i->iport ) )
                yes = TRUE;

    for ( e = n->exp; e != NULL; e = e->esucc ) {
        if ( IsStream( e->info ) ) {
            if ( (i = FindImport( ret, e->eport )) == NULL )
              continue;

            switch ( i->src->type ) {
                case IFAGather:
                    yes = TRUE;
                    break;

                default:
                    break;
                }
            }
        else
            return( FALSE );
        }

    return( yes );
}


/**************************************************************************/
/* LOCAL  **************       IsTaskFinished      ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF THE VALUES PRODUCED BY TASK n ARE AVAILABLE    */
/*          FOR USE, ELSE RETURN FALSE; THAT IS, HAS A SYNC BEEN DONE?    */
/**************************************************************************/

static int IsTaskFinished( n )
PNODE n;
{
    register PEDGE e;

    for ( e = n->exp; e != NULL; e = e->esucc )
        if ( e->dst->wmark )
            return( TRUE );

    return( FALSE );
}


/**************************************************************************/
/* LOCAL  **************       SetSyncMarks        ************************/
/**************************************************************************/
/* PURPOSE: ENABLE SYNCRONIZATION MARKS ON NODES IN g'S NODE LIST THAT    */
/*          INPUT RESULTS OF STREAM CONSUMING, NON-STREAM PRODUCING LOOPS.*/
/*          ONLY THE FIRST NODE USING THE LOOP'S OUTPUTS DOES THE SYNC.   */
/**************************************************************************/

static void SetSyncMarks( g )
PNODE g;
{
    register PEDGE i;
    register PNODE n;

    /* BUG FIX 10/16 NOTE STILL DOESN't WORK */
    if ( g->G_NODES == NULL )
        return;

    for ( n = g->G_NODES; n != g; ) {
        for ( i = n->imp; i != NULL; i = i->isucc )  {
            if ( IsConst( i ) )
                continue;

            if ( i->src->pmark && !IsStream( i->src->exp->info ) )
                if ( !IsTaskFinished( i->src ) )
                    n->wmark = TRUE;
            }
        /* BUG FIX 10/16 */
        if ( n->nsucc == NULL )
            n = g;
        else
            n = n->nsucc;
        }
}


/**************************************************************************/
/* LOCAL  **************        CanExecute         ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF PARALLEL TASK n CAN EXECUTE; THAT IS, IF TASK  */
/*          n IS DEPENDENT ON ANOTHER TASK, n CANNOT EXECUTE IF THE TASK  */
/*          HAS NOT EXECUTED. BOTH DATA AND ADE SOURCES MUST BE CHECKED.  */
/*          EXAMINING A NODE WITH A LABEL LESS THAN THAT OF TASK stop     */
/*          INDICATES THAT THE PATH WILL NOT REACH A TASK: stop IS THE    */
/*          FIRST TASK IN THE DFOrdered NODE LIST AND ALL OTHER TASKS     */
/*          MUST BE TO ITS RIGHT.                                         */
/**************************************************************************/

static int CanExecute( n, stop )
PNODE n;
PNODE stop;
{
    register PEDGE i;
    register PADE  a;

    for ( i = n->imp; i != NULL; i = i->isucc ) {
        if ( IsConst( i ) )
            continue;

        if ( i->src->label < stop->label )
            continue;

        if ( i->src->smark || i->src->pmark ) {
            if ( !(i->src->executed) )
                return( FALSE );
            else
                continue;
            }

        if ( !CanExecute( i->src, stop ) )
            return( FALSE );
        }

    for ( a = n->aimp; a != NULL; a = a->isucc ) {
        if ( a->src->label < stop->label )
            continue;

        if ( a->src->smark || a->src->pmark ) {
            if ( !(a->src->executed) )
                return( FALSE );
            else
                continue;
            }

        if ( !CanExecute( a->src, stop ) )
            return( FALSE );
        }

    return( TRUE );
}


static int GetNewActiveProcCount( f, active )
PNODE f;
int   active;
{
  register int i;

  i = (int) NumberOfIterations( f );

  /* ASSUMES LOOPS DIVIDED INTO proc CHUNKS */
  return(((i < procs)? i : procs) * active);
}


/**************************************************************************/
/* LOCAL  **************       PartitionGraph      ************************/
/**************************************************************************/
/* PURPOSE: MARK APPROPRIATE Forall, LoopA, AND LoopB NODES IN GRAPH g    */
/*          FOR PARALLEL EXECUTION (A FUNCTION OF PARALLEL NESTING LEVEL  */
/*          AND ESTIMATED EXECUTION COST). IF A Forall NODE CAN BE SLICED,*/
/*          ITS SUBGRAPHS ARE PROCESSED USING LEVEL plvl + 1.  WHEN A CALL*/
/*          NODE IS ENCOUNTERED, THE CALLEE IS FOUND AND plvl IS ADDED TO */
/*          ITS RUNNING SUM TO BE USED LATER TO CALCULATE THE AVERAGE     */
/*          PARALLEL NESTING LEVEL OF ALL CALLERS. HENCE, THIS ROUTINE    */
/*          ASSUMES THAT THE FUNCTION CALL GRAPH IS BEING TRAVERSED       */
/*          TOWARD THE LEAVES. WHEN DONE, SYNC OPERATIONS ARE INSERTED.   */
/**************************************************************************/

static void PartitionGraph( g, plvl, pbusy )
PNODE g;
int   plvl;
int   pbusy; /* BUSY PROCESSORS */
{
    register PNODE  n;
    register PNODE  gg;
    register PNODE  phead = NULL;
    register PNODE  ptail = NULL;
    register int    active;

    AverageDistance( g );

    for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
        n->level = plvl;
        active = pbusy;

        switch ( n->type ) {
            case IFForall:
                if ( IsSliceCandidate( n ) )
                    if ( (n->ccost >= SliceThreshold) && (plvl <= level) ) {
                        if ( (atlevel == -1) || (atlevel == plvl) ) {
                            if ( active < procs ) {
                              n->smark = TRUE;

                              active = GetNewActiveProcCount( n, active );

                              AppendToUtilityList( phead, ptail, n );
                              }
                            }

                        for ( gg = n->C_SUBS; gg != NULL; gg = gg->gsucc )
                            PartitionGraph( gg, plvl + 1, active );

                        break;
                        }

            case IFLoopA:
            case IFLoopB:
                if ( IsStreamTask( n ) ) {
                    n->pmark = TRUE;
                    AppendToUtilityList( phead, ptail, n );
                    }

            case IFSelect:
            case IFTagCase:
                for ( gg = n->C_SUBS; gg != NULL; gg = gg->gsucc )
                    PartitionGraph( gg, plvl, active );

                break;

            case IFCall:
                gg = FindFunction( n->imp->CoNsT );

		if ( !(IsIGraph( gg ) && gg->mark == 's') )
                  if ( n->bmark )
                    break;

                if ( gg->cnum == 0 ) {
                    gg->pbusy = active;
                    gg->level  = plvl;
                } else {
                    gg->pbusy += active;
                    gg->level  += plvl;
                    }

                gg->cnum++;
                break;

            default:
                break;
            }
        }

    if ( phead != NULL )
        SetSyncMarks( g );
}


/**************************************************************************/
/* GLOBAL **************          If2Part          ************************/
/**************************************************************************/
/* PURPOSE: PARTITION ALL GRAPHS IN ALL FUNCTIONS.  THE CALL GRAPH IS     */
/*          TRAVERSED FROM THE ROOT DOWN; HENCE, UPON PROCESSING OF A     */
/*          GIVEN FUNCTION, WE ARE GUARANTEED THAT ALL CALL SITES HAVE    */
/*          VISITED, ALLOWING CALCULATION OF THE FUNCTIONS AVERAGE        */
/*          PARALLEL NESTING LEVEL (A PARTITIONING PARAMETER).            */
/**************************************************************************/

void If2Part()
{
    register PNODE f;

    if ( info )
        fprintf( stderr, "\n   * LOCALITY MAP\n\n" );

    for ( f = FindLastGraph( glstop ); f != glstop; f = f->gpred ) {
        /* if ( IsIGraph( f ) ) */
            /* continue; */

        if ( f->bmark )
            cycle = TRUE;

        if ( f->cnum != 0 ) {
            f->level = f->level / f->cnum;
            f->pbusy = f->pbusy / f->cnum;
            }

        edges = total = 0;

        PartitionGraph( f, f->level, f->pbusy );

        if ( info ) {
            fprintf( stderr, "FUNCTION %s: ", f->G_NAME );

            if ( edges == 0 )
                fprintf( stderr, "Average Distance = 0.0\n" );
            else
                fprintf( stderr, "Average Distance = %e\n",
                             ((double) total) / ((double) edges) );
            }
        }

    if ( info && dovec )
        VectorSummary();
}
