#include "world.h"


static int fnodes;                                /* COUNT OF Forall NODES */
static int slices;          /* COUNT OF Forall NODES MARKED FOR SLICING    */
static int vecs;         /* COUNT OF Forall NODES MARKED FOR VECTORIZATION */
static int slvecs;       /* COUNT OF Forall NODES MARKED FOR VECTORIZATION */
			 /* AND SLICING                                    */

static int strcps;          /* COUNT OF STREAM CONSUMER AND PRODUCER TASKS */
static int syncs;           /* COUNT OF SYNCRONIZATION OPERATIONS          */


/**************************************************************************/
/* LOCAL  **************       WriteTaskInfo       ************************/
/**************************************************************************/
/* PURPOSE: WRITE INFORMATION FOR TASK n TO stderr. Msg IDENTIFIES THE    */
/*          TASK'S TYPE. IF msg IS NULL, n'S SYMBOLIC NAME IS WRITTEN.    */
/**************************************************************************/

static void WriteTaskInfo( msg, n, indent )
char *msg;
PNODE n;
int   indent;
{
    register int i;

    for ( i = 0; i < indent; i++ ) 
	fprintf( stderr, " " );

    fprintf( stderr, "%d: %s", indent, msg );

    fprintf( stderr, " (%s) ", cfunct->G_NAME );
    fprintf( stderr, "[cost=%e]: ", n->ccost );
    fprintf( stderr, "(%s,%s,%d)\n",  n->file, n->funct, n->line );
}


/**************************************************************************/
/* LOCAL  **************         WriteMap          ************************/
/**************************************************************************/
/* PURPOSE: WRITE THE PARTITION MAP OF GRAPH g TO stderr AND INCREMENT    */
/*          THE APPROPRIATE COUNTERS.                                     */
/**************************************************************************/

static void WriteMap( g, indent )
PNODE g;
int   indent;
{
    register PNODE n;

    for ( n = g; n != NULL; n = n->nsucc ) {
	if ( n->wmark )
	    syncs++;

	switch ( n->type ) {
	    case IFForall:
		fnodes++;

		if ( n->smark ) {
		    if ( n->vmark ) {
		        WriteTaskInfo( "Sliced-Vectorized Forall", n, indent );
			slvecs++;
		    } else {
		        WriteTaskInfo( "Sliced Forall", n, indent );
		        slices++;
			}

		    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		        WriteMap( g, indent + 1 );

		    break;
		    }
                else if ( n->vmark ) {
		    vecs++;
		    WriteTaskInfo( "Vectorized Forall", n, indent );

		    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		        WriteMap( g, indent + 1 );

                    break;
		    }
		else if ( !n->pmark ) {
		    WriteTaskInfo( "Sequential Forall", n, indent );

		    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		        WriteMap( g, indent );

		    break;
		    }

	    case IFLoopA:
	    case IFLoopB:
		if ( n->pmark ) {
		    strcps++;

		    WriteTaskInfo( "Stream Task", n, indent );

		    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		        WriteMap( g, indent + 1 );

		    break;
		    }

	    case IFSelect:
	    case IFTagCase:
		for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		    WriteMap( g, indent );

		break;

	    default:
		break;
	    }
        }
}


static void PrintLInfo( lvl, c, l )
int  lvl;
char  *c;
PNODE  l;
{
  register int i;

   for ( i = 1; i <= lvl; i++ )
     fprintf( stderr, " " );

   fprintf( stderr, "(%d) %s[%s,%s,%d]%s%s%s%s\n", lvl, c, l->file, l->funct, 
	    l->line, (l->smark)? " CONCURRENT" : "",
		     (l->vmark)? " VECTOR" : "",
		     (l->pmark)? " TASK" : "",
		     (l->smark || l->vmark || l->pmark)? "" : " SEQUENTIAL" );
}


static void WriteTheLMap( lvl, g )
int   lvl;
PNODE g;
{
  register PNODE n;
  register PNODE sg;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    switch ( n->type ) {
      case IFForall:
	PrintLInfo( lvl, "Forall", n );
	WriteTheLMap( lvl + 1, n->F_BODY );
	break;

      case IFLoopB:
      case IFLoopA:
	PrintLInfo( lvl, "For Initial", n );
	WriteTheLMap( lvl + 1, n->L_BODY );
	break;

      default:
	break;
      }
    }
}


static void WriteLoopMap( msg )
char *msg;
{
  register PNODE f;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
    if ( IsIGraph( f ) )
      continue;

    fprintf( stderr, "\n   * LOOP MAP (%s) %s\n\n", f->G_NAME, msg );
    WriteTheLMap( 1, f );
    }
}


/**************************************************************************/
/* GLOBAL **************         If2Count          ************************/
/**************************************************************************/
/* PURPOSE: PRINT A PARTITION MAP OF ALL FUNCTIONS TO stderr.             */
/**************************************************************************/

void If2Count()
{
    register PNODE f;

    fnodes = vecs = slices = strcps = syncs = 0;

    fprintf( stderr, "\n   * PARTITION AND VECTORIZATION MAP (procs=%d)\n\n",
		     procs );

    for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
	fprintf( stderr, "FUNCTION %s [cost=%e] [apl=%d] [pbsy=%d]\n",
			 f->G_NAME, f->ccost, f->level, f->pbusy   );

	WriteMap( cfunct = f, 1 );
	}

    fprintf( stderr, "\n   * OCCURRENCE COUNTS\n\n" );
    fprintf( stderr,   "Forall Nodes:                       %d\n", fnodes  );
    fprintf( stderr,   "Sliced Forall Nodes:                %d\n", slices  );
    fprintf( stderr,   "Vectorized Forall Nodes:            %d\n", vecs    );
    fprintf( stderr,   "Sliced and Vectorized Forall Nodes: %d\n", slvecs  );
    fprintf( stderr,   "Stream Consumer/Producer Tasks:     %d\n", strcps  );
    fprintf( stderr,   "Syncronization Operations:          %d\n", syncs   );
}
