#include <stdio.h>
#include <math.h>

#include "if2.h"


void                 If2Read();                           /* if2read.c        */

double                TSECND();                           /* if2timer.c       */
void            StopProfiler();
void           StartProfiler();

char      *BindInterfaceName();                           /* if2interface.c   */
int              GetLanguage();
void      PrintInterfaceCall();
void PrintInterfaceUtilities();
void      WriteInterfaceInfo();
int               IsReadOnly();

void                  If2Opt();                           /* if2opt.c         */
void            PrepareGraph();
void         WriteIf2OptInfo();

void       WritePrebuildInfo();                           /* if2prebuild.c    */
void            If2Prebuild0();
void            If2Prebuild1();
void            If2Prebuild2();

void            If2Vectorize();                           /* if2vector.c      */
void         WriteVectorInfo();
void             PrintVECTOR(),        PrintNOVECTOR();
void              PrintASSOC(),            PrintSAFE();

void                 If2AImp(),    AssignNewPortNums();   /* if2aimp.c        */
void             MoveMallocs(),     WriteIf2AImpInfo();

void              EnterScope(),            MakeGraph();   /* if2build.c       */
void                MakeInfo(),             MakeEdge();
void               MakeConst(),             MakeNode();
void            MakeCompound(),            ExitScope();
void                AddStamp(),          RemoveStamp();
void    AssignSourceFileName(),              MakeAde();
int                  IsStamp();
PINFO               FindInfo();
void            MakePtrTypes();
char         *GetStampString();

void              LinkImport(),           LinkExport();   /* if2util.c        */
void         LinkExportLists(),       TouchTheUnions();
void            UnlinkImport(),         UnlinkExport();
PNODE           FindLastNode(),         FindFunction();
PNODE              LinkGraph();
PNODE          FindGraphNode();
PNODE               LinkNode();
PNODE             UnlinkNode();
PNODE            UnlinkGraph();
char             *CopyString(),             *MyAlloc();
void                Warning1(),               Error1();
void                  Error2();
PALIST        LinkAssocLists();
int                IsPMarked();
PEDGE              EdgeAlloc(),       FindLastImport();
PNODE              NodeAlloc();
PINFO              InfoAlloc();
PALIST        AssocListAlloc();
PTEMP              TempAlloc();
PEDGE             FindImport();
PEDGE             FindExport();
int               UsageCount(),             IsCalled();
char              *UpperCase();
char              *LowerCase();
void    ChangeExportsToConst(),      ClearTouchFlags();
void              ImportSwap();
int              IsDivByZero();
PEDGE               CopyEdge();
void         CopyEdgeAndLink();
void           NormalizeNode();

void    PrintReadFibreInputs();                           /* if2fibre.c       */
void  PrintWriteFibreOutputs();
void               PrintPeek();

void              SmashTypes();                           /* if2smash.c       */

void                If2Yank0();                           /* if2yank.c        */
void                If2Yank1();
void           WriteYankInfo();

void      PrintSliceTaskInit(),        PrintRanges();     /* if2loop.c        */
int      PrintStreamTaskInit();
void             PrintAStore();
void             PrintForall();
void               PrintLoop(),    PrintSumOfTerms();
int         AreAllUnitFanout();
void          PrintYankedRed();
PEDGE          GetSliceParam();
void           PrintFirstSum();
void                PrintTri();
void            PrintVMinMax();

void             PrintSelect(),       PrintTagCase();     /* if2select.c      */

void           SaveSdbxState();                           /* if2sdbx.c        */
void    UpdateSdbxScopeNames();
void   PrintSdbxFunctionList();

void          PrintArrayNoOp(),      PrintAReplace();     /* if2array.c       */
void           PrintABuildAT();
void           PrintAAddHLAT(),   PrintACatenateAT();
void              PrintAAddH();
void         PrintArrayMacro(),      PrintMemAlloc();
void             PrintRagged();
void              PrintAElem(),        PrintABuild();
void             PrintGABase(),   PrintOptAElement();
char           *GetSisalInfo();
void        PrintBoundsCheck();
void          PrintPSScatter();
void          PrintPSManager();
void             PrintPSFree();
void            PrintPSAlloc();
void      PrintPSMemAllocDVI();
void         PrintPSMemFlush();

void           PrintUElement(),        PrintUBuild();     /* if2record.c      */
void      PrintBROptAElement();
void             PrintRBuild(),     PrintRElements();
void           PrintRReplace(),    PrintRecordNoOp();
void         PrintBRElements(),      PrintBRAStore();
void            PrintBRBuild(),     PrintBRReplace();
void           PrintUTagTest(),       PrintUGetTag();

void       If2DataPartition0();                           /* if2data.c        */
void       If2DataPartition1();
void           AddToCallList();
void  WriteDataPartitionInfo();
int               IsPrefetch();
int               IsDistRead();
void        PrintPrePrefetch();
void           PrintPrefetch();
void       PrintFreePrefetch();

void              PrintGraph(),          PrintTemp();     /* if2print.c       */
void        PrintIndentation(),         PrintMacro();
void  PrintProducerModifiers(),   PrintSetRefCount();
void  PrintConsumerModifiers(),        PrintFldRef();
void PrintProducerLastModifiers();
void           PrintFldAssgn(),         PrintAssgn();
int          BuildInParallel();
void           PrintFreeCall();
int              IsIntrinsic();

PTEMP                GetTemp();                           /* if2temp.c        */
void   InitializeSymbolTable(),   ChangeToAllocated();
void                FreeTemp(),       PropagateTemp();
int           IsTempExported(),      IsTempImported();
void             PrintLocals(),         AssignTemps();
char               *MakeName();
void          MoveToNewLevel();
void      PrintFrameDeallocs();           

void       PrintFilePrologue(),  PrintFunctPrologue();    /* if2preamble.c    */
void      PrintFunctEpilogue(),   PrintFileEpilogue();
void  CheckParallelFunctions();
void  MarkRecursiveFunctions();

char               *GetMacro(),    *GetCopyFunction();    /* if2.c            */
char     *GetIncRefCountName();
char     *GetSetRefCountName();

char            *GetFreeName();                           /* if2free.c        */
void        PrintFreeRoutine(),   PrintFreeUtilities();
void      PrintInputDeallocs();
void     PrintOutputDeallocs();

void                    Stop(),                 main();   /* DRIVER FILE      */

int                   strlen();                           /* C LIBRARY STUFF  */
char                 *malloc();
char                 *strcpy();
int                     free();
#ifdef CRAY
double                  atof();
#endif


#define OK       0                               /* PROGRAM EXIT STATUS CODES */
#define ERROR    1

#define FALSE    0
#define TRUE     1

extern FILE  *input;                             /* IF1 INPUT  FILE           */
extern FILE  *output;                            /* IF1 OUTPUT FILE           */

extern char  *program;                           /* PROGRAM NAME              */

extern char *sfile;                              /* SISAL FILE BEING READ     */
extern char *entry;                       /* PROGRAM ENTRY POINT              */
extern PNODE cfunct;                      /* FUNCTION BEING BUILT OR EXAMINED */

extern int    info;                      /* DUMP OPTIMIZATION INFO TO stderr? */
extern int    vinfo;                   /* DUMP CONCURRENT-VECTOR INFORMATION? */
extern int    dbl;                       /* TREAT real DATA AS double_real?   */
extern int    flt;                       /* TREAT double_real DATA AS real?   */
extern int    aimp;                 /* OPTIMIZE ARRAY DEREFERENCE OPERATIONS? */
extern int    if2opt;                             /* OPTIMIZE GatherAT NODES? */

extern int    regok;                   /* ASSIGN register PREFIXES?           */

extern int    maxint;                  /* MAXIMUM INTEGER READ FROM IF1 FILE  */
extern int    nmid;                    /* NAME STAMP                          */
extern int    tmpid;                   /* TEMPORARY STAMP                     */
extern int    bounds;                  /* GENERATE BOUNDS CHECKS?             */

extern int    line;        /* LINE NUMBER OF PREVIOUSLY READ LINE OF IF1 FILE */

extern PNODE  chead;             /* HEAD OF CONSTANT AGGREGATE GENERATOR LIST */
extern PNODE  ctail;             /* TAIL OF CONSTANT AGGREGATE GENERATOR LIST */

extern PINFO  ihead;                    /* SYMBOL TABLE HEAD POINTER          */
extern PINFO  itail;                    /* SYMBOL TABLE TAIL POINTER          */

extern PNODE  glstop;                   /* HEADER OF FUNCTION GRAPH LIST      */
extern char  *stamps[];                 /* ARRAY OF IF1 STAMPS 0 to 127       */
extern PRAGS  pragmas;        /* PRAGMAS FORM CURRENTLY READ LINE OF IF1 FILE */

extern int   gshared;

extern int   sequential;             /* CURRENTLY GENERATING SEQUENTIAL CODE? */
extern int   recursive;               /* CURRENTLY GENERATING RECURSIVE CODE? */

extern int   invtfa;                    /* COUNT OF INVARIANT TASK FRAME ARGS */
extern int   vec;                                  /* FURTHER VECTORIZE CODE? */

extern int   rmsrcnt;                      /* COUNT OF ELIMINATED SR PRAGMAS */
extern int   rmpmcnt;                      /* COUNT OF ELIMINATED PM PRAGMAS */
extern int   rmcmcnt;                      /* COUNT OF ELIMINATED CM PRAGMAS */
extern int   rmcnoop;             /* COUNT OF REMOVED CONDITIONAL COPY NoOpS */
extern int   rmnoop;                          /* COUNT OF REMOVED COPY NoOpS */
extern int   rmsmark;                         /* COUNT OF REMOVED smarks     */
extern int   rmvmark;                         /* COUNT OF REMOVED vmarks     */

extern int   cRay;                                 /* COMPILING FOR THE CRAY? */
extern int   alliantfx;               /* COMPILING FOR THE ALLIANT FX SERIES? */
extern int   movereads;                        /* MOVE ARRAY READ OPERATIONS? */
extern int   xmpchains;                     /* FORM CHAINS FOR THE CRAY X-MP? */
extern int   newchains;  

extern int   rag;                             /* IDENTIFY RAGGED MEM-ALLOCS? */
extern int   bip;                                    /* BIP OPTIMIZATION?    */
extern int   bipmv;
extern int   oruntime;          /* USE ORIGINAL SISAL MICROTASKING SOFTWARE  */

extern int   bind;                         /* BIND INTERFACE CALLS TO SISAL? */

extern int   freeall;                       /* FORCE RELEASE OF ALL STORAGE? */

extern PINFO ptr_real;                       /* VARIOUS SYMBOL TABLE ENTIRES */
extern PINFO ptr_double;
extern PINFO ptr_integer;
extern PINFO ptr;
extern PINFO integer;

extern int   Iupper;                   /* INTERFACE NAME GENERATION COMMANDS */
extern int   IunderR;
extern int   IunderL;

extern int   fva;                    /* FORCE ALLIANT VECTORIZATION PRAGMAS? */
extern int   fvc;                    /* FORCE CRAY VECTORIZATION PRAGMAS?    */
extern int   nltss;                  /* COMPILE FOR NLTSS C-COMPILER?        */

extern int   SISdebug;                        /* REMOVE DEAD FUNCTION CALLS? */

extern int   intrinsics;     /* RECOGNIZE LOGICAL FUNCTIONS: and,or,xor,not? */

extern int   max_dims;  /* MAXIMUM NUMBER OF DESIRED POINTER SWAP DIMENSIONS */
extern int   share;                    /* TRY AND SHARE POINTER SWAP STORAGE */

extern int   assoc;                    /* DO ASSOCIATIVE TRANSFORMATIONS?    */

extern int   prof;                     /* PROFILE THE OPTIMIZER?             */

extern int   standalone;               /* CALLED FROM THE OPERATING SYSTEM?  */

extern int   gdata;                    /* PREPARE GLOBAL DATA?               */

extern int   sdbx;                     /* GENERATE SDBX CODE?                */

extern FILE *hyfd;                                 /* HYBRID FILE DESCRIPTOR */
extern char *hybrid;                                     /* HYBRID FILE NAME */

extern int smallocs;                             /* COUNT OF SHARED MALLOCS  */
extern int pmallocs;                             /* COUNT OF PRIVATE MALLOCS */

extern int spsmallocs;              /* COUNT OF SHARED POINTER SWAP MALLOCS  */
extern int ppsmallocs;              /* COUNT OF PRIVATE POINTER SWAP MALLOCS */

extern int pargD;                  /* COUNT OF PRIVATE ARGUMENT DOPE VECTORS */
extern int pargP;              /* COUNT OF PRIVATE ARGUMENT PHYSICAL VECTORS */
extern int sargD;                   /* COUNT OF SHARED ARGUMENT DOPE VECTORS */
extern int sargP;               /* COUNT OF SHARED ARGUMENT PHYSICAL VECTORS */

extern int pcD;                    /* COUNT OF PRIVATE CONSTANT DOPE VECTORS */
extern int pcP;                /* COUNT OF PRIVATE CONSTANT PHYSICAL VECTORS */
extern int scD;                     /* COUNT OF SHARED CONSTANT DOPE VECTORS */
extern int scP;                 /* COUNT OF SHARED CONSTANT PHYSICAL VECTORS */
extern int pargs;                     /* COUNT OF COMPLETE PRIVATE ARGUMENTS */
extern int sargs;                      /* COUNT OF COMPLETE SHARED ARGUMENTS */

extern int sread;                                   /* COUNT OF SHARED READS */
extern int pread;                              /* COUNT OF DISTRIBUTED READS */
