#include "world.h"


int sequential = FALSE;                 /* GENERATING CODE FOR THE MASTER */
int recursive  = FALSE;                 /* GENERATING RECURSIVE CODE      */


/**************************************************************************/
/* LOCAL  **************     PrintConstants        ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE CONSTANTS BEGINNING WITH frst AND ENDING BEFORE lst.*/
/**************************************************************************/

static void PrintConstants( frst, lst )
PEDGE frst;
PEDGE lst;
{
  register PEDGE i1;
  register PEDGE i2;
  register int   comma1;
  register int   comma2;
	   char  buf[100];

  for ( i1 = frst; i1 != lst; i1 = i1->isucc ) {
    comma1 = (i1->isucc == lst)? ' ' : ',';

    if ( IsBRecord( i1->info ) ) {
      for ( i2 = i1->src->imp; i2 != NULL; i2 = i2->isucc ) {
        comma2 = (i2->isucc == NULL)? comma1 : ',';

        if ( IsChar( i2->info ) )
          sprintf( buf, "\'%s\'", i2->CoNsT );
        else
          sprintf( buf, "%s", i2->CoNsT );

        fprintf( output, "  %s%c\n", buf, comma2 );
	}

      continue;
      }

    if ( IsConst( i1 ) ) {
      if ( IsChar( i1->info ) )
        sprintf( buf, "\'%s\'", i1->CoNsT );
      else
        sprintf( buf, "%s", i1->CoNsT );
      }
    else
      sprintf( buf, "(POINTER) &%sData", i1->src->G_NAME );

    fprintf( output, "  %s%c\n", buf, comma1 );
    }
}


/**************************************************************************/
/* LOCAL  **************   PrintCopyFunctions      ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY COPY FUNCTIONS TO output.                         */
/**************************************************************************/

static void PrintCopyFunctions()
{
  register char  *t;
  register PINFO  i;
  register int    c;
           int    printed[TYPE_STOP+1];

  /* CLEAR touch1 FIELDS and NO REPEAT FIELDS */
  ClearTouchFlags();

  for ( c = 0; c <= TYPE_STOP; c++ )
    printed[c] = FALSE;

  for ( i = ihead; i != NULL; i = i->next ) {
    if ( i->touch1 || !IsArray( i ) )
      continue;

    /* NO ARRAY OF ARRAY AND ARRAY OF SCALAR REPEATS! */
    if ( printed[i->A_ELEM->type] )
      continue;

    fprintf( output, "\nstatic void %s( dest, source, num )\n",
             GetCopyFunction( i )                            );

    fprintf( output, "POINTER  dest;\n" );
    fprintf( output, "POINTER  source;\n" );
    fprintf( output, "register int num;\n" );
    fprintf( output, "{\n" );
  
    if ( IsBasic( i->A_ELEM ) ) {

      t = i->A_ELEM->tname;
  
      fprintf( output, "  register int  i;\n" );
      fprintf( output, "  register %s  *src = (%s*) source;\n", t, t );
      fprintf( output, "  register %s  *dst = (%s*) dest;\n", t, t );

      if ( IsChar( i->A_ELEM ) )
	fprintf( output, "  MyBCopy( src, dst, num );\n" );
      else {
	PrintVECTOR();
	PrintASSOC();
	PrintSAFE( "dst" );
        fprintf( output, "  for ( i = 0; i < num; i++ )\n" );
        fprintf( output, "    dst[i] = src[i];\n" );
	}

      fprintf( output, "}\n" );

    } else {

      t = i->A_ELEM->sname;
  
      fprintf( output, "  register %s **src = (%s**) source;\n", t, t );
      fprintf( output, "  register %s **dst = (%s**) dest;\n", t, t );
      fprintf( output, "  while ( num-- > 0 ) {\n" );
      fprintf( output, "    *dst = *src++;\n" );
      fprintf( output, "    MY_LOCK( &(*dst)->Mutex );\n" );
      fprintf( output, "    (*dst)->RefCount++;\n" );
      fprintf( output, "    MY_UNLOCK( &(*dst)->Mutex );\n" );
      fprintf( output, "    dst++;\n" );
      fprintf( output, "    }\n" );
      fprintf( output, "}\n" );

      }
  
    i->touch1 = TRUE;

    if ( (IsBasic(i->A_ELEM) && !IsBRecord(i->A_ELEM)) || IsArray(i->A_ELEM) )
      printed[i->A_ELEM->type] = TRUE;
    }

  ClearTouchFlags();
}


/**************************************************************************/
/* LOCAL  **************       PrintGlobals        ************************/
/**************************************************************************/
/* PURPOSE: PRINT GLOBAL CONSTANT RECORDS AND ARRAYS TO output.           */
/**************************************************************************/

static void PrintGlobals()
{
  register PNODE n;
  register PEDGE i;
  register PEDGE b;
  register int   gid = 0;
  register int   s;

  gdata = (chead == NULL)? FALSE : TRUE;

  for ( n = chead; n != NULL; n = n->usucc )
    switch ( n->type ) {
      case IFBRBuild:
	pcD++; pcP++;

        fprintf( output, "\nstatic %s %s = {\n",
                 n->exp->info->tname, n->G_NAME      );

	PrintConstants( n->imp, NULL );
        fprintf( output, "  };\n" );
        break;

      case IFRBuild:
        fprintf( output, "\nstatic shared %s %sData = {\n",
                 n->exp->info->sname, n->G_NAME          );

        fprintf( output, "  0, %d,\n", n->exp->sr + 9 );

	PrintConstants( n->imp, NULL );
        fprintf( output, "  };\n" );

	fprintf( output, "\nstatic shared %s %s = (%s) &%sData;\n",
	         n->exp->info->tname, n->G_NAME, n->exp->info->tname,
		 n->G_NAME                                         );
	break;

      case IFABuildAT:
	pcP++;

	if ( n->Smark )
	  scD++; 
        else
	  pcD++;

        for ( s = 0, i = n->imp->isucc; i != NULL; i = i->isucc ) {
          if ( i->isucc != NULL )
            s++;
          else
	    b = i;
          }

	if ( s == 0 )
	  Error2( "PrintGlobals", "IFABuildAT WITHOUT ARGUMENTS" );

/* CANN DIST 92 BEGIN */
        fprintf( output, "\nstatic %s Storage%d[%d] = {\n", 
                 n->exp->info->A_ELEM->tname, ++gid, s          );
/* CANN DIST 92 END */

	PrintConstants( n->imp->isucc, b );
        fprintf( output, "  };\n" );

        fprintf( output, "\nstatic %sPHYS Phys%d = {\n", 
			 (n->Smark)? "shared " : "", gid );

        fprintf( output, "  %d, (POINTER)Storage%d, 0, 1, 1, 0, (POINTER)0,\n",
                 s, gid );
	fprintf( output, "  (POINTER)0, 0, pr_NOTACTIVE, (PHYSP)0\n  };\n" );

        fprintf( output, "\nstatic %sARRAY %sData = {\n", 
			 (n->Smark)? "shared " : "", n->G_NAME );

        fprintf( output, "  (POINTER) (Storage%d - (%s)), %s, %d",
                 gid, n->imp->CoNsT, n->imp->CoNsT, s           );
        fprintf( output, ", &Phys%d, 0, %d, 0\n  };\n", gid, n->exp->sr + 9 );


	fprintf( output, "\nstatic POINTER %s = (POINTER) &%sData;\n",
		 n->G_NAME, n->G_NAME                               );
	break;

      default:
        break;
      }
}


/**************************************************************************/
/* LOCAL  **************        AssignNames        ************************/
/**************************************************************************/
/* PURPOSE: ASSIGN STRUCTURE NAMES TO ALL RECORD, UNION, ARRAY, UNION,    */
/*          BUFFER, AND FUNCTION TYPES IN THE SYMBOL TABLE. ALSO ASSIGN   */
/*          WRITE, READ, COPY AND DEALLOCATION ROUTINE NAMES.             */
/**************************************************************************/

static void AssignNames()
{
  register PINFO i;

  for ( i = ihead; i != NULL; i = i->next ) {
    switch ( i->type ) {
      case IF_ARRAY:
        i->sname  = "ARRAY";
        i->rname  = MakeName( "ReadArr",   "",   ++nmid );
        i->wname  = MakeName( "WriteArr",  "",     nmid );
        i->fname1 = MakeName( "SFreeArr",  "",     nmid );
        i->fname2 = MakeName( "PFreeArr",  "",     nmid );
        break;

      case IF_BUFFER:
        i->sname = "BUFFER";
        break;

      case IF_UNION:
        i->sname  = MakeName( "struct Un",  "", ++nmid );
        i->rname  = MakeName( "ReadUn",     "",   nmid );
        i->wname  = MakeName( "WriteUn",    "",   nmid );
        i->fname1 = MakeName( "SFreeUn",    "",   nmid );
        i->fname2 = MakeName( "PFreeUn",    "",   nmid );
        i->cname  = MakeName( "Un",         "",   nmid );
        break;

      case IF_RECORD:
        i->sname  = MakeName( "struct Rec", "", ++nmid );
        i->fname1 = MakeName( "SFreeRec",   "",   nmid );
        i->fname2 = MakeName( "PFreeRec",   "",   nmid );
        i->cname  = MakeName( "Rec",        "",   nmid );
        i->rname  = MakeName( "ReadRec",    "",   nmid );
        i->wname  = MakeName( "WriteRec",   "",   nmid );
        break;

      case IF_BRECORD:
	i->sname = MakeName( "struct BRec", "", ++nmid );
	i->tname = MakeName( "struct BRec", "",   nmid );
        i->cname = MakeName( "BRec",        "",   nmid );
	break;

      case IF_FUNCTION:
        i->sname = MakeName( "struct Args", "", ++nmid );
        break;

      default:
        break;
      }
    }
}


/**************************************************************************/
/* LOCAL  **************       PrintStructs        ************************/
/**************************************************************************/
/* PURPOSE: PRINT STRUCTURES FOR ALL RECORDS, UNION, AND FUNCTIONS TO     */
/*          output.                                                       */
/**************************************************************************/

static void PrintStructs()
{
  register PINFO i;
  register PINFO ii;
  register int   c;
  register int   cc;
           char  buf[100];

  for ( i = ihead; i != NULL; i = i->next ) {
    switch ( i->type ) {
      case IF_UNION:
        fprintf( output, "\n%s {\n  ", i->sname );
        fprintf( output, "%-16s  %-16s  %-16s\n  ", 
                 "LOCK_TYPE Mutex; ", "int  RefCount; ", "int  Tag;" );

        fprintf( output, "union {\n    " );

        for ( c = 0, ii = i->R_FIRST; ii != NULL; ii = ii->L_NEXT ) {
          sprintf( buf, "%-7s Fld%d; ", ii->L_SUB->tname, c++ );
          fprintf( output, "%-16s", buf ); 

          if ( (c % 4) == 0 )
            fprintf( output, "\n    " );
          }

        if ( (c % 4) != 0 )
          fprintf( output, "\n    " );

        fprintf( output, "} Data;\n  };\n" );
        break;

      case IF_RECORD:
        fprintf( output, "\n%s {\n  ", i->sname );
        fprintf( output, "%-16s %-16s\n  ",
		 "LOCK_TYPE Mutex; ", "int  RefCount;" );
	
        for ( c = 0, ii = i->R_FIRST; ii != NULL; ii = ii->L_NEXT ) {
          sprintf( buf, "%-7s Fld%d; ", ii->L_SUB->tname, ++c );
          fprintf( output, "%-16s", buf ); 

          if ( (c % 4) == 0 )
            fprintf( output, "\n  " );
          }

        if ( (c % 4) != 0 )
          fprintf( output, "\n  " );

        fprintf( output, "};\n" );
        break;

      case IF_BRECORD:
        fprintf( output, "\n%s {\n  ", i->sname );
	
        for ( c = 0, ii = i->R_FIRST; ii != NULL; ii = ii->L_NEXT ) {
          sprintf( buf, "%-7s Fld%d; ", ii->L_SUB->tname, ++c );
          fprintf( output, "%-16s", buf ); 

          if ( (c % 4) == 0 )
            fprintf( output, "\n  " );
          }

        if ( (c % 4) != 0 )
          fprintf( output, "\n  " );

        fprintf( output, "};\n" );
        break;

      case IF_FUNCTION:
        fprintf( output,"\n%s {   \n", i->sname );
	fprintf( output, "struct ActRec *FirstAR; int Count;   \n" );

        for ( c = 0, ii = i->F_IN; ii != NULL; ii = ii->L_NEXT ) {
          if ( ii->L_SUB->type == IF_BUFFER ) 
            sprintf( buf, "%-7s In%d; ", "POINTER", ++c );
          else
            sprintf( buf, "%-7s In%d; ", ii->L_SUB->tname, ++c );

          fprintf( output, "%-16s", buf );

          if ( (c % 4) == 0 )
            fprintf( output, "\n  " );
          }

        cc = c;

        for ( c = 0, ii = i->F_OUT; ii != NULL; ii = ii->L_NEXT ) {
          if ( ii->L_SUB->type == IF_BUFFER )
            Error2( "PrintStructs", "FUNCTION RETURNING BUFFER" );

          sprintf( buf, "%-7s Out%d; ", ii->L_SUB->tname, ++c );
          fprintf( output, "%-16s", buf ); 

	  cc++;

          if ( (cc % 4) == 0 )
            fprintf( output, "\n  " );
          }

        if ( (cc % 4) != 0 )
          fprintf( output, "\n  " );

        fprintf( output, "};\n" );
        break;

      default:
        break;
      }
    }
}


/**************************************************************************/
/* LOCAL  **************    PrintExternFunction    ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE EXTERN DECLARATION FOR THE FUNCTION NAMED f WHICH   */
/*          RETURNS TYPE t.  THE CALLED FUNCTION GRAPH IS ff, UNLESS IT   */
/*          IS NULL.                                                      */
/**************************************************************************/

static PrintExternFunction( t, f, ff )
char  *t;
char  *f;
PNODE  ff;
{
  fprintf( output, "extern %-12s %s();", t, f );

  if ( ff != NULL )
    fprintf( output, " \/* [Call=%c,Rec=%c,Par=%c,Xmk=%c,Mk=%c] *\/",
	     (ff->Cmark)? 'T' : 'F', 
	     (ff->bmark)? 'T' : 'F', 
	     (ff->Pmark)? 'T' : 'F',
	     (ff->xmark)? 'T' : 'F', (ff->mark) );

  fprintf( output, "\n" );
}


/**************************************************************************/
/* LOCAL  **************        PrintForwards      ************************/
/**************************************************************************/
/* PURPOSE: PRINT FORWARD DECLARATIONS FOR SISAL, LOOP TASK, FREE, AND    */
/*          FIBRE READ AND WRITE OPERATIONS TO output.                    */
/**************************************************************************/

static void PrintForwards()
{
  register PNODE f;
  register PINFO i;
	   char  buf[100];

  /* PRINT FORWARD DECLARATIONS */
  fprintf( output, "extern void InitGlobalData();\n\n" );

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
    if ( IsIGraph( f ) ) {
      if ( IsIntrinsic( f ) )
	continue;

      if ( f->mark != 's' ) /* NEW CANN 2/92 */
        PrintExternFunction( f->info->F_OUT->L_SUB->tname, f->G_NAME, f );
      else
        PrintExternFunction( "void", f->G_NAME, f );
      }
    else
      PrintExternFunction( "void", f->G_NAME, f );
    }

  /* PRINT DEALLOCATION AND FIBRE READ AND WRITE FORWARD DECLARATIONS */
  /* AND INTERFACE ROUTINES */
  for ( i = ihead; i != NULL; i = i->next ) {
    switch ( i->type ) {
      case IF_UNION:
      case IF_RECORD:
      case IF_ARRAY:
        PrintExternFunction( "void",   i->fname1,  NULL );
        PrintExternFunction( "void",   i->fname2,  NULL );
        PrintExternFunction( i->tname, i->rname,   NULL );
        PrintExternFunction( "void",   i->wname,   NULL );

	/* INTERFACE ROUTINES */
	sprintf( buf, "I%s", i->rname );
        PrintExternFunction( i->tname, buf, NULL );
	sprintf( buf, "I%s", i->wname );
        PrintExternFunction( "void", buf, NULL );
	break;

      default:
	break;
      }
    }
}


/**************************************************************************/
/* GLOBAL **************     PrintFilePrologue     ************************/
/**************************************************************************/
/* PURPOSE: PRINT INCLUDES, FORWARDS, TYPE TABLE, ENTRY POINT, GLOBALS,   */
/*          AND ARUGMENT AND RECORD STRUCTURES TO output.                 */
/**************************************************************************/

void PrintFilePrologue()
{
  register PNODE f;

  fprintf( output, "#ifdef CInfo\n" );
  fprintf( output, "#define GatherCopyInfo 1\n" );
  fprintf( output, "#endif\n\n" );

  fprintf( output, "#ifdef FInfo\n" );
  fprintf( output, "#define GatherFlopInfo 1\n" );
  fprintf( output, "#endif\n\n" );

  if ( !regok )
    fprintf( output, "#define register\n\n" );

  fprintf( output, "#define _INTRINSICS_ 1\n\n" );

  fprintf( output, "#include \"sisal.h\"\n\n" );


  /* START: DUMP MODULE COORDINATION VARIABLES */
  if ( IsStamp( PDBASE ) )
    fprintf( output,"int AllCompilesMustUseTheModuleDataBase;\n\n" );
  else if ( IsStamp( MDBASE ) ) {
    fprintf( output,"extern int AllCompilesMustUseTheModuleDataBase;\n" );
    fprintf( output,
      "static int *ModuleValue = &AllCompilesMustUseTheModuleDataBase;\n\n");
    }
  else if ( IsStamp( PNODBASE ) )
    fprintf( output,"int ProvideModuleDataBaseOnAllCompiles;\n\n" );
  else if ( IsStamp( MNODBASE ) ){
    fprintf( output,"extern int ProvideModuleDataBaseOnAllCompiles;\n" );
    fprintf( output,
      "static int *ModuleValue = &ProvideModuleDataBaseOnAllCompiles;\n\n");
    }

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
    if ( f->mark == 's' && IsIGraph( f ) && f->Pmark ) {
      fprintf( output, "extern int RecompileTheModuleDefining%s;\n", f->G_NAME);
      fprintf( output, 
	       "static int *%sValue = &RecompileTheModuleDefining%s;\n\n",
	       f->G_NAME, f->G_NAME );
      }
    else if ( f->Pmark && IsXGraph( f ) && f->mark == 's' )
      fprintf( output, "int RecompileTheModuleDefining%s;\n\n", f->G_NAME );
    }
  /* END: DUMP MODULE COORDINATION VARIABLES */


  if ( sdbx )
    PrintSdbxFunctionList();
    
  AssignNames();

  PrintForwards();
  PrintStructs();
  PrintCopyFunctions();
  PrintGlobals();

  /* FOR DEALLOCATION ROUTINE INFORMATION */
  ClearTouchFlags();
}


/**************************************************************************/
/* LOCAL  **************    DriveRecursiveMarks    ************************/
/**************************************************************************/
/* PURPOSE: MARK ALL THE FUNCTIONS CALLED WITHIN GRAPH g AS RECURSIVE.    */
/**************************************************************************/

static int DriveRecursiveMarks( g, bmark )
PNODE g;
int   bmark;
{
  register PNODE n;
  register PNODE sg;
  register PNODE f;
  register int   change;

  for ( change = FALSE, n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( IsCompound( n ) )
      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
	change = change || DriveRecursiveMarks( sg, bmark );

    if ( !IsCall( n ) )
      continue;

    f = FindFunction( n->imp->CoNsT );

    /* MARK AS CALLED! */
    if ( !(f->Cmark) ) {
      f->Cmark = TRUE;
      change = TRUE;
      }

    if ( bmark )
      if ( !(f->bmark) ) {
        f->bmark = TRUE;
        change = TRUE;
        }
    }

  return( change );
}


/**************************************************************************/
/* GLOBAL **************   MarkRecursiveFunctions  ************************/
/**************************************************************************/
/* PURPOSE: MARK ALL THE RECURSIVE FUNCTIONS IN THE PROGRAM.              */
/**************************************************************************/

void MarkRecursiveFunctions()
{
  register PNODE f;
  register int   change = TRUE;
  register int   rsmodule = FALSE;

  /* COULD THIS MODULE BE PART OF A RECURSIVE CYCLE THAT CROSSES MODULES? */
  /* LOOKUP WOULD HELP! */
  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    if ( IsIGraph( f ) )
      if ( f->mark == 's' )
	 rsmodule = TRUE;

  while ( change ) {
    change = FALSE;

    for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
      switch( f->type ) {
	case IFIGraph:
	  break;

	case IFXGraph:
	  /* NEW CANN 2/92 ASSUME A SISAL MODULE THAT CALLS ANOTHER SISAL */
	  /* MODULE IS RECURSIVE; LOOKUP WOULD HELP! */
	  /* NOTE: PROGRAM MODULE ENTRY POINTS (e,c,f) CANNOT BE RECURSIVE!!! */
	  if ( f->mark == 's' && rsmodule )
	     f->bmark = TRUE;

	case IFLGraph:
	  change = DriveRecursiveMarks( f, f->bmark );
	  break;

	default:
	  Error2( "MarkRecursiveFunctions", "ILLEGAL GRAPH NODE" );
	}
    }
}


/**************************************************************************/
/* LOCAL  **************    CheckParallelMarks     ************************/
/**************************************************************************/
/* PURPOSE: FUNCTION g IS CALLED IN PARALLEL, SO MARK IT'S CALLEES        */
/*          SIMILARLY.                                                    */
/**************************************************************************/

static void CheckParallelMarks( g )
PNODE g;
{
  register PNODE n;
  register PNODE sg;
  register PNODE f;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( IsCompound( n ) )
      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
	CheckParallelMarks( sg );

    if ( !IsCall( n ) )
      continue;

    f = FindFunction( n->imp->CoNsT );

    if ( !(f->Pmark) )
      Error2( "CheckParallelMarks", "Pmark IS NOT SET ON FUNCTION CALL" );
    }
}


/**************************************************************************/
/* GLOBAL **************   CheckParallelFunctions  ************************/
/**************************************************************************/
/* PURPOSE: VERIFY THE EXECUTION MODES FOR ALL THE FUNCTIONS.             */
/**************************************************************************/

void CheckParallelFunctions()
{
  register PNODE f;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    switch( f->type ) {
      case IFLPGraph:
	if ( !(f->Pmark) )
	  Error2( "CheckParallelFunctions", "Pmark NOT SET ON LPGraph" );

	CheckParallelMarks( f );
	break;

      case IFIGraph:
	break;

      case IFLGraph:
      case IFXGraph:
	if ( f->Pmark )
	  CheckParallelMarks( f );

	break;

      default:
	Error2( "CheckParallelFunctions", "ILLEGAL GRAPH NODE" );
      }
}


/**************************************************************************/
/* GLOBAL **************     PrintFunctPrologue    ************************/
/**************************************************************************/
/* PURPOSE: PRINT FUNCTION f'S PROLOGUE TO output.                        */
/**************************************************************************/

void PrintFunctPrologue( f )
PNODE f;
{
  register PINFO ii;
  register int   eport;

  switch ( f->type ) {
    case IFIGraph:
      return;

    case IFLPGraph:
      fprintf( output, "\nstatic void %s( args, lo, hi )\n", f->G_NAME );
      fprintf( output, "%s args;\n", f->info->tname );
      fprintf( output, "int lo, hi;\n{\n" );
      break;

    default:
      eport = 1;

      for ( ii = f->info->F_IN; ii != NULL; ii = ii->L_NEXT, eport++ ) {
        if ( IsExport( f, eport ) )
          continue;

        fprintf( stderr, "%s: W - ARGUMENT %d OF %s ON LINE %d IN %s IS NEVER USED\n",
	         program, eport, 
		 (f->funct == NULL)? "???()" : f->funct, f->line, 
		 (f->file == NULL)? "???.sis" : f->file                      );
        }

      fprintf( output, "\n%svoid %s( args )\n",
	       /* (f->emark)? "" : "static ", f->G_NAME ); */
	       (f->mark == 's')? "" : "static ", f->G_NAME); /* NEW CANN 2/92 */
      fprintf( output, "%s args;\n{\n", f->info->tname );
      break;
    }

  PrintLocals();

  if ( f->flp ) {
    fprintf( output, "register double FCa;\n" );
    fprintf( output, "register double FCl;\n" );
    fprintf( output, "register double FCi;\n" );
    }

  if ( sdbx )
    SaveSdbxState( f );

  if ( sequential ) {
    fprintf( output, "#undef  MY_LOCK(x)\n"   );
    fprintf( output, "#undef  MY_UNLOCK(x)\n" );
    fprintf( output, "#define MY_LOCK(x)\n"   );
    fprintf( output, "#define MY_UNLOCK(x)\n\n" );
    }

  if ( f->flp ) {
    fprintf( output, "FCa = MyInfo->FlopCountA;\n" );
    fprintf( output, "FCl = MyInfo->FlopCountL;\n" );
    fprintf( output, "FCi = MyInfo->FlopCountI;\n" );
    }

  if ( f->time )
    fprintf( output, "  StartFunctionTimer(\"%s\");\n\n", 
	     (f->funct == NULL)? f->G_NAME : f->funct );
}


/**************************************************************************/
/* GLOBAL **************     PrintFunctEpilogue    ************************/
/**************************************************************************/
/* PURPOSE: PRINT FUNCTION f'S EPILOGUE TO output. GRAPH TYPE CONTROLS    */
/*          THE TERMINATION MECHANISM. WHEN DONE, THE LOCAL NAME STORAGE  */
/*          IS RELEASED.                                                  */
/**************************************************************************/

void PrintFunctEpilogue( f )
PNODE f;
{
  PrintFrameDeallocs();

  if ( f->time )
    fprintf( output, "\n  StopFunctionTimer(\"%s\");\n", 
	     (f->funct == NULL)? f->G_NAME : f->funct );

  if ( sdbx )
    fprintf( output, "SdbxMonitor( SDBX_POP );\n" );

  if ( f->mark == 's' && sdbx ) {
    fprintf( output, "if ( ClearSdbx ) {\n" );
    fprintf( output, " SdbxMonitor( SDBX_ESTOP );\n" );
    fprintf( output, " }\n" );
    }

  if ( f->flp ) {
    fprintf( output, "fprintf( stderr, \"%%18.0fA %%18.0fL %%18.0fI [%s]\\n\",(MyInfo->FlopCountA)-FCa,(MyInfo->FlopCountL)-FCl, (MyInfo->FlopCountI)-FCi );\n", 
      (f->funct == NULL)? f->G_NAME : f->funct );
    }

  if ( sequential ) {
    fprintf( output, "\n#undef  MY_LOCK(x)\n" );
    fprintf( output, "#undef  MY_UNLOCK(x)\n" );
    fprintf( output, "#define MY_LOCK(x)    MY_LOCK_BACKUP(x)\n"   );
    fprintf( output, "#define MY_UNLOCK(x)  MY_UNLOCK_BACKUP(x)\n" );
    }

  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************   PrintInitGlobalData     ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE GLOBAL CONSTANT INITIALIZATION FUNCTION.            */
/**************************************************************************/

static void PrintInitGlobalData()
{
  register PNODE n;

  fprintf( output, "\nstatic int *GInit = NULL;\n" ); 

  fprintf( output, "\nstatic void InitGlobalData()\n" );
  fprintf( output, "{\n" );
  fprintf( output, "  SLockParent;\n\n" );
  fprintf( output, "  if ( GInit == NULL )\n" );
  fprintf( output, "    GInit = (int *) Alloc( sizeof(int) );\n" );
  fprintf( output, "  else if ( *GInit ) {\n" );
  fprintf( output, "    SUnlockParent;\n" );
  fprintf( output, "    return;\n" );
  fprintf( output, "    }\n\n" );

  fprintf( output, "  *GInit = TRUE;\n\n" );

  for ( n = chead; n != NULL; n = n->usucc )
    switch ( n->type ) {
      case IFRBuild:
        fprintf( output, "  MY_INIT_LOCK( &(%sData.Mutex) );\n", n->G_NAME );
        break;

     case IFABuildAT:
       fprintf( output, "  MY_INIT_LOCK( &(%sData.Phys->Mutex) );\n",n->G_NAME);
       fprintf( output, "  MY_INIT_LOCK( &(%sData.Mutex) );\n", n->G_NAME );
       break;

     default:
       break;
     }

  fprintf( output, "\n  SUnlockParent;\n" );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  ************** PrintStandAloneEntryPoint ************************/
/**************************************************************************/
/* PURPOSE: PRINT STAND ALONE SISAL ENTRY POINT FOR FUNCTION f TO output. */
/**************************************************************************/

static void PrintStandAloneEntryPoint( f )
PNODE f;
{
  fprintf( output, "\nvoid SisalMain( args )\n" );
  fprintf( output, "POINTER args;\n" );
  fprintf( output, "{\n" );
  fprintf( output, "  register int Cycles;\n" );
  fprintf( output, "  register double StartTime;\n" );

  fprintf( output, "#ifdef CInfo\n" );
  fprintf( output, "  SaveCopyInfo;\n" );
  fprintf( output, "#endif\n" );

  fprintf( output, "#ifdef FInfo\n" );
  fprintf( output, "  SaveFlopInfo;\n" );
  fprintf( output, "#endif\n" );

  fprintf( output, "  for ( Cycles = 1; /* NOTHING */; Cycles++ ) {\n");

  if ( gdata )
    fprintf( output, "    InitGlobalData();\n" );

  if ( sdbx ) {
    fprintf( output, "    SdbxCurrentFunctionList = MyFunctionList;\n" );
    fprintf( output, "    SdbxMonitor( SDBX_ESTART );\n" );
    }

  fprintf( output, "    if ( Benchmarking )\n" );
  fprintf( output, "      StartBenchmarkTimer(StartTime);\n" );

  fprintf( output, "    %s( args );\n", f->G_NAME );

  fprintf( output, "    if ( Benchmarking )\n" );
  fprintf( output, "      StopBenchmarkTimer(StartTime,Cycles,\"%s\");\n",
	   (f->funct != NULL)? f->funct : f->G_NAME  );

  if ( sdbx ) {
    fprintf( output, "    SdbxMonitor( SDBX_ESTOP );\n" );
    }

  /* PrintInputDeallocs( NULL, 2, f ); */

  fprintf( output, "    if ( Benchmarking && Cycles < BenchmarkCycles ) {\n" );
  PrintOutputDeallocs( 4, f );
  fprintf( output, "      DoDistDeAllocs();\n" );
  fprintf( output, "      }\n" );
  fprintf( output, "    else break;\n" );

  fprintf( output, "  }\n" );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* GLOBAL **************     PrintFileEpilogue     ************************/
/**************************************************************************/
/* PURPOSE: PRINT ALL REMAINING STUFF TO output TO COMPLETE THE C CODE.   */
/**************************************************************************/

void PrintFileEpilogue()
{
  register PNODE f;

  /* FORCE SEQUENTIAL MODE OF EXECUTION */
  sequential = TRUE;

  PrintInitGlobalData();

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {

    /* NEW CANN 2/92 */
    if ( IsIGraph( f ) )
      continue;
    /* if ( !f->emark ) */
    if ( f->mark == ' ' || f->mark == 's' )
      continue;

    if ( standalone ) {
      PrintStandAloneEntryPoint( f );
      break; 
      }

    PrintInterface( f );
    }

  PrintInterfaceUtilities();
  PrintFreeUtilities();

  if ( standalone ) {
    for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
      /* if ( !f->emark ) */
      if ( f->mark != 'e' ) /* NEW CANN 2/92 */
        continue;

      PrintReadFibreInputs( f );
      PrintWriteFibreOutputs( f );
      break;
      }
    }
  else
    PrintWriteFibreOutputs( NULL );

  /* CLEAR MODE OF EXECUTION */
  sequential = FALSE;
}
