#include "world.h"

int smallocs = 0;                             /* COUNT OF SHARED MALLOCS  */
int pmallocs = 0;                             /* COUNT OF PRIVATE MALLOCS */

int spsmallocs = 0;              /* COUNT OF SHARED POINTER SWAP MALLOCS  */
int ppsmallocs = 0;              /* COUNT OF PRIVATE POINTER SWAP MALLOCS */

int pargD = 0;                  /* COUNT OF PRIVATE ARGUMENT DOPE VECTORS */
int pargP = 0;              /* COUNT OF PRIVATE ARGUMENT PHYSICAL VECTORS */
int sargD = 0;                   /* COUNT OF SHARED ARGUMENT DOPE VECTORS */
int sargP = 0;               /* COUNT OF SHARED ARGUMENT PHYSICAL VECTORS */

int pargs = 0;                     /* COUNT OF COMPLETE PRIVATE ARGUMENTS */
int sargs = 0;                      /* COUNT OF COMPLETE SHARED ARGUMENTS */

int pcD = 0;                    /* COUNT OF PRIVATE CONSTANT DOPE VECTORS */
int pcP = 0;                /* COUNT OF PRIVATE CONSTANT PHYSICAL VECTORS */
int scD = 0;                     /* COUNT OF SHARED CONSTANT DOPE VECTORS */
int scP = 0;                 /* COUNT OF SHARED CONSTANT PHYSICAL VECTORS */

int sread = 0;                                   /* COUNT OF SHARED READS */
int pread = 0;                              /* COUNT OF DISTRIBUTED READS */

static int dpsm = 0;         /* COUNT OF DISTRIBUTED POINTER SWAP MALLOCS */
static int psm = 0;      /* COUNT OF NON-DISTRIBUTED POINTER SWAP MALLOCS */

static int dnpsm = 0;    /* COUNT OF DISTRIBUTED NON-POINTER SWAP MALLOCS */
static int npsm = 0;                 /* COUNT OF NON-POINTER SWAP MALLOCS */

static int pfcnt = 0;                              /* COUNT OF PREFETCHES */

static PNODE callh = NULL;                       /* CALL NODE LIST HEADER */
static int change = FALSE;                       /* PROPAGATION UPDATE?   */

static void PushSharedAttribute();


/**************************************************************************/
/* LOCAL  **************  PushAllSharedAttributes  ************************/
/**************************************************************************/
/* PURPOSE: PUSH ALL THE SHARED ATTRIBUTES OF sg1 EXPORTS TO ASSOCIATED   */
/*          IMPORTS OF sg2.                                               */
/**************************************************************************/

static void PushAllSharedAttributes( sg1, sg2 )
PNODE sg1;
PNODE sg2;
{
  register PEDGE e;

  for ( e = sg1->exp; e != NULL; e = e->esucc )
    if ( e->Smark )
      PushSharedAttribute( FindImport( sg2, e->eport ) );
}


/**************************************************************************/
/* LOCAL  **************    StabalizeAttributes    ************************/
/**************************************************************************/
/* PURPOSE: SUMMARIZE THE SHARED ATTRIBUTES OF NODE n AND PROPAGATE THEM  */
/*          OUT AND UP THE GRAPH TO STABALIZE THE ANALYSIS.               */
/**************************************************************************/

static void StabalizeAttributes( n )
PNODE n;
{
  register PEDGE e;
  register PNODE sg;
  register PNODE f;
  register PEDGE i;

  if ( IsCall( n ) ) {
    f = FindFunction( n->imp->CoNsT );

    if ( f == NULL )
      Error2( "StabalizeAttributes", "FindFunction failed" );

    if ( IsIntrinsic( f ) )
      return;

    if ( IsIGraph( f ) ) {
      if ( f->mark == 's' ) {
  /* DATA BASE LOOKUP WOULD HELP THIS!!! */
  /* BUT FOR NOW ASSUME THE WORST!!! */
        for ( i = n->imp; i != NULL; i = i->isucc )
          PushSharedAttribute( i );
  }

      return;
      }

    for ( e = n->exp; e != NULL; e = e->esucc )
      if ( e->Smark )
        PushSharedAttribute( FindImport( f, e->eport ) );

    for ( e = f->exp; e != NULL; e = e->esucc )
      if ( e->Smark )
        PushSharedAttribute( FindImport( n, e->eport ) );

    return;
    }

  if ( !IsCompound( n ) )
    Error2( "StabalizeAttributes", "ILLEGAL NODE" );

  switch ( n->type ) {
    case IFForall:
      PushAllSharedAttributes( n->F_RET, n->F_BODY );
      PushAllSharedAttributes( n->F_RET, n->F_GEN );
      PushAllSharedAttributes( n->F_BODY, n->F_GEN );
      break;

    case IFSelect:
    case IFTagCase:
      break;

    default:
      PushAllSharedAttributes( n->L_RET, n->L_BODY );
      PushAllSharedAttributes( n->L_RET, n->L_INIT );

      for ( e = n->L_BODY->exp; e != NULL; e = e->esucc ) 
        if ( e->Smark )
          PushSharedAttribute( FindImport( n->L_BODY, e->eport ) );

      PushAllSharedAttributes( n->L_BODY, n->L_INIT );
      break;
    }

  for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
    for ( e = sg->exp; e != NULL; e = e->esucc )
      if ( e->Smark )
        PushSharedAttribute( FindImport( n, e->eport ) );
}




/**************************************************************************/
/* LOCAL  **************    PushSharedAttribute    ************************/
/**************************************************************************/
/* PURPOSE: IF e REPRESENTS AN AGGREGATE, THEN MARK IT AS SHARED AND PUSH */
/*          THE ATTRIBUTE THROUGH ITS PREDECESSORS.                       */
/**************************************************************************/

static void PushSharedAttribute( e )
PEDGE e;
{
  register PINFO info;
  register PEDGE i;
  register PNODE n;
  register PNODE sg;

  if ( e == NULL )
    return;

  info = (IsMultiple( e->info ))? e->info->A_ELEM : e->info;

  if ( IsBasic( info ) ) /* SCALARS ARE NOT SHARED */
    return;

  /* WAS e ALREADY PROCESSED? IF SO, DO NOTHING */
  if ( e->Smark )
    return;

  e->Smark = TRUE;

  if ( (n = e->src) == NULL )
    return;

  n->Smark = TRUE;

  change = TRUE;

  switch ( n->type ) {
    case IFSGraph:
      StabalizeAttributes( n->G_DAD );
      break;

    case IFLGraph:
    case IFXGraph:
      break;

    case IFForall:
      PushSharedAttribute( FindImport( n->F_RET, e->eport ) );
      StabalizeAttributes( n );
      break;

    case IFSelect:
      PushSharedAttribute( FindImport( n->S_ALT, e->eport ) );
      PushSharedAttribute( FindImport( n->S_CONS, e->eport ) );
      StabalizeAttributes( n );
      break;

    case IFTagCase:
      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
        PushSharedAttribute( FindImport( sg, e->eport ) );

      StabalizeAttributes( n );
      break;

    case IFLoopA:
    case IFLoopB:
      PushSharedAttribute( FindImport( n->L_RET, e->eport ) );
      StabalizeAttributes( n );
      break;

    case IFCall:
      break;

    default:
      for ( i = n->imp; i != NULL; i = i->isucc )
        PushSharedAttribute( i );

      break;
    }
}


/**************************************************************************/
/* LOCAL  **************   EstablishSharedBuilds   ************************/
/**************************************************************************/
/* PURPOSE: ESTABLISH THE SHARED AGGREGATE BUILD NODES IN GRAPH g. ALL    */
/*          NODES ARE ASSUMED TO BE PRIVATE UNTIL INVALIDATED. THIS       */
/*          ROUTINE DOES NOT CROSS FUNCTION GRAPH BOUNDARIES, WHICH IS    */
/*          DONE BY StabalizeAttributes AT A LATER TIME. THIS ROUTINE     */
/*          WILL HELP BUILD THE CALL NODE LIST.                           */
/**************************************************************************/

static void EstablishSharedBuilds( g )
PNODE g;
{
  register PNODE n;
  register PNODE sg;
  register PEDGE i;
  register PEDGE e;

  if ( IsXGraph( g ) )
    if ( g->mark == 's' ) {
      /* UGH! ASSUME THE WORST. A DATA BASE LOOKUP WOULD HELP HERE */
      /* NOTE THAT A MODULE ENTRY POINT CANNOT BE A PROGRAM ENTRY POINT */
      for ( i = g->imp; i != NULL; i = i->isucc )
  PushSharedAttribute( i );
      }

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( IsCompound( n ) ) {

      /* IF n IS A SLICED FORALL THEN ITS IMPORTS MUST BE SHARED AND */
      /* ITS EXPORTS MUST BE SHARED */

      if ( IsForall( n ) && n->smark ) {
  for ( i = n->imp; i != NULL; i = i->isucc )
    PushSharedAttribute( i );

  for ( e = n->exp; e != NULL; e = e->esucc )
    PushSharedAttribute( e );
  }

      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
  EstablishSharedBuilds( sg );
      }
    }
}


/**************************************************************************/
/* GLOBAL **************      If2DataPartition0    ************************/
/**************************************************************************/
/* PURPOSE: MARK SHARED AGGREGATE CONSTRUCTIONS.                          */
/**************************************************************************/

void If2DataPartition0()
{
  register PNODE f;
  register PNODE n;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    if ( !IsIGraph( f ) )
      EstablishSharedBuilds( f );

  change = TRUE;

  /* STABALIZE THE ATTRIBUTES ACROSS CALL BOUNDARIES */
  while ( change ) {
    change = FALSE;

    for ( n = callh; n != NULL; n = n->next )
      StabalizeAttributes( n );
    }
}


/**************************************************************************/
/* GLOBAL **************      AddToCallList        ************************/
/**************************************************************************/
/* PURPOSE: ADD CALL NODE n TO THE CALL NODE LIST HEADED BY callh.        */
/**************************************************************************/

void AddToCallList( n )
PNODE n;
{
  n->next = callh;
  callh = n;
}


/**************************************************************************/
/* GLOBAL **************   WriteDataPartitionInfo  ************************/
/**************************************************************************/
/* PURPOSE: PRINT DATA PARTITION INFORMATION TO stderr.                   */
/**************************************************************************/

void WriteDataPartitionInfo()
{
  fprintf( stderr, "\n**** DATA PARTITIONING\n" );

  fprintf( stderr, " Shared  Memory Mallocs in Code:  %d\n", smallocs  );
  fprintf( stderr, " Private Memory Mallocs in Code:  %d\n\n", pmallocs  );

  fprintf( stderr, " Shared  Memory Pointer Swap Mallocs in Code:  %d\n", 
     spsmallocs  );

  fprintf( stderr, " Private Memory Pointer Swap Mallocs in Code:  %d\n\n", 
     ppsmallocs  );

  fprintf( stderr, " Private FIBRE Aggregates:   %d\n", pargs );
  fprintf( stderr, " Shared  FIBRE Aggregates:   %d\n", sargs );

  fprintf( stderr, " Private FIBRE Arrays (Dope,Phys): %d %d\n",pargD,pargP);
  fprintf( stderr, " Shared  FIBRE Arrays (Dope,Phys): %d %d\n",sargD,sargP);

  fprintf( stderr, "\n Private Constants (Dope,Phys): %d %d\n", pcD, pcP  );
  fprintf( stderr, " Shared  Constants (Dope,Phys): %d %d\n\n", scD, scP  );

  fprintf( stderr, " Private Read Attempts: %d\n", pread );
  fprintf( stderr, " Shared Read Attempts:  %d\n\n", sread );

  fprintf( stderr, " Shadowed PSMallocs: %d\n", dpsm );
  fprintf( stderr, " Non-Shadowed  PSMallocs: %d\n\n", psm );

  fprintf( stderr, " Shadowed Mallocs: %d\n", dnpsm );
  fprintf( stderr, " Non-Shadowed Mallocs: %d\n\n", npsm );

  fprintf( stderr, " Prefetches: %d\n", pfcnt );
}


/**************************************************************************/
/* GLOBAL **************        IsDistRead         ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF EXPORT eport OF NODE n IS A CANDIDATE FOR      */
/*          PRIVATE READ ONLY OPERATION.                                  */
/**************************************************************************/

int IsDistRead( n, eport )
PNODE n;
int   eport;
{
  register PEDGE e;
  register int   f;
  register int   p;

  for ( p = 0, f = 0, e = n->exp; e != NULL; e = e->esucc, p++ ) {
    if ( e->eport != eport )
      continue;

    switch( e->dst->type ) {
      case IFForall:
  if ( !IsDistRead( e->dst->F_BODY, e->iport ) )
    return( FALSE );
  /* f++; */
  break;

      case IFOptAElement:
  break;

      case IFSelect:
  if ( !IsDistRead( e->dst->S_ALT, e->iport ) )
    return( FALSE );

  if ( !IsDistRead( e->dst->S_CONS, e->iport ) )
    return( FALSE );

  break;

      case IFLoopA:
      case IFLoopB:
  if ( !IsDistRead( e->dst->L_BODY, e->iport ) )
    return( FALSE );

  break;

      default:
  return( FALSE );
      }
    }

  /* if ( f <= 0 )
    if ( p > 0 )
      return( FALSE ); */

  return( TRUE );
}


static int IsSafe( n, eport )
PNODE n;
int eport;
{
  register PEDGE e;
  register PEDGE ee;

  for ( e = n->exp; e != NULL; e = e->esucc ) {
    if ( e->eport != eport )
      continue;

    switch ( e->dst->type ) {
      case IFShiftBuffer:
        if ( !IsSafe( e->dst, e->dst->exp->eport ) )
          return( FALSE );

        continue;

      case IFForall:
	if ( e->dst->smark ) return( FALSE );
	if ( IsExport( e->dst->F_BODY, e->iport ) )
	   return( FALSE );
	
	ee = FindExport( e->dst->F_RET, e->iport );

ProcessRet:
	if ( ee == NULL )
	  return( FALSE );

	switch ( ee->dst->type ) {
	  case IFAGatherAT:
	    if ( !(ee->dst->nmark) )
	      return( FALSE );

	    ee = ee->dst->exp;

	    if ( !IsSafe( e->dst, ee->iport ) )
	      return( FALSE );

	    break;

	  case IFAGatherATDV:
	    ee = ee->dst->exp;

	    if ( UsageCount( e->dst, ee->iport ) != 1 )
	      return( FALSE );

	    ee = FindExport( e->dst, ee->iport );

	    if ( ee->dst->type != IFSGraph )
	      return( FALSE );

	    continue;

	  default:
	    return( FALSE );
          }

	return( TRUE );

      case IFLoopA:
      case IFLoopB:
	if ( IsExport( e->dst->L_INIT, e->iport ) )
	   return( FALSE );
	if ( IsExport( e->dst->L_BODY, e->iport ) )
	   return( FALSE );

	ee = FindExport( e->dst->L_RET, e->iport );
	goto ProcessRet;

      case IFSelect:
        return( FALSE );

      case IFAAddHAT:
      case IFAAddLAT:
      case IFACatenateAT:
	if ( !(e->dst->nmark) )
	  return( FALSE );

      case IFOptNoOp:
        if ( !IsSafe( e->dst, e->dst->exp->eport ) )
          return( FALSE );

        continue;

      case IFAAddHATDV:
      case IFAAddLATDV:
      case IFACatenateATDV:
      case IFABuildATDV:
	if ( e->dst->exp->esucc != NULL ) {
	  return( FALSE );
	  }

	if ( e->dst->exp->dst->type == IFAStore )
	  continue;

	if ( !IsSGraph( e->dst->exp->dst ) ) {
	  return( FALSE );
	  }

        continue;

      case IFSGraph:
        continue;

      default:
        return( FALSE );
      }
    }

  return( TRUE );
}


/**************************************************************************/
/* LOCAL  **************   DistributeSharedArrays  ************************/
/**************************************************************************/
/* PURPOSE: DISTRIBUTE THE SHARED ARRAYS BUILT AND RETURNED FROM GRAPH g. */
/**************************************************************************/

static void DistributeSharedArrays( g )
PNODE g;
{
  register PNODE n;
  register PNODE ln;
  register PNODE nn;
  register PNODE sg;
  register PEDGE e;
  register int   c;

  for ( c = 1, n = g->G_NODES; n != NULL; n = n->nsucc, c++ )
    n->label = c;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( IsCompound( n ) ) {
      for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc )
        DistributeSharedArrays( sg );
      }

    switch ( n->type ) {
      case IFMemAllocDVI:
        if ( n->wmark ) break;
        if ( !IsSGraph( g ) ) break;
        if ( !IsForall( g->G_DAD ) ) break;
        if ( g->G_DAD->exp->dst->type != IFLPGraph ) break;
        if ( !IsSafe( n, n->exp->eport ) ) break;
	/* FUCK IT, IT DOES NOT WORK */
	break;

      case IFPSMemAllocDVI:
        if ( IsBasic( n->exp->info->A_ELEM->A_ELEM ) ) {
          if ( n->Smark ) {
            n->Dmark = TRUE;

            nn = NodeAlloc( ++maxint, IFPSMemFlush );

            e = n->exp;

Start:
            for ( ln = NULL; e != NULL; e = e->esucc ) {
              if ( ln == NULL )
                ln = e->dst;
              else if ( ln->label < e->dst->label )
                ln = e->dst;
              }

           if ( ln == NULL )
             Error2( "DistributeSharedArrays", "LinkNode SEARCH FAILED!!!\n" );

           if ( ln->type == IFShiftBuffer ) {
             e = ln->exp;
             goto Start;
             }

           LinkNode( ln, nn );

           e = EdgeAlloc( n, n->exp->eport, nn, 1 );
           e->info = n->exp->info;
           e->sr = n->exp->sr;
           LinkExport( n, e );
           LinkImport( nn, e );

           if ( n->type == IFMemAllocDVI )
             dnpsm++;
           else
             dpsm++;
         } else {
           if ( n->type == IFMemAllocDVI )
             npsm++;
           else
             psm++;
           }
         }

       break;

     default:
       break;
     }
   }
}


/**************************************************************************/
/* GLOBAL **************     If2DataPartition1     ************************/
/**************************************************************************/
/* PURPOSE: DISTRIBUTE THE SHARED ARRAYS (int,int,..,block).              */
/**************************************************************************/

void If2DataPartition1()
{  
  register PNODE f;

  for ( f = glstop->gsucc; f != NULL; f = f->gsucc )
    if ( f->type == IFLPGraph )
      DistributeSharedArrays( f );
}


static int IsReadInLoop( g, iport )
PNODE g;
int   iport;
{
  register PEDGE e;

  for ( e = g->exp; e != NULL; e = e->esucc ) {
    if ( e->eport != iport ) 
      continue;

    switch ( e->dst->type ) {
      case IFLoopA:
      case IFLoopB:
      case IFForall:
        return( TRUE );

      case IFSelect:
        if ( IsReadInLoop( e->dst->S_ALT, e->iport ) )
          return( TRUE );

        if ( IsReadInLoop( e->dst->S_CONS, e->iport ) )
          return( TRUE );

        break;

      default:
        break;
      }
    }

  return( FALSE );
}


int IsPrefetch( i, f )
PEDGE i;
PNODE f;
{
  register PEDGE e;
  register PEDGE ee;

  if ( IsConst( i ) )
    return( FALSE );

  if ( i->src->type != IFGetArrayBase ) 
    return( FALSE );

  if ( !IsPointer( i->info ) )
    return( FALSE );

  if ( i->info->type == IF_PTR )
    return( FALSE );

  for ( ee = i->src->exp; ee != NULL; ee = ee->esucc )
    if ( ee->dst == f && ee != i )
      break;

  if ( ee != NULL )
    return( FALSE );

  if ( IsReadInLoop( f->F_BODY, i->iport ) ) {
    pfcnt++;
    return( TRUE );
    }

  return( FALSE );
}


void PrintPrePrefetch( indent, n )
int   indent;
PNODE n;
{
  fprintf( output, "PrePrefetch( " );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );

  switch ( n->exp->info->type ) {
    case IF_PTR_DOUBLE:
      fprintf( output, ", double );\n" );
      break;

    case IF_PTR_REAL:
      fprintf( output, ", float );\n" );
      break;

    case IF_PTR_INTEGER:
      fprintf( output, ", int );\n" );
      break;

    default:
      Error2( "PrintPrePrefetch", "ILLEGAL POINTER TYPE" );
    }
}

void PrintPrefetch( indent, n )
int   indent;
PNODE n;
{
  fprintf( output, "Prefetch( " );
  PrintTemp( n->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );

  switch ( n->imp->info->type ) {
    case IF_PTR_DOUBLE:
      fprintf( output, ", double );\n" );
      break;

    case IF_PTR_REAL:
      fprintf( output, ", float );\n" );
      break;

    case IF_PTR_INTEGER:
      fprintf( output, ", int );\n" );
      break;

    default:
      Error2( "PrintPrefetch", "ILLEGAL POINTER TYPE" );
    }
}

void PrintFreePrefetch( indent, n )
int   indent;
PNODE n;
{
  fprintf( output, "FreePrefetch( " );
  PrintTemp( n->imp );
  fprintf( output, ", " );
  PrintTemp( n->imp->isucc );

  switch ( n->imp->isucc->info->type ) {
    case IF_PTR_DOUBLE:
      fprintf( output, ", double );\n" );
      break;

    case IF_PTR_REAL:
      fprintf( output, ", float );\n" );
      break;

    case IF_PTR_INTEGER:
      fprintf( output, ", int );\n" );
      break;

    default:
      Error2( "PrintFreefetch", "ILLEGAL POINTER TYPE" );
    }
}
