#define IFForall           0           /* IF1 NODE TYPES --- COMPOUND         */
#define IFSelect           1
#define IFTagCase          2
#define IFLoopA            3
#define IFLoopB            4
#define IFIfThenElse       5           /* IF1 Version 1.1                     */
#define IFIterate          6           /* IF1 Version 1.1                     */

#define IFAAddH            100         /* IF1 NODE TYPES --- SIMPLE           */
#define IFAAddL            101
#define IFAAdjust          102
#define IFABuild           103
#define IFACatenate        104
#define IFAElement         105
#define IFAFill            106
#define IFAGather          107
#define IFAIsEmpty         108
#define IFALimH            109
#define IFALimL            110
#define IFARemH            111
#define IFARemL            112
#define IFAReplace         113
#define IFAScatter         114
#define IFASetL            115
#define IFASize            116
#define IFAbs              117
#define IFBindArguments    118
#define IFBool             119
#define IFCall             120
#define IFChar             121
#define IFDiv              122
#define IFDouble           123
#define IFEqual            124
#define IFExp              125
#define IFFirstValue       126
#define IFFinalValue       127
#define IFFloor            128
#define IFInt              129
#define IFIsError          130
#define IFLess             131
#define IFLessEqual        132
#define IFMax              133
#define IFMin              134
#define IFMinus            135
#define IFMod              136
#define IFNeg              137
#define IFNoOp             138
#define IFNot              139
#define IFNotEqual         140
#define IFPlus             141
#define IFRangeGenerate    142
#define IFRBuild           143
#define IFRElements        144
#define IFRReplace         145
#define IFRedLeft          146
#define IFRedRight         147
#define IFRedTree          148
#define IFReduce           149
#define IFRestValues       150
#define IFSingle           151
#define IFTimes            152
#define IFTrunc            153
#define IFReplaceMulti     160         /* IF1 Version 1.1                     */

#define IFAAddLAT              170         /* IF2 Version 1.1                 */
#define IFAAddHAT              171
#define IFABufPartition        172
#define IFABuildAT             173
#define IFABufScatter          174
#define IFACatenateAT          175
#define IFAElementAT           176
#define IFAExtractAT           177
#define IFAFillAT              178
#define IFAGatherAT            179
#define IFARemHAT              180
#define IFARemLAT              181
#define IFAReplaceAT           182
#define IFArrayToBuf           183
#define IFASetLAT              184
#define IFDefArrayBuf          185
#define IFDefRecordBuf         186
#define IFFinalValueAT         187
#define IFMemAlloc             188
#define IFBufElements          189
#define IFRBuildAT             190
#define IFRecordToBuf          191
#define IFRElementsAT          192
#define IFReduceAT             193
#define IFShiftBuffer          194

#define IFScatterBufPartitions 195        /* NEW AT-NODES NOT IN IF2 MANUAL  */
#define IFRedLeftAT            196
#define IFRedRightAT           197
#define IFRedTreeAT            198

#define RESERVED_NUMBER        199        /* DO NOT USE THIS NUMBER          */
#define IFLoopPoolEnq          200
#define IFReadyListEnq         201
#define IFAssign               202
#define IFGetArrayBase         203
#define IFOptAElement          204
#define IFDiv2                 205
#define IFUTagTest             206
#define IFUBuild               207
#define IFUGetTag              208
#define IFUElement             209

#define IFOptLoopPoolEnq       210
#define IFBuildSlices          211

#define IFAIndexMinus          220
#define IFAIndexPlus           221

#define IFFirstSum             222
#define IFFirstMin             223
#define IFFirstMax             224
#define IFTri                  225
#define IFFirstAbsMin          226
#define IFFirstAbsMax          227

#define IFAStore               250    /* YANKED RETURN NODES (NONSTANDARD)    */
#define IFLeast                251
#define IFGreatest             252
#define IFProduct              253
#define IFSum                  254
#define IFGreat                260
#define IFGreatEqual           261

#define IFBRBuild              262
#define IFBRElements           263
#define IFBRReplace            264

#define IFError                265

#define IFSaveCallParam        266
#define IFSaveSliceParam       267
#define IFBuildLoopSlices      268

#define IFOptAReplace          269

#define IFMemAllocDVI          299
#define IFMemAllocDV           300
#define IFAAddHATDVI           301
#define IFAAddHATDV            302
#define IFAAddLATDVI           303
#define IFAAddLATDV            304
#define IFACatenateATDVI       305
#define IFACatenateATDV        306
#define IFABuildATDVI          307
#define IFABuildATDV           308
#define IFReduceATDVI          309
#define IFReduceATDV           310
#define IFAGatherATDVI         311
#define IFAGatherATDV          312
#define IFOptNoOp              313
#define IFPeek                 314
#define IFRagged               315

#define IFPSAllocCond          316
#define IFPSAllocOne           317
#define IFPSAllocTwo           318
#define IFPSAllocSpare1        319
#define IFPSAllocSpare2        320

#define IFPSFreeOne            321
#define IFPSFreeTwo            322
#define IFPSFreeSpare1         323
#define IFPSFreeSpare2         324

#define IFPSManager            325
#define IFPSManagerSwap        326

#define IFPSScatter            327
#define IFPSMemAllocDVI        328
#define IFPSMemFlush           329
#define IFPrePrefetch          330
#define IFPrefetch             331
#define IFFreePrefetch         332

#define IFSGraph               1000    /* IF1 GRAPH NODE TYPES (NONSTANDARD)  */
#define IFLGraph               1001
#define IFIGraph               1002
#define IFXGraph               1003
#define IFLPGraph              1004
#define IFRLGraph              1005

#define IFUndefined            9999

#define IF1SimpleNodes         55                              /* NODE COUNTS */
#define IF1CompoundNodes       7
#define IF1GraphNodes          4
#define IF2AtNodes             29

#define IsAtNode(x)    ( ((x)->type >= IFAAddLAT) &&                        \
			 ((x)->type <= IFDiv2) )

#define IsGetArrayBase(x) ( (x)->type == IFGetArrayBase )

#define IsAssign(x)    ( (x)->type == IFAssign )
#define IsAAddHAT(x)   ( (x)->type == IFAAddHAT )
#define IsUndefined(x) ( (x)->type == IFUndefined )
#define IsSimple(x)    ( ((x)->type >= IFAAddH)   && ((x)->type < IFAAddLAT) )

#define IsAReplace(x)  ( ((x)->type == IFAReplace) ||                       \
			 ((x)->type == IFOptAReplace) )

#define IsABuildAT(x)  ( (x)->type == IFABuildAT )
#define IsAFillAT(x)   ( (x)->type == IFAFillAT  )
#define IsAAddHAT(x)   ( (x)->type == IFAAddHAT )
#define IsGraph(x)     ( ((x)->type >= IFSGraph) && ((x)->type <= IFRLGraph) )
#define IsIGraph(x)    ( (x)->type == IFIGraph )
#define IsLGraph(x)    ( (x)->type == IFLGraph )
#define IsSGraph(x)    ( (x)->type == IFSGraph )
#define IsXGraph(x)    ( (x)->type == IFXGraph )
#define IsLPGraph(x)   ( (x)->type == IFLPGraph )
#define IsSelect(x)    ( (x)->type == IFSelect )
#define IsCompound(x)  ( (x)->type <  IFAAddH  )
#define IsNoOp(x)      ( (x)->type == IFNoOp )

#define IsMemAlloc(x)  ( (x)->type == IFMemAlloc )

#define IsAlloc(x)     ( (x)->type == IFMemAlloc   || \
			 (x)->type == IFMemAllocDV || \
			 (x)->type == IFMemAllocDVI )

#define IsForall(x)    ( (x)->type == IFForall )
#define IsPlus(x)      ( (x)->type == IFPlus   )
#define IsMax(x)       ( (x)->type == IFMax    )
#define IsLoopA(x)     ( (x)->type == IFLoopA  )
#define IsLoopB(x)     ( (x)->type == IFLoopB  )
#define IsALimL(x)     ( (x)->type == IFALimL  )
#define IsABuild(x)    ( (x)->type == IFABuild )
#define IsNot(x)       ( (x)->type == IFNot  )
#define IsCall(x)      ( (x)->type == IFCall )
#define IsMinus(x)     ( (x)->type == IFMinus )
#define IsNeg(x)       ( (x)->type == IFNeg )
#define IsASize(x)     ( (x)->type == IFASize )
#define IsASetL(x)     ( (x)->type == IFASetL )
#define IsAGather(x)   ( (x)->type == IFAGather )
#define IsAScatter(x)  ( (x)->type == IFAScatter )
#define IsAElement(x)  ( (x)->type == IFAElement )
#define IsRElements(x) ( (x)->type == IFRElements )
#define IsTagCase(x)   ( (x)->type == IFTagCase )
#define IsRBuild(x)    ( (x)->type == IFRBuild )
#define IsLoop(x)      ( ((x)->type == IFLoopA) || ((x)->type == IFLoopB) )

#define IsRangeGenerate(x)        ( (x)->type == IFRangeGenerate )
#define IsFinalValue(x)           ( (x)->type == IFFinalValue  )
#define IsFinalValueAT(x)         ( (x)->type == IFFinalValueAT)
#define IsDefArrayBuf(x)          ( (x)->type == IFDefArrayBuf )
#define IsScatterBufPartitions(x) ( (x)->type == IFScatterBufPartitions )
#define IsOptAElement(x)          ( (x)->type == IFOptAElement )

#define REDUCE_SUM        'S'      /* FIRST CHARACTER OF REDUCTION FUNCTIONS  */
#define REDUCE_PRODUCT    'P'
#define REDUCE_LEAST      'L'
#define REDUCE_GREATEST   'G'
#define REDUCE_CATENATE   'C'

#define IF_ARRAY          0            /* IF SYMBOL TABLE TYPES               */
#define IF_BASIC          1
#define IF_FIELD          2
#define IF_FUNCTION       3
#define IF_MULTPLE        4
#define IF_RECORD         5
#define IF_STREAM         6
#define IF_TAG            7
#define IF_TUPLE          8
#define IF_UNION          9
#define IF_UNKNOWN        10
#define IF_BUFFER         11

#define BASIC_TYPE_START  12
#define IF_BOOL           0 + BASIC_TYPE_START
#define IF_CHAR           1 + BASIC_TYPE_START
#define IF_DOUBLE         2 + BASIC_TYPE_START
#define IF_INTEGER        3 + BASIC_TYPE_START
#define IF_NULL           4 + BASIC_TYPE_START
#define IF_REAL           5 + BASIC_TYPE_START
#define IF_NONTYPE        6 + BASIC_TYPE_START

#define IF_BRECORD        7 + BASIC_TYPE_START

#define IF_PTR_DOUBLE     8  + BASIC_TYPE_START         /* FOR GetArrayBase */
#define IF_PTR_INTEGER    9  + BASIC_TYPE_START
#define IF_PTR_REAL       10 + BASIC_TYPE_START
#define IF_PTR            11 + BASIC_TYPE_START

#define TYPE_STOP         IF_PTR

#define IsBasic(x)          ( (x)->type >= BASIC_TYPE_START )

#define IsPointer(x)        ( (x)->type >= IF_PTR_DOUBLE &&  \
                              (x)->type <= IF_PTR )

#define IsBRecord(x)        ( (x)->type == IF_BRECORD )

#define IsChar(x)           ( (x)->type == IF_CHAR )
#define IsFunction(x)       ( (x)->type == IF_FUNCTION )
#define IsRecord(x)         ( (x)->type == IF_RECORD )
#define IsUnion(x)          ( (x)->type == IF_UNION )
#define IsMultiple(x)       ( (x)->type == IF_MULTPLE )
#define IsBoolean(x)        ( (x)->type == IF_BOOL  )

#define IsArray(x)          ( (x)->type == IF_ARRAY )

#define IsArrayBase(x)      ( ((x)->type >= IF_PTR_DOUBLE) && \
			      ((x)->type <= IF_PTR)         )

#define IsBuffer(x)         ( (x)->type == IF_BUFFER )
#define IsInteger(x)        ( (x)->type == IF_INTEGER )

#define IsArithmetic(x)     ( (x)->type == IF_INTEGER || \
			      (x)->type == IF_REAL    || \
			      (x)->type == IF_DOUBLE  )  

#define IsArithmeticPtr(x)  ( (x)->type == IF_PTR_INTEGER || \
                              (x)->type == IF_PTR_DOUBLE  || \
			      (x)->type == IF_PTR_REAL    )

#define IsReal(x)           ( (x)->type == IF_REAL    )
#define IsDouble(x)         ( (x)->type == IF_DOUBLE  )

#define ERROR_CONSTANT    "error"
#define GRAPH_LABEL       0
#define CONST_PORT        -1

#define FOR_C             0
#define FOR_FORTRAN       1
#define FOR_SISAL         2

#define DFORDERED         'D'          /* LLNL STAMPS                         */
#define IF1CHECK          'C'
#define FRONTEND          'F'
#define OFFSETS           'O'
#define LOOPINVARS        'L'
#define COMMONSUBS        'C'
#define CONSTANT          'G'
#define PDBASE            'V'
#define MDBASE            'W'
#define PNODBASE          'X'
#define MNODBASE          'Y'


#define IF1OPTIMIZED      'I'          /* CSU STAMPS                          */
#define MONOLITH          'M'
#define NORMALIZED        'N'
#define BUILDINPLACE      'B'
#define UPDATEINPLACE     'U'
#define UNIVSTROWNER      'S'
#define OPTPARTITIONED    'Z'
#define QMODE             'Q'


#define NOMARK             0                         /* THE MARK IS DISABLED  */
#define RMARK              1                         /* THE R MARK IS ENABLED */
#define rMARK              2                         /* THE r MARK IS ENABLED */

#define PRAGMAS unsigned pmark   : 1;  /* %mk=PRrODLMCNBWF */                 \
                unsigned rmark1  : 2;                                         \
		unsigned omark1  : 1;                                         \
		unsigned rmark2  : 2;                                         \
		unsigned omark2  : 1;                                         \
		unsigned dmark   : 1;                                         \
		unsigned lmark   : 1;                                         \
		unsigned emark   : 1;                                         \
		unsigned cmark   : 1;                                         \
		unsigned nmark   : 1;                                         \
		unsigned umark   : 1;                                         \
		unsigned bmark   : 1;                                         \
		unsigned time    : 1;                                         \
		unsigned flp     : 1;                                         \
		unsigned wmark   : 1;                                         \
		unsigned smark   : 1;                                         \
		unsigned Smark   : 1;                                         \
		unsigned Dmark   : 1;                                         \
		unsigned vmark   : 1;                                         \
		unsigned fmark   : 1;                                         \
		unsigned Pmark   : 1;                                         \
		unsigned Cmark   : 1;                                         \
		unsigned xmark   : 1;                                         \
                                                                              \
		unsigned rstable : 1;  /* ARE THE R AND O MARKS STABLE?   */  \
		unsigned ostable : 1;                                         \
                                                                              \
		short    sr;           /* PRODUCER REFERENCE COUNT VALUES */  \
		short    pm;                                                  \
		short    pl;                                                  \
                                                                              \
		short    cm;           /* CONSUMER REFERENCE COUNT VALUE  */  \
                                                                              \
		double   ccost;        /* CALCULATED EXECUTION COST       */  \
		char     mark;         /* FUNCTION DOMAIN TYPE            */  \
                                                                              \
		char     *name;        /* %na=source_data_name            */  \
		char     *file;        /* %fn=source_file_name            */  \
		char     *funct;       /* %sf=source_function_name        */  \
		int       line         /* %sl=source_line_number          */

#define InitPragmas(x)   (x)->pmark   = FALSE;     (x)->rmark1  = NOMARK;     \
                         (x)->Pmark   = FALSE;     (x)->Cmark   = FALSE;      \
                         (x)->xmark   = FALSE;     (x)->mark    = ' ';        \
                         (x)->omark1  = FALSE;     (x)->rmark2  = NOMARK;     \
                         (x)->omark2  = FALSE;     (x)->dmark   = FALSE;      \
                         (x)->lmark   = FALSE;     (x)->emark   = FALSE;      \
                         (x)->cmark   = FALSE;     (x)->nmark   = FALSE;      \
                         (x)->umark   = FALSE;                                \
                         (x)->bmark   = FALSE;     (x)->rstable = TRUE;       \
			 (x)->time    = FALSE;                                \
			 (x)->flp     = FALSE;                                \
                         (x)->ostable = TRUE;      (x)->wmark   = FALSE;      \
                         (x)->name    = NULL;      (x)->file    = NULL;       \
                         (x)->funct   = NULL;      (x)->line    = 0;          \
			 (x)->sr      = 0;         (x)->pm      = 0;          \
			 (x)->pl      = 0;         (x)->cm      = 0;          \
			 (x)->vmark   = FALSE;     (x)->fmark   = FALSE;      \
			 (x)->Smark   = FALSE;                                \
			 (x)->Dmark   = FALSE;                                \
			 (x)->smark   = FALSE;     (x)->ccost   = 0.0

#define AssignPragmas(x) (x)->pmark   = pragmas.pmark;                        \
                         (x)->rmark1  = pragmas.rmark1;                       \
                         (x)->omark1  = pragmas.omark1;                       \
                         (x)->rmark2  = pragmas.rmark2;                       \
                         (x)->omark2  = pragmas.omark2;                       \
                         (x)->dmark   = pragmas.dmark;                        \
                         (x)->mark    = pragmas.mark;                         \
                         (x)->lmark   = pragmas.lmark;                        \
                         (x)->Pmark   = pragmas.Pmark;                        \
                         (x)->Cmark   = pragmas.Cmark;                        \
                         (x)->xmark   = pragmas.xmark;                        \
                         (x)->emark   = pragmas.emark;                        \
                         (x)->cmark   = pragmas.cmark;                        \
                         (x)->nmark   = pragmas.nmark;                        \
                         (x)->umark   = pragmas.umark;                        \
                         (x)->bmark   = pragmas.bmark;                        \
                         (x)->flp     = pragmas.flp;                          \
			 (x)->wmark   = pragmas.wmark;                        \
                         (x)->rstable = pragmas.rstable;                      \
                         (x)->ostable = pragmas.ostable;                      \
                         (x)->name    = pragmas.name;                         \
                         (x)->line    = pragmas.line;                         \
			 (x)->sr      = pragmas.sr;                           \
			 (x)->pm      = pragmas.pm;                           \
			 (x)->pl      = pragmas.pl;                           \
			 (x)->cm      = pragmas.cm;                           \
			 (x)->vmark   = pragmas.vmark;                        \
			 (x)->fmark   = pragmas.fmark;                        \
			 (x)->smark   = pragmas.smark;                        \
			 (x)->Smark   = pragmas.Smark;                        \
			 (x)->Dmark   = pragmas.Dmark;                        \
			 (x)->ccost   = pragmas.ccost;                        \
			 if ( pragmas.file != NULL )                          \
			     (x)->file = pragmas.file;                        \
			 else                                                 \
			     (x)->file = sfile;                               \
			 if ( pragmas.funct != NULL )                         \
			     (x)->funct = pragmas.funct;                      \
			 else if ( cfunct == NULL )                           \
			     (x)->funct = "?";                                \
                         else                                                 \
			     (x)->funct = cfunct->G_NAME

#define CopyPragmas(y,x) (x)->pmark   = (y)->pmark;                           \
                         (x)->rmark1  = (y)->rmark1;                          \
                         (x)->Pmark   = (y)->Pmark;                           \
                         (x)->Cmark   = (y)->Cmark;                           \
                         (x)->xmark   = (y)->xmark;                           \
                         (x)->omark1  = (y)->omark1;                          \
                         (x)->rmark2  = (y)->rmark2;                          \
                         (x)->omark2  = (y)->omark2;                          \
                         (x)->dmark   = (y)->dmark;                           \
                         (x)->mark    = (y)->mark;                            \
                         (x)->lmark   = (y)->lmark;                           \
                         (x)->emark   = (y)->emark;                           \
                         (x)->cmark   = (y)->cmark;                           \
                         (x)->nmark   = (y)->nmark;                           \
                         (x)->umark   = (y)->umark;                           \
                         (x)->bmark   = (y)->bmark;                           \
                         (x)->time    = (y)->time;                            \
                         (x)->flp     = (y)->flp ;                            \
			 (x)->wmark   = (y)->wmark;                           \
                         (x)->rstable = (y)->rstable;                         \
                         (x)->ostable = (y)->ostable;                         \
                         (x)->vmark   = (y)->vmark;                           \
                         (x)->fmark   = (y)->fmark;                           \
                         (x)->smark   = (y)->smark;                           \
                         (x)->Smark   = (y)->Smark;                           \
                         (x)->Dmark   = (y)->Dmark;                           \
			 (x)->sr      = (y)->sr;                              \
			 (x)->pm      = (y)->pm;                              \
			 (x)->pl      = (y)->pl;                              \
			 (x)->cm      = (y)->cm;                              \
                         (x)->name    = (y)->name;                            \
                         (x)->file    = (y)->file;                            \
                         (x)->funct   = (y)->funct;                           \
                         (x)->ccost   = (y)->ccost;                           \
                         (x)->line    = (y)->line



typedef struct node       NODE,  *PNODE, **PPNODE;
typedef struct edge       EDGE,  *PEDGE;
typedef struct info       INFO,  *PINFO;
typedef struct temp       TEMP,  *PTEMP;
typedef struct alist      ALIST, *PALIST;
typedef struct prags      PRAGS;

struct prags {
    PRAGMAS;
    };

#define UNKNOWN         0                      /* TEMPORARY STORAGE STATUSES */
#define ALLOCATED       1
#define FREE            2

#define NONE            0                      /* TYPE MODIFIERS              */
#define GLOB            1
#define FPTR            2

struct temp {
    char *name;                                 /* NAME OF TEMPORARY          */
    char  status;                               /* ALLOCATION STATUS          */
    char  mod;                                  /* TYPE MODIFIER              */
    char  DeAl;                                 /* DEALLOC THIS ITEM?         */
    short fld;                                  /* STRUCTURE FIELD IDENTIFIER */
    PTEMP next;                                 /* NEXT TEMPORARY             */
    PINFO info;                                 /* TYPE INFO FOR TEMPORARY    */
    int   pop;                                  /* TOTAL USERS                */
    double ccost;                               /* EXECUTION COST OF SCOPE    */
    int   dist;
    int    fid;                                 /* GLOBAL FRAME IDENTIFIER    */
    };

#define AppendToUtilityList( h, t, n )  if ( (h) == NULL ) (h) = (n);      \
                                        else (t)->usucc = (n); (t) = (n)

struct node {
    int    if1line;                    /* LINE NUMBER OF NODE IN IF1 FILE     */

    int    type;                       /* IF NODE TYPE                        */
    int    label;                      /* UNIQUE (IN SCOPE) NODE IDENTIFIER   */

    PEDGE  exp;                        /* EXPORTED (GENERATED) VALUES         */
    PEDGE  imp;                        /* IMPORTED (ARGUMENT)  VALUES         */

    PNODE  gpred;                      /* DOUBLE LINK LIST POINTERS (2 SETS)  */
    PNODE  gsucc;                      /* n FOR NODE LIST, g FOR GRAPH LIST   */
    PNODE  npred;
    PNODE  nsucc;

    PNODE  usucc;                      /* UTILITY NODE LIST NODE SUCCESSOR    */
    PNODE  next;                       /* DATA DISTRIBUTION CALL NODE LIST    */

    PRAGMAS;

    PINFO   info;                      /* UTILITY FIELDS                      */
    char   *gname;
    PALIST  alst;
    int    *flps;
    int     scnt;
    int     sdbx;                      

    PTEMP   temp;                      /* TEMPORARY STORAGE                   */
    };

#define G_DAD   npred                  /* POINTER FROM SUBGRPAPH TO CMP NODE  */
#define G_NODES nsucc                  /* NODES OF GRAPH                      */
#define G_INFO  info                   /* FUNCTION GRAPH ARGUMENT TYPE INFO   */
#define G_NAME  gname                  /* FUNCTION GRAPH NAME                 */
#define G_TAGS  alst                   /* SUBGRAPH TAG LIST                   */

#define C_SUBS  gsucc                  /* SUBGRAPHS OF COMPOUND NODE          */
#define C_SCNT  scnt                   /* # OF SUBGRAPHS IN COMPOUND NODE     */
#define C_ALST  alst                   /* ASSOCIATION LIST OF COMPOUND NODE   */

#define L_INIT  gsucc     /* LOOPA AND LOOPB SUBGRAPH POSITIONS IN GRAPH LIST */
#define L_TEST  gsucc->gsucc                
#define L_BODY  gsucc->gsucc->gsucc         
#define L_RET   gsucc->gsucc->gsucc->gsucc  

#define F_GEN   gsucc              /* FORALL SUBGRAPH POSITIONS IN GRAPH LIST */
#define F_BODY  gsucc->gsucc
#define F_RET   gsucc->gsucc->gsucc

#define S_TEST  gsucc              /* SELECT SUBGRAPH POSITIONS IN GRAPH LIST */
#define S_ALT   gsucc->gsucc
#define S_CONS  gsucc->gsucc->gsucc


struct edge {
    int    if1line;                    /* LINE NUMBER OF EDGE IN IF1 FILE     */

    int   iport;                       /* IMPORT PORT IDENTIFIER              */
    int   eport;                       /* EXPORT PORT IDENTIFIER              */

    PNODE dst;                         /* DESTINATION NODE                    */
    PNODE src;                         /* SOURCE NODE                         */

    PRAGMAS;

    PEDGE ipred;                       /* IMPORT PREDECESSOR                  */
    PEDGE isucc;                       /* IMPORT SUCCESSOR                    */
    PEDGE epred;                       /* EXPORT PREDECESSOR                  */
    PEDGE esucc;                       /* EXPORT SUCCESSOR                    */

    char  *CoNsT;                      /* CONSTANT STRING (IF SRC IS NULL)    */
    PINFO  info;                       /* DATA VALUE TYPE                     */

    PTEMP  temp;                       /* TEMPORARY STORAGE                   */

    int    rc;                         /* REFERENCE COUNT                     */

    int    vtemp;                      /* VECTOR TEMPORARY NAME               */

    int    sdbx;                      
    };


struct info {
    int    if1line;                    /* LINE NUMBER OF INFO IN IF1 FILE     */

    int   type;                        /* IF SYMBOL TABLE TYPE                */
    int   label;                       /* UNIQUE SYMBOL IDENTIFIER            */

    unsigned  touch1 : 1;              /* UTILITY FLAGS                       */
    unsigned  touch2 : 1;
    unsigned  touch3 : 1;
    unsigned  touch4 : 1;              /*  *** INTERFACE READ-WRITE ROUTINES  */
    unsigned  touch5 : 1;
    unsigned  touch6 : 1;

    PRAGMAS;

    PINFO info1;                       /* UTILITY POINTERS                    */
    PINFO info2;

    PINFO next;                        /* NEXT TYPE IN SYMBOL TABLE           */

    int    eid;                        /* EQUIVALENCE CLASS IDENTIFIER        */
    PINFO  mnext;                      /* NEXT MEMBER OF EQUIVALENCE CLASS    */
    PINFO  fmem;                       /* FIRST MEMBER OF EQUIVALENCE CLASS   */

    char *tname;                       /* TYPE DECLARATION NAME               */
    char *sname;                       /* STRUCTURE NAME                      */
    char *rname;                       /* READ ROUTINE NAME                   */
    char *wname;                       /* WRITE ROUTINE NAME                  */
    char *fname1;                      /* FIRST FREE STORAGE ROUTINE          */
    char *fname2;                      /* SECOND FREE STORAGE ROUTINE         */
    char *cname;                       /* UNIQUE PART OF COPY ROUTINE NAME    */
    };

#define A_ELEM      info1              /* ARRAY-STREAM-MULTIPLE SUBCOMPONENT  */
#define R_FIRST     info1              /* FIRST RECORD-UNION MEMBER           */
#define F_IN        info1              /* FUNCTION IMPORT TYPES               */
#define F_OUT       info2              /* FUNCTION EXPORT TYPES               */
#define L_NEXT      info2              /* NEXT LIST ENTRY                     */
#define L_SUB       info1              /* LIST COMPONENT TYPE                 */


struct alist {
    int    datum;                      /* INTEGER LIST DATUM                  */
    PALIST next;                       /* NEXT DATUM                          */
    };


#define IsNodeListEmpty(x) ( (x)->G_NODES == NULL )
#define IsOneExport(x)     ( (x)->exp->esucc == NULL )

#define IsImport(x,y)      ( FindImport((x),(y)) != NULL )
#define IsExport(x,y)      ( FindExport((x),(y)) != NULL )

#define IsConst(x)         ( ((x)->src == NULL) && ((x)->eport == CONST_PORT) )
#define IsNonErrorConst(x) ( IsConst(x) && ((x)->CoNsT != NULL) )

#define Max(a,b)           (((a) > (b)) ? (a) : (b))

#define MAX_PORT_NUMBER          100000 /* FOR ARRAY IMPROVEMENTS             */

#define MAX_DOTS                 2      /* ALSO DEFINED IN world.h OF If2part */
                                        /* AND process.h OF Runtime           */

#define IsEntry(x)         (x->mark == 'f' || x->mark == 'c' || x->mark == 'e')

#define ARITHMETICS  0                                   /* FLOP COUNT MACROS */
#define LOGICALS     1
#define INTRINSICS   2
