#define IFForall           0           /* IF1 NODE TYPES --- COMPOUND         */
#define IFSelect           1
#define IFTagCase          2
#define IFLoopA            3
#define IFLoopB            4
#define IFIfThenElse       5           /* IF1 Version 1.1                     */
#define IFIterate          6           /* IF1 Version 1.1                     */

#define IFAAddH            100         /* IF1 NODE TYPES --- SIMPLE           */
#define IFAAddL            101
#define IFAAdjust          102
#define IFABuild           103
#define IFACatenate        104
#define IFAElement         105
#define IFAFill            106
#define IFAGather          107
#define IFAIsEmpty         108
#define IFALimH            109
#define IFALimL            110
#define IFARemH            111
#define IFARemL            112
#define IFAReplace         113
#define IFAScatter         114
#define IFASetL            115
#define IFASize            116
#define IFAbs              117
#define IFBindArguments    118
#define IFBool             119
#define IFCall             120
#define IFChar             121
#define IFDiv              122
#define IFDouble           123
#define IFEqual            124
#define IFExp              125
#define IFFirstValue       126
#define IFFinalValue       127
#define IFFloor            128
#define IFInt              129
#define IFIsError          130
#define IFLess             131
#define IFLessEqual        132
#define IFMax              133
#define IFMin              134
#define IFMinus            135
#define IFMod              136
#define IFNeg              137
#define IFNoOp             138
#define IFNot              139
#define IFNotEqual         140
#define IFPlus             141
#define IFRangeGenerate    142
#define IFRBuild           143
#define IFRElements        144
#define IFRReplace         145
#define IFRedLeft          146
#define IFRedRight         147
#define IFRedTree          148
#define IFReduce           149
#define IFRestValues       150
#define IFSingle           151
#define IFTimes            152
#define IFTrunc            153
#define IFPrefixSize       154
#define IFError            155         /* IF1 Version 1.MY_DEFINITION         */
#define IFReplaceMulti     156         /* IF1 Version 1.1                     */

#define IF1SimpleNodes     57
#define IF1CompoundNodes   7

#define IFAElementN        200
#define IFAElementP        201
#define IFAElementM        202

#define IFPeek             314

#define IFSGraph           1000        /* IF1 GRAPH NODE TYPES (NONSTANDARD)  */
#define IFLGraph           1001
#define IFIGraph           1002
#define IFXGraph           1003

#define IFUndefined        9999

#define IF1GraphNodes      4

#define IsUndefined(x) ( (x)->type == IFUndefined )

#define IsOther(x)     ( (x)->type >= IFPeek && (x)->type <= IFPeek )
#define IsSimple(x)    ( (((x)->type >= IFAAddH) && ((x)->type <= IFError)) || \
			  ((x)->type == IFPeek) )

#define IsGraph(x)     ( ((x)->type >= IFSGraph) && ((x)->type <= IFXGraph) )
#define IsIGraph(x)    ( (x)->type == IFIGraph )
#define IsSGraph(x)    ( (x)->type == IFSGraph )
#define IsXGraph(x)    ( (x)->type == IFXGraph )
#define IsSelect(x)    ( (x)->type == IFSelect )
#define IsCompound(x)  ( (x)->type <= IFIterate )
#define IsError(x)     ( (x)->type == IFError )
#define IsForall(x)    ( (x)->type == IFForall )
#define IsAFill(x)     ( (x)->type == IFAFill  )
#define IsInt(x)       ( (x)->type == IFInt    )
#define IsExp(x)       ( (x)->type == IFExp   )
#define IsPlus(x)      ( (x)->type == IFPlus   )
#define IsMinus(x)     ( (x)->type == IFMinus  )
#define IsNeg(x)       ( (x)->type == IFNeg    )
#define IsLoopA(x)     ( (x)->type == IFLoopA  )
#define IsLoopB(x)     ( (x)->type == IFLoopB  )
#define IsALimL(x)     ( (x)->type == IFALimL  )
#define IsALimH(x)     ( (x)->type == IFALimH  )
#define IsNot(x)       ( (x)->type == IFNot    )
#define IsLess(x)      ( (x)->type == IFLess   )
#define IsLessEqual(x) ( (x)->type == IFLessEqual )
#define IsCall(x)      ( (x)->type == IFCall   )
#define IsPeek(x)      ( (x)->type == IFPeek   )
#define IsASetL(x)     ( (x)->type == IFASetL  )
#define IsGather(x)    ( (x)->type == IFAGather )
#define IsRElements(x) ( (x)->type == IFRElements )
#define IsAElement(x)  ( (x)->type == IFAElement )
#define IsAReplace(x)  ( (x)->type == IFAReplace )
#define IsAScatter(x)  ( (x)->type == IFAScatter )
#define IsTagCase(x)   ( (x)->type == IFTagCase )
#define IsLoop(x)      ( ((x)->type == IFLoopA) || ((x)->type == IFLoopB) )

#define IsGenerate(x)  ( ((x)->type == IFAScatter)     ||              \
			 ((x)->type == IFRangeGenerate) )

#define IsReduction(x) ( ((x)->type == IFReduce)     ||                \
			 ((x)->type == IFRedLeft)    ||                \
			 ((x)->type == IFRedRight)   ||                \
			 ((x)->type == IFRedTree)    )

#define IsReturn(x)    ( ((x)->type == IFAGather)    ||                \
			 ((x)->type == IFReduce)     ||                \
			 ((x)->type == IFRedLeft)    ||                \
			 ((x)->type == IFRedRight)   ||                \
			 ((x)->type == IFRedTree)    ||                \
			 ((x)->type == IFFirstValue) ||                \
			 ((x)->type == IFFinalValue) ||                \
			 ((x)->type == IFRestValues) )

#define REDUCE_SUM        'S'      /* FIRST CHARACTER OF REDUCTION FUNCTIONS  */
#define REDUCE_PRODUCT    'P'
#define REDUCE_LEAST      'L'
#define REDUCE_GREATEST   'G'
#define REDUCE_CATENATE   'C'

#define IF_ARRAY          0            /* IF SYMBOL TABLE TYPES               */
#define IF_BASIC          1
#define IF_FIELD          2
#define IF_FUNCTION       3
#define IF_MULTIPLE       4
#define IF_RECORD         5
#define IF_STREAM         6
#define IF_TAG            7
#define IF_TUPLE          8
#define IF_UNION          9
#define IF_UNKNOWN        10

#define BASIC_TYPE_START  11
#define IF_BOOL           0 + BASIC_TYPE_START
#define IF_CHAR           1 + BASIC_TYPE_START
#define IF_DOUBLE         2 + BASIC_TYPE_START
#define IF_INTEGER        3 + BASIC_TYPE_START
#define IF_NULL           4 + BASIC_TYPE_START
#define IF_REAL           5 + BASIC_TYPE_START
#define IF_NONTYPE        6 + BASIC_TYPE_START

#define IsBasic(x)          ( (x)->type >= BASIC_TYPE_START )
#define IsMultiple(x)       ( (x)->type == IF_MULTIPLE )
#define IsBoolean(x)        ( (x)->type == IF_BOOL  )
#define IsArray(x)          ( (x)->type == IF_ARRAY )
#define IsRecord(x)         ( (x)->type == IF_RECORD )
#define IsInteger(x)        ( (x)->type == IF_INTEGER )
#define IsReal(x)           ( (x)->type == IF_REAL    )
#define IsDouble(x)         ( (x)->type == IF_DOUBLE  )
#define IsStream(x)         ( (x)->type == IF_STREAM  )

#define IsArithmetic(x)     ( ((x)->type == IF_INTEGER) ||    \
			      ((x)->type == IF_DOUBLE)  ||    \
			      ((x)->type == IF_REAL)     )

#define ERROR_CONSTANT    "error"
#define GRAPH_LABEL       0
#define CONST_PORT        -1

#define DFORDERED         'D'          /* LLNL STAMPS                         */
#define IF1CHECK          'C'
#define FRONTEND          'F'
#define OFFSETS           'O'
#define LOOPINVARS        'L'
#define COMMONSUBS        'C'
#define CONSTANT          'G'

#define IF1OPTIMIZED      'I'          /* CSU STAMPS                          */
#define MONOLITH          'M'
#define NORMALIZED        'N'


#define PRAGMAS unsigned na : 1; /* PRAGMAS %na=name %sl=line  %mk=mark */ \
                unsigned sl : 1; /*         %sf=file %fn=funct          */ \
                unsigned mk : 1;                                           \
		unsigned sf : 1;                                           \
		unsigned fn : 1;                                           \
		unsigned print : 1;                                        \
                char    *name;                                             \
                int      line;                                             \
                char     mark;                                             \
		char    *file;                                             \
		char    *funct

#define AssignPragmas(x) (x)->na = pragmas.na; (x)->name  = pragmas.name;  \
			 (x)->sl = pragmas.sl; (x)->line  = pragmas.line;  \
			 (x)->mk = pragmas.mk; (x)->mark  = pragmas.mark;  \
			 (x)->sf = TRUE;                                   \
			 if ( pragmas.sf ) (x)->file = pragmas.file;       \
                         else              (x)->file = sfile;              \
			 (x)->fn = TRUE;                                   \
			 (x)->print = pragmas.print;                       \
			 if ( pragmas.fn ) (x)->funct = pragmas.funct;     \
                         else (x)->funct = (cfunct == NULL)? "" :          \
					    cfunct->G_NAME

#define InitPragmas(x)   (x)->na = FALSE;    (x)->name  = "";              \
			 (x)->mk = FALSE;    (x)->mark  = 'V';             \
			 (x)->fn = FALSE;    (x)->funct = "?()";           \
			 (x)->print = FALSE;                               \
			 (x)->sf = FALSE;    (x)->file  = "?.sis";         \
			 (x)->sl = FALSE;    (x)->line  = -1

#define CopyVitals(x,y)  (y)->sl = (x)->sl; (y)->line  = (x)->line;        \
			 (y)->fn = (x)->fn; (y)->funct = (x)->funct;       \
			 (y)->sf = (x)->sf; (y)->file  = (x)->file

#define CopyPragmas(x,y) (y)->na = (x)->na; (y)->name  = (x)->name;        \
			 (y)->sl = (x)->sl; (y)->line  = (x)->line;        \
			 (y)->mk = (x)->mk; (y)->mark  = (x)->mark;        \
			 (y)->print = (x)->print;                          \
			 (y)->sf = (x)->sf; (y)->file  = (x)->file;        \
			 (y)->fn = (x)->fn; (y)->funct = (x)->funct


typedef struct node       NODE,  *PNODE;
typedef struct edge       EDGE,  *PEDGE;
typedef struct info       INFO,  *PINFO;
typedef struct alist      ALIST, *PALIST;
typedef struct prags      PRAGS;
typedef struct dope       DOPE,  *PDOPE;

struct dope {
    PEDGE lo;                           /* EDGE DEFINING LOWER BOUND OF CORE */
    int   dec;                          /* NUMBER OF array_addl'S TO CORE    */
    PEDGE hi;                           /* EDGE DEFINING UPPER BOUND OF CORE */
    int   inc;                          /* NUMBER OF array_addh'S TO CORE    */
    };

struct prags {
    PRAGMAS;
    };

struct node {
    int    if1line;                    /* LINE NUMBER OF NODE IN IF1 FILE     */

    int    type;                       /* IF NODE TYPE                        */
    int    label;                      /* UNIQUE (IN SCOPE) NODE IDENTIFIER   */

    PEDGE  exp;                        /* EXPORTED (GENERATED) VALUES         */
    PEDGE  imp;                        /* INPORTED (ARGUMENT)  VALUES         */

    PNODE  copy;                       /* POINTS TO A COPY OF THIS NODE       */

    PNODE  gpred;                      /* DOUBLE LINK LIST POINTERS (2 SETS)  */
    PNODE  gsucc;                      /* n FOR NODE LIST, g FOR GRAPH LIST   */
    PNODE  npred;
    PNODE  nsucc;

    PNODE  usucc;                      /* UTILITY NODE LIST FIELD             */

    PRAGMAS;

    PINFO   info;
    char   *gname;
    PALIST  alst;
    int     scnt;
    int     size;
    };

#define G_DAD   npred                  /* POINTER FROM SUBGRPAPH TO CMP NODE  */
#define G_NODES nsucc                  /* NODES OF GRAPH                      */
#define G_INFO  info                   /* FUNCTION GRAPH ARGUMENT TYPE INFO   */
#define G_NAME  gname                  /* FUNCTION GRAPH NAME                 */
#define G_TAGS  alst                   /* SUBGRAPH TAG LIST                   */

#define C_SUBS  gsucc                  /* SUBGRAPHS OF COMPOUND NODE          */
#define C_SCNT  scnt                   /* # OF SUBGRAPHS IN COMPOUND NODE     */
#define C_ALST  alst                   /* ASSOCIATION LIST OF COMPOUND NODE   */

#define L_INIT  gsucc     /* LOOPA AND LOOPB SUBGRAPH POSITIONS IN GRAPH LIST */
#define L_TEST  gsucc->gsucc                
#define L_BODY  gsucc->gsucc->gsucc         
#define L_RET   gsucc->gsucc->gsucc->gsucc  

#define F_GEN   gsucc              /* FORALL SUBGRAPH POSITIONS IN GRAPH LIST */
#define F_BODY  gsucc->gsucc
#define F_RET   gsucc->gsucc->gsucc

#define S_TEST  gsucc              /* SELECT SUBGRAPH POSITIONS IN GRAPH LIST */
#define S_ALT   gsucc->gsucc
#define S_CONS  gsucc->gsucc->gsucc


struct edge {
    int    if1line;                    /* LINE NUMBER OF EDGE IN IF1 FILE     */

    int   iport;                       /* IMPORT PORT IDENTIFIER              */
    int   eport;                       /* EXPORT PORT IDENTIFIER              */

    PNODE dst;                         /* DESTINATION NODE                    */
    PNODE src;                         /* SOURCE NODE                         */

    PRAGMAS;

    PEDGE ipred;                       /* IMPORT PREDECESSOR                  */
    PEDGE isucc;                       /* IMPORT SUCCESSOR                    */
    PEDGE epred;                       /* EXPORT PREDECESSOR                  */
    PEDGE esucc;                       /* EXPORT SUCCESSOR                    */

    PEDGE uedge;                       /* UTILITY EDGE POINTER                */

    char  *CoNsT;                      /* CONSTANT STRING (IF SRC IS NULL)    */
    PINFO  info;                       /* DATA VALUE TYPE                     */

    /* dope AND lvl SHOULD NOT BE REFERENCED OUTSIDE THE CONFINES OF If1Dope  */
    PDOPE  dope;                       /* ARRAY BOUNDS INFORMATION            */
    int    lvl;                        /* SCOPE LEVEL OF EDGE                 */

    char  *dname;                      /* NAME USED IN PRETTY PRINTING        */
    };


struct info {
    int    if1line;                    /* LINE NUMBER OF INFO IN IF1 FILE     */

    int   type;                        /* IF SYMBOL TABLE TYPE                */
    int   label;                       /* UNIQUE SYMBOL IDENTIFIER            */

    PRAGMAS;

    PINFO info1;                       /* UTILITY POINTERS                    */
    PINFO info2;

    int   touch1;                      /* UTILITY FIELD                       */

    PINFO next;                        /* NEXT TYPE IN SYMBOL TABLE           */
    };

#define A_ELEM      info1              /* ARRAY-STREAM-MULTIPLE SUBCOMPONENT  */
#define R_FIRST     info1              /* FIRST RECORD-UNION MEMBER           */
#define F_IN        info1              /* FUNCTION IMPORT TYPES               */
#define F_OUT       info2              /* FUNCTION EXPORT TYPES               */
#define L_NEXT      info1              /* NEXT LIST ENTRY                     */
#define L_SUB       info2              /* LIST COMPONENT TYPE                 */


struct alist {
    int    datum;                      /* INTEGER LIST DATUM                  */
    PALIST next;                       /* NEXT DATUM                          */
    };


#define IsNodeListEmpty(x) ( (x)->G_NODES == NULL )

#define IsImport(x,y)      ( FindImport((x),(y)) != NULL )
#define IsExport(x,y)      ( FindExport((x),(y)) != NULL )

#define IsOctal(x)         ( ((x) >= '0') && ((x) <= '7') )

#define IsConst(x)         ( ((x)->src == NULL) && ((x)->eport == CONST_PORT ) )
