/* National Institute of Standards and Technology (NIST)
/* National Computer System Laboratory (NCSL)
/* Office Systems Engineering (OSE) Group
/* ********************************************************************
/*                            D I S C L A I M E R
/*                              (March 8, 1989)
/*  
/* There is no warranty for the NIST NCSL OSE SGML parser and/or the NIST
/* NCSL OSE SGML parser validation suite.  If the SGML parser and/or
/* validation suite is modified by someone else and passed on, NIST wants
/* the parser's recipients to know that what they have is not what NIST
/* distributed, so that any problems introduced by others will not
/* reflect on our reputation.
/* 
/* Policies
/* 
/* 1. Anyone may copy and distribute verbatim copies of the SGML source
/* code as received in any medium.
/* 
/* 2. Anyone may modify your copy or copies of SGML parser source code or
/* any portion of it, and copy and distribute such modifications provided
/* that all modifications are clearly associated with the entity that
/* performs the modifications.
/* 
/* NO WARRANTY
/* ===========
/* 
/* NIST PROVIDES ABSOLUTELY NO WARRANTY.  THE SGML PARSER AND VALIDATION
/* SUITE ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
/* EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
/* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
/* THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS
/* WITH YOU.  SHOULD THE SGML PARSER OR VALIDATION SUITE PROVE DEFECTIVE,
/* YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
/* 
/* IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NIST BE LIABLE FOR
/* DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
/* INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
/* BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
/* FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
/* NIST) THE PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF
/* SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.
*/

/************************************************************************/
/*   TITLE:          SGML PARSER                                        */
/*   SYSTEM:         DOCUMENT PROCESSOR                                 */
/*   SUBSYSTEM:                                                         */
/*   SOURCE FILE:    SEMANTIC.C                                         */
/*   AUTHOR:         Steven Lindeman, Fred Maples                       */
/*                                                                      */
/*   DATE CREATED:                                                      */
/*   LAST MODIFIED:                                                     */
/*                                                                      */
/*                  REVISIONS                                           */
/*   WHEN      WHO            WHY                                       */
/************************************************************************/

#include <stdio.h>
#include "semantic.h"
/*------------------------------------------------------*/
/*------------------------------------------------------*/
/*------------------------------------------------------*/
/* 
   This function is called by the parser at 'significant' points in
   the document.  These points are identified by the value of the
   variable 'code' which will be:

      1.  END_TAG_NAME - when an end tag is encountered, e.g.,
          </para>; str1 will point to a null terminated string
          containing the element name.
      2.  TAG_NAME - when a start tag is encountered, e.g., <para>;
          this will be followed by 0 or more calls to this function
          with code = TAG_ATTR; str1 will point to a null terminated 
          string containing the element name.
      3.  TAG_ATTR - this value is passed for each attribute associated
          with a start tag; str1 will point to a null terminated string
          containing the attribute name, str2 will point to a null 
          terminated string containing the attribute value.
      4.  TAG_END - this value is passed when there are no more
          attributes associated with a start tag.
      5.  DATA_STG - this value is passed to give text (not markup)
          to the application; str1 points to a null terminated
          character string.

      6.  PROC_INST - this value is passed to give the content of a 
          processing instruction to the application; str1 points to 
          a null terminated character string.
*/
void semantics(code,str1,str2)
int code;
char *str1,*str2;
{

     switch(code) {
     case END_TAG_NAME:
#ifdef APPL_DEBUG
       printf("*** END_TAG_NAME='%s' ***\n",str1);
#endif
       break;
     case TAG_NAME:
#ifdef APPL_DEBUG
       printf("*** TAG_NAME='%s' ***\n",str1);
#endif
       break;
     case TAG_ATTR:
#ifdef APPL_DEBUG
       printf("*** TAG_ATTR='%s'='%s' ***\n",str1,str2);
#endif
       break;
     case TAG_END:
#ifdef APPL_DEBUG
       printf("*** TAG_END ***\n");
#endif
       break;
     case DATA_STG:
#ifdef APPL_DEBUG
       printf("*** DATA_STG='%s' ***\n",str1);
#endif
       break;
     case PROC_INST:
#ifdef APPL_DEBUG
       printf("*** PROC_INST='%s' ***\n",str1);
#endif
       break;
     }
    return;
}
