/* National Institute of Standards and Technology (NIST)
/* National Computer System Laboratory (NCSL)
/* Office Systems Engineering (OSE) Group
/* ********************************************************************
/*                            D I S C L A I M E R
/*                              (March 8, 1989)
/*  
/* There is no warranty for the NIST NCSL OSE SGML parser and/or the NIST
/* NCSL OSE SGML parser validation suite.  If the SGML parser and/or
/* validation suite is modified by someone else and passed on, NIST wants
/* the parser's recipients to know that what they have is not what NIST
/* distributed, so that any problems introduced by others will not
/* reflect on our reputation.
/* 
/* Policies
/* 
/* 1. Anyone may copy and distribute verbatim copies of the SGML source
/* code as received in any medium.
/* 
/* 2. Anyone may modify your copy or copies of SGML parser source code or
/* any portion of it, and copy and distribute such modifications provided
/* that all modifications are clearly associated with the entity that
/* performs the modifications.
/* 
/* NO WARRANTY
/* ===========
/* 
/* NIST PROVIDES ABSOLUTELY NO WARRANTY.  THE SGML PARSER AND VALIDATION
/* SUITE ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
/* EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
/* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
/* THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS
/* WITH YOU.  SHOULD THE SGML PARSER OR VALIDATION SUITE PROVE DEFECTIVE,
/* YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
/* 
/* IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NIST BE LIABLE FOR
/* DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
/* INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
/* BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
/* FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
/* NIST) THE PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF
/* SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.
*/

/************************************************************************/
/*   TITLE:          SGML PARSER                                        */
/*   SYSTEM:         DTD PROCESSOR                                      */
/*   SUBSYSTEM:                                                         */
/*   SOURCE FILE:    DETGLBL.H                                          */
/*   AUTHOR:         Michael Garris                                     */
/*                                                                      */
/*   DATE CREATED:                                                      */
/*   LAST MODIFIED:                                                     */
/*                                                                      */
/*                  REVISIONS                                           */
/*   WHEN      WHO            WHY                                       */
/************************************************************************/

#define  BUFFSIZE  (400)
#define  NAMELEN   (8)

#define  POINTER   (-1)

#define  GRPO      0x00
#define  GRPC      0x01
#define  AND       0x02
#define  OR        0x03
#define  SEQ       0x04
#define  OPT       0x05
#define  PLUS      0x06
#define  REP       0x07
#define  REQ       0x08

#define  EMPTY     (-1)
#define  BACK      (-2)
#define  INT        0
#define  PTR        1
#define  START      0
#define  CONNECTOR  1

#define  TRUE        1
#define  FALSE       0

extern int debug,ambmodel;
extern ITEM *startbuf,*endbuf;
extern TABLE symtable[BUFFSIZE];
extern char reducedexpr[BUFFSIZE];
extern int index;
extern ITEM tokseen[BUFFSIZE],buffer[BUFFSIZE];
extern int symtabindx;
extern MEMNODE *head;

/* DETERMIN.C */ 
/*global*/  int main();
/*global*/  int determin();
/*global*/  struct STATEID *proclowgrp();
/*global*/  void tokensingrp();
/*global*/  struct STATEID *FSAtoken();
/*global*/  void lowgrp();
/*global*/  struct STATEID *getFSAtoken();
/*global*/  struct STATEID *FSAgrp();
/*global*/  struct STATEID *FSAgrpocid();
/* DETUTIL.C */ 
/*global*/  int nestlevel();
/*global*/  void getlowgrp();
/*global*/  void skippointer();
/*global*/  int gettoken();
/*global*/  int getoccind();
/*global*/  struct STATE *buildstate();
/*global*/  struct STATEID *buildid();
/*global*/  void insertpointer();
/*global*/  void makeroom();
/*global*/  ITEM *findendofgrp();
/*global*/  void stripunit();
/*global*/  void copy();
/*global*/  int getconnector();
/*global*/  void myexit();
/*global*/  int searchtoken();
/*global*/  struct STATE *mymalloc();
/*global*/  int freefsa();
/* DETTRAV.C */ 
/*global*/  void procinordr();
/*global*/  void procnode();
/*global*/  void procdet();
/*global*/  void findlabels();
/*global*/  int searchamb();
/*global*/  int ssearch();
/* PREPROC.C */ 
/*global*/  void preproc();
/*global*/  void init();
/*global*/  void tokenize();
/*global*/  int mysearch();
/*global*/  void get_name();
/*global*/  void handleoi();
/*global*/  void remove_blanks();
/*global*/  void validate_expr();
/*global*/  int get_expr();
/*global*/  int get_string();
/*global*/  int reduce();
/*global*/  void replace_parens();
/*global*/  void update_oi();
