/*  $Header: tools.h,v 3.0 88/04/14 09:30:17 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
# ifndef	TOOLS_H			/*  to allow multiple inclusions  */
# define	TOOLS_H

# include	<stdio.h>

/*  pseudo type definitions
 */
# define	Bool		int

/*  successful program completion and failure status codes
 */
# define	OFF		(0)
# define	ON		(1)

/*
 *  logical constants
 */
# define	TRUE		(1)
# define	FALSE		(0)
# define	YES		(1)
# define	NO		(0)
# define	FATAL		(1)
# define	NOTFATAL	(0)

/*
 *  logical operators
 */
# define	not		!
# define	and		&&
# define	or		||


/*
 *  pseudo functions
 */
# define	MIN(X,Y)	((X) <= (Y) ? (X) : (Y))
# define	MAX(X,Y)	((X) >= (Y) ? (X) : (Y))
# define	my_strlen(X)	(((X) == NULL) ? (0) : (strlen(X)) )
# define	isupper(X)	((X >= 'A') and (X <= 'Z'))
# define	islower(X)	((X >= 'a') and (X <= 'z'))
# define	lower(X)	((isupper(X)) ? (X+'a'-'A') : (X) )
# define	upper(X)	((islower(X)) ? (X-'a'+'A') : (X) )
# define	mod		%
# define	div		/

/*
 *  A trick to give the parameters in an extern function declaration.
 *  Put parameters between PAR & RAP:
 *      extern String strsave(PAR String s RAP);
 *  If 'cplus' is not defined, these parameters are commented out.
 */
# ifdef cplus
# define        PAR
# define        RAP
# else
# define        SELF(x)x
# define        CONCAT(x,y)    SELF(x)y
# define        PAR            CONCAT(SELF(/),SELF(*))
# define        RAP            CONCAT(SELF(*),SELF(/))
# endif

extern  String cstring     (PAR  String  RAP);
extern  String cname       (PAR  String  RAP);
extern  int    hash_string (PAR  String  RAP);
extern  void   to_lower    (PAR  String  RAP);
extern  void   to_upper    (PAR  String  RAP);

extern  String  strsave (PAR  String  RAP);
extern  int     strcmp  (PAR  String, String  RAP);
extern  void    strcpy  (PAR  String, String  RAP);
extern  int     strlen  (PAR  String  RAP);
extern  void    strcat  (PAR  String, String  RAP);
extern  Bool    streq   (PAR  String, String  RAP);
extern  int     abs     (PAR  int RAP);

extern  Bool    check_int(PAR int, int, int, ...  RAP);

extern  void*   MALLOC  (PAR  unsigned  RAP);
extern  void*   CALLOC  (PAR  unsigned, unsigned  RAP);
extern  void    FREE    (PAR  void*, int  RAP);
extern  void    CFREE   (PAR  String  RAP);

# endif		TOOLS_H
