/*  $Header: tools.c,v 3.0 88/04/13 16:30:51 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"

String cstring(str)
String str;
{
    static char answer[LITLEN + LITLEN + 1];
    int         i = 0;
    int         j = 0;

    while( str[i] ){
	if (str[i] == '\n') {
	    answer[j++] = '\\';
	    answer[j++] = 'n';
	    i++;
	} else {
	    if( (str[i] == '"') or (str[i] == '\\') ){
	        answer[j++] = '\\';
	    }
	    answer[j++] = str[i++];
	}
    }
    answer[j] = '\0';
    return answer;
}

String cname(name)
String name;
{
	static char nm[NAMELEN + 1];
	int         i = 0;

	while (name[i] != '\0')  {
	    if (name[i] == '-') nm[i] = 'a';
	    else if (name[i] == '.') nm[i] = 'z';
	    else nm[i] = name[i];
	    i++;
	}
	nm[i] = '\0';
	return(nm);
}

int hash_string(s)
String s;
{
    int sum = 0;

    while( (*s) != '\0' ){
	s++;
	sum += (*s);
    }
    return sum;
}

Bool   streq(s1, s2)
String s1;
String s2;
{
    return( strcmp(s1, s2) == 0 );
}

String strsave(s)
String s;
{
    String ss;

    ss = (String) CALLOC( (unsigned)(strlen(s)+1), 
			  (unsigned)(sizeof(char)) );
    strcpy(ss, s);
    return ss;
}

void to_upper(s)
String s;
{
    int i=0;
    while( s[i] != '\0' ){
	s[i] = upper(s[i]);
	i++;
    }
}

void to_lower(s)
String s;
{
    int i=0;
    while( s[i] != '\0' ){
	s[i] = lower(s[i]);
	i++;
    }
}

/*  Checks wether key is one of key[1-14].
 */
Bool check_int(key, key1, key2, key3, key4, key5, key6, key7, key8,
		    key9, key10, key11, key12, key13, key14, key15)
int key,  key1, key2,  key3,  key4,  key5,  key6,  key7;
int key8, key9, key10, key11, key12, key13, key14, key15;
{
    if( key1 == 0     ){ return FALSE; }
    if( key  == key1  ){ return TRUE;  }
    if( key2 == 0     ){ return FALSE; }
    if( key  == key2  ){ return TRUE;  }
    if( key3 == 0     ){ return FALSE; }
    if( key  == key3  ){ return TRUE;  }
    if( key4 == 0     ){ return FALSE; }
    if( key  == key4  ){ return TRUE;  }
    if( key5 == 0     ){ return FALSE; }
    if( key  == key5  ){ return TRUE;  }
    if( key6 == 0     ){ return FALSE; }
    if( key  == key6  ){ return TRUE;  }
    if( key7 == 0     ){ return FALSE; }
    if( key  == key7  ){ return TRUE;  }
    if( key8 == 0     ){ return FALSE; }
    if( key  == key8  ){ return TRUE;  }
    if( key9 == 0     ){ return FALSE; }
    if( key  == key9  ){ return TRUE;  }
    if( key10== 0     ){ return FALSE; }
    if( key  == key10 ){ return TRUE;  }
    if( key11== 0     ){ return FALSE; }
    if( key  == key11 ){ return TRUE;  }
    if( key12== 0     ){ return FALSE; }
    if( key  == key12 ){ return TRUE;  }
    if( key13== 0     ){ return FALSE; }
    if( key  == key13 ){ return TRUE;  }
    if( key14== 0     ){ return FALSE; }
    if( key  == key14 ){ return TRUE;  }
    if( key15== 0     ){ return FALSE; }
    if( key  == key15 ){ return TRUE;  }
    return FALSE;
}

/*  allocation routines */
extern int errno;
#ifdef DEBUG
int mem_used = 0;
#endif

void* MALLOC(nr_bytes)
unsigned nr_bytes;
{
    void *a;
    a = (void *) malloc(nr_bytes);
    if( a == 0 ){
	report(SYSTEM_ALLOC, FATAL, 0, 0, "malloc", errno);
	assert(FALSE);
    }
#ifdef DEBUG
    mem_used += nr_bytes;
#endif
    return a;
}

void* CALLOC(nr_bytes, size)
unsigned nr_bytes;
unsigned size;
{
    void *a;
    a = (void *) calloc(nr_bytes, size);
    if( a == 0 ){
	report(SYSTEM_ALLOC, FATAL, 0, 0, "calloc", errno);
	assert(FALSE);
    }
#ifdef DEBUG
    mem_used += (nr_bytes * size);
#endif
    return a;
}

void  FREE(x, nr_bytes)
void *x;
int   nr_bytes;
{
    free(x);
#ifdef DEBUG
    mem_used -= nr_bytes;
#endif
}

void  CFREE(x)
String x;
{
#ifdef DEBUG
    int nr_bytes = 0;

    if (x) nr_bytes = strlen(x) + 1;
    mem_used -= nr_bytes;
#endif
    cfree(x);
}
