/*  $Header: symtable.c,v 3.0 88/04/13 16:28:04 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "symtable.h"

String symbol_string(table, symbol)
SymbolTable table;
int         symbol;
{
    int i;

    for( i=0;  table[i].string != ILL_STRING; i++){
	if( table[i].symbol == symbol ){
	    return table[i].string;
	}
    }
    return ( (String)ILL_STRING );
}

int string_symbol(table, string)
SymbolTable table;
String      string;
{
    int i;

    for( i=0;  table[i].string != ILL_STRING; i++){
	if( streq(table[i].string, string) ){
	    return table[i].symbol;
	}
    }
    return (ILL_SYMBOL);
}
