#!/bin/sh
#
#  This file is part of the Amsterdam SGML Parser.
#
#  Copyright: Faculteit Wiskunde en Informatica
#             Department of Mathematics and Computer Science
#             Vrije Universiteit Amsterdam
#             The Netherlands
#
#  Authors:   Sylvia van Egmond
#             Jos Warmer
#
#
#  Makefile for Amsterdam SGML Parser
#
DIR=ASPROOT

PWD=`pwd`
BASE=`basename $1 .dtd`
BASE=`basename $BASE .DTD`

rm -f $DIR/document*.g $DIR/DOC/document*.c  $DIR/DOC/document*.o
echo "SGML check DTD $1"
if (cd $DIR; GEN/generator $PWD/$1 document 2>$PWD/errors)
then
    echo "DTD $1 correct, compiling document parser"
    cd $DIR; make -f Makefile ASPDIR=$DIR doc_parser
    mv $DIR/DOC/doc_parser $PWD/$BASE.asp
else
    echo "DTD $1 contains FATAL error, see file: errors"
    cat errors
fi
