/* $Header: report.c,v 3.2 88/07/19 09:58:01 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "ambigu.h"
#include "group.h"
#include "in.h"
#include "file_in.h"
#ifdef DOC_PARSER
#include "rep_pars.h"
#endif
#include "set.h"

#define MAX_ERRORS	60


static String report_msg[] = {
"Error: In switch label '%d' in '%s'\n",
"Error: Loop in element: ",
"Error: In element: ",
"Error: In element: ",
"Error: Clash for element: ",
"Error: In attr. '%s': default type '%s' not allowed\n\twith declared value ID\n",
"Error: In attr. '%s': no default value allowed with declared value ID\n",
"Error: Attribute name '%s' redeclared\n",
"Error: At least two %s attributes occur in the same attlist for: ",
"Error: Token '%s' occurs in two groups in the attlist for: ",
"Error: Content model of ",
"Warning: Content model of ",
"Error: '%s' = '%d' exceeds the capacity 35000\n",
"Error: Reference to undefined element '%s'\n",
"Error: '%s' is not a name of capacity in basic SGML\n",
"Error: '%s' has value %s, should be %s in basic SGML\n",
"Warning: Shunned character '%s' is already declared (ignored)\n",
"Error: Shunned character '%s' is not defined in basic SGML\n",
"Error: '%d' is also a shunned character in basic SGML\n",
"Error: '%s' is not a %s delimiter in basic SGML\n",
"Error: '%s' is also a short reference delimiter in basic SGML\n",
"Error: '%s' is not a quantity-name in basic SGML\n",
"Error: Cannot open file '%s'\n",
"Error: End of file expected, token is '%s'\n",
"Error: %s unexpected: deleted\n",
"Error: %s expected: inserted\n",
"Error: Inclusion of undefined element '%s'\n",
"Error: Exclusion of undefined element '%s'\n",
"Error: Unreachable element %s\n",
"Warning: %s exceeds LITLEN (%d), truncated\n",
"Warning: Attr.names + name-tokens of ",
"Warning: Wrong keyword '%s'in %s, %s expected, replaced by %s\n",
"Warning: Number of name-tokens must not exceed GRPCNT (%d)\n",
"Error: Different connectors in one group\n",
"Error: This document is not made according\n\tthe ISO standard 8879-1986.\n",
"Error: In basic SGML ISO 8879-1986//CAPACITY Reference//EN\n\tmust be used for the capacity set.\n",
"Error: In basic SGML, the concrete syntax scope must be DOCUMENT\n",
"Error: In basic SGML ISO 8879-1986//SYNTAX Reference//EN\n\tmust be used for the public concrete syntax.\n",
"Error: In basic SGML, switches of characters are not allowed\n",
"Error: In basic SGML, shunned characters are predefined\n",
"Error: In basic SGML all shunned characters are control characters\n",
"Error: In basic SGML the %s is character code %s\n",
"Error: In basic SGML only the tab (9) is an extra\n\tadded SEPCHAR function.\n",
"Error: In basic SGML %s is defined '%s'\n",
"Error: In basic SGML NAMECASE GENERAL must be YES.\n",
"Error: In basic SGML NAMECASE ENTITY must be NO.\n",
"Error: In basic SGML only the predefined shortreference\n\tdelimiters are allowed.\n",
"Error: In basic SGML %s is/are not allowed\n",
"Error: In basic SGML %s is always YES\n",
"Error: In basic SGML APPINFO must be NONE.\n",
"Error: Value %s has at least two possible attributes\n",
"Error: There is no attribute with value: %s\n",
"Warning: Element '%s' is included but also excluded,\n\texclusion prevails\n",
"Error: Endtag '%s' may not be omitted, inserted\n",
"Error: Unknown attribute name '%s'\n",
"Warning: Attr. spec. list of '%s' exceeds ATTSPLEN\n",
"Warning: Starttag length of '%s' exceeds TAGLEN\n",
"Error: Non-namecharacter in attribute-value '%s', character position %d\n",
"Warning: Name '%s' exceeds NAMELEN (%d), truncated\n",
"Error: Non-digit in attribute-value '%s', character position %d\n",
"Error: Unknown value '%s' in attribute %s\n",
"Error: Non-nametoken in attribute-value '%s', character position %d\n",
"Error: Non-numbertoken in attribute-value '%s', character position %d\n",
"Error: Non-cdata in attribute-value '%s', character position %d\n",
"Error: Attribute '%s' empty literal not allowed\n",
"Warning : Redefinition of %s entity '%s' ignored\n",
"Error: Entity '%s', NDATA not implemented\n",
"Error: Entity '%s', SUBDOC not implemented\n",
"Error: Referenced %s entity '%s' not defined.\n",
"System error: Too much pushback (>%d) in file_input.c\n",
"Error: Recursive entity '%s' ignored\n",
"Warning: Short reference map '%s' defined twice (ignored)\n",
"Error, Undefined short reference role '%s'\n",
"Error: Short reference '%s' defined twice in same map\n",
"Error: Short reference map '%s' does not exist\n",
"Error: Element in usemap-declaration not allowed in document\n",
"System error: %s returns 0, errno = %d\n",
"Warning: Length of processing instruction exceeds\n\tthe PILEN (%d), truncated\n",
"Warning: Parameter entity reference name '%s' must\n\tnot exceed NAMELEN - 1(%d) truncated\n",
"Error: SDATA/CDATA not allowed in parameter entity\n",
"Error: NDATA/SUBDOC not allowed in parameter entity\n",
"Warning: Number of open marked sections exceeds TAGLVL (%d)\n",
"Error: Marked section closed, while none was open\n",
"Error: Element required in usemap-declaration '%s' in DTD\n",
"Error: Attribute '%s' is required, but no value is given\n",
"Error: Attribute '%s' is a fixed attribute,\n\tso default value (%s) = given value (%s)\n",
"Error: Attribute '%s' is a current attribute, so value must be filled first time\n",
"Warning: Number of open elements must not exceed TAGLVL (%d)\n",
"Error: Element '%s' is excluded\n",
"Error: Empty %stag outside open element\n",
"Error: Unknown %stag: '%s': deleted\n",
"Error: Endtag without closing delimiter\n",
"Error: Unknown function name '%s' in character reference\n",
"Error: Character reference does not start with a correct character\n",
"Error: Token '%s' occurs twice in attribute range\n",
"Error: Too many open entities (> ENTLVL = %d) in entity '%s'\n",
"Error: Attribute ID-value '%s' is not unique\n",
"Error: Attribute ID-value '%s' is never referenced\n",
"Error: Attribute IDREF-value '%s' has no corresponding ID attribute\n",
"Error: Redefinition of element '%s'\n",
"Error: String '%s' unexpected: deleted\n",
"Warning: Cannot find extern identifier SYSTEM '%s' PUBLIC '%s'\n",
"System error: Constraint not Ok for token %d\n",
"System error: Too much pushback, %d > %d\n",
"Error: Empty content of element '%s' is not allowed with NOTATION/CONREF attributes\n",
"Error: Undefined notation name '%s' in  %s '%s'\n",
"Error: Notation name '%s' is defined twice\n",
"Error: More than one map ('%s' and '%s') used with element `%s'\n",
"Error: No associated element '%s' in attribute definition list\n",
"Warning: Number of idrefs in starttag of element %s exceeds GRPCNT (%d)\n",
"Error: In the starttag of element %s: a NOTATION attribute is not allowed if there is an explicit content reference\n",
"Error: Character `%c' expected: inserted\n",
"System Error: Token `%s' expected\n",
"Error: Element `%s' has no attribute with name `%s'\n",
"Error: Element `%s' does not exist\n",
"Error: Token `%s' unexpected: deleted\n",
"Error: String '%s' unexpected: deleted\n",
"Error: Name does not start with name start character, but with `%c'\n",
"Warning: Name '%s' exceeds NAMELEN (%d), truncated\n",
"Error: In switch label '%d' in '%s'\n",
"Warning: processing instruction in DTD is ignored\n"

};

static Bool report_fatal = FALSE;

void report(type, fatal, group, set, i1,i2,i3,i4,i5,i6,i7,i8,i9,i10)
int     type, fatal;
P_Group group;
P_Set   set;
int     i1,i2,i3,i4,i5,i6,i7,i8,i9,i10;
{

	static int    nr_errors = 0;
	static char   last_location[LITLEN + 1] = "";
	String        location = 0;
	int           i;
	int           current_char;
	String        current_line;

	if (type != FILE_OPEN) {
#ifdef DOC_PARSER
	    if( check_int(type, REP_INSERTED, REP_ASSERT, REP_ATTR, REP_ELEM,
		                REP_DEL, REP_DEL_CHARS, REP_NAME_START,
				REP_WAR_NAMELEN, REP_NO_LABEL, 0))
	    {
		location = rep_location();
	    } else {
#endif
		current_line = file_current_line(&current_char);
		if( current_line != (String)0 ){
		    fprintf(stderr, "%s\n", current_line);
		    for( i=1; i<current_char; i++){
			fprintf(stderr, " ");
		    }
		    fprintf(stderr, "^\n");
		}
		location = input_location();
#ifdef DOC_PARSER
	    }
#endif
	    fprintf(stderr, "%s: ", location);
	}
	else location = 0;
	fprintf(stderr, report_msg[type], i1,i2,i3,i4,i5,i6,i7,i8,i9,i10);
	if (fatal){
	    report_fatal = TRUE;
	    if (location == 0) {
		last_location[0] = '\0';
	    	nr_errors++;
	    } else
		if ((last_location[0] == '\0') or
		    (strcmp(location, last_location) != 0)) {
		    strcpy(last_location, location);
	    	    nr_errors++;
	    	}
	}
	switch(type) {
#ifdef GENERATOR
	  case AMB_LOOP       :
		group_print(stderr, group);
		fprintf(stderr, "\n");
		break;
	  case AMB_ALTER      :
		group_print(stderr, group);
		fprintf(stderr, "\n\tmore alternatives on: ");
		sym_set_print(stderr, set);
		fprintf(stderr, "\n");
		break;
	  case AMB_FOLLOWS    :
		group_print(stderr, group);
		fprintf(stderr, "\n\tgroup is followed by itself : ");
		sym_set_print(stderr, set);
		fprintf(stderr, "\n");
		break;
	  case AMB_CLASH      :
		sym_print(stderr, i1);
		fprintf(stderr, "in element : ");
		group_print(stderr, group);
		fprintf(stderr, "\n");
		break;
#endif
	  case ATTR_TWO_ID    :
		group_print(stderr, group);
		fprintf(stderr, "\n");
		break;
	  case ATTR_TWO_TOKEN :
		group_print(stderr, group);
		fprintf(stderr, "\n");
		break;
	  case ER_GRPGTCNT    :
		group_print(stderr, group);
		fprintf(stderr, "\n\texceeds GRPGTCNT (%d)\n", GRPGTCNT);
		break;
	  case WAR_GRPLVL     :
		group_print(stderr, group);
		fprintf(stderr, "\n\texceeds GRPLVL (%d)\n", GRPLVL);
		break;
	  case WAR_ATTCNT     :
		group_print(stderr, group);
		fprintf(stderr, " exceeds ATTCNT (%d)\n", ATTCNT);
		break;
	  case NO_LABEL       :
	  case CHREF_ERROR    : 
	  case FILE_OPEN      :
	  case LLGEN_EOF      :
	  case SYSTEM_ALLOC   :
	  case SYSTEM_PUSH    :
		if (fatal) fatal_report();
		break;
	  default             :
		break;
	}
	fflush(stderr);
	if (nr_errors > MAX_ERRORS) {
	    fprintf(stderr, "Too many errors have occured, execution stopped\n");
	    fflush(stderr);
	    exit(1);
	}
}

void fatal_report()
{
	if (!report_fatal) return;
	fprintf(stderr, "FATAL error has occured, execution is stopped\n");
	fflush(stderr);
	exit(1);
}
