/* $Header: group.c,v 3.0 88/04/13 15:54:47 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "group.h"

#ifdef DEBUG
int tot_nr_groups = 0;
int tot_nr_links = 0;
int tot_nr_iters = 0;

int nr_groups = 0;
int nr_links  = 0;
#endif

typedef struct link_struct *P_Link;

typedef struct link_struct {
    P_Link   next_link;
    P_Link   prev_link;
    void    *element;
} Link;

P_Group    group_create()
{
    P_Group g;

    g = (P_Link)MALLOC( (unsigned)sizeof(struct link_struct) );
    g->next_link = g;
    g->prev_link = g;
    g->element   = 0;

#ifdef DEBUG
    nr_groups++;
    tot_nr_groups++;
    nr_links++;
    tot_nr_links++;
#endif

    return g;
}

void delete_group(g, elem_free)
P_Group   g;
func      elem_free;
{
    P_Link tmp, l;
    if( g==0 ){ return; }

    l = g->next_link;
    while( l != g ){
	tmp = l;
	l = l->next_link;
	(*elem_free)(tmp->element);
	FREE(tmp, sizeof(struct link_struct));
#ifdef DEBUG
	nr_links--;
#endif
    }
    FREE(g, sizeof(struct link_struct));
#ifdef DEBUG
    nr_groups--;
#endif
}

void       group_add(g, elem)			/* adds at the end */
P_Group  g;
void    *elem;
{
    P_Link   l;
    assert( g != 0 );

    l = (P_Link)MALLOC( (unsigned)sizeof(struct link_struct) );
#ifdef DEBUG
    nr_links++;
    tot_nr_links++;
#endif
    l->element   = elem;
    l->next_link = g;
    l->prev_link = g->prev_link;

    g->prev_link->next_link = l;
    g->prev_link = l;
}

void       group_insert(g, elem)			/* adds at the end */
P_Group  g;
void    *elem;
{
    P_Link   l;
    assert( g != 0 );

    l = (P_Link)MALLOC( (unsigned)sizeof(struct link_struct) );
#ifdef DEBUG
    nr_links++;
    tot_nr_links++;
#endif
    l->element   = elem;
    l->prev_link = g;
    l->next_link = g->next_link;

    g->next_link->prev_link = l;
    g->next_link = l;
}

static void  group_delete(tmp, elem_free)
P_Iterator   tmp;
func         elem_free;
{
    (*elem_free)(tmp->element);
    tmp->next_link->prev_link = tmp->prev_link;
    tmp->prev_link->next_link = tmp->next_link;
    FREE(tmp, sizeof(struct link_struct));
}

void       group_del_next(g, iter, elem_free)
P_Group     g;
P_Iterator *iter;
func        elem_free;
{
    P_Iterator  tmp = *iter;

    assert( (g!=0) and (*iter!=0) );
    if( *iter == g ){ return; }

    *iter = (*iter)->next_link;
    group_delete(tmp, elem_free);
}

void       group_del_previous(g, iter, elem_free)
P_Group     g;
P_Iterator *iter;
func        elem_free;
{
    P_Iterator  tmp = *iter;

    assert( (g!=0) and (*iter!=0) );
    if( *iter == g ){ return; }

    *iter = (*iter)->prev_link;
    group_delete(tmp, elem_free);
}

P_Iterator  group_iterator(g)		/* sets current elem to first elem */
P_Group   g;
{
#ifdef DEBUG
    tot_nr_iters++;
#endif
    return (g);
}

void*     iter_previous(it)
P_Iterator *it;
{
    if( *it == 0 ){ return 0; }

    *it = (*it)->prev_link;
    return ((*it)->element);
}

void*    iter_next(it)		/* sets current elem to next  elem */
P_Iterator *it;
{
    if( *it == 0 ){ return 0; }

    *it = (*it)->next_link;
    return ((*it)->element);
}

void*     iterator_elem(it)			/* returns current elem  */
P_Iterator it;
{
    if( it == 0 ){ return 0; }

    return (it->element);
}

void group_print(file, g)
FILE    *file;
P_Group  g;
{
    P_Link l;

    if( g==0 ){ return; }

    l = g->next_link;
    while( l != g ){
	fprintf(file, "`%s' ", (String)l->element );
	l = l->next_link;
    }
}

Bool group_add_unique(group, elem, equal)
P_Group               group;
void                 *elem;
IntFunctionVoidVoid   equal;
{
    P_Iterator   it;
    void        *el;

    it = group_iterator(group);
    while( el = iterator_next(it) ){
	if( (*equal)(elem, el) ){
	    iterator_delete(it);
	    return FALSE;
	}
    }
    group_add(group, elem);
    return TRUE;
}

