/*  $Header: element.h,v 3.0 88/04/14 09:12:56 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*  Element definition.
 *  Functions to get values for one element.
 */

extern void         init_element();
extern P_Element    element     (PAR  String name  RAP);
extern P_Group      name_group  (PAR  P_Element    RAP);
extern Bool         omit_start  (PAR  P_Element    RAP);
extern Bool         omit_end    (PAR  P_Element    RAP);
extern P_Node       content     (PAR  P_Element    RAP);
extern P_Group      exclusions  (PAR  P_Element    RAP);
extern P_Group      inclusions  (PAR  P_Element    RAP);

extern P_Element    reference_elem(PAR  P_Reference  RAP);
extern P_Node       reference_node(PAR  P_Reference  RAP);

extern  int     element_number       (PAR  String     RAP);
extern  Bool    element_busy         (PAR  P_Element  RAP);
extern  void    element_set_busy     (PAR  P_Element, Bool  RAP);
extern  Bool    element_done         (PAR  P_Element  RAP);
extern  void    element_set_done     (PAR  P_Element, Bool  RAP);
extern  P_Set   element_firstsym     (PAR  P_Element  RAP);

extern   void          set_document_name(PAR  String RAP);
extern   String        document_name    ();

/*  Functions to walk through the list of elements.
 *  Call 'next_element' until it delivers 0.
 */
extern P_Iterator  element_iterator  ();

extern void        elem_traverse_post(PAR  P_Node_func  RAP);
extern void        elem_traverse_pre (PAR  P_Node_func  RAP);

/*  Define an element.
 */
extern   void          define_element(PAR
					P_Group     name_grp,
					Bool        omit_start,
					Bool        omit_end,
					P_Node      content,
					P_Group     exclus,
					P_Group     inclus
				      RAP);

/* Additional functions */
extern int     number_of_elements();
extern String  number_to_name    (PAR int t RAP);

extern void    elem_reference    (PAR String elem_name, P_Node, P_Element RAP);
extern P_Group elem_references   (PAR  P_Element  RAP);
