/* $Header: element.c,v 3.0 88/04/13 15:51:02 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "element.h"
#include "node.h"

typedef struct reference_struct {
    P_Node     node;
    P_Element  elem;
} Reference;

#define HASH_STRUCT          tmpnamexxyz
#define HASH_TABLE           ElemTable
#define ELEM_KEY             String
#define HASH_FUNCTION(a)     hash_string(a)
#define EQUAL_KEY(a, b)      !strcmp(a,b)
#define INFO                 P_Element
#define NEW_HASH_TABLE       new_elem_table
#define INSERT               insert_elem
#define LOOKUP               lookup_elem

#include "hash.gen"

static ElemTable table;
static P_Group   grammar;
static String    doc_name;
static int       nr_of_elements = 1;

struct element_struct {
    P_Group     name_grp;	/* generic id., name group wordt uitgewerkt */
    Bool        omit_start;	/* TRUE or FALSE */
    Bool        omit_end;	/* TRUE or FALSE */
    int         number;
    Bool        busy;
    Bool        done;
    P_Node      content;	/* content model wordt als een boom beschouwt */
    P_Group     exclus;		/* lijst namen voor exclusie */
    P_Group     inclus;		/* lijst namen voor inclusie */
    P_Group     refs;
} Element;

void set_document_name(name)
String  name;
{
    doc_name = name;
}

int number_of_elements()
{
   return nr_of_elements-1;
}

String document_name()
{
    return doc_name ;
}

void define_element( name_grp, omit_start, omit_end, content,
					    exclus, inclus)
P_Group     name_grp;
Bool        omit_start;
Bool        omit_end;
P_Node      content;
P_Group     exclus;
P_Group     inclus;
{
    P_Element    elem;
    String       elem_name;
    P_Iterator   iter;
    Bool         empty_group = TRUE;

    iter = group_iterator(name_grp);
    elem_name = next_name(iter);
    while( elem_name ){
	if( element(elem_name) ){
	    report(ELEM_REDEF, FATAL, 0, 0, elem_name);
	    group_delete_next(name_grp, iter, CFREE);
	    elem_name = (String) iterator_elem(iter);
	} else {
	    elem_name = next_name(iter);
	    empty_group = FALSE;
	}
    }
    if( empty_group ){ return; }

    elem = (P_Element)MALLOC( (unsigned)sizeof(Element) );
    elem->name_grp  = name_grp;
    elem->omit_start= omit_start;
    elem->omit_end  = omit_end;
    elem->content   = content;
    elem->number    = nr_of_elements;
    elem->busy      = FALSE;
    elem->done      = FALSE;
    elem->exclus    = exclus;
    elem->inclus    = inclus;
    elem->refs      = group_create();

    group_add(grammar, elem);
    iter = group_iterator(name_grp);
    while( elem_name = next_name(iter) ){
	nr_of_elements++;
	insert_elem(table, elem_name, elem);
    }
}

P_Iterator element_iterator()
{
    return group_iterator(grammar);
}

/*  Element definition.
 *  Functions to get values for one element.
 */

P_Element  element     (name  )
String name;
{
    return  lookup_elem(table, name);
}

P_Group     name_group(element)
P_Element  element;
{
    return element->name_grp;
}

Bool       omit_start  (element)
P_Element  element;
{
    return element->omit_start;
}

Bool       omit_end    (element)
P_Element  element;
{
    return element->omit_end;
}

P_Node     content     (element)
P_Element  element;
{
    return element->content;
}

P_Group    exclusions(element)
P_Element  element;
{
    return element->exclus;
}

P_Group    inclusions(element)
P_Element  element;
{
    return element->inclus;
}

void init_element()
{
    grammar = group_create();
    table   = new_elem_table(111);
}

Bool element_busy    (e   ) P_Element e;        { return e->busy    ; }
void element_set_busy(e, b) P_Element e; int b; {        e->busy = b; }
Bool element_done    (e   ) P_Element e;        { return e->done    ; }
void element_set_done(e, b) P_Element e; int b; {        e->done = b; }

int  element_number(element_name)
String element_name;
{
    P_Element    e;
    P_Iterator   iter;
    String       elem_name;
    int          nr;

    e    = element( element_name );
    nr   = e->number;
    iter = group_iterator(e->name_grp);
    while( elem_name = next_name(iter) ){
	if( streq(elem_name, element_name) ){
	    iterator_delete(iter);
	    return nr;
	}
	nr++;
    }
}

String number_to_name(t)
int t;
{
    P_Iterator it;
    P_Element  e1, e2 = 0; 
    String     name;
    int        i;
    
    assert( t >= 1 );
    it = element_iterator();
    while( e1 = next_element(it) ){ 
        if( e1->number == t ){ 
            iterator_delete(it); 
	    break;
        }
        if( e1->number > t ){
            iterator_delete(it);
            e1 = e2;
	    break;
        }
	e2 = e1;
    }
    if( e1 == 0 ) {
	if (e2 == 0) { return 0; }
        else e1 = e2;
    }

    it = group_iterator( e1->name_grp );
    for( (i=e1->number, name = next_name(it)) ; (i<t) and (name!=0); (i++, name = next_name(it)) );
    iterator_delete(it);
    return name;
}

void elem_traverse_post(function) 
P_Node_func   function; 
{
    P_Iterator iter;
    P_Element  elem;

    iter = element_iterator();
    while( elem = next_element(iter) ){
        node_traverse_post(content(elem), function, elem );
    }
}

void elem_traverse_pre(function) 
P_Node_func   function; 
{
    P_Iterator iter;
    P_Element  elem;

    iter = element_iterator();
    while( elem = next_element(iter) ){
        node_traverse_pre(content(elem), function, elem );
    }
}

void elem_reference(elem_name, node, node_elem)
P_Node     node;
String     elem_name;
P_Element  node_elem;
{
    P_Element     elem;
    P_Reference   ref;

    elem = lookup_elem(table, elem_name);
    ref = (P_Reference)MALLOC((unsigned) sizeof(Reference));
    ref->node  = node;
    ref->elem  = node_elem;
    group_add(elem->refs, ref);
}

P_Group elem_references(elem)
P_Element  elem;
{
    return (elem->refs);
}

P_Element reference_elem(ref)
P_Reference ref;
{
    return ref->elem;
}

P_Node reference_node(ref)
P_Reference ref;
{
    return ref->node;
}
