/******************************************************************************/
/* Added PCBEAL for LINK and data attribute specification list endings. */
/******************************************************************************/
/* SYNXTRN.H: External declarations for concrete syntax constants.
*/
/******************************************************************************/
/* Short References
*/
#define SRCT    32            /* Number of short reference delimiters. */
#define SRMAXLEN 3            /* Maximum length of a SHORTREF delimiter. */
#define SRNPRT   8            /* Number of non-printable SHORTREF delimiters. */
/******************************************************************************/
struct srdel {
     struct map dtb[SRCT+2];  /* LEXCNM: Short reference delimiters. */
     char *pdtb[SRNPRT+1];    /* LEXCNM: Printable form of unprintable SRs. */
     int fce;                 /* LEXCNM: Index of first FCE in srdeltab. */
     int hyp2;                /* LEXCNM: Index of "two hyphens" in srdeltab. */
     int data;                /* LEXCNM: Index of first SR with data char. */
     int hyp;                 /* LEXCNM: Index of hyphen in srdeltab. */
     int prtmin;              /* LEXCNM: Index of 1st printable SR. */
     int spc;                 /* LEXCNM: Index of space in srdeltab. */
};
struct delim {
     char genre;              /* LEXCON: Generated RE; cannot be markup. */
     char lit;                /* LEXMARK: Char used as LIT delimiter.*/
     char lita;               /* LEXMARK: Char used as LITA delimiter.*/
     char mdc;                /* LEXLMS: Char used as MDC delimiter.*/
     char msc;                /* LEXCON: Char used as MSC delimiter. */
     char net;                /* LEXCON: Char used as NET when enabled.*/
     char pero;               /* LEXMARK: Char used as PERO delimiter. */
     char pic;                /* LEXCON: Char used as PIC delimiter.*/
     char tago;               /* LEXCON: Char used as TAGO when enabled.*/
};
struct lexcode {
     char fce;                /* LEXCNM: FRE character as entity reference. */
     char fre;                /* LEXCON: Free character not an entity ref. */
     char litc;               /* LEXLMS: Literal close delimiter enabled. */
     char lmnsc;              /* LEXLMS: Non-SGML character prefix. */
     char msc;                /* LEXLMS: Marked section close delim enabled. */
     char net;                /* LEXCON: Null end-tag delimiter enabled. */
     char nonet;              /* LEXCON: NET disabled; still used as ETI. */
     char spcr;               /* LEXCNM: Space in use as SHORTREF delimiter. */
     char tago;               /* LEXCON: Tag open delimiter enabled. */
     char cde;                /* LEXLMS: CDATA/SDATA delimiters. */
};
struct lexical {
     struct markup m;         /* Markup strings for text processor. */
     struct srdel s;          /* Short reference delimiters. */
     struct delim d;          /* General delimiter characters. */
     struct lexcode l;        /* Lexical table code assignments. */
};
extern struct lexical lex;    /* Delimiter set constants. */
/******************************************************************************/
extern char lexcnm[];         /* Lexical table: mixed content. */
extern char lexcon[];         /* Lexical table for content (except mixed). */
extern char lexgrp[];         /* Lexical table for groups. */
extern char lexlms[];         /* Lexical table: literals and marked sections. */
extern char lexmark[];        /* Lexical table for markup. */
extern char lextran[];        /* Case translation table for SGML names. */
extern char lextoke[];        /* Lexical table for tokenization. */
/******************************************************************************/
extern struct parse pcbconc;  /* PCB: character data. */
extern struct parse pcbcone;  /* PCB: element content (no data allowed). */
extern struct parse pcbconm;  /* PCB: mixed content (data allowed). */
extern struct parse pcbconr;  /* PCB: replaceable character data. */
extern struct parse pcbetag;  /* PCB: end-tags. */
extern struct parse pcbgrcm;  /* PCB: content model group. */
extern struct parse pcbgrcs;  /* PCB: content model suffix. */
extern struct parse pcbgrnm;  /* PCB: name group. */
extern struct parse pcbgrnt;  /* PCB: name token group. */
extern struct parse pcblitc;  /* PCB: literal with CDATA. */
extern struct parse pcblitp;  /* PCB: literal with CDATA, parm & char refs. */
extern struct parse pcblitr;  /* PCB: attribute value with general refs. */
extern struct parse pcblitv;  /* PCB: literal with CDATA, function char trans.*/
extern struct parse pcbmd;    /* PCB: markup declaration. */
extern struct parse pcbmdc;   /* PCB: comment declaration. */
extern struct parse pcbmdi;   /* PCB: markup declaration (ignored). */
extern struct parse pcbmds;   /* PCB: markup declaration subset. */
extern struct parse pcbmsc;   /* PCB: marked section in CDATA mode. */
extern struct parse pcbmsi;   /* PCB: marked section in IGNORE mode. */
extern struct parse pcbmsrc;  /* PCB: marked section in RCDATA mode. */
extern struct parse pcbpro;   /* PCB: prolog. */
extern struct parse pcbref;   /* PCB: reference. */
extern struct parse pcbstag;  /* PCB: start-tag. */
extern struct parse pcbval;   /* PCB: attribute value. */
extern struct parse pcbeal;   /* PCB: end of attribute list. */
/******************************************************************************/
extern int pcbcnda;           /* PCBCONM: data in buffer. */
extern int pcbcnet;           /* PCBCONM: markup found or data buffer flushed.*/
extern int pcbmdtk;           /* PCBMD: token expected. */
extern int pcbstan;           /* PCBSTAG: attribute name expected. */
/******************************************************************************/
struct keywords {
     char any      [NAMELEN+1];
     char attlist  [NAMELEN+1];
     char capacity [NAMELEN+1];
     char cdata    [NAMELEN+1];
     char charset  [NAMELEN+1];
     char conref   [NAMELEN+1];
     char current  [NAMELEN+1];
     char kdefault [NAMELEN+1];
     char doctype  [NAMELEN+1];
     char document [NAMELEN+1];
     char dtd      [NAMELEN+1];
     char element  [NAMELEN+1];
     char elements [NAMELEN+1];
     char empty    [NAMELEN+1];
     char endtag   [NAMELEN+1];
     char entities [NAMELEN+1];
     char entitee  [NAMELEN+1];
     char fixed    [NAMELEN+1];
     char idiot    [NAMELEN+1];
     char idref    [NAMELEN+1];
     char idrefs   [NAMELEN+1];
     char ignore   [NAMELEN+1];
     char implied  [NAMELEN+1];
     char include  [NAMELEN+1];
     char link     [NAMELEN+1];
     char linktype [NAMELEN+1];
     char lpd      [NAMELEN+1];
     char md       [NAMELEN+1];
     char ms       [NAMELEN+1];
     char name     [NAMELEN+1];
     char names    [NAMELEN+1];
     char ndata    [NAMELEN+1];
     char nmtoken  [NAMELEN+1];
     char nmtokens [NAMELEN+1];
     char nonsgml  [NAMELEN+1];
     char notation [NAMELEN+1];
     char number   [NAMELEN+1];
     char numbers  [NAMELEN+1];
     char nutoken  [NAMELEN+1];
     char nutokens [NAMELEN+1];
     char pcdata   [NAMELEN+1];
     char pi       [NAMELEN+1];
     char public   [NAMELEN+1];
     char rcdata   [NAMELEN+1];
     char re       [NAMELEN+1];
     char required [NAMELEN+1];
     char rs       [NAMELEN+1];
     char sdata    [NAMELEN+1];
     char sgml     [NAMELEN+1];
     char shortref [NAMELEN+1];
     char space    [NAMELEN+1];
     char starttag [NAMELEN+1];
     char subdoc   [NAMELEN+1];
     char syntax   [NAMELEN+1];
     char system   [NAMELEN+1];
     char tab      [NAMELEN+1];
     char temp     [NAMELEN+1];
     char text     [NAMELEN+1];
     char uselink  [NAMELEN+1];
     char usemap   [NAMELEN+1];
};
struct sintax {
     struct keywords k;
};
extern struct sintax syn;     /* Reserved names, concrete syntax constants. */
/******************************************************************************/
