/******************************************************************************/
/* SGMLSUBS: Subroutines for SGML APIs.  Must be "included" in SGMLAPI?.C.    */
/******************************************************************************/
void alset(struct ad *);      /* Set up to start processing att list. */
void setndata(PNE);           /* Build ext data entity rcbde with entity text.*/
/******************************************************************************/
static struct ad *alptrsv;    /* Save pending (tag or link) att list.        */
static UNCH *docentid;        /* System identifier of SGML document entity.  */
/******************************************************************************/
/* ALSET: Prepares for ALNEXT processing of tag or data attribute list.
*/
VOID alset(al)
struct ad *al;                /* Attribute list (NULL=tag or link atts). */
{
     if (al) {                /* Non-null means data attributes. */
          alptrsv = alptr;    /* Save pending (tag or link) att list. */
          alptr = al;         /* Data attribute list is now current. */
          te.pca = &de.ca;    /* Current attribute structure in rcbde. */
     }
     CA.aln = 0;              /* Index of attribute to process. */
     CA.idrn = 0;             /* No IDREF(S) tokens as yet. */
     CA.entityn = 0;          /* No AENTITY(S) tokens as yet. */
}
/******************************************************************************/
/* ALNEXT: Transfers next attribute list entry to global variables.
           Returns 1 if there is yet another entry; 0 if all done.
*/
int alnext(void)
{
     if ((CA.aln += BITON(ADFLAGS(CA.aln), AGROUP) ? ADNUM(CA.aln)+1 : 1)>ADN) {
          if (te.pca==&de.ca) {
               alptr = alptrsv;    /* Restore pending (tag or link) att list. */
               te.pca = &te.ca;    /* Current attribute structure in rcbte. */
          }
          return(0);
     }
     CA.aname = ADNAME(CA.aln);
     CA.anamelen = *(CA.aname-1)-2;
     CA.aflags = ADFLAGS(CA.aln);       /* For validator only. */
     if (ADVAL(CA.aln)==NULL)           /* No value specified. */
          CA.astatus = GET(CA.aflags, AINVALID) ? TPANOREQ : TPAIMPLY;
     else {
          CA.aval = ADVAL(CA.aln)+1;
          CA.avallen = *(CA.aval-1)-2;
          CA.aconref = (UNS)(GET(CA.aflags, ACONREF));
          CA.adata = TPANONE;           /* Assume no special data. */
          if (ADTYPE(CA.aln)<ATKNLIST) {/* Value is a string or token. */
               CA.atype = (ADTYPE(CA.aln)==ACHARS) ? TPACDATA : TPATOKEN;
               if (ADTYPE(CA.aln)==ANOTEGRP) {
                    CA.adata = TPANOTE;
                    CA.dcnid = ((char *)ADDATA(CA.aln).x)+1;
                    CA.dcnidlen = *(CA.dcnid)-2;
               }
               else if (ADTYPE(CA.aln)==AENTITY) CA.adata = TPAENTIT;
               else if (ADTYPE(CA.aln)==AIDREF)  CA.adata = TPAIDREF;
          }
          else {              /* Value is a list of one or more tokens. */
               CA.atype = TPALIST;
               CA.avn = 0;
               CA.tn = 0;
               if (ADTYPE(CA.aln)==AENTITYS) CA.adata = TPAENTIT;
               else if (ADTYPE(CA.aln)==AIDREFS) CA.adata = TPAIDREF;
          }
          if (GET(CA.aflags, AERROR)) CA.astatus = TPAERROR;
          else if (GET(CA.aflags, AINVALID)) CA.astatus = TPAINVAL;
          else CA.astatus = TPAOK;      /* Specified attribute value is o.k. */
     }
     if (!TPisVM) CA.aflags = 0;        /* Flags are for validator only. */
     return(1);
}
/******************************************************************************/
/* AVNEXT: Transfers next attribute value token to global variables.
           The number of tokens is in ADNUM(CA.aln).
           Returns 1 if there is yet another entry; 0 if all done.
*/
int avnext(void)
{
     if (++CA.tn>ADNUM(CA.aln)) return(0);
     CA.tokenlen = *(CA.aval+CA.avn);
     CA.token = CA.aval+CA.avn+1;
     CA.avn += CA.tokenlen+1;
     return(1);
}
/******************************************************************************/
/* IDRNEXT: Sets idrstat global variable for current IDREF token.
*/
VOID idrnext(void)
{
     CA.idrstat = (int)IDRHIT(++CA.idrn);
}
/******************************************************************************/
/* GETENT: Sets up global variables for a data entity.
           Returns:
               3 if entity is internal SDATA;
               2 if entity is internal CDATA;
               1 if entity is NDATA;
              -1 if entity is not defined;
              -2 if not CDATA, SDATA, or NDATA;
              -3 if entity name is too long.
*/
int getent(
UNS enmlen,                   /* Length of GI of element (without EOS). */
UNCH *ename)                  /* GI of element (EOS optional). */
{
     if ((*pd = (char)enmlen+2)>NAMELEN+2) return(-3);
     memcpy(pd+1, ename, enmlen);
     *(pd+*pd-1) = EOS;
     it.itnm = pd;             /* Entity name (len+EOS). */
     it.ipbtype = ENTGET; sgml(itlpu);  /* Retrieve entity information. */
     switch (src) {
     case 1:                       /* External NDATA entity. */
          setndata((PNE)it.itp1);
          break;
     case 2:                       /* Internal CDATA entity. */
     case 3:                       /* Internal SDATA entity. */
          de.detype = src-1;       /* Data entity type. */
          de.ename = pd+1;         /* Current entity name. */
          de.enamelen = *pd-2;
          de.detxt = ((char *)it.itp1)+1;    /* Entity text. */
          de.detxtlen = *(de.detxt-1)-2;
          break;
     }
     return(src);                  /* Return with error code or entity type. */
}
/******************************************************************************/
/* SETNDATA: Set system ID and notation for NDATA entity reference in
             global variables for text processor use.
*/
VOID setndata(
PNE p)                        /* Pointer to data entity control block. */
{
     de.detype = NEXTYPE(p) + TPISDATA;   /* Data entity type. */
     de.ename = NEENAME(p)+1;             /* Current entity name. */
     de.enamelen = *(de.ename-1)-2;
     de.detxt = ((char *)NEID(p))+1;      /* Entity system ID. */
     de.detxtlen = *(de.detxt-1)-2;
     de.dcnnm = NEDCN(p)+1;               /* Data content notation name. */
     de.dcnnmlen = *(de.dcnnm-1)-2;
     de.dcnid = ((char *)NEDCNID(p))+1;   /* Notation system ID. */
     de.dcnidlen = *(de.dcnid-1)-2;
     if (NEAL(p)) {           /* Data attributes will be processed. */
          de.alcnt = AN;      /* Indicate number of attributes in list. */
          alset(NEAL(p));     /* Initialize for alnext processing. */
     }
     else de.alcnt = 0;       /* No data attributes for this entity. */
}
/******************************************************************************/
/* DOCENT: Initialize the SGML document entity.
           Returns: 1 if entity system ID is too long; 0 if o.k.
*/
int docent(
UNCH *sysid)                  /* System identifier of document entity. */
{
     if ((*pd = (char)(strlen(sysid)+1))>LITLEN+1) return(1);
     memcpy( pd+1 , sysid, (UNS)*pd );
     ++*pd;
     docentid = savestr(pd);  /* File identifier (len+EOS). */
     return(0);
}
/******************************************************************************/
/* GISET: Stores data for start- and end-tags of an element.
          Returns 0 if o.k.; 1 if element is not defined.
*/
int giset(
UNCH *gi,                     /* GI of element. */
UNIV start,                   /* Data for start-tag. */
UNIV end)                     /* Data for end-tag. */
{
     it.itnm = gi;            /* Document type GI. */
     it.itp1 = start;         /* GIDATA for start-tag. */
     it.itp2 = end;           /* GIDATA for end-tag. */
     it.ipbtype = GISET; sgml(itlpu);  /* Store GIDATA. */
     return(src);             /* Report results. */
}
/******************************************************************************/
/* SGMLOSET: Performs SGML initialization for option processing.
*/
void sgmloset(void)
{
     te.passes = 1;           /* Number of passes requested. */
     tpsw.swenttr = 1;        /* 1=trace entity stack in error messages; 0=no.*/
     tpsw.swbufsz = readcnt+2;/* SGML file read buffer size. */
}
/******************************************************************************/
/* SGMLOPT: Processes a TP option argument if it is one of the standard ones
            supported by the interface.  They are:
                  /d /e /f /g /mSGML.MSG /p1 /r /t3
            Other arguments are returned intact to the TP, as they may
            be valid arguments for the application.
*/
UNCH *sgmlopt(
UNCH *arg)                    /* Current argument in argv. */
{
          switch (toupper((int)arg[1])) {
          case 'D':           /* Report duplicate entity declarations. */
               tpsw.swdupent = 1;
               return(0);
          case 'E':           /* Suppress entity stack trace in error msg. */
               tpsw.swenttr = 0;
               return(0);
          case 'F':           /* Files located in current directory only. */
               cdirsw = 1;
               return(0);
          case 'G':           /* Suppress GI stack trace in error messages. */
               eltrsv = 0;
               return(0);
          case 'M':           /* Message file identifier. */
               msgfptr = &arg[2];
               return(0);
          case 'P':           /* Number of passes desired: 1 or more. */
               if ((te.passes = atoi(&arg[2]))==0) break;
               return(0);
          case 'R':           /* Give warning for defaulted references. */
               tpsw.swrefmsg = 1;
               return(0);
          case 'T':           /* Don't trim final RE of file or prefix RS. */
               if ((boundsw = (int)arg[2])>'3' || boundsw<'0') break;
               return(0);
          }
          return(arg);        /* Erroneous option argument. */
}
/******************************************************************************/
/* SGMLSET: Performs SGML initialization and other housekeeping for the run.
*/
void sgmlset(void)
{
     tpsw.swetdtag = 0;       /* Return on all tags, even if no user data. */
     tpsw.delcdata = '\35';   /* 29 Delimiters: CDATA entity in att value. */
     tpsw.delsdata = '\36';   /* 30 Delimiters: SDATA entity in att value. */
     tpsw.delnonch = '\37';   /* 31 Prefix: non-SGML character. */
     tpsw.addnonch = 64;      /* Addend: added to non-SGML char (mod 256). */
     msginit();                    /* Load error messages. */
     tpsw.src = &src;              /* TP addr for SGMLSERV to put return code.*/
     tpsw.srcbp = &srcbp;          /* TP addr for SGML to put rcb ptr. */
     itlpu = &it;                  /* Create it ipb LPU to pass to SGML. */
     it.itp1 = (UNIV)&tpsw;        /* Parser control switches. */
     it.ipbtype = SGMLSET; sgml(itlpu);   /* Initialize the run. */
     /* Pointer to markup string array was returned in srcbp. */
}
/******************************************************************************/
/* SGMLPSET: Initialize the pass and open the SGML document entity.
             Returns: <0 if entity could not be opened; 0 if o.k.
*/
int sgmlpset(void)
{
     it.itl1 = te.pass;       /* Identify current pass: 1 to passes. */
     it.ipbtype = SGMLRSET; sgml(itlpu);   /* Initialize the pass. */

     tpts = 0;                /* Initialize element structure stack. */
     tpes = 1;                /* Initialize entity structure stack. */

     it.itl1 = (UNS)*docentid;
     it.itp1 = docentid;      /* File identifier (len+EOS). */
     it.ipbtype = ENTPRIME; sgml(itlpu);  /* Open document entity. */
     return (src);
}
/******************************************************************************/
/* SGMLEND: Performs SGML final cleanup and transfers capacity statistics
            to a local structure.
*/
UNS sgmlend(void)
{
     it.ipbtype = SGMLEND; sgml(itlpu);    /* Final cleanup. */
     /* Pointer to statistics is now in srcbp: save it. */
     return (cnterr);
}
/******************************************************************************/
