/******************************************************************************/
/* SGMLMAIN: Main interface to SGML services.

               "Good fences make good neighbors." -- Robert Frost

Preprocessor variable names are the only supported interface
to data maintained by SGML.  They are defined in this file or in adl.h.
The data is READ ONLY, and will last only until the next call to SGML,
SGMLSET, SGMLRSET, or SGMLEND.
*/
/******************************************************************************/
/* Definitions for members of SGML return control blocks (RCBs).
   The symbols RFD and RFT must be defined before including this file; e.g:
     RFD (*(struct rcbdata *)srcbp)
     RFT (*(struct rcbtag  *)srcbp)
*/
/* Datatype abbreviations: C=unsigned char  S=string  U=unsigned int L=4 bytes
                           A=array  P=ptr to structure N=name (see sgmlcb.h)
*/
/* Data control block fields: processing instructions (rcbtype==SGMLPIS).
*/
#define PDATA RFD.data            /*S  PI string. */
#define PDATALEN RFD.datalen      /*U  Length of PI string. */
#define PIESW ((RFD.contersw & 4))/*U  1=PIDATA entity returned. */
/* Data control block fields: other data types.
*/
#define CDATA RFD.data            /*S  CDATA content string. */
#define CDATALEN RFD.datalen      /*U  Length of CDATA content string. */
#define CONTERSW ((RFD.contersw &1)) /*U  1=CDATA or TAG out of context. */
#define CDESW ((RFD.contersw & 2))/*U  1=CDATA entity returned. */
#define SDESW ((RFD.contersw & 4))/*U  1=SDATA entity returned. */
#define NDESW ((RFD.contersw & 8))/*U  1=NDATA entity returned. */
#define NEPTR ((PNE)RFD.data)     /*P  Ptr to NDATA entity control block. */
#define MARKUP RFD.data           /*A  Markup delimiter strings. */
#define DTYPELEN RFD.datalen      /*U  Length of doc type name + len+EOS. */
#define DOCTYPE RFD.data          /*S  Document type name (with len+EOS). */
#define SGMLSCBS RFD.sgmlscbs     /*A  SGML source control block stack. */
#define SGMLES   RFD.sgmles       /*I  Index of current source in scbs. */
#define RCBTYPE  RFD.rcbtype      /*U  Return control block type. */
/* Tag control block fields.
*/
#define ALPTR (RFT.ru.al)         /*P  Ptr to SGML attribute list. */
#define AENTL   (RFT.aentl)       /*P  ECBs ordered by AENTITY(S) tokens in al*/
#define GI      (RFT.curgi+1)     /*N  GI of started or ended element. */
#define GIDATA RFT.gidata         /*L  User data for GI. */
#define OLDGI   (RFT.ru.oldgi)    /*S  GI of resumed element. */
#define IDRHIT(n)(BITNIS(RFT.idrefl,n))/*L Nth IDREF token in AL:ID exists.*/
#define TAGMIN  RFT.tagmin        /*U  Minimization for current tag. */
#define TAGREAL (RFT.tagreal)     /*P  Dummy etd that implied this tag. */
#define TAGRLNM ((UNCH *)RFT.tagreal)  /*P GI of tag that implied this tag.*/
#define ETISW ((RFT.contersw & 2))/*U  1=NET delimiter enabled by ETI. */
#define PEXSW ((RFT.contersw & 4))/*U  1=Element was plus exception. */
#define MTYSW ((RFT.contersw & 8))/*U  1=Element is empty. */
#define ETICTR  (RFT.etictr)      /*U  Number of active NET delimiters. */
#define SRMNM  (RFT.srmnm)        /*S  Name of current SHORTREF map. */
#define SRMCNT (RFT.contersw)     /*U  Number of SHORTREF maps defined. */
#define FORMAT (RFT.format)       /*U  Format class for default processing.*/
/******************************************************************************/
