/******************************************************************************/
/* SGMLAPI.H: Codes for communication between a text processor (TP)
              and SGML parser services.
*/
/******************************************************************************/
/* Return codes from SGMLNEXT.
*/
#define TPPCDATA  1           /* Parsed character data found. */
#define TPEOD     2           /* End of document. */
#define TPETAG    3           /* End-tag. */
#define TPPI      4           /* Processing instruction. */
#define TPPIENT   5           /* Processing instruction entity. */
#define TPRE      6           /* Significant record end. */
#define TPSTAG    7           /* Start-tag. */
#define TPCDATA   8           /* Declared character data found. */
#define TPNDATA   9           /* Non-SGML data entity reference. */
#define TPSDATA  10           /* System data entity reference. */
#define TPNSGML  11           /* Non-SGML character reference. */
/* The following are for housekeeping only; not supported for users. */
#define TPMV     12           /* Markup validator information. */
#define TPSDTD   13           /* Document type definition started. */
#define TPEDTD   14           /* Document type definition ended. */
/******************************************************************************/
/* astatus: Attribute specification status codes set by ALNEXT.
*/
#define TPAOK     0           /* Specified value had no errors. */
#define TPAIMPLY  1           /* Impliable attribute not specified. */
#define TPANOREQ  2           /* Required attribute not specified. */
#define TPAERROR  3           /* Specified value had syntax error. */
#define TPAINVAL  4           /* Specified value had value error. */
/******************************************************************************/
/* atype: Attribute type codes set by ALNEXT.
*/
#define TPACDATA  0           /* Value is (possibly empty) character string. */
#define TPATOKEN  1           /* Value is a single token. */
#define TPALIST   2           /* Value is a list of one or more tokens. */
/******************************************************************************/
/* adata: Attribute codes set by ALNEXT when additional data is present.
*/
#define TPANONE   0           /* No additional data for this attribute. */
#define TPANOTE   1           /* Data content notation: system ID. */
#define TPAENTIT  2           /* External entity: system ID, dcn, att list. */
#define TPAIDREF  3           /* ID reference: valid/invalid.*/
/******************************************************************************/
/* Internal/external entity types for detype member of rcbde structure. */
#define TPICDATA  1           /* Internal character data entity. */
#define TPISDATA  2           /* Internal specific character data entity. */
#define TPECDATA  3           /* External character data entity. */
#define TPENDATA  4           /* Non-SGML data entity. */
#define TPESDATA  5           /* External specific character data entity. */
#define TPESUB    6           /* SGML subdocument entity (NOT SUPPORTED). */
/******************************************************************************/
/* Public variables allocated by SGMLAPI.C for use by a text processor (TP).  */
/*       THESE ARE READ-ONLY!!!!!  MODIFICATIONS CAN CAUSE GREAT GRIEF!!!!!   */
/******************************************************************************/
#define CA (*(te.pca))        /* Active current att rcb: tag/link or data.    */
/******************************************************************************/
struct rcbca {                /* RCB for current attribute information. */
     char    *aname;          /* Current attribute name. */
     unsigned anamelen;       /* Length of current attribute name. */
     char    *aval;           /* Current attribute value. */
     unsigned avallen;        /* Length of attribute value. */
     unsigned astatus;        /* Attribute status: implied, default, etc. */
     unsigned atype;          /* Attribute type: string, token, or list. */
     unsigned adata;          /* Attribute data: none, dcn, entity, ID ref. */
     unsigned aconref;        /* Explicit content reference? 1=yes 0=no. */
     char    *token;          /* Current token in tokenized value (no EOS). */
     unsigned tokenlen;       /* Length of current token in tokenized value. */
     unsigned idrstat;        /* ID reference status: 1=valid; 0=undefined. */
     char    *dcnid;          /* Notation attribute system identifier. */
     unsigned dcnidlen;       /* Length of notation identifier. */
     /* The following are for housekeeping only; not supported for users. */
     char     aflags;         /* Added attribute info (e.g.: defaulted?) */
     unsigned aln;            /* Next attribute list member to process. */
     unsigned avn;            /* Offset of next att value token to process. */
     unsigned tn;             /* Number of next value token to process. */
     unsigned entityn;        /* Current number of AENTITY(S) in att list.*/
     unsigned idrn;           /* Current number of IDs referenced in att list.*/
};
struct rcbte {                /* RCB for calls to SGMLAPI. */
     int passes;              /* Number of passes requested. */
     int pass;                /* Current pass. */
     unsigned datalen;        /* Length of returned data. */
     char *data;              /* Returned data: data, GI, PI, etc. */
     char nonsgml;            /* Actual (unshifted) non-SGML character. */
     unsigned alcnt;          /* Number of attributes in list; 0=no list. */
     struct rcbca *pca;       /* Active rcbca: tag/link or data entity. */
     struct rcbca ca;         /* Return control block: current tag attribute.*/
     void *gidata;            /* User data for GI. */
#ifdef V2
     unsigned format;         /* Default format type for element. */
#endif
};
struct rcbde {                /* RCB for current data entity description. */
     char    *ename;          /* Current entity name. */
     unsigned enamelen;       /* Length of current entity name. */
     unsigned detype;         /* Data entity type: int C/S; ext C/S/N/SUBDOC. */
     char    *detxt;          /* Internal text or external system identifier. */
     unsigned detxtlen;       /* Length of data entity text or system ID. */
     char    *dcnnm;          /* Data content notation name. */
     unsigned dcnnmlen;       /* Length of notation name. */
     char    *dcnid;          /* Data content notation system identifier. */
     unsigned dcnidlen;       /* Length of notation identifier. */
     unsigned alcnt;          /* Number of attributes in list; 0=no list. */
     struct rcbca ca;         /* Return control block: current data attribute.*/
};
/******************************************************************************/
extern struct rcbde de;       /* RCB for current data entity information. */
extern struct rcbte te;       /* RCB for calls to SGMLAPI. */
extern char sgmlomsg[];       /* Text for invalid option error message. */
/******************************************************************************/
/* SGMLAPI function library
*/
/******************************************************************************/
char *sgmlopt(char *);        /* Process a supported parser option argument. */
void sgmloset(void);          /* Initialize for SGML option processing. */
void sgmlset(void);           /* Initialize the parser for the run. */
int docent(unsigned char *);  /* Initialize the SGML document entity. */
int sgmlpset(void);           /* Initialize pass; open document entity. */
int sgmlnext(void);           /* Get next SGML event: data, tag, etc. */
unsigned int sgmlend(void);   /* Terminate SGML processing. */
int alnext(void);             /* Process next attribute in list. */
void idrnext(void);           /* Process IDREF or IDREFS token in value. */
/******************************************************************************/
/*lint +fvr                      Returned value may be ignored. */
int avnext(void);             /* Process next token in attribute value. */
int getent(unsigned, char *); /* Build data entity rcbde with entity name. */
int giset(char *,void *,void *); /* Save user data for an element. */
/*lint -fvr                      Restore normal LINT processing. */
/******************************************************************************/
/* Environment and compiler function libraries
*/
/******************************************************************************/
#include <stdio.h>            /* Stream I/O functions. */
#include <stdlib.h>           /* Common types, variables, and functions. */
#include <string.h>           /* Memory and string functions. */
void location(int);           /* SGMLMSG: print file location in message. */
/******************************************************************************/
