/******************************************************************************/
/* Struct dcncb: attribute list added to support data attributes.             */
/******************************************************************************/
#ifndef ENTITY_H              /* Don't include this file more than once. */
#define ENTITY_H
/******************************************************************************/
/* ENTITY.H: Definitions and control block templates for entity management.
*/
#include "tools.h"            /* Definitions for type declarations, etc. */
/* SGML Character Use
*/
#define EOFCHAR   '\032'      /* FUNCTION: EE (entity end: files). */
#define EOS         '\0'      /* NONCHAR: EE (entity end: strings). */
#define EOBCHAR   '\034'      /* NONCHAR: EOB (file entity: end of buffer. */
#define RSCHAR    '\012'      /* FUNCTION: RS (record start). */
#define RECHAR    '\015'      /* FUNCTION: RE (record end). */
#define TABCHAR   '\011'      /* FUNCTION: TAB (horizontal tab). */
#define SPCCHAR   '\040'      /* FUNCTION: SPACE (horizontal space). */

/* SGML Naming Rules
*/
#define ENTCASE       0       /* 1=case translation of entity names; 0=no. */
#define NAMECASE      1       /* 1=case translation of non-entity names; 0=no.*/
#define AVALCASE      2       /* 2=untranslated string of name characters. */

/* SGML Reference Quantity Set
*/
#define ATTCNT       40       /* Att names & name tokens in an att def. */
#define ATTSPLEN    960       /* Length: attribute specification.*/
#define BSEQLEN     960       /* Length: blank/space sequence.*/
#define CAPACITY  35000L      /* Capacity points allowed in document. */
#define DTAGLEN      16       /* Length: data tag in document. */
#define DTEMPLEN     16       /* Length: data tag/pat template (less delims). */
#define ENTLVL       16       /* Level: nested entities (less primary). */
#define GRPCNT       32       /* Tokens in a group or model. */
#define GRPGTCNT     96       /* Grand total: tokens at all lvls of model grp.*/
#define GRPLVL       16       /* Nested level of model grps (including 1st). */
#define LITLEN      240       /* Length: literal, del att value (less delims).*/
#define NAMELEN       8       /* Length of name, name token, number, etc.. */
#define NORMSEP       2       /* Length: separator for normalized lengths. */
#define PILEN       240       /* Length: processing instruction (less delims).*/
#define TAGLEN      960       /* Length: start-tag as entered (with delims). */
#define TAGLVL       24       /* Level: nesting of open elements (tag stack).*/

/* Minimization status of returned tags.
*/
#define MINNONE 0             /* Minimization: tag not minimized. */
#define MINNULL 1             /* Minimization: tag was null. */
#define MINNET  2             /* Minimization: end-tag was NET delimiter. */
#define MINDATA 3             /* Minimization: end-tag was data tag. */
#define MINSTAG 4             /* Minimization: tag implied by start-tag. */
#define MINETAG 5             /* Minimization: end-tag implied by end-tag. */

/* Formal public identifier public text classes.
*/
#define FPICAP         1
#define FPICHARS       2
#define FPINOT         3
#define FPISYN         4
#define FPICMINV       5      /* Minimum fpic value for versionable text. */
#define FPIDOC         5
#define FPIDTD         6
#define FPIELEM        7
#define FPIENT         8
#define FPILPD         9
#define FPINON        10
#define FPISHORT      11
#define FPISUB        12
#define FPITEXT       13
struct fpi {                  /* Formal public identifier. */
     UNCH fpiot;              /* Owner type: + or - or ! (for ISO). */
     UNCH fpiol;              /* Length of owner identifier. */
     int fpio;                /* Offset in pubis of owner identifier (no EOS).*/
     int fpic;                /* Public text class. */
     UNCH fpitt;              /* Text type: - or + (for available). */
     UNCH fpitl;              /* Length of text identifier. */
     int fpit;                /* Offset in pubis of text identifier (no EOS). */
     UNCH fpil[2];            /* Public text language. */
     UNCH fpivl;              /* Length of display version . */
     int fpiv;                /* Offset in pubis of display version (no EOS). */
     int fpiversw;            /* 1=use best ver; 0=use stated ver; -1=error. */
     UNCH fpinml;             /* Length of entity name. */
     UNCH fpinm[NAMELEN+2];   /* Entity/DCN name (length & EOS). */
     UNCH fpistore;           /* 1=NDATA 2=general 3=parm 4=DTD 5=LPD 6=DCN. */
     UNCH fpipubl;            /* Length of public ID string. */
     UNCH fpipubis[LITLEN+2]; /* Public ID string (length & EOS). */
     UNCH fpisysl;            /* Length of system ID string. */
     UNCH fpisysis[LITLEN+2]; /* System ID string (length & EOS). */
};
#define FPISZ sizeof(struct fpi)
typedef struct fpi *PFPI;     /* Ptr to FPI control block. */

/* General control blocks.
*/
#define NONONCH 1             /* Character references to non-chars invalid. */
#define OKNONCH 0             /* Character references to non-chars allowed. */
struct parse {                /* Parse control block. */
     UNCH   *pname;           /* Parse name; content, tag, etc. */
     UNCH   *plex;            /* Lexical analysis table. */
     UNCH   **ptab;           /* State and action table. */
     UNS    state;            /* State. */
     UNS    input;            /* Input. */
     UNS    action;           /* Action. */
     UNS    newstate;         /* Next state. */
};
struct restate {
     UNS   sstate;            /* State. */
     UNS   sinput;            /* Input. */
     UNS   saction;           /* Action. */
     UNS   snext;             /* Next state. */
};
struct map {
     UNCH   *mapnm;           /* Name followed by EOS. */
     int    mapdata;          /* Data associated with that name. */
};
struct hash {                 /* Dummy structure for function arguments. */
     struct hash *enext;      /* Next entry in chain. */
     UNCH ename [NAMELEN+2];  /* Entry name with size and EOS. */
};
typedef struct hash *PHASH;   /* Ptr to hash table entry. */
typedef struct hash **THASH;  /* Ptr to hash table. */

struct loc {                  /* Location where ID or IDREF was found. */
     struct loc *lnext;       /* Pt to next location in chain. */
     UNCH *letdgi;            /* Element type (GI). */
     UNCH *lename;            /* Entity name. */
     UNS lrcnt;               /* Source record number. */
     UNS lccnt;               /* Source record chars since last RS. */
     UNIV lfile;              /* DOS fileid if external, else NULL. */
};
#define LOCSZ sizeof(struct loc)

struct dcncb {                /* Data content notation control block. */
     /*l nt -e18                 Suppress duplicate definition msg. */
     struct dcncb *enext;     /* Next DCN in chain. */
     UNCH ename[NAMELEN+2];   /* Notation name followed by EOS. */
     /*l nt +e18                 Restore duplicate definition msg. */
     UNIV dcnid;              /* DOS ID of full notation identifier. */
     struct ad *adl;          /* Data attribute list (NULL if none). */
};
#define DCBSZ sizeof(struct dcncb)
typedef struct dcncb *PDCB;   /* Ptr to DCN control block. */

struct stat {                 /* Document statistics. */
     long capused;            /* Total: NAMELEN*cnt + 1*chars (not counterr). */
     long capacity;           /* Capacity points allowed in document. */
     UNS counterr;            /* ** MOVED TO TP ** Number of errors reported. */
     UNS dcncnt;              /* Number of data content notations defined. */
     UNS pmexgcnt;            /* Number of plus or minus exception groups. */
     UNS etdcnt;              /* Number of element types declared. */
     UNS etdercnt;            /* Number of element types defined by default. */
     UNS pmexcnt;             /* Number of plus/minus exception grp members. */
     UNS modcnt;              /* Number of content model tokens defined. */
     UNS attcnt;              /* Number of attributes defined. */
     UNS attdef;              /* Characters of attribute defaults defined. */
     UNS attgcnt;             /* Number of att value grp members (incl dcn). */
     UNS idcnt;               /* Number of ID attributes specified. */
     UNS idrcnt;              /* Number of ID references specified. */
     UNS ecbcnt;              /* Number of entities declared. */
     UNS ecbtext;             /* Characters of entity text defined. */
     UNS srcnt;               /* Number of short reference tables defined. */
     UNS dcntext;             /* Characters of notation identifiers defined. */
};
struct switches {             /* Parser control switches (1=non-standard). */
     int swetdtag;            /* 1=return only for tags with user data; 0=all.*/
     int swdupent;            /* 1=msg if duplicate ENTITY def attempted;0=no.*/
     int swcommnt;            /* 1=return comment declarations as data; 0=no. */
     int swrefmsg;            /* 1=msg if undeclared ref is defaulted; 0=no. */
     UNS swbufsz;             /* Size of source file buffer for READ(). */
     UNCH deleob;             /* Delimiter: end of block (IGNORED: 28 used). */
     UNCH deleof;             /* Delimiter: end of file (IGNORED: 26 used). */
     UNCH delcdata;           /* Delimiters: CDATA entity in att value. */
     UNCH delsdata;           /* Delimiters: SDATA entity in att value. */
     UNCH delnonch;           /* Prefix: non-SGML character. */
     UNCH addnonch;           /* Addend: added to non-SGML char (mod 256). */
     int *src;                /* Return code from call to SGML services. */
     UNIV *srcbp;             /* Ptr to SGML's RCB/IPB. */
     int swenttr;             /* 1=trace entity stack in error messages; 0=no.*/
     UNCH swproc[NAMELEN+2];  /* Link process name (IGNORED). */
};
struct markup {               /* Delimiter strings for text processor. */
     char *cro;               /* LEXCON markup string: CRO        */
     char *dso;               /* LEXCON markup string: DSO        */
     char *ero;               /* LEXCON markup string: ERO        */
     char *etag;              /* LEXMARK markup string: end-tag   */
     char *lit;               /* LEXMARK markup string: LIT       */
     char *lita;              /* LEXMARK markup string: LITA      */
     char *mdc;               /* LEXCON markup string: MDC       */
     char *mdo;               /* LEXCON markup string: MDO       */
     char *mse;               /* LEXCON markup string: mse        */
     char *mss;               /* LEXCON markup string: mss        */
     char *mssc;              /* LEXCON markup string: mss CDATA  */
     char *mssr;              /* LEXCON markup string: mss RCDATA */
     char *pic;               /* LEXCON markup string: PIC        */
     char *pio;               /* LEXCON markup string: PIO        */
     char *refc;              /* LEXGRP markup string: REFC       */
     char *stag;              /* LEXMARK markup string: start-tag */
     char *tagc;              /* LEXMARK markup string: TAGC      */
     char *vi;                /* LEXMARK markup string: VI        */
     int lennet;              /* LEXMARK markup string length: null end-tag. */
     int lennst;              /* LEXMARK markup string length: null start-tag.*/
};
/******************************************************************************/
#endif /* ndef ENTITY_H */
/******************************************************************************/
