/******************************************************************************/
/* Extended struct ne to support C/S/NDATA and entity name.                   */
/******************************************************************************/
/* ADL.H: Definitions for attribute descriptor list processing.
*/
/* N/C/SDATA external entity types for nxetype member of ne structure. */
#define ESNCDATA    1         /* External character data entity. */
#define ESNNDATA    2         /* Non-SGML data entity. */
#define ESNSDATA    3         /* External specific character data entity. */
#define ESNSUB      4         /* SGML subdocument entity. */

/* N/C/SDATA control block for AENTITY attributes and NDATA returns.*/
struct ne {                   /* N/C/SDATA entity control block. */
     UNIV neid;               /* System file identifier of NDATA entity. */
     PDCB nedcn;              /* Data content notation control block. */
     struct ad *neal;         /* Data attribute list (NULL if none). */
     UNCH *neename;           /* Ptr to entity name (length and EOS). */
     UNCH nextype;            /* Entity type: NDATA SDATA CDATA SUBDOC. */
};
#define NESZ (sizeof(struct ne))
typedef struct ne *PNE;
/* NDATA entity control block fields. */
#define NEID(p) (((PNE)p)->neid)            /* System ID of NDATA entity. */
#define NEDCN(p) (((PNE)p)->nedcn->ename)   /* Data content notation name. */
#define NEDCNID(p) (((PNE)p)->nedcn->dcnid) /* Data content notation full ID.*/
#define NEDCNADL(p) (((PNE)p)->nedcn->dcnadl)/* Data content notation attlist.*/
#define NEENAME(p) (((PNE)p)->neename)      /* Entity name pointer. */
#define NEXTYPE(p) (((PNE)p)->nextype)      /* External entity type. */
#define NEAL(p) (((PNE)p)->neal)            /* Data attributes (if any). */

/* Attribute descriptor list entry. */
struct ad {
     UNCH adname[NAMELEN+2];  /* Attribute name with length and EOS. */
     UNCH adflags;            /* Attribute flags. */
     UNCH adtype;             /* Value type. */
     UNCH adnum;              /* Group size or member pos in grp. */
     UNCH adlen;              /* Length of default or value (for capacity). */
     UNCH *addef;             /* Default value (NULL if REQUIRED or IMPLIED). */
     union {
          PNE n;              /* AENTITY: NDATA control block. */
          UNIV x;             /* ANOTEGRP: external DOS identifier. */
     } addata;                /* Special data associated with some attributes.*/
};
#define ADSZ (sizeof(struct ad))   /* Size of an ad structure. */

/* Attribute flags for entire list adflags: ADLF. */
#define ADLREQ    0x80        /* Attribute list: 1=REQUIRED att defined. */
#define ADLNOTE   0x40        /* Attribute list: 1=NOTATION att defined. */
#define ADLCONR   0x20        /* Attribute list: 1=CONREF att defined. */

/* Attribute flags for list member adflags: ADFLAGS(n). */
#define AREQ      0x80        /* Attribute: 0=null; 1=required. */
#define ACURRENT  0x40        /* Attribute: 0=normal; 1=current. */
#define AFIXED    0x20        /* Attribute: 0=normal; 1=must equal default. */
#define AGROUP    0x10        /* Attribute: 0=single; 1=group of ad's. */
#define ACONREF   0x08        /* Attribute: 0=normal; 1=att is CONREF. */
#define AINVALID  0x04        /* Attribute: 1=value is invalid; 0=o.k. */
#define AERROR    0x02        /* Attribute: 1=error was specified; 0=o.k. */
#define ASPEC     0x01        /* Attribute: 1=value was specified; 0=default. */

/* Attribute types for adtype. */
#define ANMTGRP   0x00        /* Attribute: Name token group or member. */
#define ANOTEGRP  0x01        /* Attribute: Notation (name group). */
#define ACHARS    0x02        /* Attribute: Character string. */
#define AENTITY   0x03        /* Attribute: Data entity (name). */
#define AID       0x04        /* Attribute: ID value (name). */
#define AIDREF    0x05        /* Attribute: ID reference value (name). */
#define ANAME     0x06        /* Attribute: Name. */
#define ANMTOKE   0x07        /* Attribute: Name token. */
#define ANUMBER   0x08        /* Attribute: Number. */
#define ANUTOKE   0x09        /* Attribute: Number token. */
#define ATKNLIST  0x0A        /* Attribute: >= means value is a token list. */
#define AENTITYS  0x0A        /* Attribute: Data entities (name list). */
#define AIDREFS   0x0B        /* Attribute: ID reference value (name list). */
#define ANAMES    0x0C        /* Attribute: Name list. */
#define ANMTOKES  0x0D        /* Attribute: Name token list. */
#define ANUMBERS  0x0E        /* Attribute: Number list. */
#define ANUTOKES  0x0F        /* Attribute: Number token list. */

/* Field definitions for entries in an attribute list.
   The list must be declared as: struct ad listname[].
   The symbol AL must be defined as a list address before including
   this file.
*/
#define ADLF (AL[0].adflags)      /* Attribute list: flags. */
#define ADN (AL[0].adtype)        /* Attribute list: number of list members. */
#define AN (AL[0].adnum)          /* Attribute list: number of attributes. */
#define ADNAME(n) ((AL[n].adname+1))/* Nth attribute in list: name. */
#define ADNUM(n) (AL[n].adnum)    /* Nth att in list: number of values. */
#define ADFLAGS(n) (AL[n].adflags)/* Nth attribute in list: flags. */
#define ADTYPE(n) (AL[n].adtype)  /* Nth attribute in list: type. */
#define ADLEN(n) (AL[n].adlen)    /* Nth attribute in list: len of def or val.*/
#define ADVAL(n) (AL[n].addef)    /* Nth attribute in list: def or value. */
#define ADDATA(n) (AL[n].addata)  /* Nth attribute in list: special data. */
#define ADTOKEN(n,p)((AL[n].addef+(p)))/* Nth att: token at Pth pos in value. */

#define IDHASH 13             /* Est. 50 entries in ID hash table (itab). */
struct id {                   /* ID attribute control block. */
     struct id *idnext;       /* Next ID in chain. */
     UNCH idname[NAMELEN+2];  /* ID name with length prefix and EOS. */
     struct loc *idl;         /* Location where ID was found. */
     struct loc *idrl;        /* Ptr to chain of locations of IDREFs. */
};
#define IDSZ sizeof(struct id)
typedef struct id *PID;       /* Ptr to ID attribute control block. */
/******************************************************************************/
