/*  $Header: rules.g,v 3.0 88/04/14 08:35:52 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "att_chk.h"
#include "att_par.h"
#include "entity.h"
#include "keywords.h"
#include "lexical.h"
#include "modes.h"
#include "out.h"
#include "shortref.h"
#include "tags.h"
#include "cappoint.i"

extern String current_element_name;

#ifdef DEBUG
static Bool debug = FALSE;

void debug_rules(b)
Bool b;
{
	debug = b;
}
#endif
}

%start document, document_prolog;

%start f_sep1,        f_sep1;
%start f_sep2,        f_sep2;
%start sep1,          sep1;
%start sep2,          sep2;
%start xpcdata,       xpcdata;
%start att_spec_list, att_spec_list ;

f_sep1: sep1 TOK_XXX;
f_sep2: sep2 TOK_XXX;

sep1 : [%while(1) other_content]*  ;

sep2 : [%while(1) [other_content | s] ]*  ;

document_prolog { int tmp_ent = entcap, tmp_map = mapcap; } :
		{ entcap = 0; mapcap = 0; }
	[%while (1)
	    comment_decl
	  | processing_instr
          | s
	  | ent_decl
          | short_ref_mapping_decl
        ]*
		{ 
		  entcap *= NAMELEN; 
		  mapcap *= (NAMELEN + (32 * NAMELEN));
		  entcap += tmp_ent;    mapcap += tmp_map;
		  totalcap += entcap + entchcap + mapcap;
		  if (entcap > CAP_VAL) {
		     report(ER_CAPACITY, FATAL, 0, 0, "entcap", entcap);
		  }
		  if (entchcap > CAP_VAL)  {
		     report(ER_CAPACITY, FATAL, 0, 0, "entchcap",
			    entchcap);
		  }
		  if (mapcap > CAP_VAL)  {
		     report(ER_CAPACITY, FATAL, 0, 0, "mapcap", mapcap);
		  }
		  if (totalcap > CAP_VAL)  {
		     report(ER_CAPACITY, FATAL, 0, 0, "totalcap",
			    totalcap);
		  }
		  fatal_report();
		}
	document ;

other_content :
        [   comment_decl
          | short_ref_use_decl
	  | processing_instr
	  | TOK_SHORTREF
	      { switch_to_gen_entity(current_mapping(current_value())); }
	  | char_ref
	  | general_ent_ref
  	  | marked_sect_decl
	  | marked_sect_close
	  | TOK_EE
        ] ;

xpcdata(String str; int length; Bool echo; Bool *error;)
{
    char ch;
} :
        [
	  data_char(&ch)
	    {
		if( echo ){
		    out_char(ch);
		} else {
		    str[0] = ch;
		}
	    }
        ]
	pcdata(&(str[1]), length-1, echo, error)
    ;

pcdata(String str; int length; Bool echo; Bool *error;)
{
    int  i=0;
    char ch;
} :
      [%while(1)
        [
	  data_char(&ch)
	        { if( echo ) {
		      out_char(ch);
		  } else {
		     { if (!(*error)) { str[i] = ch; i++; } }
		  }
		}
        | other_content
        ]
                { if (!(*error) and (i > length)) {
                     if (echo) {
                         ch = str[i-1];
                         str[i-1] = '\0';
			 out_string(str);
                         str[0] = ch;
                         i = 1;
                     }
                     else {
                         str[i-1] = '\0';
                         *error = TRUE;
                     }
                  }   
                }
      ]*
              { if (!(*error)) str[i] = '\0';
                if( echo ){
		    out_string(str);
                    str[0] = '\0';
                }
              }  
    ;

att_spec_list
{
    char          name[NAMELEN + 1]  ;
    char          value[LITLEN + 1] ;
    P_Attdeflist  att_list;
    P_Attdef      att;
#ifdef DEBUG
    P_Att_iter    it;
#endif
    int           nr       = 0;
    int           attsplen = 0;
    int           taglen   = 0;

} :
	{ att_list = string_to_attrs(current_element_name);
	  taglen = strlen(current_element_name);
	}
	[ [%while(1) s]* 
	  [
		{ name[0] = '\0'; value[0] = '\0'; }
	    att_spec(name, value)
		{
		  int norm = 0;
		  if( name[0] == '\0' ){
		      att = attdef_value_lookup(att_list, value);
		  } else {
		      attsplen += strlen(name) + NORMSEP;
		      taglen += strlen(name) + 1;
		      att = attdef_name_lookup(att_list, name);
		      if( att == 0 /*ILL_ATTR*/ ){
			  report(ATTR_UNKNOWN, FATAL, 0, 0, name);
		      }
		  }
		  if( att != 0 /*ILL_ATTR*/ ){
		      check_attr(att_name(att), value,
				  att_declared_value(att), att_range(att), &nr);
		      norm = norm_val_length(value, att_declared_value(att));
		      if (norm > LITLEN) {
			 report(WAR_LITLEN, NOTFATAL, 0, 0, 
			        "normalized attribute value length",
				LITLEN);
		      }
		      attsplen += norm;
		      taglen += norm - nr * NORMSEP;
		      att_set_current_value(att, strsave(value));
		  }
		}
	  ]*
	  {
	    if (attsplen > ATTSPLEN) {
		 report(WAR_ATTSPLEN, NOTFATAL, 0, 0, current_element_name, ATTSPLEN);
	    }
	    if (taglen > TAGLEN) {
		 report(WAR_TAGLEN, NOTFATAL, 0, 0, current_element_name, TAGLEN);
	    }
#ifdef DEBUG
	    if (debug) {
	        it = attdef_iterator(att_list);
	        DEB1("Attributes for start-tag %s\n", current_element_name);
	        while( att = att_next(it) ){
		    fprintf(fpdg, "%20s, %20s",
		            att_name(att), key_str(att_declared_value(att)));
		    if (att_current_value(att))
		        fprintf(fpdg, "%20s\n", att_current_value(att));
		    else
		        fprintf(fpdg, "`nil'\n");
	        }
	    }
#endif
	  }
	] ;

att_spec(String name; String value;) :
        [
	  name_token(value, FALSE)
	  [%while(1) s]*
	  [
		  { if (NAMECASE_GENERAL) to_upper(value);
		    strcpy(name, value);
		  }
	      TOK_VI   s*
	      [  name_token(value, FALSE)
	       | Xatt_val(value)  { att_change_s(value); }
	      ]
	  ]?
	  s*
	] ;

Xatt_val(String str;) { Bool error = FALSE; } :
	[ [ TOK_LIT		{ enter_mode(MODE_LIT_ERO); }
	    rcdata(str, LITLEN, FALSE, &error)
			{ if (error)
			     report(WAR_LITLEN, NOTFATAL, 0 ,0,
				    "attribute value length", LITLEN);
			}
	    TOK_LIT		{ leave_mode(); }
	  ]
	| [ TOK_LITA		{ enter_mode(MODE_LITA_ERO); }
	    rcdata(str, LITLEN, FALSE, &error)
			{ if (error)
			     report(WAR_LITLEN, NOTFATAL, 0 ,0,
				    "attribute value length", LITLEN);
			}
	    TOK_LITA		{ leave_mode(); }
	] ] ;
