/* $Header: gen_incl.c,v 3.0 88/04/13 15:35:22 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "element.h"
#include "gen_incl.h"
#include "group.h"

#define ST_ELEMENT	String
#define STACK		ch_stack
#define stack_struct	junky
#define create_stack	create_ch_stack
#define pop		pop_ch
#define push		push_ch
#define on_stack	on_stack_ch
#define ST_EQUALKEY(a,b)	!strcmp(a, b)

#include "stack.gh"
#include "stack.gen"

void generate_incl(fp_doc, name_ext, name_incl)
FILE  *fp_doc;
String name_ext;
String name_incl;
{
	FILE      *fp_ext;
	FILE      *fp_incl;
	ch_stack   tmp;
	P_Element  elem;
	P_Iterator it;
	P_Iterator incl;
	String     name;

	fp_ext = fopen(name_ext, "w");
	fp_incl = fopen(name_incl, "w");

	if (fp_ext == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, name_ext);
	}
	if (fp_ext == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, name_incl);
	}
	tmp = create_ch_stack(0);

	fprintf(fp_incl, "#include \"%s\"\n\n", name_ext);
	fprintf(fp_incl, "Inclfunc incl_func[] = {\n\t");
	it = element_iterator();
	while (elem = next_element(it)) {
	    if (inclusions(elem) == 0) continue;
	    incl = group_iterator(inclusions(elem));
	    while (name = next_name(incl)) {
		name = cname(name);
		if (!on_stack_ch(tmp, name)) {
		    fprintf(fp_doc, "%%start f_%s, f_%s;\n", name, name);
		    fprintf(fp_doc, "f_%s : ST_%s %s;\n", name, name, name);
		    fprintf(fp_ext, "extern int f_%s();\n", name);
		    fprintf(fp_incl, "{ ST_%s, f_%s },\n\t", name, name);
		    push(tmp, strsave(name));
		}
	    }
	}
	fprintf(fp_incl, "{ 0, 0 } };\n");
	while (name = pop_ch(tmp)) CFREE(name);
	fclose(fp_ext);
	fclose(fp_incl);
}
