/* $Header: entity.c,v 3.0 88/04/13 15:51:11 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "Lpars.h"
#include "conc_syn.h"
#include "element.h"
#include "entity.h"
#include "in.h"
#include "notation.h"

typedef struct extern_id_struct {
    int      ex_type;
    String   public_str;
    String   system_str;
} Extern_id;

#ifdef DEBUG
void print_entity(PAR  FILE*, String, String, String,P_Extern_id, int, String  RAP);
static int           debug = FALSE;
#endif

typedef struct Entity_info {
    String      name; /* entity name */
    int         type;
    String      text;/* text for LITERAL STARTTAG ENDTAG MS MD CDATA
				 SDATA PI */
                     /* notation_name for NDATA */
    P_Extern_id extern_id;        /* EXTERNAL SUBDOC NDATA */
} Entity;

#ifdef DOC_PARSER
#include "entity.i"
#endif

Bool switch_to_extern_id(PAR  P_Extern_id ex_id  RAP);
int  extern_id_type     (PAR P_Extern_id RAP);

#include "hash_ent.i"
static  EntityTable  gen_entities;
static  EntityTable  par_entities;

static  int ee_string[] = { TOK_EE, 0 };

static Entity *open_entities[ENTLVL];
static int     open_index = 0;

Bool recursive_entity(info)
Entity *info;
{
    int i;
    
    for(i=0; i<open_index; i++){
	if( (open_entities[i]->type == info->type)
	    and
	    streq(open_entities[i]->name, info->name) )
	{
	    return TRUE;
	}
    }
    return FALSE;
}

void leave_entity(ent_name)
String ent_name;
{
    Entity *info = open_entities[--open_index];
    DEB1("leave entity %s\n", ent_name);
    if( not streq(info->name, ent_name) ){
	fprintf(stderr,"SYSTEM error, closing not open entity.\n");
    }
}

int entity_type(entity_name)
String entity_name;
{
    Entity  *info;

    info = lookup_entity(gen_entities, entity_name);
    return ( (info==0) ? UNDEFINED : (info->type) );
}

#ifdef GENERATOR
void entity_notation(key, entity)
String   key;
Entity  *entity;
{
	if (entity->type != NDATA) return;
	if (!get_notation(entity->text))
	    report(NOT_UNDEF, FATAL, 0, 0, entity->text, "entity", key);
}

void check_entity_notations()
{
	hash_generator(gen_entities, entity_notation);
}
#endif

static void define_entity(str, entities,entity_name,text,extern_id, type, not_name )
String       str;
EntityTable  entities;
String       entity_name;
String       text ;
P_Extern_id  extern_id;
int          type;
String       not_name;
{
    Entity  *info;
    extern int entcap, entchcap;

#ifdef DEBUG
    if( debug ){
	print_entity(fpdg, str, entity_name, text, extern_id, type, not_name );
    }
#endif
    if( lookup_entity(entities, entity_name) ){
	report(ENT_REDEF, NOTFATAL, 0, 0, str, entity_name);
	return;
    }
    entcap++;
    info = (Entity*)MALLOC((unsigned) sizeof(Entity));
    info->name = strsave(entity_name);
    info->type = type;
    switch(type){
	case STARTTAG :       /* save the text of the entity */
	case ENDTAG   :
	case MS       :
	case MD       :
	case CDATA    :
	case SDATA    :
	case PI       :
	case LITERAL  : info->text = strsave(text);
    		        entchcap += strlen(text); 
			break;
	case NDATA    : info->text = strsave(not_name);
			entchcap += strlen(extern_id_system(extern_id));
	                info->extern_id = extern_id;
			break;
	case SUBDOC   : report(ENT_NOT_SUB, FATAL, 0, 0,entity_name );
			FREE(info, sizeof(Entity));
			return;
	case EXTERNAL : info->extern_id = extern_id;
			entchcap += strlen(extern_id_system(extern_id));
			break;
	default       : report(NO_LABEL, FATAL, 0, 0, type, 
			       "define_entity");
			FREE(info, sizeof(Entity));
			return;
    }
    insert_entity(entities, info->name, info);
}

void    define_parameter_entity( entity_name, text, extern_id, type, not_name )
String       entity_name;
String       text ;
P_Extern_id  extern_id;
int          type;
String       not_name;
{
    define_entity("parameter",
		 par_entities,  entity_name, text, extern_id, type, not_name );
}

void    define_general_entity  ( entity_name, text, extern_id, type, not_name )
String       entity_name;
String       text ;
P_Extern_id  extern_id;
int          type;
String       not_name;
{
    define_entity("general",
		 gen_entities,  entity_name, text, extern_id, type, not_name );
}

static void switch_to_entity(type, entity_table, ent_name)
String        type;
EntityTable   entity_table;
String        ent_name;
{
    Entity *info;
    int    tokens[LITLEN+1];
    int    values[LITLEN+1];
    int    len, i;

    info = lookup_entity(entity_table, ent_name);
    if( info == 0 ) {
	info = lookup_entity(entity_table, "DEFAULT");
	if( info == 0 ) {
	    report(ENT_UNDEF, FATAL, 0, 0, type, ent_name);
	    return;
	}
    }
    if( open_index == ENTLVL ){
	report(ENT_OPEN, FATAL, 0, 0, ENTLVL, ent_name);
	return;
    } else if( recursive_entity(info) ){
	report(ENT_RECUR, FATAL, 0, 0, ent_name);
	return;
    } else {
	open_entities[open_index++] = info;
    }
    DEB1("enter entity %s\n", ent_name);
    entity_input( info->name, ee_string, 0 );
    switch(info->type){
	case MD       : string_input( delimiter_to_string(TOK_MDC) );
	                string_input(info->text);
	                string_input(delimiter_to_string(TOK_MDO));
			break;
	case PI       : string_input( delimiter_to_string(TOK_PIC) );
	                string_input(info->text);
	                string_input(delimiter_to_string(TOK_PIO));
			break;
	case MS       : string_input( delimiter_to_string(TOK_MSC_MDC) );
	                string_input(info->text);
	                string_input(delimiter_to_string(TOK_MDO_DSO));
			break;
	case STARTTAG : string_input( delimiter_to_string(TOK_TAGC) );
	                string_input(info->text);
	                string_input(delimiter_to_string(TOK_STAGO));
			break;
	case ENDTAG   : string_input( delimiter_to_string(TOK_TAGC) );
	                string_input(info->text);
	                string_input(delimiter_to_string(TOK_ETAGO));
			break;
	case CDATA    :
	case SDATA    : len = strlen(info->text);
			for(i=0; i<=len ; i++){
			    tokens[i] = TOK_DATACHAR;
			    values[i] = info->text[i];
			}
			tokens[len] = 0;
			token_input("CDATA entity", tokens, values);
			break;
	case LITERAL  : string_input(info->text);
		        break;
	case EXTERNAL : /* external looks for as file */
			switch_to_extern_id(info->extern_id);
		        break;
        case NDATA    : report(ENT_NOT_NDATA, FATAL, 0, 0, info->name);
                        break;
        case SUBDOC   : report(ENT_NOT_SUB, FATAL, 0, 0, info->name);
                        break;
        default       : report(NO_LABEL, FATAL, 0, 0, info->type,
			       "switch_to_entity");
                        break;
    }
}

void  switch_to_par_entity(ent_name)
String ent_name;
{
    switch_to_entity("parameter", par_entities, ent_name);
}

void  switch_to_gen_entity(ent_name)
String ent_name;
{
    switch_to_entity("general", gen_entities, ent_name);
}


#ifdef DEBUG
void    print_entity(file, gen, entity_name, text, ex_id, type, not_name )
FILE        *file;
String       gen;
String       entity_name;
String       text ;
P_Extern_id  ex_id;
int          type;
String       not_name;
{
    fprintf(file, "define %s entity : `%s' text `%s'\n", gen,
	     entity_name, text);

    print_extern_id(file, ex_id);
    if( ex_id != 0 ){
	if((extern_id_type(ex_id)==PUBLIC) || (extern_id_type(ex_id)==SYSTEM) ){
	    switch( type ){
	    case  NDATA    :
		fprintf(file, "              NDATA  notation `%s'\n", not_name);
		break;
	    case  SUBDOC   :
		fprintf(file, "              SUBDOC\n");
		break;
	    case  EXTERNAL   :
		fprintf(file, "              EXTERNAL\n");
		break;
	    }
	}
    } else if( type != UNDEFINED ) {
	fprintf(file, "              type `%d'\n", type);
    }
}
#endif

#ifdef GENERATOR

void generate_extern_id(PAR  FILE*, P_Extern_id, String RAP);
static FILE *generation_file;

static void do_extern(key, entity)
String   key;
Entity  *entity;
{
    char        var_name[12];
    static int  nr = 0;

    if( check_int(entity->type, NDATA, SUBDOC, EXTERNAL, 0) ){
        sprintf(var_name, "extern_%d", nr);
        nr++;
        generate_extern_id(generation_file, entity->extern_id, var_name);
    }
}

static void do_entity(key, entity)
String   key;
Entity  *entity;
{
    static int    nr = 0;

    if( entity->type == EXTERNAL ){
        fprintf(generation_file,"{ \"%s\", %d, 0, &extern_%d },\n",
                     entity->name, entity->type, nr);
        nr++;
    } else if( check_int(entity->type, NDATA, SUBDOC, 0) ){
        fprintf(generation_file,"{ \"%s\", %d,\n\"%s\",\n&extern_%d },\n",
                     entity->name, entity->type, cstring(entity->text), nr);
        nr++;
    } else {
        fprintf(generation_file,"{ \"%s\", %d,\n\"%s\",\n0 },\n",
                     entity->name, entity->type, cstring(entity->text));
    }
}

static void generate_gen_entities()
{
    fprintf(generation_file,
       "/* external identifiers generated by general entitys in DTD %s */\n",
		       document_name());
    hash_generator(gen_entities, do_extern);

    fprintf(generation_file,
		   "/* general entity declarations generated by DTD %s */\n",
	    document_name());
    fprintf(generation_file,"Entity dtd_gen_entities[] = {\n");
    hash_generator(gen_entities, do_entity);
    fprintf(generation_file,"     { 0, 0, 0, 0 }\n};\n");
}

static void generate_par_entities()
{
    fprintf(generation_file,
       "/* external identifiers generated by parameter entitys in DTD %s */\n",
		       document_name());
    hash_generator(par_entities, do_extern);

    fprintf(generation_file,
		   "/* parameter entity declarations generated by DTD %s */\n",
	    document_name());
    fprintf(generation_file,"Entity dtd_par_entities[] = {\n");
    hash_generator(par_entities, do_entity);
    fprintf(generation_file,"     { 0, 0, 0, 0 }\n};\n");
}

void generate_entities(file)
FILE   *file;
{
    generation_file = file;
    generate_gen_entities();
    generate_par_entities();
}

void generate_extern_id(file, id, var_name)
FILE        *file;
P_Extern_id  id;
String       var_name;
{
    fprintf(file,"Extern_id  %s = {%d, \"%s\",",
                 var_name, id->ex_type, cstring(id->public_str) );
    fprintf(file," \"%s\" };\n", cstring(id->system_str));
}
#endif

void  init_entity()
{
    int i=0;

    par_entities  = new_entity_table(191);
    gen_entities  = new_entity_table(191);

#ifdef DOC_PARSER
    while( dtd_gen_entities[i].name != 0 ){
	DEB1("general entity `%s' pre-defined\n", dtd_gen_entities[i].name);
        insert_entity(gen_entities, dtd_gen_entities[i].name,
					      &(dtd_gen_entities[i]) );
        i++;
    }
    i = 0;
    while( dtd_par_entities[i].name != 0 ){
	DEB1("parameter entity `%s' pre-defined\n", dtd_par_entities[i].name);
        insert_entity(par_entities, dtd_par_entities[i].name,
					      &(dtd_par_entities[i]) );
        i++;
    }
#endif
}

#ifdef DEBUG
void debug_entity(b)
Bool b;
{
    debug = b;
}
#endif

/*
 *  Extern identifiers.
  */
P_Extern_id  new_extern_id(type, pub_str, sys_str)
int    type;
String pub_str;
String sys_str;
{
    P_Extern_id  id;

    id = (P_Extern_id)MALLOC( (unsigned)sizeof(Extern_id) );
    id->ex_type    = type;
    id->public_str = pub_str;
    id->system_str = sys_str;
    return id;
}

void delete_extern_id(id)
P_Extern_id  id;
{
    CFREE(id->public_str);
    CFREE(id->system_str);
    FREE(id, sizeof(Extern_id));
}

String extern_id_system(ex_id)
P_Extern_id  ex_id;
{
    return ex_id->system_str;
}

String extern_id_public(ex_id)
P_Extern_id  ex_id;
{
    return ex_id->public_str;
}

int extern_id_type(ex_id)
P_Extern_id  ex_id;
{
    return ex_id->ex_type;
}

Bool switch_to_extern_id(ex_id)
P_Extern_id  ex_id;
{
    if (!file_input(extern_id_system(ex_id))){
	if (!file_input(extern_id_public(ex_id))){
	    report(EXID_OPEN, NOTFATAL, 0, 0,
			 ex_id->system_str, ex_id->public_str);
	    return FALSE;
	}
    }
    return TRUE;
}

#ifdef DEBUG
void print_extern_id(file, identifier)
FILE        *file;
P_Extern_id  identifier;
{
    fprintf(file, "extern_identifier: ");
    if( identifier == 0 ){
	fprintf(file,"(nil)\n");
	return;
    }
    if( identifier->ex_type == UNDEFINED ){
	fprintf(file, " UNDEFINED\n");
    } else if( identifier->ex_type == PUBLIC ){
	fprintf(file, " PUBLIC : `%s' SYSTEM `%s'\n",
                               identifier->public_str,  identifier->system_str );
    } else {
	fprintf(file, " SYSTEM : `%s'\n", identifier->system_str );
    }
}
#endif
