/*  $Header: comment.g,v 3.0 88/04/13 16:38:37 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "modes.h"
#include "lexical.h"

int gch;
}

comment_decl :
	[ MDO_COM                               { enter_mode(MODE_MD); }
	                                        { enter_mode(MODE_COM); }
	  [ [SGML_char(&gch) ]* TOK_COM         { leave_mode(); }
	    [
		s
	      | comment
	    ]*
	  ]
	  TOK_MDC                                      { leave_mode(); }
        ]
      |
	[ MDO_MDC ]
	;

comment :
	[ TOK_COM                              { enter_mode(MODE_COM); }
	  [ SGML_char(&gch) ]*
	  TOK_COM                                     { leave_mode(); }
	] ;
