/*  $Header: charclas.h,v 3.0 88/04/14 09:13:48 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*
 *  Basis character classes. The current_token is taken as the argument.
 *
 *  Most of these classes will eventually become macro definitions,
 *  because of the efficiency.
 */

#ifndef Bool
#define Bool int
#endif

extern Bool    is_SPACE      (PAR  int ch  RAP);
extern Bool    is_RE         (PAR  int ch  RAP);
extern Bool    is_RS         (PAR  int ch  RAP);
extern Bool    is_SEPCHAR    (PAR  int ch  RAP);
extern Bool    is_DATACHAR   (PAR  int ch  RAP);
extern Bool    is_DELMCHAR   (PAR  int ch  RAP);
extern Bool    is_SPECIAL    (PAR  int ch  RAP);
extern Bool    is_DIGIT      (PAR  int ch  RAP);
extern Bool    is_LCNMCHAR   (PAR  int ch  RAP);
extern Bool    is_UCNMCHAR   (PAR  int ch  RAP);
extern Bool    is_LCNMSTRT   (PAR  int ch  RAP);
extern Bool    is_UCNMSTRT   (PAR  int ch  RAP);
extern Bool    is_LC_LETTER  (PAR  int ch  RAP);
extern Bool    is_UC_LETTER  (PAR  int ch  RAP);
extern Bool    is_MSOCHAR    (PAR  int ch  RAP);
extern Bool    is_MSICHAR    (PAR  int ch  RAP);
extern Bool    is_MSSCHAR    (PAR  int ch  RAP);
extern Bool    is_FUNCHAR    (PAR  int ch  RAP);
/*
 *  Composite character classes corresponding to rules in the grammar.
 */
extern Bool    is_s                        (PAR  int ch  RAP);
extern Bool    is_data_character           (PAR  int ch  RAP);
extern Bool    is_SGML_character           (PAR  int ch  RAP);
extern Bool    is_markup_character         (PAR  int ch  RAP);
extern Bool    is_name_character           (PAR  int ch  RAP);
extern Bool    is_name_start_character     (PAR  int ch  RAP);
extern Bool    is_function_character       (PAR  int ch  RAP);
extern Bool    is_NONSGML                  (PAR  int ch  RAP);
extern Bool    is_alpha                    (PAR  int ch  RAP);

extern void    init_charclas               ();

#ifdef GENERATOR
extern void    unused_char                 (PAR  int ch  RAP);
extern void    unused_standard             ();
extern void    generate_unused             (PAR  FILE *file  RAP);
#endif
