/*  $Header: assert.h,v 3.0 88/04/14 09:10:58 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#ifndef __ASSERT__		/* to allow multiple includes */
#define __ASSERT__
/*	assert.h	4.1	83/05/03	*/
/*
 *  Changed by Jos Warmer, july 1985.
 *
 *  If an assertion fails, it not only produces the source line and file,
 *  but also the statement of the assertion that caused the failure.
 *  This gives better diagnostics.
 *  Instead of an exit(1), this version calls abort(), which produces a
 *  core dump, so the exact state of the program can be examined wiht dbx.
 */


#ifdef DEBUG
#ifdef VMS
#define _assert(ex) {if (!(ex)){fprintf(stderr,"Assertion `ex' failed\n");abort();}}
#define assert(ex) {if (!(ex)){fprintf(stderr,"Assertion `ex' failed\n");abort();}}
#else
#define _assert(ex) {if (!(ex)){fprintf(stderr,"Assertion `ex' failed: file %s, line %d\n",  __FILE__, __LINE__);abort();}}
#define assert(ex) {if (!(ex)){fprintf(stderr,"Assertion `ex' failed: file %s, line %d\n", __FILE__, __LINE__);abort();}}
#endif
#else
#define _assert(ex) ;
#define assert(ex) ;
#endif /* ifdef DEBUG     */
#endif /* ifndef __ASSERT__ */
