;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; See Template.scm in the Scheme Library for how to set up
;;; vicinities and require.

;(load (in-vicinity (program-vicinity) "scl" (scheme-file-suffix)))
			;Common Lisp/Scheme compatability definitions.
;(load (in-vicinity (program-vicinity) "toploads" (scheme-file-suffix)))

(load (in-vicinity (program-vicinity) "grammar" (scheme-file-suffix)))

(define (funcall p . args) (apply p args))
(define page-height #f)
(define page-width #f)
(define *input-grammar* (get-grammar 'scheme))
			;grammar to use if none is loaded.
(define *output-grammar* (get-grammar 'scheme))
			;grammar to use if none is loaded.
(define *echo-grammar* (get-grammar 'null))

(for-each
 (lambda (f) (load (in-vicinity (program-vicinity) f (scheme-file-suffix))))
 '("parse" "unparse" "English"))

(define *input-grammar* (get-grammar 'tex))

(define (view)
  (define obj #f)
  (define math:prompt ":")
  (let loop ()
    (cond ((output-port? (current-input-port))
	   (let ((cip (current-input-port)))
	     (display math:prompt cip)
	     (force-output cip)
	     (lex:bump-column (string-length math:prompt))))
	  (else (display math:prompt)
		(force-output)
		(lex:bump-column (string-length math:prompt))))
    (set! obj (read-sexp *input-grammar*))
    (lex:bump-column 0)
    (cond ((not obj))
	  ((eof-object? obj))
	  (else (write-sexp obj *output-grammar*)
		(newline)
		(loop)))))

(view)
