;;; trysmg.scm

;;; This code is ugly and poorly written, but should give you some
;;; idea how to use these routines.

(require "scm_dir:defformvr.scm")
(require "scm_dir:smg$routines.si")

(define dodbg #f)
(if dodbg 
    (require 'debug))

(define (arg1 a1 . rest) a1)
(define (arg2 a2 a2 . rest) a2)

(define input-device #f)
(define pbd (arg1 (smg$create_pasteboard input-device)))
(define kbd (arg1 (smg$create_virtual_keyboard input-device)))
(define display-id (arg1 (smg$create_virtual_display 24 80)))

(define smg$m_reverse #x00000002)


(define (beginning-screen)
  (smg$put_chars display-id "Hello!" 1 1 #f smg$m_reverse)
  (smg$put_chars display-id "Hello!" 24 1)
  (smg$put_chars display-id "Hello!" 1 75 #f #f smg$m_reverse)
  (smg$put_chars display-id "Hello!" 24 75)
  (smg$put_chars display-id ">" 12 39)
  (smg$put_chars display-id "Press HELP for a list of keys" 24 30 #f #f
		 smg$m_reverse))

;; Define the SMG termcodes for the keys we'll use.
(define smg$k_trm_ctrlz 26)
(define smg$k_trm_up 274)
(define smg$k_trm_down 275)
(define smg$k_trm_left 276)
(define smg$k_trm_right 277)
(define smg$k_trm_ctrli 9)
(define smg$k_trm_ctrlh 8)
(define smg$k_trm_help 295)
(define smg$k_trm_do 296)
(define smg$k_trm_insert_here 312)
(define smg$k_trm_ctrlr 18)
(define smg$k_trm_f19 299)
(define smg$k_trm_f20 300)


(define row 1)
(define col 1)

(define (set-pos r c)
  (set! row (if (> r 24)
		(- r 24)
		(if (< r 1)
		    (+ r 24)
		    r)))
  (set! col (if (> c 80)
		(- c 80)
		(if (< c 1)
		    (+ c 80)
		    c)))
  (smg$set_cursor_abs display-id row col))

(define (reset-pos)
  (smg$set_cursor_abs display-id row col))

(define (main)
  (smg$paste_virtual_display display-id pbd 1 1)
  (beginning-screen)
  (set-pos 12 40)
  (do ((key (arg1 (smg$read_keystroke kbd))
	    (arg1 (smg$read_keystroke kbd))))
      ((or (not (number? key))
	   (= key SMG$K_TRM_CTRLZ)))
    (action key))
  (smg$set_physical_cursor pbd 24 1)
  (smg$delete_pasteboard pbd 0)
  (smg$delete_virtual_display display-id)
  (smg$delete_virtual_keyboard kbd))

(define (action key)
  (cond
   ((= key SMG$K_TRM_UP)
    (set-pos (- row 1) col))
   ((= key SMG$K_TRM_DOWN)
    (set-pos (+ row 1) col))
   ((= key SMG$K_TRM_LEFT)
    (set-pos row (- col 1)))
   ((= key SMG$K_TRM_RIGHT)
    (set-pos row (+ col 1)))
   ((= key SMG$K_TRM_CTRLI)
    (set-pos row (+ col 8)))
   ((= key SMG$K_TRM_CTRLH) 
    (set-pos row (- col 8)))
   ((= key SMG$K_TRM_DO)
    (let ((pos (smg$return_cursor_pos display-id)))
      (smg$put_chars display-id (pair-string (arg1 pos) (arg2 pos) 3) 12 41))
    (reset-pos))
   ((= key SMG$K_TRM_INSERT_HERE)
    (smg$put_chars display-id "*" row col)
    (reset-pos))
   ((= key SMG$K_TRM_CTRLR)
    (smg$repaint_screen pbd))
   ((= key SMG$K_TRM_F20)
    (box)
    (reset-pos))
   ((= key SMG$K_TRM_HELP)
    (help-screen)
    (reset-pos))
   ((= key SMG$K_TRM_F19)
    (cond (rend-toggle
	   (smg$change_rendition
	    display-id 12 41 1 10 on-bits-set on-bits-comp)
	   (set! rend-toggle #f))
	  (else
	   (smg$change_rendition
	    display-id 12 41 1 10 off-bits-set off-bits-comp)
	   (set! rend-toggle #t))))
   (else
    (smg$ring_bell display-id 2))))

(define rend-toggle #t)
(define on-bits-set smg$m_reverse)		;bit 1 is SMG$M_REVERSE
(define on-bits-comp 0)
(define off-bits-set smg$m_reverse)
(define off-bits-comp smg$m_reverse)

(define (pair-string x y width)
  (let ((xs (pad (number->string x) width "0"))
	(ys (pad (number->string y) width "0")))
    (string-append "(" xs "," ys ")")))

(define (pad s w padding)
  (do ((s s (string-append padding s)))
      ((>= (string-length s) w)
       s)))

(define (the-end)
  (smg$delete_virtual_display display-id)
  (smg$delete_virtual_keyboard kbd)
  (smg$delete_pasteboard pbd 1))

(define (box)
  (define display-id (arg1 (smg$create_virtual_display 5 10 1)))
  (smg$paste_virtual_display display-id pbd row col)
  (smg$put_chars display-id "Golly!" 1 1)
  (smg$put_chars display-id "A Box!" 3 1)
  (smg$read_keystroke kbd)
  (smg$delete_virtual_display display-id))

(define (help-screen)
  (let ((display-id (arg1 (smg$create_virtual_display 15 50 1)))
	(text-list '("Help Screen"
		     ""
		     "Ctrl-Z: Exit        Ctrl-R: Repaint"
		     "Up Arrow: Up        Down Arrow: Down"
		     "Left Arrow: Left    Right Arrow: Right"
		     "Ctrl-I: Right 8     Ctrl-H: Left 8"
		     "Do: Location        Insert Here: Insert a `*'"
		     "F20: Popup Box      F19: Change Rendition"
		     "Help: This screen"
		     ""
		     "Press any key to continue" 
		     )))
    (smg$paste_virtual_display display-id pbd 3 15)
    (do ((i 1 (+ i 1))
	 (l text-list (cdr l)))
	((null? l) #f)
      (smg$put_chars display-id (car l) i 1))
    (smg$read_keystroke kbd)
    (smg$delete_virtual_display display-id)))




(cond (dodbg
       (set! smg$create_pasteboard
	     (tracef smg$create_pasteboard 'smg$create_pasteboard))
       (set! smg$create_virtual_keyboard
	     (tracef smg$create_virtual_keyboard 'smg$create_virtual_keyboard))
       (set! smg$create_virtual_display
	     (tracef smg$create_virtual_display 'smg$create_virtual_display))
       (set! smg$put_chars
	     (tracef smg$put_chars 'smg$put_chars))
       (set! smg$set_cursor_abs
	     (tracef smg$set_cursor_abs 'smg$set_cursor_abs))
       (set! smg$paste_virtual_display
	     (tracef smg$paste_virtual_display 'smg$paste_virtual_display))
       (set! smg$read_keystroke
	     (tracef smg$read_keystroke 'smg$read_keystroke))
       (set! smg$set_physical_cursor
	     (tracef smg$set_physical_cursor 'smg$set_physical_cursor))
       (set! smg$delete_pasteboard
	     (tracef smg$delete_pasteboard 'smg$delete_pasteboard))
       (set! smg$delete_virtual_display
	     (tracef smg$delete_virtual_display 'smg$delete_virtual_display))
       (set! smg$delete_virtual_keyboard
	     (tracef smg$delete_virtual_keyboard 'smg$delete_virtual_keyboard))
       ))



(main)
