#ifdef VMS
#include <stddef.h>
#include <stdio.h>
/* sys_fwrite -- A replacement for fwrite.
   VAX/VMS C's fwrite has been extended so that when writing to a record
   oriented file each call to fwrite produces one record.  This is convenient
   when one is working with RMS files.  However, if one is writing to a
   non-streamLF text file or a mailbox, which are also record oriented, each
   call to fwrite still produces one record WITH AN IMPLICIT END-OF-RECORD!
   This means that if you write out two strings with two calls to fwrite
   they will be seperate lines, even if there is no embedded newline.
   This version of fwrite just uses fputc to write out each byte in the
   object, thus avoiding the whole mess.
 */
size_t
sys_fwrite (const void *ptr, size_t size, size_t nelem, FILE *stream)
{
  size_t i;
  char *cptr;
  size_t nchars;
  char ch;
  int stat;
  
  cptr = (char *) ptr;
  nchars = size * nelem;
  for (i = 0; i < nchars; i++)
    {
      ch = *cptr++;
      stat = fputc (ch, stream);
      if (EOF == stat)
	return i / size;	/* error, so quit */
    }
  return i / size;
}
#endif /* defined (VMS) */
