;;; quidef.scm -- Define constants for LIB$GETQUI function.

(define QUI$_CANCEL_OPERATION 1)	; Cancel a wildcard operation
(define QUI$_DISPLAY_CHARACTERISTIC 2)  ; Return characteristic attributes
(define QUI$_DISPLAY_FILE 3)		; Return file attributes
(define QUI$_DISPLAY_FORM 4)		; Return form attributes
(define QUI$_DISPLAY_JOB 5)		; Return job attributes
(define QUI$_DISPLAY_QUEUE 6)		; Return queue attributes
(define QUI$_TRANSLATE_QUEUE 7)		; Validate and translate queue name
(define QUI$_DISPLAY_ENTRY 8)		; Return entry (job) attributes (without first having to establish queue  & context)
(define QUI$_RESERVED_FUNC_9 9)		; Reserved for Digital use (name may change)
(define QUI$_RESERVED_FUNC_10 10)	; Reserved for Digital use (name may change)
(define QUI$_ACCOUNT_NAME 1)		; Job: Submitter's account name
(define QUI$_AFTER_TIME 2)		; Job: /AFTER=time
(define QUI$_ASSIGNED_QUEUE_NAME 3)	; Queue: ASSIGN/QUEUE target
(define QUI$_BASE_PRIORITY 4)		; Queue: /BASE_PRIORITY=n
(define QUI$_CHARACTERISTIC_NAME 5)	; Characteristic: Name
(define QUI$_CHARACTERISTIC_NUMBER 6)	; Characteristic: Number
(define QUI$_CHARACTERISTICS 7)		; Job, queue: /CHARACTERISTICS=(c,...)
(define QUI$_CHECKPOINT_DATA 8)		; Job: Checkpoint data
(define QUI$_CLI 9)			; Job: /CLI=filename
(define QUI$_COMPLETED_BLOCKS 10)	; Job: Completed blocks including checkpoint
(define QUI$_CONDITION_VECTOR 11)	; Job: Completion status
(define QUI$_CPU_DEFAULT 12)		; Queue: /CPUDEFAULT=t
(define QUI$_CPU_LIMIT 13)		; Job, queue: /CPUMAXIMUM=t
(define QUI$_DEVICE_NAME 14)		; Queue: /ON=device
(define QUI$_ENTRY_NUMBER 15)		; Job: Entry number
(define QUI$_FILE_COPIES 16)		; File: /COPIES=n
(define QUI$_FILE_COPIES_CHKPT 17)	; File: File copies checkpoint (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_FILE_COPIES_DONE 18)	; File: File copies completed
(define QUI$_FILE_FLAGS 19)		; File: Boolean information
(define QUI$_FILE_SETUP_MODULES 20)	; File: /SETUP=(module,...)
(define QUI$_FILE_SPECIFICATION 21)	; File: Full file specification
(define QUI$_FILE_STATUS 22)		; File: Status information
(define QUI$_FIRST_PAGE 23)		; File: /PAGES=(n,"")
(define QUI$_FORM_DESCRIPTION 24)	; Form: /DESCRIPTION=string
(define QUI$_FORM_FLAGS 25)		; Form: Boolean information
(define QUI$_FORM_LENGTH 26)		; Form: /LENGTH=n
(define QUI$_FORM_MARGIN_BOTTOM 27)	; Form: /MARGIN=BOTTOM=n
(define QUI$_FORM_MARGIN_LEFT 28)	; Form: /MARGIN=LEFT=n
(define QUI$_FORM_MARGIN_RIGHT 29)	; Form: /MARGIN=RIGHT=n
(define QUI$_FORM_MARGIN_TOP 30)	; Form: /MARGIN=TOP=n
(define QUI$_FORM_NAME 31)		; Form, job, queue: Form name
(define QUI$_FORM_NUMBER 32)		; Form: Number
(define QUI$_FORM_SETUP_MODULES 33)	; Form: /SETUP=(module,...)
(define QUI$_FORM_STOCK 34)		; Form: /STOCK=stock-name
(define QUI$_FORM_WIDTH 35)		; Form: /WIDTH=n
(define QUI$_GENERIC_TARGET 36)		; Queue: /GENERIC=(queue-name,...)
(define QUI$_INTERVENING_BLOCKS 37)	; Job: Intervening pending blocks
(define QUI$_INTERVENING_JOBS 38)	; Job: Intervening pending jobs
(define QUI$_JOB_COPIES 39)		; Job: /JOB_COUNT=n
(define QUI$_JOB_COPIES_CHKPT 40)	; Job: Job copies checkpoint (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_JOB_COPIES_DONE 41)	; Job: Job copies completed
(define QUI$_JOB_FLAGS 42)		; Job: Boolean information
(define QUI$_JOB_LIMIT 43)		; Queue: /JOB_LIMIT=n
(define QUI$_JOB_NAME 44)		; Job: Name
(define QUI$_JOB_RESET_MODULES 45)	; Queue: /SEPARATE=RESET=(module,...)
(define QUI$_JOB_SIZE 46)		; Job: Total blocks in job
(define QUI$_JOB_SIZE_MAXIMUM 47)	; Queue: /BLOCK_LIMIT=n
(define QUI$_JOB_SIZE_MINIMUM 48)	; Queue: /BLOCK_LIMIT=(n,"")
(define QUI$_JOB_STATUS 49)		; Job: Status information
(define QUI$_LAST_PAGE 50)		; File: /PAGES=n
(define QUI$_LIBRARY_SPECIFICATION 51)  ; Queue: /LIBRARY=file-specification
(define QUI$_LOG_QUEUE 52)		; Job: /PRINTER=queue-name
(define QUI$_LOG_SPECIFICATION 53)	; Job: /LOG_FILE=file-specification
(define QUI$_NOTE 54)			; Job: /NOTE=string
(define QUI$_OPERATOR_REQUEST 55)	; Job: /OPERATOR=string
(define QUI$_OWNER_UIC 56)		; Queue: /OWNER=uic
(define QUI$_PAGE_SETUP_MODULES 57)	; Form: /PAGE_SETUP=(module,...)
(define QUI$_PARAMETER_1 58)		; Job: /PARAMETER=string
(define QUI$_PARAMETER_2 59)
(define QUI$_PARAMETER_3 60)
(define QUI$_PARAMETER_4 61)
(define QUI$_PARAMETER_5 62)
(define QUI$_PARAMETER_6 63)
(define QUI$_PARAMETER_7 64)
(define QUI$_PARAMETER_8 65)
(define QUI$_PRIORITY 66)		; Job: /PRIORITY=n
(define QUI$_PROCESSOR 67)		; Queue: /PROCESSOR=filename
(define QUI$_PROTECTION 68)		; Queue: /PROTECTION=mask
(define QUI$_QUEUE_FLAGS 69)		; Queue: Boolean information
(define QUI$_QUEUE_NAME 70)		; Job, queue: Queue name
(define QUI$_QUEUE_STATUS 71)		; Queue: Status information
(define QUI$_REFUSAL_REASON 72)		; Job: Reason symbiont refused job (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_REQUEUE_PRIORITY 73)	; Job: Priority after requeue (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_REQUEUE_QUEUE_NAME 74)	; Job: Queue after requeue
(define QUI$_SCSNODE_NAME 75)		; Queue: /ON=node::
(define QUI$_SEARCH_FLAGS 76)		; Flags to control search
(define QUI$_SEARCH_NAME 77)		; Object name to search for	
(define QUI$_SEARCH_NUMBER 78)		; Object number to search for
(define QUI$_SUBMISSION_TIME 79)	; Job: Submission time
(define QUI$_UIC 80)			; Job: Submitter's UIC
(define QUI$_USERNAME 81)		; Job: Submitter's username
(define QUI$_WSDEFAULT 82)		; Job, queue: /WSDEFAULT=n
(define QUI$_WSEXTENT 83)		; Job, queue: /WSEXTENT=n
(define QUI$_WSQUOTA 84)		; Job, queue: /WSQUOTA=n
(define QUI$_RESERVED_BOOLEAN_85 85)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_86 86)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_INPUT_87 87)	; Reserved for Digital use (name may change)
(define QUI$_SEARCH_USERNAME 88)	; Username of owner of job to modify search
(define QUI$_DEFAULT_FORM_NAME 89)	; Default form name on queue
(define QUI$_DEFAULT_FORM_NUMBER 90)	; Default form number on queue
(define QUI$_DEFAULT_FORM_STOCK 91)	; Stock name for default form 
(define QUI$_JOB_PID 92)		; Pid of batch job
(define QUI$_FILE_IDENTIFICATION 93)	; File identification (From RMS NAM block)
(define QUI$_PENDING_JOB_BLOCK_COUNT 94) ; Total number of blocks for all pending jobs
(define QUI$_RESERVED_BOOLEAN_95 95)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_96 96)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_97 97)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_98 98)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_99 99)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_100 100)  ; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_101 101)  ; Reserved for Digital use (name may change)
(define QUI$_RESERVED_BOOLEAN_102 102)  ; Reserved for Digital use (name may change)
(define QUI$_RESERVED_INPUT_103 103)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_INPUT_104 104)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_INPUT_105 105)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_INPUT_106 106)	; Reserved for Digital use (name may change)
(define QUI$_EXECUTING_JOB_COUNT 107)	; Number of jobs that are executing
(define QUI$_HOLDING_JOB_COUNT 108)	; Number of holding jobs
(define QUI$_TIMED_RELEASE_JOB_COUNT 109) ; Number of jobs specified with /AFTER_TIME
(define QUI$_PENDING_JOB_REASON 110)	; Secondary status describing why job is pending
(define QUI$_ORB_ADDRESS 111)		; Address of in-memory ORB data structure (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_QUEUE_DESCRIPTION 112)	; Queue: /DESCRIPTION
(define QUI$_SYMBIONT_FLAGS 113)	; Symbiont options (requests) passed to job controller (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_JOB_ACCESS_CLASS 114)	; Job access class information (for internal use only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_ORB_LOCK_KEY 115)		; Key value for locking of in-memory ORB data structure (for internal use  & only) (note this item code is intentionally not documented and reserved for Digital use)
(define QUI$_RESERVED_OUTPUT_116 116)	; Reserved for Digital use (name may change)
(define QUI$_PENDING_JOB_COUNT 117)	; Number of pending jobs
(define QUI$_RETAINED_JOB_COUNT 118)	; Number of retained jobs
(define QUI$_RESTART_QUEUE_NAME 119)	; Name of queue into which a job would be restarted, if appropriate
(define QUI$_RESERVED_OUTPUT_120 120)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_OUTPUT_121 121)	; Reserved for Digital use (name may change)
(define QUI$_RESERVED_OUTPUT_122 122)	; Reserved for Digital use (name may change)
(define QUI$M_FILE_BURST #x00000001)
(define QUI$M_FILE_BURST_EXP #x00000002)
(define QUI$M_FILE_DELETE #x00000004)
(define QUI$M_FILE_DOUBLE_SPACE #x00000008)
(define QUI$M_FILE_FLAG #x00000010)
(define QUI$M_FILE_FLAG_EXP #x00000020)
(define QUI$M_FILE_TRAILER #x00000040)
(define QUI$M_FILE_TRAILER_EXP #x00000080)
(define QUI$M_FILE_PAGE_HEADER #x00000100)
(define QUI$M_FILE_PAGINATE #x00000200)
(define QUI$M_FILE_PASSALL #x00000400)
(define QUI$M_FILE_PAGINATE_EXP #x00000800)
(define QUI$S_FILE_FLAGS 4)
(define QUI$M_FILE_CHECKPOINTED #x00000001)
(define QUI$M_FILE_EXECUTING #x00000002)
(define QUI$S_FILE_STATUS 4)
(define QUI$M_FORM_SHEET_FEED #x00000001)
(define QUI$M_FORM_TRUNCATE #x00000002)
(define QUI$M_FORM_WRAP #x00000004)
(define QUI$S_FORM_FLAGS 4)
(define QUI$M_JOB_CPU_LIMIT #x00000001)
(define QUI$M_JOB_FILE_BURST #x00000002)
(define QUI$M_JOB_FILE_BURST_ONE #x00000004)
(define QUI$M_JOB_FILE_BURST_EXP #x00000008)
(define QUI$M_JOB_FILE_FLAG #x00000010)
(define QUI$M_JOB_FILE_FLAG_ONE #x00000020)
(define QUI$M_JOB_FILE_FLAG_EXP #x00000040)
(define QUI$M_JOB_FILE_TRAILER #x00000080)
(define QUI$M_JOB_FILE_TRAILER_ONE #x00000100)
(define QUI$M_JOB_FILE_TRAILER_EXP #x00000200)
(define QUI$M_JOB_LOG_DELETE #x00000400)
(define QUI$M_JOB_LOG_NULL #x00000800)
(define QUI$M_JOB_LOG_SPOOL #x00001000)
(define QUI$M_JOB_LOWERCASE #x00002000)
(define QUI$M_JOB_NOTIFY #x00004000)
(define QUI$M_JOB_RESTART #x00008000)
(define QUI$M_JOB_WSDEFAULT #x00010000)
(define QUI$M_JOB_WSEXTENT #x00020000)
(define QUI$M_JOB_WSQUOTA #x00040000)
(define QUI$M_JOB_FILE_PAGINATE #x00080000)
(define QUI$M_JOB_FILE_PAGINATE_EXP #x00100000)
(define QUI$S_JOB_FLAGS 4)
(define QUI$M_JOB_ABORTING #x00000001)
(define QUI$M_JOB_EXECUTING #x00000002)
(define QUI$M_JOB_HOLDING #x00000004)
(define QUI$M_JOB_INACCESSIBLE #x00000008)
(define QUI$M_JOB_REFUSED #x00000010)
(define QUI$M_JOB_REQUEUE #x00000020)
(define QUI$M_JOB_RESTARTING #x00000040)
(define QUI$M_JOB_RETAINED #x00000080)
(define QUI$M_JOB_STARTING #x00000100)
(define QUI$M_JOB_TIMED_RELEASE #x00000200)
(define QUI$M_JOB_SUSPENDED #x00000400)
(define QUI$M_JOB_PENDING #x00000800)
(define QUI$S_JOB_STATUS 4)
(define QUI$V_JOB_TIMED 9)		; Synonym for QUI$V_JOB_TIMED_RELEASE for V4 compatibility
(define QUI$M_JOB_TIMED 512)		; Synonym for QUI$M_JOB_TIMED_RELEASE for V4 compatibility
(define QUI$M_PEND_CHAR_MISMATCH #x00000001)
(define QUI$M_PEND_JOB_SIZE_MAX #x00000002)
(define QUI$M_PEND_JOB_SIZE_MIN #x00000004)
(define QUI$M_PEND_LOWERCASE_MISMATCH #x00000008)
(define QUI$M_PEND_NO_ACCESS #x00000010)
(define QUI$M_PEND_QUEUE_BUSY #x00000020)
(define QUI$M_PEND_QUEUE_STATE #x00000040)
(define QUI$M_PEND_STOCK_MISMATCH #x00000080)
(define QUI$S_PENDING_JOB_REASON 4)
(define QUI$M_QUEUE_BATCH #x00000001)
(define QUI$M_QUEUE_CPU_DEFAULT #x00000002)
(define QUI$M_QUEUE_CPU_LIMIT #x00000004)
(define QUI$M_QUEUE_FILE_BURST #x00000008)
(define QUI$M_QUEUE_FILE_BURST_ONE #x00000010)
(define QUI$M_QUEUE_FILE_FLAG #x00000020)
(define QUI$M_QUEUE_FILE_FLAG_ONE #x00000040)
(define QUI$M_QUEUE_FILE_TRAILER #x00000080)
(define QUI$M_QUEUE_FILE_TRAILER_ONE #x00000100)
(define QUI$M_QUEUE_GENERIC #x00000200)
(define QUI$M_QUEUE_GENERIC_SELECTION #x00000400)
(define QUI$M_QUEUE_JOB_BURST #x00000800)
(define QUI$M_QUEUE_JOB_FLAG #x00001000)
(define QUI$M_QUEUE_JOB_SIZE_SCHED #x00002000)
(define QUI$M_QUEUE_JOB_TRAILER #x00004000)
(define QUI$M_QUEUE_RETAIN_ALL #x00008000)
(define QUI$M_QUEUE_RETAIN_ERROR #x00010000)
(define QUI$M_QUEUE_SWAP #x00020000)
(define QUI$M_QUEUE_TERMINAL #x00040000)
(define QUI$M_QUEUE_WSDEFAULT #x00080000)
(define QUI$M_QUEUE_WSEXTENT #x00100000)
(define QUI$M_QUEUE_WSQUOTA #x00200000)
(define QUI$M_QUEUE_FILE_PAGINATE #x00400000)
(define QUI$M_QUEUE_RECORD_BLOCKING #x00800000)
(define QUI$M_QUEUE_PRINTER #x01000000)
(define QUI$M_QUEUE_ACL_SPECIFIED #x02000000)
(define QUI$S_QUEUE_FLAGS 4)
(define QUI$M_QUEUE_ALIGNING #x00000001)
(define QUI$M_QUEUE_IDLE #x00000002)
(define QUI$M_QUEUE_LOWERCASE #x00000004)
(define QUI$M_QUEUE_OPERATOR_REQUEST #x00000008)
(define QUI$M_QUEUE_PAUSED #x00000010)
(define QUI$M_QUEUE_PAUSING #x00000020)
(define QUI$M_QUEUE_REMOTE #x00000040)
(define QUI$M_QUEUE_RESETTING #x00000080)
(define QUI$M_QUEUE_RESUMING #x00000100)
(define QUI$M_QUEUE_SERVER #x00000200)
(define QUI$M_QUEUE_STALLED #x00000400)
(define QUI$M_QUEUE_STARTING #x00000800)
(define QUI$M_QUEUE_STOPPED #x00001000)
(define QUI$M_QUEUE_STOPPING #x00002000)
(define QUI$M_QUEUE_UNAVAILABLE #x00004000)
(define QUI$M_QUEUE_CLOSED #x00008000)
(define QUI$S_QUEUE_STATUS 4)
(define QUI$M_SEARCH_ALL_JOBS #x00000001)
(define QUI$M_SEARCH_WILDCARD #x00000002)
(define QUI$M_SEARCH_BATCH #x00000004)
(define QUI$M_SEARCH_SYMBIONT #x00000008)
(define QUI$M_SEARCH_THIS_JOB #x00000010)
(define QUI$M_SEARCH_PRINTER #x00000020)
(define QUI$M_SEARCH_SERVER #x00000040)
(define QUI$M_SEARCH_TERMINAL #x00000080)
(define QUI$M_SEARCH_GENERIC #x00000100)
(define QUI$M_SEARCH_GENERIC_TARGET #x00000200)
(define QUI$M_SEARCH_PENDING_JOBS #x00000400)
(define QUI$M_SEARCH_EXECUTING_JOBS #x00000800)
(define QUI$M_SEARCH_TIMED_RELEASE_JOBS #x00001000)
(define QUI$M_SEARCH_HOLDING_JOBS #x00002000)
(define QUI$M_SEARCH_RETAINED_JOBS #x00004000)
(define QUI$M_SEARCH_FREEZE_CONTEXT #x00008000)
(define QUI$S_SEARCH_FLAGS 4)
(define QUI$M_SYM_NOTIFIES #x00000001)
(define QUI$M_SYM_REQUESTS_OPER #x00000002)
(define QUI$M_SYM_COPIES_FILE #x00000004)
(define QUI$M_SYM_COPIES_JOB #x00000008)
(define QUI$M_SYM_ACCEPTS_ALL_FORMS #x00000010)
(define QUI$M_SYM_NO_JOB_CHECKPOINT #x00000020)
(define QUI$S_SYMBIONT_FLAGS 4)
