;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

(set! Language "English")	;grammar <Language>.scm should exist

(set! math:debug #f)		; #t to break on soft errors, #f to continue
				;also does --more-- after didn't verify

(set! math:phases #f)		; #t to show phases of normaization.

(set! math:trace #f)		; #t to trace variable eliminations, #f not to.

(set! linkradicals #t)		;Relate radicals in the traditional manner.

(set! Horner #f)		;Horner's rule on expression output

(set! page-height #t)		;#t for pagination on, #f off

(set! page-width #t)		;Number or #t to use SLIB's width. #f for wide.

(set! newextstr (string-standard-case "EXT0")) ;extension template

(set! newlabelstr (string-standard-case "E0")) ;prompt template

(set! newlabelsym (string->symbol newlabelstr))
(set! % novalue)

(let ((init (in-vicinity (user-vicinity) "mathinit" (scheme-file-suffix))))
  (if (file-exists? init)
      (load init)))			;User initialization file

(if (and Language (= 3 (length (list-of-grammars)))) ;none loaded yet.
    (load (in-vicinity jacal-vicinity Language (scheme-file-suffix))))
