;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; stox.sc -- some widget design thoughts. Johan Ihren

;;; $Id: stox.sc,v 2.2 91/09/15 00:58:29 johani Exp $

(module stox (with scix stoxdfsm stoxwidget
		   stoxlabel stoxbutton stoxstredit stoxscrollbar stoxtext
		   stoxmenu stoxbox stoxcont stoxutil
		   ))

(define-external getenv stoxutil)
(define-external file-readable? stoxutil)
(define-external scix-msg scixutil)

;;; This line automatically generated. It may not be split.
(define scix-load-path '("." "/misc/projects/johani/scix-1.00"))

;;; find-file -- search for the file with name name along the load-path.
(define (find-file name)
  (let loop ((prefixes scix-load-path))
    (if (null? prefixes)
	#f
	(let ((fullname (string-append (car prefixes) "/" name)))
	  (if (file-readable? fullname)
	      fullname
	      (loop (cdr prefixes)) )))))

;;; stox-init loads personal initializations, if any.
(define (stox-init)
  (let* ((home (getenv "HOME"))
	 (scixrc (if (file-readable? ".scixrc")
		     ".scixrc"
		     (let ((scixrc (string-append home "/.scixrc")))
		       (if (file-readable? scixrc)
			   scixrc
			   #f)))) )
    (if scixrc
	(begin
	  (scix-msg ";;; Loading ~a.~%" scixrc)
	  (load scixrc) ))))

(stox-init)

